/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import weblogic.servlet.internal.ChunkOutput;
import weblogic.socket.NIOConnection;
import weblogic.utils.io.Chunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GatheringChunkOutput
extends ChunkOutput {
    private static final byte[] CRCF = "\r\n".getBytes();
    private LinkedList<ByteBuffer> buffers;
    private ChunkOutput delegate;
    private Chunk currentChunk;
    private Chunk httpHeaders;
    private int currentChunkOffset;

    GatheringChunkOutput(ChunkOutput chunkOutput) {
        this.delegate = chunkOutput;
        this.currentChunk = this.delegate.head;
        this.currentChunkOffset = 6;
        this.buffers = new LinkedList();
        this.internalSetFlushStrategy();
    }

    GatheringChunkOutput(GatheringChunkOutput gatheringChunkOutput, ChunkOutput chunkOutput) {
        this.delegate = chunkOutput;
        this.currentChunk = gatheringChunkOutput.currentChunk;
        this.currentChunkOffset = gatheringChunkOutput.currentChunkOffset;
        this.buffers = gatheringChunkOutput.buffers;
        this.internalSetFlushStrategy();
    }

    public ChunkOutput getDelegate() {
        return this.delegate;
    }

    @Override
    public void reset() {
        this.delegate.reset();
        this.internalClear();
    }

    @Override
    public void release() {
        this.delegate.release();
        this.internalClear();
        this.internalRelease();
    }

    @Override
    public void clearBuffer() {
        this.delegate.clearBuffer();
        this.internalClear();
    }

    @Override
    public void setBufferSize(int n) {
        this.delegate.setBufferSize(n);
        this.internalSetFlushStrategy();
    }

    @Override
    public void setAutoFlush(boolean bl) {
        this.delegate.setAutoFlush(bl);
        this.internalSetFlushStrategy();
    }

    @Override
    protected void flushBufferedDataToChunk() {
        this.delegate.flushBufferedDataToChunk();
        this.flushChunksToByteBuffers();
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException {
        if (this.delegate.released) {
            return;
        }
        this.delegate.flushStrategy.checkOverflow(byteBuffer.limit());
        this.delegate.flushBufferedDataToChunk();
        this.flushChunksToByteBuffers();
        byteBuffer.rewind();
        this.buffers.addLast(byteBuffer.duplicate());
        this.delegate.count += byteBuffer.limit();
        this.delegate.flushStrategy.checkForFlush();
    }

    @Override
    public void flush() throws IOException {
        if (this.delegate.released) {
            return;
        }
        this.delegate.flushBufferedDataToChunk();
        if (!this.isHeaderSent()) {
            this.delegate.sos.sendHeaders();
        }
        if (this.delegate.os != null) {
            this.flushChunksToByteBuffers();
            int n = this.flushBuffer();
            this.delegate.total += this.delegate.count;
            if (this.delegate.chunking) {
                this.delegate.total += 8 * n;
            }
            if (this.httpHeaders != null) {
                this.releaseHeaders();
            }
            this.clearBuffer();
        }
        this.delegate.postFlush();
    }

    @Override
    protected void setHttpHeaders(Chunk chunk) {
        this.httpHeaders = chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int flushBuffer() throws IOException {
        int n;
        int n2 = this.addChunkingHeaderAndTail();
        if (this.httpHeaders != null) {
            this.flushHeaderToByteBuffers();
        }
        if (this.buffers.isEmpty()) {
            return 0;
        }
        try {
            GatheringChunkOutput.registerToTrigger(this.delegate.os);
            this.writeChunks();
            n = n2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            GatheringChunkOutput.unregisterFromTrigger(this.delegate.os);
            throw throwable;
        }
        GatheringChunkOutput.unregisterFromTrigger(this.delegate.os);
        return n;
    }

    private boolean isHeaderSent() {
        return this.delegate.sos != null && this.delegate.sos.headersSent();
    }

    private int addChunkingHeaderAndTail() {
        if (this.delegate.chunking && !this.buffers.isEmpty()) {
            this.buffers.addFirst(GatheringChunkOutput.getChunkHeader(this.delegate.count));
            this.buffers.addLast(ByteBuffer.wrap(CRCF));
            return 1;
        }
        return 0;
    }

    private void writeChunks() throws IOException {
        if (this.buffers.size() == 1) {
            ByteBuffer byteBuffer = this.buffers.getFirst();
            if (byteBuffer.hasArray()) {
                this.delegate.os.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
            } else {
                byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
                byteBuffer.get(byArray, 0, byArray.length);
                this.delegate.os.write(byArray, 0, byArray.length);
            }
        } else {
            GatheringChunkOutput.writeGatheredChunks(this.buffers, ((NIOConnection)this.delegate.os).getGatheringByteChannel());
        }
    }

    private static void writeGatheredChunks(List<ByteBuffer> list, GatheringByteChannel gatheringByteChannel) throws IOException {
        while (!list.isEmpty()) {
            int n = list.size();
            ByteBuffer[] byteBufferArray = new ByteBuffer[n];
            for (int i = 0; i < n; ++i) {
                byteBufferArray[i] = list.get(i);
            }
            gatheringByteChannel.write(byteBufferArray, 0, byteBufferArray.length);
            Iterator<ByteBuffer> iterator = list.iterator();
            while (iterator.hasNext() && !iterator.next().hasRemaining()) {
                iterator.remove();
            }
        }
    }

    private static ByteBuffer getChunkHeader(int n) {
        int n2 = n > 65535 ? 8 : 4;
        byte[] byArray = new byte[n2 + 2];
        int n3 = n2;
        do {
            byArray[--n3] = DIGITS[n & 0xF];
        } while ((n >>>= 4) != 0);
        for (int i = 0; i < n3; ++i) {
            byArray[i] = 48;
        }
        byArray[n2] = 13;
        byArray[n2 + 1] = 10;
        return ByteBuffer.wrap(byArray);
    }

    private void internalClear() {
        this.currentChunk = this.delegate.head;
        this.buffers.clear();
        this.currentChunkOffset = 6;
        this.releaseHeaders();
    }

    private void releaseHeaders() {
        if (this.httpHeaders != null) {
            Chunk.releaseChunks((Chunk)this.httpHeaders);
            this.httpHeaders = null;
        }
    }

    private void internalRelease() {
        this.currentChunk = null;
        this.buffers = null;
        this.delegate = null;
    }

    private void internalSetFlushStrategy() {
        if (this.delegate.flushStrategy != null) {
            this.delegate.flushStrategy.setChunkOutput(this);
        }
    }

    private void flushChunksToByteBuffers() {
        while (this.currentChunk != null && this.currentChunk.end > this.currentChunkOffset) {
            this.buffers.addLast(ByteBuffer.wrap(this.currentChunk.buf, this.currentChunkOffset, this.currentChunk.end - this.currentChunkOffset));
            if (this.currentChunk.end == END_OFFSET) {
                this.currentChunkOffset = 6;
                this.currentChunk = this.currentChunk.next;
                continue;
            }
            this.currentChunkOffset = this.currentChunk.end;
        }
    }

    private void flushHeaderToByteBuffers() {
        Chunk chunk = this.httpHeaders;
        int n = 0;
        while (chunk != null) {
            ByteBuffer byteBuffer = chunk.getWriteByteBuffer();
            byteBuffer.position(0);
            this.buffers.add(n++, byteBuffer);
            chunk = chunk.next;
        }
    }

    @Override
    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    @Override
    public Chunk getHead() {
        return this.delegate.getHead();
    }

    @Override
    public int getTotal() {
        return this.delegate.getTotal();
    }

    @Override
    public int getCount() {
        return this.delegate.getCount();
    }

    @Override
    public int getBufferSize() {
        return this.delegate.getBufferSize();
    }

    @Override
    public void setStickyBufferSize(boolean bl) {
        this.delegate.setStickyBufferSize(bl);
    }

    @Override
    public boolean isAutoFlush() {
        return this.delegate.isAutoFlush();
    }

    @Override
    public boolean isChunking() {
        return this.delegate.isChunking();
    }

    @Override
    public void setChunking(boolean bl) {
        this.delegate.setChunking(bl);
    }

    @Override
    void writeByte(int n) throws IOException {
        this.delegate.writeByte(n);
    }

    @Override
    public void write(int n) throws IOException {
        this.delegate.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.delegate.write(byArray, n, n2);
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        this.delegate.write(cArray, n, n2);
    }

    @Override
    public void print(String string) throws IOException {
        this.delegate.print(string);
    }

    @Override
    public void println(String string) throws IOException {
        this.delegate.println(string);
    }

    @Override
    public void println() throws IOException {
        this.delegate.println();
    }

    @Override
    public void commit() throws IOException {
        this.delegate.commit();
    }

    @Override
    public void writeStream(InputStream inputStream, int n, int n2) throws IOException {
        this.delegate.writeStream(inputStream, n, n2);
    }

    @Override
    protected int getCountForCheckOverflow() {
        return this.delegate.getCountForCheckOverflow();
    }
}

