/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.cluster.ClusterService;
import weblogic.cluster.replication.ROID;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.jndi.Environment;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.configuration.WebAppContainerMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.OnDemandManager;
import weblogic.servlet.internal.ROIDLookup;
import weblogic.servlet.internal.ROIDLookupImpl;
import weblogic.servlet.internal.ServletContextManager;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.URLResourceRuntimeMBeanImpl;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebServerRuntimeMBeanImpl;
import weblogic.servlet.internal.session.ReplicatedSessionContext;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.logging.LogManagerHttp;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.collections.WeakConcurrentHashMap;
import weblogic.version;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextMap;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextMapInterceptor;
import weblogic.workarea.utils.WorkContextInputAdapter;
import weblogic.workarea.utils.WorkContextOutputAdapter;

public final class HttpServer {
    public static final String SERVER_INFO;
    private static final AuthenticatedSubject kernelId;
    public static final byte[] FORBIDDEN_RESPONSE;
    private static final boolean PRODUCTION_MODE;
    private static final WebAppContainerMBean webAppContainer;
    private final WebServerMBean mbean;
    private final ServerMBean serverMBean;
    private final ClusterMBean clusterMBean;
    private String replicationChannel;
    private WebServerRuntimeMBeanImpl runtime;
    private final boolean defaultWebServer;
    private final String logContext;
    private final String serverHash;
    private final ServletContextManager servletContextManager;
    private final OnDemandManager onDemandManager;
    private final LogManagerHttp logmanager;
    private final Replicator replicator = new Replicator();
    private final WorkContextManager workCtxManager = new WorkContextManager();
    private final SessionLogin sessionLogin = new SessionLogin(this.workCtxManager);
    private boolean weblogicPluginEnabled;
    private boolean httpTraceSupportEnabled;
    private boolean authCookieEnabled;
    private boolean wapEnabled;
    private String clientIpHeader = null;
    private static ROIDLookupImpl roidImpl;
    private final Map runtimes = new HashMap();
    private Context jndiContext;
    static final long serialVersionUID = 5593485415812104821L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_UnloadWebApp_Around_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_LoadWebApp_Around_Low;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public HttpServer(WebServerMBean webServerMBean) {
        this.mbean = webServerMBean;
        this.defaultWebServer = !(this.mbean instanceof VirtualHostMBean);
        this.serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        this.clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        this.logContext = this.initLogContext();
        if (roidImpl == null) {
            Class<HttpServer> clazz = HttpServer.class;
            // MONITORENTER : weblogic.servlet.internal.HttpServer.class
            if (roidImpl == null) {
                try {
                    roidImpl = new ROIDLookupImpl(this);
                    ClusterService clusterService = (ClusterService)ClusterService.getServices();
                    if (clusterService != null && clusterService.isReplicationTimeoutEnabled()) {
                        ServerHelper.exportObject((Remote)roidImpl, (int)clusterService.getHeartbeatTimeoutMillis());
                    } else {
                        ServerHelper.exportObject((Remote)roidImpl);
                    }
                }
                catch (RemoteException remoteException) {
                    throw new AssertionError((Object)"ROIDLookupImpl initial reference could not be exported.");
                }
            }
            // MONITOREXIT : clazz
        }
        this.servletContextManager = new ServletContextManager(this.mbean);
        this.logmanager = new LogManagerHttp(this.mbean);
        this.onDemandManager = new OnDemandManager();
        this.serverHash = Integer.toString(LocalServerIdentity.getIdentity().hashCode());
        this.initConfigSwitches();
    }

    private void initConfigSwitches() {
        this.weblogicPluginEnabled = webAppContainer.isWeblogicPluginEnabled();
        this.httpTraceSupportEnabled = webAppContainer.isHttpTraceSupportEnabled();
        this.authCookieEnabled = webAppContainer.isAuthCookieEnabled();
        this.wapEnabled = webAppContainer.isWAPEnabled();
        if (this.clusterMBean != null) {
            this.replicationChannel = this.clusterMBean.getReplicationChannel();
            if (this.clusterMBean.isSet("WeblogicPluginEnabled")) {
                this.weblogicPluginEnabled = this.clusterMBean.isWeblogicPluginEnabled();
            }
            if (this.clusterMBean.isSet("HttpTraceSupportEnabled")) {
                this.httpTraceSupportEnabled = this.clusterMBean.isHttpTraceSupportEnabled();
            }
        }
        if (this.serverMBean.isSet("WeblogicPluginEnabled")) {
            this.weblogicPluginEnabled = this.serverMBean.isWeblogicPluginEnabled();
        }
        if (this.serverMBean.isSet("HttpTraceSupportEnabled")) {
            this.httpTraceSupportEnabled = this.serverMBean.isHttpTraceSupportEnabled();
        }
        if (this.mbean.isSet("AuthCookieEnabled")) {
            this.authCookieEnabled = this.mbean.isAuthCookieEnabled();
        }
        if (this.mbean.isSet("WAPEnabled")) {
            this.wapEnabled = this.mbean.isWAPEnabled();
        }
        if (this.mbean.isSet("ClientIpHeader")) {
            this.clientIpHeader = this.mbean.getClientIpHeader();
        }
    }

    private String initLogContext() {
        if (this.defaultWebServer) {
            return "HttpServer (defaultWebserver) name: " + this.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HttpServer (VirtualHost) name: ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" hosts: [");
        String[] stringArray = this.getVirtualHostNames();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("] channel: ");
        stringBuffer.append(((VirtualHostMBean)this.mbean).getNetworkAccessPoint());
        return stringBuffer.toString();
    }

    public boolean isWeblogicPluginEnabled() {
        return this.weblogicPluginEnabled;
    }

    public boolean isHttpTraceSupportEnabled() {
        return this.httpTraceSupportEnabled;
    }

    public static boolean isProductionModeEnabled() {
        return PRODUCTION_MODE;
    }

    public String[] getVirtualHostNames() {
        if (this.defaultWebServer) {
            return new String[]{this.getFrontendHost()};
        }
        return ((VirtualHostMBean)this.mbean).getVirtualHostNames();
    }

    public Replicator getReplicator() {
        return this.replicator;
    }

    public String getReplicationChannel() {
        return this.replicationChannel;
    }

    public SessionLogin getSessionLogin() {
        return this.sessionLogin;
    }

    public LogManagerHttp getLogManager() {
        return this.logmanager;
    }

    public WorkContextManager getWorkContextManager() {
        return this.workCtxManager;
    }

    public ServletContextManager getServletContextManager() {
        return this.servletContextManager;
    }

    public OnDemandManager getOnDemandManager() {
        return this.onDemandManager;
    }

    public String getServerHash() {
        return this.serverHash;
    }

    public WebServerMBean getMBean() {
        return this.mbean;
    }

    public String getName() {
        return this.getMBean().getName();
    }

    public String getListenAddress() {
        return this.serverMBean.getListenAddress();
    }

    public String getFrontendHost() {
        if (this.defaultWebServer && this.clusterMBean != null) {
            return this.clusterMBean.getFrontendHost();
        }
        return this.mbean.getFrontendHost();
    }

    public int getFrontendHTTPPort() {
        if (this.defaultWebServer && this.clusterMBean != null) {
            return this.clusterMBean.getFrontendHTTPPort();
        }
        return this.mbean.getFrontendHTTPPort();
    }

    public int getFrontendHTTPSPort() {
        if (this.defaultWebServer && this.clusterMBean != null) {
            return this.clusterMBean.getFrontendHTTPSPort();
        }
        return this.mbean.getFrontendHTTPSPort();
    }

    public RuntimeMBean initialize() {
        HTTPLogger.logInit((String)this.logContext);
        String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
        String string2 = string + "_" + this.getName();
        try {
            this.runtime = new WebServerRuntimeMBeanImpl(string2, this, this.defaultWebServer);
            ManagementService.getRuntimeAccess(kernelId).getServerRuntime().addWebServerRuntime(this.runtime);
            return this.runtime;
        }
        catch (ManagementException managementException) {
            HTTPLogger.logFailedToCreateWebServerRuntimeMBean((String)string2, (Throwable)managementException);
            return null;
        }
    }

    public synchronized void start() {
        this.initURLResources();
        this.logmanager.start();
        if (HTTPDebugLogger.isEnabled()) {
            HTTPLogger.logStarted((String)this.logContext);
            HTTPDebugLogger.debug(this + " HttpServer started and is ready to receive http requests");
        }
    }

    private void initURLResources() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        hashtable.put("weblogic.jndi.createIntermediateContexts", "true");
        try {
            this.jndiContext = new InitialContext(hashtable);
        }
        catch (Exception exception) {
            HTTPLogger.logNoJNDIContext((String)this.logContext, (String)exception.toString());
            return;
        }
        Map map = this.getMBean().getURLResource();
        if (map != null) {
            for (String string : map.keySet()) {
                URL uRL;
                String string2 = (String)map.get(string);
                if (string2 == null || string2.length() == 0) {
                    HTTPLogger.logNullURL((String)this.logContext, (String)string);
                    continue;
                }
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    HTTPLogger.logURLParseError((String)this.logContext, (String)string2);
                    continue;
                }
                try {
                    this.jndiContext.bind(string, (Object)uRL);
                }
                catch (NamingException namingException) {
                    HTTPLogger.logUnableToBindURL((String)this.logContext, (String)string2, (String)string, (String)namingException.toString());
                    continue;
                }
                try {
                    URLResourceRuntimeMBeanImpl uRLResourceRuntimeMBeanImpl = new URLResourceRuntimeMBeanImpl(string);
                    this.runtimes.put(string, uRLResourceRuntimeMBeanImpl);
                }
                catch (ManagementException managementException) {
                    HTTPLogger.logUnableToBindURL((String)this.logContext, (String)string2, (String)string, (String)managementException.toString());
                }
                HTTPLogger.logBoundURL((String)this.logContext, (String)string2, (String)string);
            }
        }
    }

    private void destroyURLResources() {
        for (String string : this.runtimes.keySet()) {
            block5: {
                try {
                    this.jndiContext.unbind(string);
                }
                catch (NamingException namingException) {
                    if (!HTTPDebugLogger.isEnabled()) break block5;
                    HTTPDebugLogger.debug("Error while unbinding URLResource: " + StackTraceUtils.throwable2StackTrace((Throwable)namingException));
                }
            }
            URLResourceRuntimeMBeanImpl uRLResourceRuntimeMBeanImpl = (URLResourceRuntimeMBeanImpl)this.runtimes.get(string);
            try {
                if (uRLResourceRuntimeMBeanImpl == null) continue;
                uRLResourceRuntimeMBeanImpl.unregister();
            }
            catch (ManagementException managementException) {
                if (!HTTPDebugLogger.isEnabled()) continue;
                HTTPDebugLogger.debug("Error while unregistering URLResource: " + StackTraceUtils.throwable2StackTrace((Throwable)managementException));
            }
        }
    }

    public synchronized void shutdown() {
        this.destroyURLResources();
        try {
            if (this.runtime != null) {
                ManagementService.getRuntimeAccess(kernelId).getServerRuntime().removeWebServerRuntime(this.runtime);
                this.runtime.unregister();
            }
        }
        catch (ManagementException managementException) {
            throw new AssertionError((Object)"Unable to unregister runtime mbean");
        }
        if (this.logmanager != null) {
            this.logmanager.close();
        }
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("HttpServer is shutting down: " + this.logContext);
            HTTPLogger.logShutdown((String)this.logContext);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized WebAppServletContext loadWebApp(WebAppComponentMBean webAppComponentMBean, ApplicationContextInternal applicationContextInternal, WebAppModule webAppModule, String string) throws ModuleException {
        WebAppServletContext webAppServletContext;
        boolean bl = _WLDF$INST_FLD_Servlet_LoadWebApp_Around_Low.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var13_8 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_Servlet_LoadWebApp_Around_Low.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, webAppComponentMBean, applicationContextInternal, webAppModule, string};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_LoadWebApp_Around_Low;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug(HTTPLogger.logLoadingWebAppLoggable((String)this.logContext, (String)webAppModule.getName()).getMessage());
            }
            try {
                webAppServletContext = new WebAppServletContext(this, applicationContextInternal, webAppComponentMBean, webAppModule, string);
            }
            catch (Exception exception) {
                String string2;
                String string3 = string2 = webAppModule == null ? "<internal>" : webAppModule.getName();
                if (!HTTPDebugLogger.isEnabled()) throw new ModuleException("Failed to load webapp: '" + string2 + "'", exception);
                HTTPDebugLogger.debug("Failed to load webapp: '" + string2 + "'", exception);
                throw new ModuleException("Failed to load webapp: '" + string2 + "'", exception);
            }
            J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = applicationContextInternal.getRuntime();
            this.doPostContextInit(webAppServletContext, j2EEApplicationRuntimeMBeanImpl);
            Object var11_16 = null;
            if (!bl) return webAppServletContext;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_LoadWebApp_Around_Low, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_LoadWebApp_Around_Low, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        return webAppServletContext;
    }

    private void doPostContextInit(WebAppServletContext webAppServletContext, RuntimeMBean runtimeMBean) throws ModuleException {
        try {
            this.servletContextManager.registerContext(webAppServletContext);
        }
        catch (DeploymentException deploymentException) {
            throw new ModuleException(deploymentException.getMessage(), (Throwable)((Object)deploymentException));
        }
        if (HTTPDebugLogger.isEnabled() && webAppServletContext.isDefaultContext()) {
            HTTPDebugLogger.debug(HTTPLogger.logSetContextLoggable((String)this.logContext, (String)webAppServletContext.getName(), (String)this.getName()).getMessage());
        }
        try {
            webAppServletContext.prepare(runtimeMBean);
        }
        catch (DeploymentException deploymentException) {
            this.unloadWebApp(webAppServletContext, webAppServletContext.getVersionId());
            throw new ModuleException(deploymentException.getMessage(), (Throwable)((Object)deploymentException));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void unloadWebApp(WebAppServletContext webAppServletContext, String string) {
        boolean bl = _WLDF$INST_FLD_Servlet_UnloadWebApp_Around_Low.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var8_6 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_Servlet_UnloadWebApp_Around_Low.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, webAppServletContext, string};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_UnloadWebApp_Around_Low;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            this.servletContextManager.destroyContext(webAppServletContext, string);
            Object var6_10 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_UnloadWebApp_Around_Low, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_UnloadWebApp_Around_Low, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
    }

    public synchronized WebAppServletContext createInternalContext(ApplicationContextInternal applicationContextInternal, String string, ClassLoader classLoader) throws DeploymentException {
        Context context = applicationContextInternal.getEnvContext();
        try {
            context.lookup("/webapp");
        }
        catch (NameNotFoundException nameNotFoundException) {
            try {
                context.createSubcontext("webapp");
            }
            catch (NamingException namingException) {
                throw new DeploymentException("Failed to create environment context", namingException);
            }
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)namingException);
        }
        WebAppServletContext webAppServletContext = new WebAppServletContext(this, applicationContextInternal, string, classLoader);
        this.servletContextManager.registerContext(webAppServletContext);
        return webAppServletContext;
    }

    public String getServerName() {
        return this.serverMBean.getName();
    }

    public String toString() {
        return this.logContext;
    }

    public boolean isAuthCookieEnabled() {
        return this.authCookieEnabled;
    }

    public boolean isWAPEnabled() {
        return this.wapEnabled;
    }

    public String getClientIpHeader() {
        return this.clientIpHeader;
    }

    public int getPostTimeoutSecs() {
        if (this.mbean.isPostTimeoutSecsSet()) {
            return this.mbean.getPostTimeoutSecs();
        }
        return webAppContainer.getPostTimeoutSecs();
    }

    public int getMaxPostTimeSecs() {
        if (this.mbean.isMaxPostTimeSecsSet()) {
            return this.mbean.getMaxPostTimeSecs();
        }
        return webAppContainer.getMaxPostTimeSecs();
    }

    public int getMaxPostSize() {
        if (this.mbean.isMaxPostSizeSet()) {
            return this.mbean.getMaxPostSize();
        }
        return webAppContainer.getMaxPostSize();
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.servlet.internal.HttpServer");
        _WLDF$INST_FLD_Servlet_UnloadWebApp_Around_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_UnloadWebApp_Around_Low");
        _WLDF$INST_FLD_Servlet_LoadWebApp_Around_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_LoadWebApp_Around_Low");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"HttpServer.java", (String)"weblogic.servlet.internal.HttpServer", (String)"loadWebApp", (String)"(Lweblogic/management/configuration/WebAppComponentMBean;Lweblogic/application/ApplicationContextInternal;Lweblogic/servlet/internal/WebAppModule;Ljava/lang/String;)Lweblogic/servlet/internal/WebAppServletContext;", (int)412, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_LoadWebApp_Around_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{null, null, InstrumentationSupport.createValueHandlingInfo((String)"module", (String)"weblogic.diagnostics.instrumentation.gathering.WebAppModuleNameRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"HttpServer.java", (String)"weblogic.servlet.internal.HttpServer", (String)"unloadWebApp", (String)"(Lweblogic/servlet/internal/WebAppServletContext;Ljava/lang/String;)V", (int)461, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_UnloadWebApp_Around_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"ctx", (String)"weblogic.diagnostics.instrumentation.gathering.WebAppModuleNameRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        SERVER_INFO = version.getWebServerReleaseInfo();
        kernelId = WebAppConfigManager.KERNEL_ID;
        FORBIDDEN_RESPONSE = "HTTP/1.0 403 Forbidden\r\nWL-Result: UNAVAIL\r\nContent-Type: text/html\r\n\r\n<TITLE>403 Forbidden</TITLE>The Server is not licensed for this operation.".getBytes();
        PRODUCTION_MODE = ManagementService.getRuntimeAccess(kernelId).getDomain().isProductionModeEnabled();
        webAppContainer = ManagementService.getRuntimeAccess(kernelId).getDomain().getWebAppContainer();
        roidImpl = null;
    }

    private static class SessionIDToROIDMapHolder {
        private final HashSet set = new HashSet();
        private final ROID id;

        private SessionIDToROIDMapHolder(ROID rOID) {
            this.id = rOID;
        }

        private synchronized void add(String string) {
            this.set.add(string);
        }

        private synchronized boolean remove(String string) {
            this.set.remove(string);
            return this.set.size() == 0;
        }

        private ROID getROID() {
            return this.id;
        }
    }

    public static final class WorkContextManager {
        private final Map csidWorkContextMap = new Hashtable();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initOrRestoreThreadContexts(WebAppServletContext webAppServletContext, ServletRequestImpl servletRequestImpl) throws IOException {
            if (this.isThreadContextIgnorable(servletRequestImpl)) {
                return;
            }
            SessionInternal sessionInternal = (SessionInternal)servletRequestImpl.getSession(false);
            String string = servletRequestImpl.getSessionHelper().getSessionID();
            try {
                if (string != null) {
                    byte[] byArray;
                    boolean bl = false;
                    if (sessionInternal != null && (byArray = (byte[])sessionInternal.getInternalAttribute("weblogic.workContexts")) != null) {
                        bl = true;
                        this.restoreWorkContexts(byArray);
                    }
                    if ((byArray = (byte[])this.csidWorkContextMap.get(string)) != null) {
                        bl = true;
                        this.restoreWorkContexts(byArray);
                    }
                    if (bl) {
                        if (HTTPDebugLogger.isEnabled()) {
                            HTTPDebugLogger.debug("*** HttpServer.WorkContextManager.restoreThreadContexts for CSID=" + string + ", app=" + webAppServletContext.getAppDisplayName() + ", workCtxs=" + ApplicationVersionUtils.getDebugWorkContexts());
                        }
                        return;
                    }
                }
            }
            finally {
                if (webAppServletContext.getVersionId() != null) {
                    ApplicationVersionUtils.setCurrentVersionId(webAppServletContext.getApplicationName(), webAppServletContext.getVersionId());
                }
                if (webAppServletContext.isAdminMode()) {
                    ApplicationVersionUtils.setCurrentAdminMode(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyThreadContexts(WebAppServletContext webAppServletContext, ServletRequestImpl servletRequestImpl) {
            if (this.isThreadContextIgnorable(servletRequestImpl)) {
                return;
            }
            try {
                byte[] byArray;
                WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().getLocalInterceptor();
                if (this.isWorkContextEmpty(workContextMapInterceptor) || !webAppContainer.isWorkContextPropagationEnabled()) {
                    return;
                }
                SessionInternal sessionInternal = (SessionInternal)servletRequestImpl.getSession(false);
                if (sessionInternal == null && servletRequestImpl.getResponse().isCommitted()) {
                    return;
                }
                if (webAppServletContext.getVersionId() == null) {
                    if (sessionInternal == null) {
                        sessionInternal = (SessionInternal)servletRequestImpl.getSession(true);
                    }
                } else if (sessionInternal == null) {
                    ApplicationVersionUtils.removeAppWorkContextEntries();
                    if (this.isWorkContextEmpty(workContextMapInterceptor)) {
                        return;
                    }
                    sessionInternal = (SessionInternal)servletRequestImpl.getSession(true);
                } else if (!sessionInternal.hasStateAttributes()) {
                    ApplicationVersionUtils.removeAppWorkContextEntries();
                }
                if ((byArray = this.getWorkContextsByteArray(workContextMapInterceptor)) == null) {
                    return;
                }
                String string = servletRequestImpl.getSessionHelper().getSessionID();
                this.csidWorkContextMap.put(string, byArray);
                sessionInternal.setInternalAttribute("weblogic.workContexts", byArray);
                if (HTTPDebugLogger.isEnabled()) {
                    HTTPDebugLogger.debug("*** HttpServer.WorkContextManager.copyThreadContexts for CSID=" + string + (webAppServletContext == null ? "" : ", app=" + webAppServletContext.getAppDisplayName()) + ", workCtxs=" + ApplicationVersionUtils.getDebugWorkContexts() + ", session=" + sessionInternal);
                }
            }
            catch (IOException iOException) {
                HTTPLogger.logFailedToSaveWorkContexts((String)servletRequestImpl.toString(), (Throwable)iOException);
            }
            finally {
                if (webAppServletContext.isAdminMode()) {
                    ApplicationVersionUtils.setCurrentAdminMode(false);
                }
            }
        }

        private boolean isWorkContextEmpty(WorkContextMapInterceptor workContextMapInterceptor) {
            return workContextMapInterceptor == null || !((WorkContextMap)workContextMapInterceptor).isPropagationModePresent(128);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getWorkContextsByteArray(WorkContextMapInterceptor workContextMapInterceptor) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                WorkContextOutputAdapter workContextOutputAdapter = new WorkContextOutputAdapter((ObjectOutput)objectOutputStream);
                workContextMapInterceptor.sendRequest((WorkContextOutput)workContextOutputAdapter, 128);
            }
            finally {
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restoreWorkContexts(byte[] byArray) throws IOException {
            WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().getInterceptor();
            if (workContextMapInterceptor == null) {
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                WorkContextInputAdapter workContextInputAdapter = new WorkContextInputAdapter((ObjectInput)objectInputStream);
                workContextMapInterceptor.receiveRequest((WorkContextInput)workContextInputAdapter);
            }
            finally {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void updateWorkContexts(String string, byte[] byArray) {
            this.csidWorkContextMap.put(string, byArray);
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("*** HttpServer.WorkContextManager.updateThreadContexts for CSID=" + string + ", workCtxs=" + byArray);
            }
        }

        private void removeWorkContext(String string) {
            this.csidWorkContextMap.remove(string);
        }

        private boolean isThreadContextIgnorable(ServletRequestImpl servletRequestImpl) {
            return servletRequestImpl.getServletStub().isFileServlet() || servletRequestImpl.getServletStub().isClasspathServlet() || servletRequestImpl.getServletStub().isProxyServlet() || servletRequestImpl.getServletStub().isPubSubControllerServlet();
        }
    }

    public static final class SessionLogin {
        private final Map webapps = new ConcurrentHashMap();
        private final Map authUsers = new ConcurrentHashMap();
        private final Map authCookies = new ConcurrentHashMap();
        private final WorkContextManager workCtxManager;

        private SessionLogin(WorkContextManager workContextManager) {
            this.workCtxManager = workContextManager;
        }

        public AuthenticatedSubject getUser(String string) {
            return (AuthenticatedSubject)this.authUsers.get(string);
        }

        public void setUser(String string, AuthenticatedSubject authenticatedSubject) {
            this.authUsers.put(string, authenticatedSubject);
        }

        private void removeUser(String string) {
            this.authUsers.remove(string);
            this.authCookies.remove(string);
        }

        public void register(String string, String string2) {
            HashSet<String> hashSet = (HashSet<String>)this.webapps.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.webapps.put(string, hashSet);
            }
            hashSet.add(string2);
        }

        public void unregister(String string, String string2) {
            Set set = (Set)this.webapps.get(string);
            if (set != null) {
                set.remove(string2);
            }
            if (set == null || set.size() == 0) {
                this.removeUser(string);
                this.webapps.remove(string);
                this.workCtxManager.removeWorkContext(string);
            }
        }

        public void unregister(String string) {
            this.removeUser(string);
            this.webapps.remove(string);
            this.workCtxManager.removeWorkContext(string);
        }

        public Set getAllIds() {
            HashSet hashSet = new HashSet(this.webapps.keySet());
            return hashSet;
        }

        public void addCookieId(String string, String string2) {
            this.authCookies.put(string, string2);
        }

        public String getCookieId(String string) {
            return (String)this.authCookies.get(string);
        }
    }

    public final class Replicator {
        private final Map sessionIDToROIDPrimaryMap = new ConcurrentHashMap(101);
        private final Map sessionIDToROIDSecondaryMap = new ConcurrentHashMap(101);
        private final Map secondaryROIDMap = new WeakConcurrentHashMap(101);

        public void updateROIDLastAccessTimes(String string, ROID[] rOIDArray, long[] lArray, String string2) {
            try {
                ROIDLookup rOIDLookup = this.getROIDLookup(string);
                if (rOIDLookup == null) {
                    return;
                }
                rOIDLookup.updateLastAccessTimes(rOIDArray, lArray, System.currentTimeMillis(), string2);
            }
            catch (RemoteException remoteException) {
                HTTPLogger.logFailedToPerformBatchedLATUpdate((String)HttpServer.this.getName(), null, (String)string, (int)0, (int)0, (Throwable)remoteException);
            }
        }

        public ROID lookupROID(String string, String string2, String string3, String string4) throws RemoteException {
            return this.lookupROID(string, string2, string3, string4, false);
        }

        public ROID lookupROID(String string, String string2, String string3, String string4, boolean bl) throws RemoteException {
            Object object;
            WebAppServletContext[] webAppServletContextArray;
            if (!bl) {
                webAppServletContextArray = HttpServer.this.getServletContextManager().getAllContexts();
                if (webAppServletContextArray == null) {
                    return null;
                }
                for (int i = 0; i < webAppServletContextArray.length; ++i) {
                    ReplicatedSessionContext replicatedSessionContext;
                    object = webAppServletContextArray[i].getSessionContext();
                    if (((SessionContext)object).getPersistentStoreType() != "replicated" || !((SessionContext)object).getConfigMgr().getCookieName().equals(string3) || !((SessionContext)object).getConfigMgr().getCookiePath().equals(string4) || (replicatedSessionContext = (ReplicatedSessionContext)object).getROID(string) == null) continue;
                    return null;
                }
            }
            if ((webAppServletContextArray = this.getROIDLookup(string2)) == null) {
                return null;
            }
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
            if (authenticatedSubject != null && SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject)) {
                try {
                    object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedExceptionAction)new PrivilegedExceptionAction((ROIDLookup)webAppServletContextArray, string, string3, string4){
                        final /* synthetic */ ROIDLookup val$localStub;
                        final /* synthetic */ String val$sessionid;
                        final /* synthetic */ String val$cookieName;
                        final /* synthetic */ String val$cookiePath;
                        {
                            this.val$localStub = rOIDLookup;
                            this.val$sessionid = string;
                            this.val$cookieName = string2;
                            this.val$cookiePath = string3;
                        }

                        public Object run() throws RemoteException {
                            return this.val$localStub.lookupROID(this.val$sessionid, this.val$cookieName, this.val$cookiePath);
                        }
                    });
                    return (ROID)object;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (RemoteException)privilegedActionException.getException();
                }
            }
            return webAppServletContextArray.lookupROID(string, string3, string4);
        }

        public void putPrimary(String string, ROID rOID, String string2) {
            this.removeSecondary(string, string2);
            SessionIDToROIDMapHolder sessionIDToROIDMapHolder = (SessionIDToROIDMapHolder)this.sessionIDToROIDPrimaryMap.get(string);
            if (sessionIDToROIDMapHolder == null) {
                sessionIDToROIDMapHolder = new SessionIDToROIDMapHolder(rOID);
                this.sessionIDToROIDPrimaryMap.put(string, sessionIDToROIDMapHolder);
            }
            sessionIDToROIDMapHolder.add(string2);
        }

        public void putSecondary(String string, ROID rOID, String string2) {
            this.removePrimary(string, string2);
            SessionIDToROIDMapHolder sessionIDToROIDMapHolder = (SessionIDToROIDMapHolder)this.sessionIDToROIDSecondaryMap.get(string);
            if (sessionIDToROIDMapHolder == null) {
                sessionIDToROIDMapHolder = new SessionIDToROIDMapHolder(rOID);
                this.sessionIDToROIDSecondaryMap.put(string, sessionIDToROIDMapHolder);
            }
            sessionIDToROIDMapHolder.add(string2);
            this.secondaryROIDMap.put(rOID, null);
        }

        public ROID getPrimary(String string) {
            SessionIDToROIDMapHolder sessionIDToROIDMapHolder = (SessionIDToROIDMapHolder)this.sessionIDToROIDPrimaryMap.get(string);
            if (sessionIDToROIDMapHolder == null) {
                return null;
            }
            return sessionIDToROIDMapHolder.getROID();
        }

        public ROID getSecondary(String string) {
            SessionIDToROIDMapHolder sessionIDToROIDMapHolder = (SessionIDToROIDMapHolder)this.sessionIDToROIDSecondaryMap.get(string);
            if (sessionIDToROIDMapHolder == null) {
                return null;
            }
            return sessionIDToROIDMapHolder.getROID();
        }

        public void removePrimary(String string, String string2) {
            SessionIDToROIDMapHolder sessionIDToROIDMapHolder = (SessionIDToROIDMapHolder)this.sessionIDToROIDPrimaryMap.get(string);
            if (sessionIDToROIDMapHolder != null && sessionIDToROIDMapHolder.remove(string2)) {
                this.sessionIDToROIDPrimaryMap.remove(string);
            }
        }

        public void removeSecondary(String string, String string2) {
            SessionIDToROIDMapHolder sessionIDToROIDMapHolder = (SessionIDToROIDMapHolder)this.sessionIDToROIDSecondaryMap.get(string);
            if (sessionIDToROIDMapHolder != null && sessionIDToROIDMapHolder.remove(string2)) {
                this.sessionIDToROIDSecondaryMap.remove(string);
                this.secondaryROIDMap.remove(sessionIDToROIDMapHolder.getROID());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ROID[] getSecondaryIds() {
            ROID[] rOIDArray = null;
            Map map = this.secondaryROIDMap;
            synchronized (map) {
                int n = this.secondaryROIDMap.size();
                if (n < 1) {
                    return new ROID[0];
                }
                rOIDArray = new ROID[n];
                this.secondaryROIDMap.keySet().toArray(rOIDArray);
            }
            return rOIDArray;
        }

        private ROIDLookup getROIDLookup(String string) {
            try {
                Environment environment = new Environment();
                environment.setProviderUrl(string);
                environment.setProviderChannel(HttpServer.this.replicationChannel);
                return (ROIDLookup)environment.getInitialReference(ROIDLookupImpl.class);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }
}

