/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.HashMap;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannelManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.internal.ContextVersionManager;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ProtocolHandlerHTTP;
import weblogic.servlet.internal.ServletContextManager;
import weblogic.servlet.internal.ServletInputStreamImpl;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;
import weblogic.servlet.security.ServletAuthentication;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.utils.http.HttpRequestParseException;
import weblogic.utils.http.HttpRequestParser;
import weblogic.utils.io.NullInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class InternalRequestDispatcher {
    private static final boolean DEBUG = false;
    private static final String CONTENT_TYPE = "Content-Type";
    private final String host;
    private final String uri;
    private final HashMap headers = new HashMap();
    private String content;
    private String charset;
    private int status = 0;
    private String statusString = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String runAs = null;

    public InternalRequestDispatcher(String string) throws IOException {
        this(string, null);
    }

    public InternalRequestDispatcher(String string, String string2) throws IOException {
        this(string, string2, null);
    }

    public InternalRequestDispatcher(String string, String string2, String string3) throws IOException {
        this.host = string2;
        this.uri = string;
        this.runAs = string3;
        this.dispatch();
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public String getContent() {
        return this.content;
    }

    public String getHeader(String string) {
        return (String)this.headers.get(string);
    }

    public String getContentType() {
        return this.getHeader(CONTENT_TYPE);
    }

    public String getCharset() {
        return this.charset;
    }

    protected void dispatch() throws IOException {
        Object object;
        WebAppServletContext webAppServletContext;
        HttpRequestParser httpRequestParser;
        if (this.uri == null || !this.uri.startsWith("/")) {
            throw new IOException("URI must be absolute with no protocol, etc: " + this.uri);
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ServletRequestImpl servletRequestImpl = new ServletRequestImpl(null);
        byte[] byArray = new String("GET " + this.uri + " " + "HTTP/1.0" + "\r\n\r\n").getBytes();
        try {
            httpRequestParser = new HttpRequestParser(byArray, byArray.length);
        }
        catch (HttpRequestParseException httpRequestParseException) {
            IOException iOException = new IOException("Couldn't parse request");
            iOException.initCause(httpRequestParseException);
            throw iOException;
        }
        servletRequestImpl.initFromRequestParser(httpRequestParser);
        ServletResponseImpl servletResponseImpl = new ServletResponseImpl(servletRequestImpl, (OutputStream)unsyncByteArrayOutputStream);
        servletResponseImpl.getServletOutputStream().setWriteEnabled(!"HEAD".equals(httpRequestParser.getMethod()));
        HttpServer httpServer = null;
        httpServer = this.host != null ? WebService.getVirtualHost(this.host) : WebService.defaultHttpServer();
        if (httpServer == null) {
            throw new IOException("Virtual host not found: " + this.host);
        }
        ServletContextManager servletContextManager = httpServer.getServletContextManager();
        ContextVersionManager contextVersionManager = servletContextManager.resolveVersionManagerForURI(this.uri);
        if (contextVersionManager.isVersioned()) {
            servletRequestImpl.initContextManager(contextVersionManager);
            webAppServletContext = servletRequestImpl.getContext();
        } else {
            webAppServletContext = contextVersionManager.getContext();
            servletRequestImpl.initContext(webAppServletContext);
        }
        ServletInputStreamImpl servletInputStreamImpl = new ServletInputStreamImpl((InputStream)NullInputStream.getInstance());
        servletRequestImpl.setInputStream(servletInputStreamImpl);
        String string = httpServer.getFrontendHost();
        if (string != null) {
            servletRequestImpl.setServerName(string);
        } else {
            servletRequestImpl.setServerName(httpServer.getListenAddress());
        }
        int n = httpServer.getFrontendHTTPPort();
        if (n != 0) {
            servletRequestImpl.setServerPort(n);
        } else {
            servletRequestImpl.setServerPort(ServerChannelManager.findLocalServerChannel((Protocol)ProtocolHandlerHTTP.PROTOCOL_HTTP).getPublicPort());
        }
        servletResponseImpl.initContext(webAppServletContext);
        servletResponseImpl.getServletOutputStream().setHttpServer(httpServer);
        servletResponseImpl.setHeaderInternal("Server", HttpServer.SERVER_INFO);
        if (!ManagementService.getRuntimeAccess(kernelId).getServer().isHttpdEnabled()) {
            throw new IOException("HTTP is not enabled on this server!");
        }
        if (webAppServletContext == null) {
            servletResponseImpl.sendError(404);
            this.status = 404;
            this.statusString = "Not Found";
            return;
        }
        ServletStubImpl servletStubImpl = webAppServletContext.resolveDirectRequest(servletRequestImpl);
        servletRequestImpl.setServletStub(servletStubImpl);
        if (this.runAs != null && (object = this.getRunAsSubject(this.runAs, servletRequestImpl, servletResponseImpl, webAppServletContext)) != null) {
            ServletAuthentication.runAs(object, (HttpServletRequest)servletRequestImpl);
        }
        servletRequestImpl.getHttpAccountingInfo().setInvokeTime(System.currentTimeMillis());
        webAppServletContext.execute(servletRequestImpl, servletResponseImpl);
        try {
            servletResponseImpl.getServletOutputStream().flush();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        object = unsyncByteArrayOutputStream.toByteArray();
        unsyncByteArrayOutputStream.close();
        servletResponseImpl.getServletOutputStream().close();
        int n2 = this.parseHttpHeaders((byte[])object);
        this.parseCharset();
        if (n2 == -1) {
            return;
        }
        if (this.getCharset() != null) {
            try {
                this.content = new String((byte[])object, n2, ((AuthenticatedSubject)object).length - n2, this.getCharset());
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            this.content = new String((byte[])object, n2, ((AuthenticatedSubject)object).length - n2, "ISO-8859-1");
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.content = new String((byte[])object, n2, ((AuthenticatedSubject)object).length - n2);
            return;
        }
    }

    protected int parseHttpHeaders(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        block9: {
            n3 = -1;
            String string = this.getFirstLine(byArray);
            n2 = 0;
            n = byArray.length;
            byte[] byArray2 = byArray;
            if (string == null) {
                return n3;
            }
            n2 = string.length();
            while (byArray2[n2] == 10 || byArray2[n2] == 13) {
                ++n2;
            }
            this.parseResponseStatus(string);
            while (true) {
                String string2 = null;
                int n4 = n2;
                while (n2 < n && byArray2[n2] != 10 && (byArray2[n2] != 13 || ++n2 >= n || byArray2[n2] != 10)) {
                    if (byArray2[n2] == 58) {
                        if (++n2 < n) {
                            string2 = new String(byArray2, n4, n2 - n4 - 1);
                            if (byArray2[n2] == 32) break;
                            --n2;
                            break;
                        }
                        throw new IllegalArgumentException("malformed HTTP headers");
                    }
                    ++n2;
                }
                ++n2;
                if (string2 == null) break block9;
                n4 = n2;
                String string3 = null;
                while (n2 < n) {
                    if (byArray2[n2] == 10) {
                        string3 = new String(byArray2, n4, n2 - n4);
                        break;
                    }
                    if (byArray2[n2] == 13 && ++n2 < n && byArray2[n2] == 10) {
                        string3 = new String(byArray2, n4, n2 - n4 - 1);
                        break;
                    }
                    ++n2;
                }
                ++n2;
                if (string3 == null) break;
                this.headers.put(string2, string3);
            }
            throw new IllegalArgumentException("malformed HTTP headers");
        }
        n3 = n2 <= n ? n2 : -1;
        return n3;
    }

    protected String getFirstLine(byte[] byArray) {
        int n;
        String string = null;
        int n2 = 0;
        int n3 = byArray.length;
        byte[] byArray2 = byArray;
        for (n2 = n = 0; n2 < n3; ++n2) {
            if (byArray2[n2] == 10) {
                string = new String(byArray2, n, n2);
                break;
            }
            if (byArray2[n2] != 13) continue;
            if (byArray2[++n2] != 10 || n2 <= 2) break;
            string = new String(byArray2, n, n2 - 1);
            break;
        }
        return string;
    }

    protected void parseResponseStatus(String string) {
        int n = (string = string.trim()).indexOf(32);
        if (n != -1) {
            int n2 = string.indexOf(32, n + 1);
            if (n2 != -1) {
                this.statusString = string.substring(n2 + 1);
            } else {
                n2 = string.length();
            }
            try {
                this.status = Integer.parseInt(string.substring(n + 1, n2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void parseCharset() {
        String string = this.getContentType();
        if (string == null) {
            return;
        }
        int n = string.indexOf("charset=");
        if (n != -1) {
            int n2 = string.indexOf(";", n);
            n += 8;
            this.charset = n2 == -1 ? string.substring(n) : string.substring(n, n2);
        }
    }

    private AuthenticatedSubject getRunAsSubject(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl, WebAppServletContext webAppServletContext) {
        try {
            return this.getPrincipalAuthenticator(webAppServletContext).impersonateIdentity(string, WebAppSecurity.getContextHandler(servletRequestImpl, servletResponseImpl));
        }
        catch (LoginException loginException) {
            webAppServletContext.log("Failed to get runAs subject for the InternalRequestDispatcher", loginException);
            throw new IllegalArgumentException(loginException.getMessage());
        }
    }

    private PrincipalAuthenticator getPrincipalAuthenticator(WebAppServletContext webAppServletContext) {
        return (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)webAppServletContext.getSecurityRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
    }
}

