/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import weblogic.application.utils.SecPermSpecUtils;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.JspConfigBean;
import weblogic.j2ee.descriptor.JspPropertyGroupBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.ServletMappingBean;
import weblogic.j2ee.descriptor.TagLibBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.JspDescriptorBean;
import weblogic.j2ee.descriptor.wl.SecurityPermissionBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SupplementalPolicyObject;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.JSPServlet;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebComponentBeanUpdateListener;
import weblogic.servlet.jsp.JSPPrecompiler;
import weblogic.servlet.jsp.JspConfig;
import weblogic.servlet.jsp.JspFactoryImpl;
import weblogic.servlet.jsp.JspStub;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.io.FilenameEncoder;

public final class JSPManager {
    private static final char FSC = File.separatorChar;
    public static final String PAGE_CHECK_SECS = "PageCheckSeconds";
    public static final String JSP_VERBOSE = "Verbose";
    public static final String JSP_KEEP_GENERATED = "Keepgenerated";
    private final WebAppServletContext context;
    private final HashMap jspcArgs = new HashMap();
    private TagLibBean[] taglibs;
    private String userJSPWorkingDir;
    private String jspcPkgPrefix;
    private boolean jspExactMapping = false;
    private String jspServletClazz = JspConfig.DEFAULT_JSP_SERVLET;
    private final ArrayList jspConfigs = new ArrayList();
    private String jspSecuritySpec;
    private boolean jspPrecompileEnabled = false;
    private Set jspExtensions;
    private final BeanUpdateListener jspBeanListener;
    private String resourceProviderClass;
    private boolean isStrictStaleCheck = true;
    private boolean pageCheckSecondsSet = false;
    private int pageCheckSeconds = HttpServer.isProductionModeEnabled() ? -1 : 1;
    static Map JSP_DESC_ELEMENTS_MAP = new HashMap();
    static final String DEPRECATED_JSP_ELEMENT = "warning";

    JSPManager(WebAppServletContext webAppServletContext) {
        this.context = webAppServletContext;
        this.jspBeanListener = this.createBeanUpdateListener();
    }

    public boolean isJspExactMapping() {
        return this.jspExactMapping;
    }

    public TagLibBean[] getTagLibs() {
        return this.taglibs;
    }

    public Map getJspConfigArgs() {
        return this.jspcArgs;
    }

    String getJspcPkgPrefix() {
        return this.jspcPkgPrefix;
    }

    public String getResourceProviderClass() {
        return this.resourceProviderClass;
    }

    public String getJSPWorkingDir() {
        if (this.userJSPWorkingDir != null) {
            return this.userJSPWorkingDir;
        }
        File file = this.context.getRootTempDir();
        String string = file.getAbsolutePath();
        if (string == null) {
            string = ".";
        }
        return string;
    }

    public synchronized JspConfig createJspConfig() {
        JspConfig jspConfig = new JspConfig(this.jspcArgs);
        this.jspConfigs.add(jspConfig);
        return jspConfig;
    }

    boolean isPageCheckSecondsSet() {
        return this.pageCheckSecondsSet;
    }

    int getPageCheckSeconds() {
        return this.pageCheckSeconds;
    }

    void destroy() {
        if (this.jspSecuritySpec != null) {
            String string;
            String[] stringArray = new String[2];
            if (this.context.getDocroot() != null) {
                stringArray[0] = this.context.getDocroot().replace(FSC, '/');
            }
            if ((string = this.getJSPWorkingDir()) != null) {
                stringArray[1] = FilenameEncoder.resolveRelativeURIPath((String)string.replace(FSC, '/'));
            }
            SupplementalPolicyObject.removePolicies((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (String[])stringArray);
        }
    }

    public void registerTagLibs(JspConfigBean[] jspConfigBeanArray) {
        if (jspConfigBeanArray == null || jspConfigBeanArray.length == 0) {
            return;
        }
        this.taglibs = jspConfigBeanArray[0].getTagLibs();
    }

    void registerSecurityPermissionSpec(WeblogicWebAppBean weblogicWebAppBean) {
        String string;
        String string2;
        SecurityPermissionBean securityPermissionBean = null;
        if (weblogicWebAppBean != null) {
            securityPermissionBean = (SecurityPermissionBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getSecurityPermissions(), "SecurityPermission");
        }
        if (securityPermissionBean != null) {
            this.jspSecuritySpec = securityPermissionBean.getSecurityPermissionSpec();
        }
        String[] stringArray = new String[]{string2 = JSPManager.getCanonicalPath(this.context.getDocroot()).replace(FSC, '/'), string = JSPManager.getCanonicalPath(this.getJSPWorkingDir()).replace(FSC, '/')};
        SupplementalPolicyObject.setPoliciesFromGrantStatement((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (String[])stringArray, (String)(this.context.getApplicationContext() == null ? this.jspSecuritySpec : SecPermSpecUtils.getNewSecurityPermissionSpec(this.context.getApplicationContext(), this.jspSecuritySpec)), (String)"WEB");
    }

    private static String getCanonicalPath(String string) {
        try {
            return new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void precompileJSPs() throws DeploymentException {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        try {
            try {
                Object object;
                JspConfig jspConfig = new JspConfig(this.jspcArgs);
                if (HTTPDebugLogger.isEnabled()) {
                    object = HTTPLogger.logPrecompilingJSPsLoggable((String)this.context.getAppDisplayName(), (String)this.context.getModuleName(), (String)jspConfig.toString());
                    HTTPDebugLogger.debug(object.getMessage());
                }
                object = null;
                Class<?> clazz = Class.forName(JspConfig.COMMON_UTILS.getJspPrecompilerClass());
                object = (JSPPrecompiler)clazz.newInstance();
                File file = new File(this.context.getDocroot());
                thread2.setContextClassLoader(this.context.getServletClassLoader());
                object.compile(this.context, file);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Loggable loggable = HTTPLogger.logFailureCompilingJSPsLoggable((String)this.context.getAppDisplayName(), (String)this.context.getModuleName(), (Throwable)exception);
                loggable.log();
                throw new DeploymentException(exception);
            }
            Object var8_10 = null;
            thread2.setContextClassLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            thread2.setContextClassLoader(classLoader);
            throw throwable;
        }
    }

    private void setArg(HashMap hashMap, String string, String string2) {
        if (string2 != null) {
            hashMap.put(string, string2);
        }
    }

    void setJspParam(String string, String string2) throws DeploymentException {
        for (JspConfig jspConfig : this.jspConfigs) {
            if (string.equals("workingDir")) {
                if (string2 == null) {
                    throw new DeploymentException("JSP 'workingDir' cannot be null");
                }
                this.userJSPWorkingDir = string2;
                if (this.userJSPWorkingDir != null) {
                    this.userJSPWorkingDir = this.userJSPWorkingDir.replace('/', File.separatorChar);
                    this.ensureWorkingDir(this.userJSPWorkingDir);
                }
                jspConfig.setWorkingDir(string2);
                continue;
            }
            if (string.equals("pageCheckSeconds")) {
                jspConfig.setPageCheckSecs(Long.parseLong(string2));
                continue;
            }
            if (string.equals("compileCommand")) {
                jspConfig.setCompileCommand(string2);
                continue;
            }
            if (string.equals("compilerclass")) {
                jspConfig.setCompilerClass(string2);
                continue;
            }
            if (string.equals("compileFlags")) {
                jspConfig.setCompileFlagsString(string2);
                continue;
            }
            if (string.equals("verbose")) {
                jspConfig.setVerbose("true".equalsIgnoreCase(string2));
                continue;
            }
            if (string.equals("keepgenerated")) {
                jspConfig.setKeepGenerated("true".equalsIgnoreCase(string2));
                continue;
            }
            if (string.equals("precompileContinue")) {
                jspConfig.setPrecompileContinue("true".equalsIgnoreCase(string2));
                continue;
            }
            if (string.equals("encoding")) {
                jspConfig.setEncoding(string2);
                continue;
            }
            if (string.equals("compilerSupportsEncoding")) {
                jspConfig.setCompilerSupportsEncoding("true".equalsIgnoreCase(string2));
                continue;
            }
            if (string.equals("noTryBlocks")) {
                jspConfig.setNoTryBlocks("true".equalsIgnoreCase(string2));
                continue;
            }
            if (string.equals("exactMapping")) {
                jspConfig.setExactMapping("true".equalsIgnoreCase(string2));
                continue;
            }
            if (string.equals("debug")) {
                jspConfig.setDebugEnabled("true".equalsIgnoreCase(string2));
                continue;
            }
            if (string.equals("compressHtmlTemplate")) {
                jspConfig.setCompressHtmlTemplate("true".equalsIgnoreCase(string2));
                continue;
            }
            if (string.equals("optimizeJavaExpression")) {
                jspConfig.setOptimizeJavaExpression("true".equalsIgnoreCase(string2));
                continue;
            }
            throw new DeploymentException("Unrecognized JSP param: " + string);
        }
        this.setArg(this.jspcArgs, string, string2);
    }

    ServletStubImpl registerJSPServletDefinition(ServletBean servletBean, HashMap hashMap) throws DeploymentException {
        JspStub jspStub;
        String string = servletBean.getJspFile();
        if (string == null) {
            Loggable loggable = HTTPLogger.logNeedServletClassOrJspFileLoggable((String)servletBean.getServletName());
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        string = HttpParsing.ensureStartingSlash((String)string);
        String string2 = JSPServlet.uri2classname(this.jspcPkgPrefix, string);
        try {
            Servlet servlet = (Servlet)Class.forName(this.jspServletClazz).newInstance();
            if (servlet instanceof JSPServlet) {
                JSPServlet jSPServlet = (JSPServlet)servlet;
                jspStub = JSPServlet.getNewJspStub(servletBean.getServletName(), string2, hashMap, this.context, new JspConfig(this.jspcArgs));
                if (this.context.getRuntimeMBean() != null) {
                    jspStub.initRuntime();
                }
            } else {
                throw new DeploymentException("Unrecognized JSP Servlet '" + this.jspServletClazz);
            }
            jspStub.setFilePath(string);
            this.context.registerServletStub(servletBean.getServletName(), jspStub);
            this.context.registerServletMap(servletBean.getServletName(), string, jspStub);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeploymentException("Error initializing JSP Servlet", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new DeploymentException("Error initializing JSP Servlet", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DeploymentException("Error initializing JSP Servlet", illegalAccessException);
        }
        catch (ServletException servletException) {
            throw new DeploymentException("Error initializing JSP Servlet", servletException);
        }
        catch (ManagementException managementException) {
            throw new DeploymentException("Error initializing JSP Servlet", managementException);
        }
        return jspStub;
    }

    void registerJspDescriptor(WebAppBean webAppBean, WeblogicWebAppBean weblogicWebAppBean) throws DeploymentException {
        String string;
        Object object;
        this.addJspExtensions(webAppBean);
        this.jspcArgs.put("workingDir", this.getJSPWorkingDir());
        this.jspcArgs.put("verbose", "true");
        this.jspExactMapping = true;
        Object object2 = this.context.getInitParameterNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            int n = "weblogic.jsp.".length();
            if (!((String)object).startsWith("weblogic.jsp.") || ((String)object).length() < n + 1) continue;
            string = this.context.getInitParameter((String)object);
            object = ((String)object).substring(n);
            this.jspcArgs.put(object, string);
        }
        this.jspcArgs.put("rtexprvalueJspParamName", "" + this.context.getConfigManager().isRtexprvalueJspParamName());
        this.jspcArgs.put("backwardCompatible", "" + this.context.getConfigManager().isJSPCompilerBackwardsCompatible());
        if (weblogicWebAppBean != null) {
            this.initialize((JspDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getJspDescriptors(), "JspDescriptor"));
        }
        if (!HttpServer.isProductionModeEnabled() && JspConfig.checkCompilerClass() && this.jspcArgs != null && this.jspcArgs.get("compilerClass") == null && (object2 = (String)this.jspcArgs.get("compileCommand")) == null) {
            this.setArg(this.jspcArgs, "compilerClass", "com.sun.tools.javac.Main");
        }
        if (this.jspcPkgPrefix == null) {
            this.jspcPkgPrefix = "jsp_servlet";
        }
        object2 = new HashMap();
        if (!this.context.getConfigManager().isImplicitServletMappingDisabled()) {
            this.context.registerServlet("JspServlet", "*.jsp", this.jspServletClazz, (Map)object2);
            this.context.registerServlet("JspServlet", "*.jspx", this.jspServletClazz, (Map)object2);
        }
        if ((object = JSPManager.getJspConfigPatterns(webAppBean.getJspConfigs())) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (null != this.context.getServletStub(string)) continue;
                this.context.registerServlet("JspServlet", string, this.jspServletClazz, (Map)object2);
            }
        }
    }

    private void initialize(JspDescriptorBean jspDescriptorBean) throws DeploymentException {
        DescriptorBean descriptorBean;
        if (jspDescriptorBean == null) {
            return;
        }
        this.userJSPWorkingDir = jspDescriptorBean.getWorkingDir();
        if (this.userJSPWorkingDir != null) {
            this.userJSPWorkingDir = this.userJSPWorkingDir.replace('/', File.separatorChar);
            this.ensureWorkingDir(this.userJSPWorkingDir);
        }
        this.jspPrecompileEnabled = jspDescriptorBean.isPrecompile();
        this.jspcPkgPrefix = jspDescriptorBean.getPackagePrefix();
        this.jspExactMapping = jspDescriptorBean.isExactMapping();
        this.resourceProviderClass = jspDescriptorBean.getResourceProviderClass();
        this.isStrictStaleCheck = jspDescriptorBean.isStrictStaleCheck();
        if (jspDescriptorBean.getEncoding() != null) {
            HTTPLogger.logDeprecatedEncodingPropertyUsed((String)this.context.getLogContext());
        }
        if ((descriptorBean = (DescriptorBean)jspDescriptorBean).isSet("RtexprvalueJspParamName")) {
            this.setArg(this.jspcArgs, "rtexprvalueJspParamName", "" + jspDescriptorBean.isRtexprvalueJspParamName());
        }
        if (descriptorBean.isSet("BackwardCompatible")) {
            this.setArg(this.jspcArgs, "backwardCompatible", "" + jspDescriptorBean.isBackwardCompatible());
        }
        if (jspDescriptorBean.isPageCheckSecondsSet()) {
            this.pageCheckSecondsSet = true;
            this.pageCheckSeconds = jspDescriptorBean.getPageCheckSeconds();
        }
        this.setArg(this.jspcArgs, "encoding", jspDescriptorBean.getEncoding());
        this.setArg(this.jspcArgs, "keepgenerated", "" + jspDescriptorBean.isKeepgenerated());
        this.setArg(this.jspcArgs, "superclass", jspDescriptorBean.getSuperClass());
        this.setArg(this.jspcArgs, "pageCheckSeconds", "" + jspDescriptorBean.getPageCheckSeconds());
        this.setArg(this.jspcArgs, "index.jsp", jspDescriptorBean.getDefaultFileName());
        this.setArg(this.jspcArgs, "workingDir", jspDescriptorBean.getWorkingDir());
        this.setArg(this.jspcArgs, "packagePrefix", jspDescriptorBean.getPackagePrefix());
        this.setArg(this.jspcArgs, "printNulls", "" + jspDescriptorBean.isPrintNulls());
        this.setArg(this.jspcArgs, "exactMapping", "" + jspDescriptorBean.isExactMapping());
        this.setArg(this.jspcArgs, "verbose", "" + jspDescriptorBean.isVerbose());
        this.setArg(this.jspcArgs, "debug", "" + jspDescriptorBean.isDebug());
        this.setArg(this.jspcArgs, "compressHtmlTemplate", "" + jspDescriptorBean.isCompressHtmlTemplate());
        this.setArg(this.jspcArgs, "optimizeJavaExpression", "" + jspDescriptorBean.isOptimizeJavaExpression());
        if (this.jspPrecompileEnabled) {
            this.setArg(this.jspcArgs, "precompileContinue", "" + jspDescriptorBean.isPrecompileContinue());
        }
        if (jspDescriptorBean.getResourceProviderClass() != null) {
            this.setArg(this.jspcArgs, "resourceProviderClass", jspDescriptorBean.getResourceProviderClass());
        }
    }

    private void ensureWorkingDir(String string) throws DeploymentException {
        File file = new File(string);
        if (file.exists()) {
            return;
        }
        if (file.mkdirs()) {
            return;
        }
        if (file.exists()) {
            return;
        }
        System.out.println("*** Debug: WORKINGDIR:" + file.getAbsolutePath());
        throw new DeploymentException("Working directory: " + string + " was not found and could not be created");
    }

    boolean isJspPrecompileEnabled() {
        return this.jspPrecompileEnabled;
    }

    boolean isStrictStaleCheck() {
        return this.isStrictStaleCheck;
    }

    public static Set getJspConfigPatterns(JspConfigBean[] jspConfigBeanArray) {
        if (jspConfigBeanArray == null || jspConfigBeanArray.length == 0) {
            return null;
        }
        JspConfigBean jspConfigBean = jspConfigBeanArray[0];
        JspPropertyGroupBean[] jspPropertyGroupBeanArray = jspConfigBean.getJspPropertyGroups();
        if (jspPropertyGroupBeanArray == null) {
            return null;
        }
        HashSet<String> hashSet = null;
        for (int i = 0; i < jspPropertyGroupBeanArray.length; ++i) {
            String[] stringArray = jspPropertyGroupBeanArray[i].getUrlPatterns();
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                if ("*.jspx".equals(string)) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                if (!string.startsWith("*.")) {
                    string = HttpParsing.ensureStartingSlash((String)string);
                }
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    void addJspExtensions(WebAppBean webAppBean) {
        ServletBean[] servletBeanArray = webAppBean.getServlets();
        ArrayList<String> arrayList = null;
        if (servletBeanArray != null) {
            for (int i = 0; i < servletBeanArray.length; ++i) {
                if (!JspConfig.DEFAULT_JSP_SERVLET.equals(servletBeanArray[i].getServletClass())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(servletBeanArray[i].getServletName());
            }
            if (arrayList != null && arrayList.size() > 0) {
                ServletMappingBean[] servletMappingBeanArray = webAppBean.getServletMappings();
                if (servletMappingBeanArray == null) {
                    return;
                }
                for (int i = 0; i < servletMappingBeanArray.length; ++i) {
                    String string = servletMappingBeanArray[i].getServletName();
                    if (!arrayList.contains(string)) continue;
                    if (this.jspExtensions == null) {
                        this.jspExtensions = new HashSet();
                    }
                    if (servletMappingBeanArray[i].getUrlPatterns() == null || servletMappingBeanArray[i].getUrlPatterns().length <= 0) continue;
                    this.jspExtensions.addAll(Arrays.asList(servletMappingBeanArray[i].getUrlPatterns()));
                }
            }
        }
    }

    public Set getJspExtensions() {
        return this.jspExtensions;
    }

    BeanUpdateListener getBeanUpdateListener() {
        return this.jspBeanListener;
    }

    private BeanUpdateListener createBeanUpdateListener() {
        return new WebComponentBeanUpdateListener(){

            protected void handlePropertyRemove(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
                String string = propertyUpdate.getPropertyName();
                if (JSPManager.PAGE_CHECK_SECS.equals(string)) {
                    JSPManager.this.pageCheckSecondsSet = false;
                    JSPManager.this.pageCheckSeconds = HttpServer.isProductionModeEnabled() ? -1 : 1;
                }
                for (JspConfig jspConfig : JSPManager.this.jspConfigs) {
                    if (JSPManager.JSP_VERBOSE.equals(string)) {
                        jspConfig.setVerbose(true);
                        JSPManager.this.setArg(JSPManager.this.jspcArgs, "verbose", "ture");
                    }
                    if (JSPManager.JSP_KEEP_GENERATED.equals(string)) {
                        jspConfig.setKeepGenerated(false);
                        JSPManager.this.setArg(JSPManager.this.jspcArgs, "keepgenerated", "false");
                    }
                    if (!JSPManager.PAGE_CHECK_SECS.equals(string)) continue;
                    jspConfig.setPageCheckSecs(HttpServer.isProductionModeEnabled() ? -1L : 1L);
                    JSPManager.this.setArg(JSPManager.this.jspcArgs, "pageCheckSeconds", "" + jspConfig.getPageCheckSecs());
                }
            }

            protected void handlePropertyChange(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) {
                JspDescriptorBean jspDescriptorBean = (JspDescriptorBean)descriptorBean;
                String string = propertyUpdate.getPropertyName();
                if (string.equals(JSPManager.PAGE_CHECK_SECS) && jspDescriptorBean != null) {
                    JSPManager.this.pageCheckSecondsSet = true;
                    JSPManager.this.pageCheckSeconds = jspDescriptorBean.getPageCheckSeconds();
                }
                for (JspConfig jspConfig : JSPManager.this.jspConfigs) {
                    if (string.equals(JSPManager.JSP_VERBOSE)) {
                        jspConfig.setVerbose(jspDescriptorBean != null && jspDescriptorBean.isVerbose());
                        JSPManager.this.setArg(JSPManager.this.jspcArgs, "verbose", "" + jspConfig.isVerbose());
                    }
                    if (string.equals(JSPManager.JSP_KEEP_GENERATED)) {
                        jspConfig.setKeepGenerated(jspDescriptorBean != null && jspDescriptorBean.isKeepgenerated());
                        JSPManager.this.setArg(JSPManager.this.jspcArgs, "keepgenerated", "" + jspConfig.isKeepGenerated());
                    }
                    if (!string.equals(JSPManager.PAGE_CHECK_SECS)) continue;
                    jspConfig.setPageCheckSecs(jspDescriptorBean != null ? (long)jspDescriptorBean.getPageCheckSeconds() : (long)(HttpServer.isProductionModeEnabled() ? -1 : 1));
                    JSPManager.this.setArg(JSPManager.this.jspcArgs, "pageCheckSeconds", "" + jspConfig.getPageCheckSecs());
                }
            }

            protected void prepareBeanAdd(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) throws BeanUpdateRejectedException {
                if (!(descriptorBean instanceof JspDescriptorBean)) {
                    return;
                }
                WeblogicWebAppBean weblogicWebAppBean = JSPManager.this.context.getWebAppModule().getWlWebAppBean();
                JspDescriptorBean jspDescriptorBean = (JspDescriptorBean)descriptorBean;
                JspDescriptorBean jspDescriptorBean2 = (JspDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getContainerDescriptors(), "JspDescriptor");
                ArrayList<String> arrayList = new ArrayList<String>();
                1.computeChange("package-prefix", jspDescriptorBean.getPackagePrefix(), jspDescriptorBean2.getPackagePrefix(), arrayList);
                1.computeChange("super-class", jspDescriptorBean.getSuperClass(), jspDescriptorBean2.getSuperClass(), arrayList);
                1.computeChange("precompile", jspDescriptorBean.isPrecompile(), jspDescriptorBean2.isPrecompile(), arrayList);
                1.computeChange("precompile-continue", jspDescriptorBean.isPrecompileContinue(), jspDescriptorBean2.isPrecompileContinue(), arrayList);
                1.computeChange("working-dir", jspDescriptorBean.getWorkingDir(), jspDescriptorBean2.getWorkingDir(), arrayList);
                1.computeChange("print-nulls", jspDescriptorBean.isPrintNulls(), jspDescriptorBean2.isPrintNulls(), arrayList);
                1.computeChange("backward-compatible", jspDescriptorBean.isBackwardCompatible(), jspDescriptorBean2.isBackwardCompatible(), arrayList);
                1.computeChange("encoding", jspDescriptorBean.getEncoding(), jspDescriptorBean2.getEncoding(), arrayList);
                1.computeChange("exact-mapping", jspDescriptorBean.isExactMapping(), jspDescriptorBean2.isExactMapping(), arrayList);
                1.computeChange("default-file-name", jspDescriptorBean.getDefaultFileName(), jspDescriptorBean2.getDefaultFileName(), arrayList);
                1.computeChange("rtexprvalue-jsp-param-name", jspDescriptorBean.isRtexprvalueJspParamName(), jspDescriptorBean2.isRtexprvalueJspParamName(), arrayList);
                1.computeChange("debug", jspDescriptorBean.isDebug(), jspDescriptorBean2.isDebug(), arrayList);
                1.computeChange("compress-html-template", jspDescriptorBean.isCompressHtmlTemplate(), jspDescriptorBean2.isCompressHtmlTemplate(), arrayList);
                1.computeChange("optimize-java-expression", jspDescriptorBean.isOptimizeJavaExpression(), jspDescriptorBean2.isOptimizeJavaExpression(), arrayList);
                1.computeChange("resource-provider-class", jspDescriptorBean.getResourceProviderClass(), jspDescriptorBean2.getResourceProviderClass(), arrayList);
                if (!arrayList.isEmpty()) {
                    throw new BeanUpdateRejectedException("Non-Dynamic property in \"jsp-descriptor\" is/are specified in deployment plan: '" + 1.getChangedPropertyNames(arrayList) + "'");
                }
            }

            protected void handleBeanAdd(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) {
                if (!(descriptorBean instanceof JspDescriptorBean) || propertyUpdate == null || !"JspDescriptors".equals(propertyUpdate.getPropertyName())) {
                    return;
                }
                JspDescriptorBean jspDescriptorBean = (JspDescriptorBean)descriptorBean;
                ((DescriptorBean)jspDescriptorBean).addBeanUpdateListener((BeanUpdateListener)this);
                if (jspDescriptorBean.isPageCheckSecondsSet()) {
                    JSPManager.this.pageCheckSecondsSet = true;
                    JSPManager.this.pageCheckSeconds = jspDescriptorBean.getPageCheckSeconds();
                }
                for (JspConfig jspConfig : JSPManager.this.jspConfigs) {
                    jspConfig.setVerbose(jspDescriptorBean != null && jspDescriptorBean.isVerbose());
                    JSPManager.this.setArg(JSPManager.this.jspcArgs, "verbose", "" + jspConfig.isVerbose());
                    jspConfig.setKeepGenerated(jspDescriptorBean != null && jspDescriptorBean.isKeepgenerated());
                    JSPManager.this.setArg(JSPManager.this.jspcArgs, "keepgenerated", "" + jspConfig.isKeepGenerated());
                    jspConfig.setPageCheckSecs(jspDescriptorBean != null ? (long)jspDescriptorBean.getPageCheckSeconds() : (long)(HttpServer.isProductionModeEnabled() ? -1 : 1));
                    JSPManager.this.setArg(JSPManager.this.jspcArgs, "pageCheckSeconds", "" + jspConfig.getPageCheckSecs());
                }
            }

            protected void handleBeanRemove(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
                if (!"JspDescriptors".equals(propertyUpdate.getPropertyName()) || propertyUpdate == null || !(propertyUpdate.getRemovedObject() instanceof JspDescriptorBean)) {
                    return;
                }
                JspDescriptorBean jspDescriptorBean = (JspDescriptorBean)propertyUpdate.getRemovedObject();
                ((DescriptorBean)jspDescriptorBean).removeBeanUpdateListener((BeanUpdateListener)this);
                JSPManager.this.pageCheckSecondsSet = false;
                JSPManager.this.pageCheckSeconds = HttpServer.isProductionModeEnabled() ? -1 : 1;
                for (JspConfig jspConfig : JSPManager.this.jspConfigs) {
                    jspConfig.setVerbose(true);
                    JSPManager.this.setArg(JSPManager.this.jspcArgs, "verbose", "true");
                    jspConfig.setKeepGenerated(false);
                    JSPManager.this.setArg(JSPManager.this.jspcArgs, "keepgenerated", "false");
                    jspConfig.setPageCheckSecs(HttpServer.isProductionModeEnabled() ? -1L : 1L);
                    JSPManager.this.setArg(JSPManager.this.jspcArgs, "pageCheckSeconds", "" + jspConfig.getPageCheckSecs());
                }
            }
        };
    }

    static {
        JspFactoryImpl.init();
        JSP_DESC_ELEMENTS_MAP.put("backwardCompatible".toLowerCase(), "backward-compatible");
        JSP_DESC_ELEMENTS_MAP.put("encoding".toLowerCase(), "encoding");
        JSP_DESC_ELEMENTS_MAP.put("exactMapping".toLowerCase(), "exact-mapping");
        JSP_DESC_ELEMENTS_MAP.put("keepgenerated".toLowerCase(), "keepgenerated");
        JSP_DESC_ELEMENTS_MAP.put("packagePrefix".toLowerCase(), "package-prefix");
        JSP_DESC_ELEMENTS_MAP.put("pageCheckSeconds".toLowerCase(), "page-check-seconds");
        JSP_DESC_ELEMENTS_MAP.put("precompile".toLowerCase(), "precompile");
        JSP_DESC_ELEMENTS_MAP.put("precompileContinue".toLowerCase(), "precompile-continue");
        JSP_DESC_ELEMENTS_MAP.put("printNulls".toLowerCase(), "print-nulls");
        JSP_DESC_ELEMENTS_MAP.put("superclass".toLowerCase(), "super-class");
        JSP_DESC_ELEMENTS_MAP.put("verbose".toLowerCase(), "verbose");
        JSP_DESC_ELEMENTS_MAP.put("workingDir".toLowerCase(), "working-dir");
        JSP_DESC_ELEMENTS_MAP.put("compileCommand".toLowerCase(), DEPRECATED_JSP_ELEMENT);
        JSP_DESC_ELEMENTS_MAP.put("compilerClass".toLowerCase(), DEPRECATED_JSP_ELEMENT);
        JSP_DESC_ELEMENTS_MAP.put("compileFlags".toLowerCase(), DEPRECATED_JSP_ELEMENT);
        JSP_DESC_ELEMENTS_MAP.put("compilerSupportsEncoding".toLowerCase(), DEPRECATED_JSP_ELEMENT);
        JSP_DESC_ELEMENTS_MAP.put("defaultFileName".toLowerCase(), "default-file-name");
        JSP_DESC_ELEMENTS_MAP.put("noTryBlocks".toLowerCase(), DEPRECATED_JSP_ELEMENT);
        JSP_DESC_ELEMENTS_MAP.put("jspServlet".toLowerCase(), DEPRECATED_JSP_ELEMENT);
        JSP_DESC_ELEMENTS_MAP.put("jspPrecompiler".toLowerCase(), DEPRECATED_JSP_ELEMENT);
    }
}

