/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.HashMap;
import java.util.Locale;
import weblogic.j2ee.descriptor.LocaleEncodingMappingBean;
import weblogic.j2ee.descriptor.LocaleEncodingMappingListBean;
import weblogic.utils.CharsetMap;

final class LocaleEncodingMap {
    private final HashMap mapping = new HashMap();

    LocaleEncodingMap() {
    }

    String getJavaCharset(Locale locale) {
        if (locale == null) {
            return null;
        }
        String string = (String)this.mapping.get(locale.toString());
        if (string != null) {
            return string;
        }
        string = (String)this.mapping.get(locale.getLanguage());
        if (string != null) {
            return string;
        }
        return CharsetMap.getJavaFromLocale((Locale)locale);
    }

    void registerLocaleEncodingMap(LocaleEncodingMappingListBean[] localeEncodingMappingListBeanArray) {
        if (localeEncodingMappingListBeanArray == null || localeEncodingMappingListBeanArray.length < 1) {
            return;
        }
        for (int i = 0; i < localeEncodingMappingListBeanArray.length; ++i) {
            this.registerLocaleEncodingMap(localeEncodingMappingListBeanArray[i].getLocaleEncodingMappings());
        }
    }

    private void registerLocaleEncodingMap(LocaleEncodingMappingBean[] localeEncodingMappingBeanArray) {
        if (localeEncodingMappingBeanArray == null || localeEncodingMappingBeanArray.length < 1) {
            return;
        }
        for (int i = 0; i < localeEncodingMappingBeanArray.length; ++i) {
            LocaleEncodingMappingBean localeEncodingMappingBean = localeEncodingMappingBeanArray[i];
            this.mapping.put(localeEncodingMappingBean.getLocale(), localeEncodingMappingBean.getEncoding());
        }
    }
}

