/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.jsp.provider.JspResourceProvider;
import weblogic.utils.classloaders.Source;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.UnsyncByteArrayInputStream;

public class MDSSource
implements Source {
    private JspResourceProvider provider;
    private String requestURI;
    private String providerURI;
    private long lastModified;
    private InputStream inputStream;
    private Chunk head;
    private byte[] bytes = null;
    private long length = Long.MIN_VALUE;
    private boolean exists = false;

    public MDSSource(String string, JspResourceProvider jspResourceProvider) {
        this.provider = jspResourceProvider;
        this.requestURI = string;
        try {
            this.providerURI = this.provider.getProviderURI(this.requestURI);
            this.lastModified = this.provider.getLastModified(this.providerURI);
            this.inputStream = this.provider.fromStream(this.providerURI);
            this.exists = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean exists() {
        return this.exists;
    }

    public String getProviderURI() {
        return this.providerURI;
    }

    public byte[] getBytes() throws IOException {
        if (this.bytes != null) {
            return this.bytes;
        }
        long l = this.length();
        if (l == Long.MIN_VALUE) {
            throw new IOException("Can't get bytes from stream, provider: " + this.provider + ", requestURI: " + this.requestURI + ", providerURI: " + this.providerURI + ", stream: " + this.inputStream);
        }
        this.bytes = new byte[(int)l];
        int n = 0;
        Chunk chunk = this.head;
        while (chunk != null) {
            System.arraycopy(chunk.buf, 0, this.bytes, n, chunk.end);
            n += chunk.end;
            chunk = chunk.next;
        }
        return this.bytes;
    }

    public URL getCodeSourceURL() {
        return this.getURL();
    }

    public InputStream getInputStream() throws IOException {
        return new UnsyncByteArrayInputStream(this.getBytes());
    }

    public URL getURL() {
        try {
            return new URL(this.requestURI);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long length() {
        if (this.length == Long.MIN_VALUE) {
            this.head = Chunk.getChunk();
            try {
                this.length = Chunk.chunkFully((Chunk)this.head, (InputStream)this.inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.length;
    }
}

