/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.ClusterServices;
import weblogic.cluster.RemoteClusterMemberManager;
import weblogic.cluster.RemoteClusterMembersChangeListener;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerIdentity;
import weblogic.servlet.internal.MembershipController;
import weblogic.servlet.internal.ServerHelper;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.utils.encoders.BASE64Encoder;

public class MembershipControllerImpl
implements ClusterMembersChangeListener,
RemoteClusterMembersChangeListener,
MembershipController {
    private final Map localClusterChannelMap = new ConcurrentHashMap();
    private final Map localClusterMap = new ConcurrentHashMap();
    private final Map clusterMap = new ConcurrentHashMap();
    private final BASE64Encoder base64 = new BASE64Encoder();
    private MessageDigest sha;
    private String currentHash;

    public static MembershipController getInstance() {
        return SingletonMaker.singleton;
    }

    private MembershipControllerImpl() {
        try {
            this.sha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                this.sha = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new Error("JVM does not support SHA or MD5");
            }
        }
    }

    void startService() {
        ClusterServices clusterServices = ClusterService.getServices();
        clusterServices.addClusterMembersListener(this);
        ServerIdentity serverIdentity = LocalServerIdentity.getIdentity();
        this.localClusterMap.put(new Integer(serverIdentity.hashCode()), serverIdentity);
        this.clusterMap.put(new Integer(serverIdentity.hashCode()), serverIdentity);
        for (ClusterMemberInfo clusterMemberInfo : clusterServices.getRemoteMembers()) {
            ServerIdentity serverIdentity2 = clusterMemberInfo.identity();
            this.localClusterMap.put(new Integer(serverIdentity2.hashCode()), serverIdentity2);
            this.clusterMap.put(new Integer(serverIdentity2.hashCode()), serverIdentity2);
        }
        this.getHash();
        if (ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getServer().getCluster().getClusterType().equals("man")) {
            RemoteClusterMemberManager.getInstance().addRemoteClusterMemberListener(this);
        }
    }

    void stopService() {
        ClusterService.getServices().removeClusterMembersListener(this);
        if (ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getServer().getCluster().getClusterType().equals("man")) {
            RemoteClusterMemberManager.getInstance().addRemoteClusterMemberListener(this);
        }
    }

    private Map fabricateList(String string) {
        ConcurrentHashMap<Integer, String> concurrentHashMap = new ConcurrentHashMap<Integer, String>();
        ClusterServices clusterServices = ClusterService.getServices();
        if (clusterServices == null) {
            throw new AssertionError((Object)"ClusterService not initialized");
        }
        for (ServerIdentity serverIdentity : this.localClusterMap.values()) {
            String string2 = ServerHelper.createServerEntry(string, serverIdentity, "!");
            if (string2 == null) continue;
            concurrentHashMap.put(new Integer(serverIdentity.hashCode()), string2);
        }
        return concurrentHashMap;
    }

    private String calcHash() {
        this.sha.reset();
        ArrayList arrayList = new ArrayList(this.localClusterMap.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.sha.update(((Integer)iterator.next()).toString().getBytes());
        }
        String string = this.base64.encodeBuffer(this.sha.digest());
        return string.substring(0, string.length() - 1);
    }

    public synchronized void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        this.addClusterMember(clusterMembersChangeEvent.getClusterMemberInfo(), clusterMembersChangeEvent.getAction(), true);
    }

    private void addClusterMember(ClusterMemberInfo clusterMemberInfo, int n, boolean bl) {
        ServerIdentity serverIdentity = clusterMemberInfo.identity();
        Integer n2 = new Integer(serverIdentity.hashCode());
        switch (n) {
            case 0: 
            case 2: {
                if (bl) {
                    if (!this.localClusterChannelMap.isEmpty()) {
                        for (String string : this.localClusterChannelMap.keySet()) {
                            String string2 = ServerHelper.createServerEntry(string, serverIdentity, "!");
                            if (string2 == null) continue;
                            Map map = (Map)this.localClusterChannelMap.get(string);
                            map.put(n2, string2);
                        }
                    }
                    this.localClusterMap.put(n2, serverIdentity);
                }
                this.clusterMap.put(n2, serverIdentity);
                this.currentHash = this.calcHash();
                break;
            }
            case 1: {
                if (bl) {
                    this.localClusterMap.remove(n2);
                    if (!this.localClusterChannelMap.isEmpty()) {
                        for (Map map : this.localClusterChannelMap.values()) {
                            map.remove(n2);
                        }
                    }
                }
                this.clusterMap.remove(n2);
                this.currentHash = this.calcHash();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHash() {
        if (this.currentHash == null) {
            MembershipControllerImpl membershipControllerImpl = this;
            synchronized (membershipControllerImpl) {
                if (this.currentHash == null) {
                    this.currentHash = this.calcHash();
                }
            }
        }
        return this.currentHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String[] getClusterList(ServerChannel serverChannel) {
        String[] stringArray;
        String string = serverChannel.getChannelName();
        Map map = (Map)this.localClusterChannelMap.get(string);
        if (map == null) {
            stringArray = this;
            // MONITORENTER : this
            map = (Map)this.localClusterChannelMap.get(string);
            if (map == null) {
                map = this.fabricateList(string);
                this.localClusterChannelMap.put(string, map);
            }
            // MONITOREXIT : stringArray
        }
        stringArray = null;
        Map map2 = map;
        // MONITORENTER : map2
        int n = map.size();
        if (n < 1) {
            // MONITOREXIT : map2
            return null;
        }
        stringArray = new String[n];
        map.values().toArray(stringArray);
        // MONITOREXIT : map2
        return stringArray;
    }

    public Map getClusterMembers() {
        return this.clusterMap;
    }

    public void remoteClusterMembersChanged(ArrayList arrayList) {
        int n = arrayList.size();
        if (n == 0) {
            this.clusterMap.clear();
            this.clusterMap.putAll(this.localClusterMap);
        } else {
            for (int i = 0; i < n; ++i) {
                ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)arrayList.get(i);
                this.addClusterMember(clusterMemberInfo, 2, false);
            }
        }
    }

    private static final class SingletonMaker {
        private static final MembershipControllerImpl singleton = new MembershipControllerImpl();

        private SingletonMaker() {
        }
    }
}

