/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.protocol.ServerChannel;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.HTTPTextTextFormatter;
import weblogic.servlet.internal.ContextVersionManager;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.OnDemandContext;
import weblogic.servlet.internal.OnDemandManager;
import weblogic.servlet.internal.PostInputStream;
import weblogic.servlet.internal.ServletContextManager;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebAppShutdownService;
import weblogic.servlet.internal.WebService;
import weblogic.socket.AbstractMuxableSocket;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketMuxer;
import weblogic.utils.http.HttpChunkInputStream;
import weblogic.utils.http.HttpRequestParseException;
import weblogic.utils.http.HttpRequestParser;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.NullInputStream;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class MuxableSocketHTTP
extends AbstractMuxableSocket {
    private static final int MAX_PIPELINED_REQUESTS = 100;
    private final boolean https;
    private ServletRequestImpl request;
    private ServletResponseImpl response;
    private HttpServer httpServer;
    private byte[] buf = null;
    private int pos = 0;
    private int headerEndPos;
    private int pipelinedRequests;
    private boolean doNotPipeline = false;
    private long messagesReceived = 0L;
    private long bytesReceived = 0L;
    private boolean reuseRequestResponse;
    private static boolean doNotSendContinueHeader = false;
    ByteBuffer extraDataForJSSERead;

    public MuxableSocketHTTP(Chunk chunk, Socket socket, boolean bl, ServerChannel serverChannel) throws IOException {
        super(chunk, serverChannel);
        this.connect(socket);
        this.setSoTimeout(this.getSocket().getSoTimeout());
        this.https = bl;
        this.httpServer = WebService.defaultHttpServer();
        if (chunk.next == null) {
            this.buf = chunk.buf;
            this.incrementBufferOffset(chunk.end);
        } else {
            Chunk chunk2 = null;
            Chunk chunk3 = chunk;
            while (chunk3 != null) {
                int n;
                for (int i = 0; i < chunk3.end; i += n) {
                    byte[] byArray = this.getBuffer();
                    int n2 = this.getBufferOffset();
                    n = Math.min(byArray.length - n2, chunk3.end - i);
                    System.arraycopy(chunk3.buf, i, byArray, n2, n);
                    this.incrementBufferOffset(n);
                }
                if (chunk2 != null) {
                    Chunk.releaseChunk(chunk2);
                }
                chunk2 = chunk3;
                chunk3 = chunk3.next;
            }
            if (chunk2 != null) {
                Chunk.releaseChunk(chunk2);
            }
        }
        this.reuseRequestResponse = true;
        this.request = new ServletRequestImpl(this);
        this.response = new ServletResponseImpl(this.request, this.getSocketOutputStream());
        this.addSenderStatistics(this.response);
    }

    public String toString() {
        return super.toString() + " - idle timeout: '" + this.getIdleTimeoutMillis() + "' ms, socket timeout: '" + this.getSoTimeout() + "' ms";
    }

    boolean isHttps() {
        return this.https;
    }

    HttpServer getHttpServer() {
        return this.httpServer;
    }

    public int getIdleTimeoutMillis() {
        if (this.https) {
            return this.httpServer.getMBean().getHttpsKeepAliveSecs() * 1000;
        }
        return this.httpServer.getMBean().getKeepAliveSecs() * 1000;
    }

    public byte[] getBuffer() {
        if (this.buf != null) {
            if (this.pos < this.buf.length) {
                return this.buf;
            }
            byte[] byArray = new byte[this.pos << 1];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
            if (this.head != null) {
                Chunk.releaseChunk((Chunk)this.head);
                this.head = null;
            }
            return this.buf;
        }
        this.head = Chunk.getChunk();
        this.buf = this.head.buf;
        return this.head.buf;
    }

    public ByteBuffer[] getAvailableBufferofSize(int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.getBuffer());
        byteBuffer.position(this.pos);
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        arrayList.add(byteBuffer);
        if (byteBuffer.remaining() < n) {
            this.extraDataForJSSERead = ByteBuffer.allocate(n - byteBuffer.remaining());
            arrayList.add(this.extraDataForJSSERead);
        }
        return arrayList.toArray(new ByteBuffer[arrayList.size()]);
    }

    public int getBufferOffset() {
        return this.pos;
    }

    public void incrementBufferOffset(int n) throws MaxMessageSizeExceededException {
        int n2;
        this.pos += n;
        if (this.pos > this.buf.length) {
            this.copyDataIntoLargerByteArray(this.buf.length);
        }
        if ((n2 = this.getChannel().getMaxMessageSize()) > -1 && this.pos > n2) {
            throw new MaxMessageSizeExceededException(this.pos, n2, this.https ? "https" : "http");
        }
    }

    private void copyDataIntoLargerByteArray(int n) {
        this.buf = this.getBuffer();
        System.arraycopy(this.extraDataForJSSERead.array(), 0, this.buf, n, this.extraDataForJSSERead.position());
        this.extraDataForJSSERead = null;
    }

    public void hasException(Throwable throwable) {
        if (throwable instanceof SocketException) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Socket issue", (SocketException)throwable);
            }
        } else {
            HTTPLogger.logConnectionFailure((Throwable)throwable);
        }
        super.hasException(throwable);
    }

    public boolean timeout() {
        SocketMuxer.getMuxer().deliverEndOfStream(this.getSocketFilter());
        return super.timeout();
    }

    public void endOfStream() {
        this.blowAllChunks();
        super.endOfStream();
    }

    void requeue() {
        if (this.getSocket().isClosed()) {
            this.blowAllChunks();
            SocketMuxer.getMuxer().deliverEndOfStream(this.getSocketFilter());
            return;
        }
        boolean bl = this.request.getInputHelper().getRequestParser().isMethodSafe();
        if (this.reuseRequestResponse) {
            this.request.reset();
            this.response.init();
        } else {
            this.request.skipUnreadBody();
            this.request = new ServletRequestImpl(this);
            this.response = new ServletResponseImpl(this.request, this.getSocketOutputStream());
        }
        int n = this.headerEndPos + 1;
        this.headerEndPos = 0;
        if (bl && n < this.pos) {
            if (this.doNotPipeline) {
                SocketMuxer.getMuxer().deliverEndOfStream(this.getSocketFilter());
                return;
            }
            byte[] byArray = new byte[this.buf.length];
            System.arraycopy(this.buf, n, byArray, 0, this.pos - n);
            this.buf = byArray;
            this.pos -= n;
            if (this.isMessageComplete()) {
                ++this.pipelinedRequests;
                this.dispatch();
                return;
            }
        } else {
            this.blowAllChunks();
        }
        if (this.getSocketFilter() instanceof SSLFilter && this.https) {
            ((SSLFilter)this.getSocketFilter()).asyncOn();
        }
        SocketMuxer.getMuxer().read(this.getSocketFilter());
    }

    public boolean isMessageComplete() {
        if (this.buf == null) {
            return false;
        }
        boolean bl = false;
        block4: for (int i = 0; i < this.pos; ++i) {
            switch (this.buf[i]) {
                case 13: {
                    continue block4;
                }
                case 10: {
                    if (bl) {
                        this.headerEndPos = i;
                        return true;
                    }
                    bl = true;
                    continue block4;
                }
                default: {
                    bl = false;
                }
            }
        }
        return false;
    }

    public void dispatch() {
        if (this.getSocketFilter() instanceof SSLFilter && this.https) {
            ((SSLFilter)this.getSocketFilter()).asyncOff();
        }
        this.request.getHttpAccountingInfo().setInvokeTime(System.currentTimeMillis());
        try {
            Object object;
            try {
                object = this.request.getInputHelper().getRequestParser();
                object.parse(this.buf, this.pos);
                this.request.initFromRequestParser((HttpRequestParser)object);
                if (HTTPDebugLogger.isEnabled()) {
                    HTTPDebugLogger.debug("Request received from: " + this.getRemoteAddress() + ", Secure: " + this.https + ", Request: " + this.request.toString());
                }
                this.response.getServletOutputStream().setWriteEnabled(!this.request.getInputHelper().getRequestParser().isMethodHead());
                this.incrementMessagesReceivedCount();
                this.incrementBytesReceivedCount(this.headerEndPos + 1);
                if (this.request.getInputHelper().getRequestParser().isMethodTrace() && !this.httpServer.isHttpTraceSupportEnabled()) {
                    this.sendError(this.response, 501);
                    return;
                }
            }
            catch (HttpRequestParseException httpRequestParseException) {
                HttpRequestParser httpRequestParser = new HttpRequestParser(httpRequestParseException.getMethod(), httpRequestParseException.getProtocol(), httpRequestParseException.getURI());
                this.request.initFromRequestParser(httpRequestParser);
                HTTPLogger.logMalformedRequest((String)httpRequestParseException.getURI(), (int)-1);
                this.send400Response((Exception)((Object)httpRequestParseException));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.send400Response(illegalArgumentException);
                return;
            }
            object = this.request.getRequestHeaders().getHost();
            this.httpServer = this.findHttpServer((String)object);
            this.response.initHttpServer(this.httpServer);
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Http Server: '" + this.httpServer + "' is resolved for request: '" + this.request.toStringSimple() + "'");
            }
            String string = this.request.getInputHelper().getNormalizedURI();
            OnDemandManager onDemandManager = this.httpServer.getOnDemandManager();
            OnDemandContext onDemandContext = onDemandManager.lookupOnDemandContext(string);
            if (onDemandContext != null) {
                try {
                    if (onDemandContext.isDisplayRefresh()) {
                        onDemandManager.loadOnDemandURI(onDemandContext, true);
                        this.sendRefreshPage(string, onDemandContext.updateProgressIndicator());
                        return;
                    }
                    this.handleSyncOnDemandLoad(onDemandManager, onDemandContext, string, this);
                    return;
                }
                catch (DeploymentException deploymentException) {
                    this.sendError(this.response, 503);
                    HTTPLogger.logDispatchError((Throwable)((Object)deploymentException));
                    return;
                }
            }
            this.resolveServletContext(string);
        }
        catch (IOException iOException) {
            HTTPLogger.logDispatchError((Throwable)iOException);
            SocketMuxer.getMuxer().deliverEndOfStream(this.getSocketFilter());
        }
    }

    public long getMessagesReceivedCount() {
        return this.messagesReceived;
    }

    public long getBytesReceivedCount() {
        return this.bytesReceived;
    }

    void disableRequestResponseReuse() {
        this.reuseRequestResponse = false;
    }

    private void resolveServletContext(String string) throws IOException {
        WebAppServletContext webAppServletContext;
        ServletContextManager servletContextManager = this.httpServer.getServletContextManager();
        ContextVersionManager contextVersionManager = null;
        if (string != null) {
            contextVersionManager = servletContextManager.resolveVersionManagerForURI(string);
        }
        if (contextVersionManager == null) {
            this.handleNoContext();
            return;
        }
        if (contextVersionManager.isVersioned()) {
            this.request.initContextManager(contextVersionManager);
            webAppServletContext = this.request.getContext();
            this.request.getSessionHelper().resetSession(true);
            this.request.getRequestParameters().resetQueryParams();
        } else {
            webAppServletContext = contextVersionManager.getContext(this.request.isAdminChannelRequest());
            this.request.initContext(webAppServletContext);
        }
        this.response.initContext(webAppServletContext);
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Servlet Context: " + webAppServletContext + " is resolved for request: '" + this.request.toStringSimple() + "'");
        }
        if (!this.initAndValidateRequest(webAppServletContext)) {
            return;
        }
        WorkManager workManager = this.request.getServletStub().getWorkManager();
        if (workManager == null) {
            throw new AssertionError((Object)("Could not determine WorkManager for : " + (Object)((Object)this.request)));
        }
        workManager.schedule((Runnable)((Object)this.request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send400Response(Exception exception) throws IOException {
        String string;
        this.response.setStatus(400);
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Request parsing failed.", exception);
        }
        if ((string = this.request.getProtocol()) == null && exception instanceof HttpRequestParseException) {
            string = ((HttpRequestParseException)((Object)exception)).getProtocol();
        }
        if (string == null) {
            string = "HTTP/1.1";
        }
        String string2 = string + " " + 400 + " Bad Request\r\nConnection: close\r\n\r\n";
        try {
            this.getSocketOutputStream().write(string2.getBytes());
            Object var5_4 = null;
            this.httpServer.getLogManager().log(this.request, this.response);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.httpServer.getLogManager().log(this.request, this.response);
            throw throwable;
        }
        SocketMuxer.getMuxer().deliverEndOfStream(this.getSocketFilter());
    }

    private HttpServer findHttpServer(String string) {
        HttpServer httpServer = WebService.getVirtualHost(this.getChannel());
        if (httpServer != null) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Found virtual host: " + httpServer.getName() + " for channel: " + this.getChannel().getChannelName());
            }
            return httpServer;
        }
        return WebService.findHttpServer(string);
    }

    private void blowAllChunks() {
        if (this.head != null) {
            Chunk.releaseChunks((Chunk)this.head);
            this.buf = null;
            this.head = null;
        }
        this.pos = 0;
    }

    private void initInputStream() throws IOException {
        int n = this.request.getContentLength();
        boolean bl = this.request.getRequestHeaders().isChunked();
        if (this.request.getInputHelper().getRequestParser().isMethodSafe()) {
            this.request.setInputStream((InputStream)NullInputStream.getInstance());
            if (n > 0 || bl) {
                if (HTTPDebugLogger.isEnabled()) {
                    HTTPDebugLogger.debug(this.request.getInputHelper().getRequestParser().getMethod() + " request has Content-Length or Chunked Transfer-Encoding. " + "Pipelining is turned off for this request.");
                }
                this.response.disableKeepAlive();
                this.doNotPipeline = true;
            }
            return;
        }
        if (n != -1 && bl) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Content-Length header ignored as the Chunked Transfer-Encoding header exists.");
            }
            n = -1;
            this.request.getRequestHeaders().ignoreContentLength();
        }
        if (n == -1) {
            if (!this.request.getInputHelper().getRequestParser().isMethodPost() && !this.request.getInputHelper().getRequestParser().isMethodOptions()) {
                this.response.disableKeepAlive();
            }
            if (!bl) {
                this.request.setInputStream((InputStream)NullInputStream.getInstance());
                return;
            }
        }
        PostInputStream postInputStream = new PostInputStream(this, n, this.buf, this.headerEndPos + 1, this.pos);
        this.setSoTimeout(this.httpServer.getPostTimeoutSecs() * 1000);
        if (bl) {
            this.request.setInputStream((InputStream)new HttpChunkInputStream((InputStream)postInputStream));
        } else {
            this.request.setInputStream(postInputStream);
        }
    }

    boolean initAndValidateRequest(WebAppServletContext webAppServletContext) throws IOException {
        String string;
        if (!this.request.validate(this.httpServer)) {
            return false;
        }
        if (this.request.getInputHelper().getRequestParser().isMethodTrace() && !this.httpServer.isHttpTraceSupportEnabled()) {
            this.sendError(this.response, 501);
            return false;
        }
        this.request.initInputEncoding();
        if (webAppServletContext.getConfigManager().useDefaultEncoding()) {
            this.response.setDefaultEncoding(webAppServletContext.getConfigManager().getDefaultEncoding());
        }
        if (this.pipelinedRequests >= 100) {
            this.response.disableKeepAlive();
        }
        this.initInputStream();
        if (!doNotSendContinueHeader && this.request.getInputHelper().getRequestParser().isProtocolVersion_1_1() && (webAppServletContext.getSecurityManager().getWebAppSecurity().getAuthMethod() == null || webAppServletContext.getSecurityManager().getWebAppSecurity().isFormAuth()) && "100-continue".equalsIgnoreCase(string = this.request.getRequestHeaders().getExpect())) {
            this.request.send100ContinueResponse();
        }
        try {
            this.request.setServletStub(webAppServletContext.resolveDirectRequest(this.request));
        }
        catch (SecurityException securityException) {
            this.response.setStatus(403);
            HTTPLogger.logException((String)webAppServletContext.getLogContext(), (Throwable)securityException);
            SocketMuxer.getMuxer().deliverEndOfStream(this.getSocketFilter());
            return false;
        }
        return true;
    }

    void incrementBytesReceivedCount(long l) {
        this.bytesReceived += l;
    }

    void incrementMessagesReceivedCount() {
        ++this.messagesReceived;
    }

    private void handleNoContext() throws IOException {
        this.response.setStatus(404);
        if (HTTPDebugLogger.isEnabled()) {
            Loggable loggable = HTTPLogger.logNoContextLoggable((String)this.httpServer.toString(), (String)this.request.getInputHelper().getNormalizedURI());
            HTTPDebugLogger.debug(loggable.getMessage());
        }
        this.response.getServletOutputStream().setWriteEnabled(!this.request.getInputHelper().getRequestParser().isMethodHead());
        if (WebAppShutdownService.isSuspending() || WebAppShutdownService.isSuspended()) {
            this.sendError(this.response, 503);
        } else {
            this.sendError(this.response, 404);
        }
    }

    void sendError(final ServletResponseImpl servletResponseImpl, final int n) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    servletResponseImpl.sendError(n);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        servletResponseImpl.sendError(n);
                    }
                    catch (Throwable throwable2) {
                        Object var6_12 = null;
                        MuxableSocketHTTP.this.httpServer.getLogManager().log(MuxableSocketHTTP.this.request, MuxableSocketHTTP.this.response);
                        SocketMuxer.getMuxer().deliverEndOfStream(MuxableSocketHTTP.this.getSocketFilter());
                        throw throwable2;
                    }
                }
            }
        };
        WorkManagerFactory.getInstance().getDefault().schedule(runnable);
    }

    private void sendRefreshPage(String string, int n) throws IOException {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Sending refresh screen for on demand deploy.");
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 46;
        }
        HTTPTextTextFormatter hTTPTextTextFormatter = new HTTPTextTextFormatter(this.request.getLocale());
        String string2 = hTTPTextTextFormatter.getRefreshPageHTML(string, new String(cArray));
        ServletOutputStream servletOutputStream = this.response.getOutputStream();
        this.response.setContentLength(string2.length());
        this.response.setHeader("Connection", "close");
        servletOutputStream.write(string2.getBytes());
        servletOutputStream.flush();
        SocketMuxer.getMuxer().deliverEndOfStream(this.getSocketFilter());
    }

    void handleSyncOnDemandLoad(final OnDemandManager onDemandManager, final OnDemandContext onDemandContext, final String string, final MuxableSocketHTTP muxableSocketHTTP) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    onDemandManager.loadOnDemandURI(onDemandContext, false);
                    if (HTTPDebugLogger.isEnabled()) {
                        HTTPDebugLogger.debug("About to perform rest of servlet context processing for " + onDemandContext.getAppName());
                    }
                    muxableSocketHTTP.resolveServletContext(string);
                }
                catch (IOException iOException) {
                    HTTPLogger.logDispatchError((Throwable)iOException);
                    SocketMuxer.getMuxer().deliverEndOfStream(MuxableSocketHTTP.this.getSocketFilter());
                }
                catch (DeploymentException deploymentException) {
                    HTTPLogger.logDispatchError((Throwable)((Object)deploymentException));
                    SocketMuxer.getMuxer().deliverEndOfStream(MuxableSocketHTTP.this.getSocketFilter());
                }
            }
        };
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Scheduling runnable for on demand load of " + onDemandContext.getAppName());
        }
        WorkManagerFactory.getInstance().getDefault().schedule(runnable);
    }

    static {
        doNotSendContinueHeader = Boolean.getBoolean("doNotSendContinueHeader");
    }
}

