/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import weblogic.management.DeploymentException;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.OnDemandContext;
import weblogic.servlet.internal.OnDemandListener;
import weblogic.servlet.utils.ServletMapping;

public final class OnDemandManager {
    private ServletMapping contextTable = new ServletMapping();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerOnDemandContextPaths(String[] stringArray, OnDemandListener onDemandListener, String string, boolean bl) {
        ServletMapping servletMapping = this.contextTable;
        synchronized (servletMapping) {
            ServletMapping servletMapping2 = (ServletMapping)this.contextTable.clone();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                Object object = this.contextTable.get(string2);
                if (object != null) {
                    throw new IllegalArgumentException("Context path " + string2 + " is already registered");
                }
                if (HTTPDebugLogger.isEnabled()) {
                    HTTPDebugLogger.debug("Registering OnDemandContext with context-root: '" + string2 + "'");
                }
                OnDemandContext onDemandContext = new OnDemandContext(string2, onDemandListener, string, bl);
                servletMapping2.put(OnDemandManager.toPattern(string2), onDemandContext);
            }
            this.contextTable = servletMapping2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregisterOnDemandContextPaths(String[] stringArray) {
        ServletMapping servletMapping = this.contextTable;
        synchronized (servletMapping) {
            ServletMapping servletMapping2 = (ServletMapping)this.contextTable.clone();
            for (int i = 0; i < stringArray.length; ++i) {
                OnDemandContext onDemandContext;
                String string = stringArray[i];
                if (HTTPDebugLogger.isEnabled()) {
                    HTTPDebugLogger.debug("Unregistering OnDemandContext with context-root: '" + string + "'");
                }
                if ((onDemandContext = (OnDemandContext)this.contextTable.get(OnDemandManager.toPattern(string))) == null) continue;
                servletMapping2.remove(OnDemandManager.toPattern(string));
            }
            this.contextTable = servletMapping2;
        }
    }

    OnDemandContext lookupOnDemandContext(String string) {
        if (string == null) {
            return null;
        }
        return (OnDemandContext)this.contextTable.get(string);
    }

    void loadOnDemandURI(OnDemandContext onDemandContext, boolean bl) throws DeploymentException {
        if (onDemandContext == null) {
            return;
        }
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Loading on demand context: " + onDemandContext.getAppName() + " load async: " + bl);
        }
        OnDemandListener onDemandListener = onDemandContext.getListener();
        onDemandListener.OnDemandURIAccessed(onDemandContext.getContextPath(), onDemandContext.getAppName(), bl);
    }

    private static String toPattern(String string) {
        if (string.equals("") || string.equals("/")) {
            return "/";
        }
        if (!string.startsWith("/") && !string.startsWith("*.")) {
            string = "/" + string;
        }
        return string.endsWith("/") ? string + "*" : string + "/*";
    }
}

