/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.LinkedList;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;
import weblogic.management.runtime.PageFlowActionRuntimeMBean;
import weblogic.management.runtime.PageFlowError;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.servlet.internal.PageFlowErrorImpl;
import weblogic.servlet.internal.PageFlowsRuntimeMBeanImpl;

public final class PageFlowActionRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements PageFlowActionRuntimeMBean {
    private static final long serialVersionUID = 1L;
    private String _actionName;
    private long _successCount;
    private long _exceptionCount;
    private long _handledExceptionCount;
    private long _totalSuccessDispatchTime;
    private long _minSuccessDispatchTime;
    private long _maxSuccessDispatchTime;
    private long _totalHandledExceptionDispatchTime;
    private long _minHandledExceptionDispatchTime;
    private long _maxHandledExceptionDispatchTime;
    private int _numExceptionsToKeep;
    private LinkedList _exceptionList;
    private DebugLogger _logger;
    private static int MAX_NUM_EXCEPTIONS = 5;

    public PageFlowActionRuntimeMBeanImpl(String string, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string, runtimeMBean);
        this._actionName = string;
        this._exceptionList = new LinkedList();
        this._numExceptionsToKeep = MAX_NUM_EXCEPTIONS;
        this._logger = PageFlowsRuntimeMBeanImpl.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        PageFlowActionRuntimeMBeanImpl pageFlowActionRuntimeMBeanImpl = this;
        synchronized (pageFlowActionRuntimeMBeanImpl) {
            this._successCount = 0L;
            this._exceptionCount = 0L;
            this._handledExceptionCount = 0L;
            this._totalSuccessDispatchTime = 0L;
            this._minSuccessDispatchTime = 0L;
            this._maxSuccessDispatchTime = 0L;
            this._totalHandledExceptionDispatchTime = 0L;
            this._minHandledExceptionDispatchTime = 0L;
            this._maxHandledExceptionDispatchTime = 0L;
            this._exceptionList.clear();
        }
    }

    public String getActionName() {
        return this._actionName;
    }

    public long getSuccessCount() {
        return this._successCount;
    }

    public long getExceptionCount() {
        return this._exceptionCount;
    }

    public long getHandledExceptionCount() {
        return this._handledExceptionCount;
    }

    public long getSuccessDispatchTimeTotal() {
        return this._totalSuccessDispatchTime;
    }

    public long getSuccessDispatchTimeHigh() {
        return this._maxSuccessDispatchTime;
    }

    public long getSuccessDispatchTimeLow() {
        return this._minSuccessDispatchTime;
    }

    public long getSuccessDispatchTimeAverage() {
        if (this._successCount > 0L) {
            return this._totalSuccessDispatchTime / this._successCount;
        }
        return 0L;
    }

    public long getHandledExceptionDispatchTimeTotal() {
        return this._totalHandledExceptionDispatchTime;
    }

    public long getHandledExceptionDispatchTimeHigh() {
        return this._maxHandledExceptionDispatchTime;
    }

    public long getHandledExceptionDispatchTimeLow() {
        return this._minHandledExceptionDispatchTime;
    }

    public long getHandledExceptionDispatchTimeAverage() {
        if (this._handledExceptionCount > 0L) {
            return this._totalHandledExceptionDispatchTime / this._handledExceptionCount;
        }
        return 0L;
    }

    void reportSuccess(long l) {
        ++this._successCount;
        this._totalSuccessDispatchTime += l;
        if (l < this._minSuccessDispatchTime) {
            this._minSuccessDispatchTime = l;
        } else if (l > this._maxSuccessDispatchTime) {
            this._maxSuccessDispatchTime = l;
            if (this._minSuccessDispatchTime == 0L) {
                this._minSuccessDispatchTime = l;
            }
        }
    }

    void reportException(PageFlowErrorImpl pageFlowErrorImpl) {
        ++this._exceptionCount;
        this.enqueueException(pageFlowErrorImpl);
    }

    void reportHandledException(Throwable throwable, long l) {
        ++this._handledExceptionCount;
        this._totalHandledExceptionDispatchTime += l;
        if (this._minHandledExceptionDispatchTime == 0L) {
            this._minHandledExceptionDispatchTime = l;
        } else if (l < this._minHandledExceptionDispatchTime) {
            this._minHandledExceptionDispatchTime = l;
        }
        if (l > this._maxHandledExceptionDispatchTime) {
            this._maxHandledExceptionDispatchTime = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageFlowError[] getLastExceptions() {
        LinkedList linkedList = this._exceptionList;
        synchronized (linkedList) {
            PageFlowError[] pageFlowErrorArray = new PageFlowError[this._exceptionList.size()];
            this._exceptionList.toArray(pageFlowErrorArray);
            return pageFlowErrorArray;
        }
    }

    void setNumExceptionsToKeep(int n) {
        this._numExceptionsToKeep = n;
        if (n == 0) {
            this._exceptionList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueException(PageFlowErrorImpl pageFlowErrorImpl) {
        if (pageFlowErrorImpl != null && this._numExceptionsToKeep > 0) {
            LinkedList linkedList = this._exceptionList;
            synchronized (linkedList) {
                while (this._exceptionList.size() >= this._numExceptionsToKeep) {
                    this._exceptionList.removeFirst();
                }
                this._exceptionList.addLast(pageFlowErrorImpl);
            }
        }
    }
}

