/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import weblogic.management.runtime.PageFlowError;

public final class PageFlowErrorImpl
implements PageFlowError,
Serializable {
    private static final long serialVersionUID = 1L;
    private long _timestamp;
    private String _stackTrace;
    private String _message;

    public PageFlowErrorImpl(Throwable throwable) {
        assert (throwable != null);
        this._timestamp = System.currentTimeMillis();
        this._stackTrace = PageFlowErrorImpl.stringify(throwable);
        this._message = throwable.getLocalizedMessage();
        if (this._message == null) {
            this._message = throwable.getMessage();
        }
    }

    public long getTimeStamp() {
        return this._timestamp;
    }

    public String getStackTraceAsString() {
        return this._stackTrace;
    }

    public String getMessage() {
        return this._message;
    }

    private static String stringify(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

