/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.HashMap;
import java.util.LinkedList;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;
import weblogic.management.runtime.PageFlowActionRuntimeMBean;
import weblogic.management.runtime.PageFlowRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.servlet.internal.PageFlowActionRuntimeMBeanImpl;
import weblogic.servlet.internal.PageFlowErrorImpl;
import weblogic.servlet.internal.PageFlowsRuntimeMBeanImpl;
import weblogic.utils.AssertionError;

public class PageFlowRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements PageFlowRuntimeMBean {
    private static final long serialVersionUID = 1L;
    private String _className;
    private HashMap _actions;
    private long _lastResetTime;
    private long _createCount;
    private long _destroyCount;
    private int _numExceptionsToKeep;
    private LinkedList _reportedExceptions;
    private DebugLogger _logger;

    public PageFlowRuntimeMBeanImpl(String string, String string2, String string3, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string3, runtimeMBean);
        this._className = string3;
        this._actions = new HashMap();
        this._reportedExceptions = new LinkedList();
        this._numExceptionsToKeep = 5;
        this._logger = PageFlowsRuntimeMBeanImpl.logger;
    }

    public PageFlowRuntimeMBeanImpl() throws ManagementException {
        throw new AssertionError("Public constructor provided only for JMX compliance.");
    }

    public void reset() {
        this._lastResetTime = System.currentTimeMillis();
        this._createCount = 0L;
        this._destroyCount = 0L;
        if (this._actions.size() == 0) {
            return;
        }
        for (PageFlowActionRuntimeMBeanImpl pageFlowActionRuntimeMBeanImpl : this._actions.values()) {
            pageFlowActionRuntimeMBeanImpl.reset();
        }
    }

    public String getClassName() {
        return this._className;
    }

    public PageFlowActionRuntimeMBean[] getActions() {
        PageFlowActionRuntimeMBean[] pageFlowActionRuntimeMBeanArray = new PageFlowActionRuntimeMBean[this._actions.size()];
        this._actions.values().toArray(pageFlowActionRuntimeMBeanArray);
        return pageFlowActionRuntimeMBeanArray;
    }

    public PageFlowActionRuntimeMBean getAction(String string) {
        return (PageFlowActionRuntimeMBean)this._actions.get(string);
    }

    public void setActions(String[] stringArray) {
        assert (stringArray != null);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                PageFlowActionRuntimeMBeanImpl pageFlowActionRuntimeMBeanImpl = new PageFlowActionRuntimeMBeanImpl(string, this);
                this._actions.put(string, pageFlowActionRuntimeMBeanImpl);
                continue;
            }
            catch (ManagementException managementException) {
                this._logger.debug("Unable to create MBean for " + string, (Throwable)managementException);
            }
        }
    }

    public void reportCreate() {
        ++this._createCount;
    }

    public void reportDestroy() {
        ++this._destroyCount;
    }

    public void setNumExceptionsToKeep(int n) {
        this._numExceptionsToKeep = n;
        for (PageFlowActionRuntimeMBeanImpl pageFlowActionRuntimeMBeanImpl : this._actions.values()) {
            if (pageFlowActionRuntimeMBeanImpl == null) continue;
            pageFlowActionRuntimeMBeanImpl.setNumExceptionsToKeep(n);
        }
    }

    public void reportSuccess(String string, long l) {
        PageFlowActionRuntimeMBeanImpl pageFlowActionRuntimeMBeanImpl = (PageFlowActionRuntimeMBeanImpl)this.getAction(string);
        if (pageFlowActionRuntimeMBeanImpl != null) {
            pageFlowActionRuntimeMBeanImpl.reportSuccess(l);
        }
    }

    public void reportException(String string, Throwable throwable) {
        this.reportException(string, new PageFlowErrorImpl(throwable));
    }

    public void reportException(String string, PageFlowErrorImpl pageFlowErrorImpl) {
        PageFlowActionRuntimeMBeanImpl pageFlowActionRuntimeMBeanImpl = (PageFlowActionRuntimeMBeanImpl)this.getAction(string);
        if (pageFlowActionRuntimeMBeanImpl != null && pageFlowErrorImpl != null) {
            pageFlowActionRuntimeMBeanImpl.reportException(pageFlowErrorImpl);
        }
    }

    public void reportExceptionHandled(String string, Throwable throwable, long l) {
        PageFlowActionRuntimeMBeanImpl pageFlowActionRuntimeMBeanImpl = (PageFlowActionRuntimeMBeanImpl)this.getAction(string);
        if (pageFlowActionRuntimeMBeanImpl != null) {
            pageFlowActionRuntimeMBeanImpl.reportHandledException(throwable, l);
        }
    }

    public long getCreateCount() {
        return this._createCount;
    }

    public long getDestroyCount() {
        return this._destroyCount;
    }

    public long getLastResetTime() {
        return this._lastResetTime;
    }
}

