/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.HashMap;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;
import weblogic.management.runtime.PageFlowRuntimeMBean;
import weblogic.management.runtime.PageFlowsRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.servlet.internal.PageFlowRuntimeMBeanImpl;

public class PageFlowsRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements PageFlowsRuntimeMBean {
    private static final long serialVersionUID = 1L;
    private HashMap _pageFlows;
    private String _serverName;
    private String _httpServerName;
    private String _contextPath;
    private String _applicationName;
    static DebugLogger logger = DebugLogger.getDebugLogger((String)"DebugPageFlowMonitoring");

    public PageFlowsRuntimeMBeanImpl(String string, String string2, String string3, String string4, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string + "_" + string2 + "_" + string3, runtimeMBean);
        this._serverName = string;
        this._httpServerName = string2;
        this._contextPath = string3;
        this._applicationName = string4;
        this._pageFlows = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashMap hashMap = this._pageFlows;
        synchronized (hashMap) {
            for (PageFlowRuntimeMBean pageFlowRuntimeMBean : this._pageFlows.values()) {
                pageFlowRuntimeMBean.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageFlowRuntimeMBean[] getPageFlows() {
        HashMap hashMap = this._pageFlows;
        synchronized (hashMap) {
            return this._pageFlows.values().toArray(new PageFlowRuntimeMBean[this._pageFlows.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageFlowRuntimeMBean getPageFlow(String string) {
        HashMap hashMap = this._pageFlows;
        synchronized (hashMap) {
            return (PageFlowRuntimeMBean)this._pageFlows.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageFlow(String string, String[] stringArray) {
        HashMap hashMap = this._pageFlows;
        synchronized (hashMap) {
            try {
                PageFlowRuntimeMBeanImpl pageFlowRuntimeMBeanImpl = (PageFlowRuntimeMBeanImpl)this._pageFlows.get(string);
                if (pageFlowRuntimeMBeanImpl == null) {
                    pageFlowRuntimeMBeanImpl = new PageFlowRuntimeMBeanImpl(this._serverName, this._httpServerName, string, this);
                    pageFlowRuntimeMBeanImpl.setActions(stringArray);
                    this._pageFlows.put(string, pageFlowRuntimeMBeanImpl);
                }
            }
            catch (ManagementException managementException) {
                logger.debug("Unable to add PageFlow: " + string, (Throwable)managementException);
            }
        }
    }

    public String getServerName() {
        return this._serverName;
    }

    public String getHttpServerName() {
        return this._httpServerName;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getAppName() {
        return this._applicationName;
    }
}

