/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.MuxableSocketHTTP;
import weblogic.servlet.internal.PostTimeoutException;

final class PostInputStream
extends InputStream {
    private static final int SIZE = 512;
    private byte[] buf;
    private InputStream in;
    private int pos;
    private int count;
    private int contentLen;
    private boolean isNotChunkTransfer = true;
    private int nread = 0;
    private long timeReading = 0L;
    private int maxPostTime = -1;
    private int maxPostSize = -1;
    private MuxableSocketHTTP ms;
    private boolean timedOut = false;

    PostInputStream(MuxableSocketHTTP muxableSocketHTTP, int n, byte[] byArray, int n2, int n3) {
        int n4;
        this.ms = muxableSocketHTTP;
        this.in = muxableSocketHTTP.getSocketInputStream();
        this.contentLen = n;
        if (this.contentLen < 0) {
            this.isNotChunkTransfer = false;
        }
        if ((n4 = n3 - n2) > 0) {
            this.buf = new byte[Math.max(n4, 512)];
            System.arraycopy(byArray, n2, this.buf, 0, n4);
            this.count = n4;
        } else {
            this.buf = new byte[512];
        }
        this.maxPostTime = muxableSocketHTTP.getHttpServer().getMaxPostTimeSecs() * 1000;
        this.maxPostSize = muxableSocketHTTP.getHttpServer().getMaxPostSize();
    }

    public String toString() {
        return super.toString() + " - contentLen: '" + this.contentLen + "', nread: '" + this.nread + "', pos: '" + this.pos + "', count: '" + this.count + "'" + "', timedOut: '" + this.timedOut + "'";
    }

    private void complain() throws ProtocolException {
        ProtocolException protocolException = new ProtocolException("EOF after reading only: '" + this.nread + "' of: '" + this.contentLen + "' promised bytes, out of which at least: '" + this.count + "' were already buffered");
        this.in = null;
        this.buf = null;
        this.contentLen = 0;
        this.nread = 0;
        throw protocolException;
    }

    private void checkPostSize() throws IOException {
        if (this.maxPostSize > 0 && (this.count >= this.maxPostSize || this.nread >= this.maxPostSize)) {
            HTTPLogger.logPOSTSizeExceeded((int)this.maxPostSize);
            throw new IOException("MaxPostSize exceeded");
        }
    }

    private void checkPostTime() throws PostTimeoutException {
        if (this.maxPostTime >= 0 && this.timeReading > (long)this.maxPostTime) {
            HTTPLogger.logPOSTTimeExceeded((int)(this.maxPostTime / 1000));
            this.nread = 0;
            throw new PostTimeoutException("Attempt to read for more thanthe max POST read time: " + this.maxPostTime / 1000 + "' seconds");
        }
    }

    public int read() throws IOException {
        this.checkTimedOut();
        try {
            if (this.isNotChunkTransfer && this.nread == this.contentLen) {
                return -1;
            }
            if (this.pos == this.count) {
                this.checkPostTime();
                this.pos = 0;
                long l = System.currentTimeMillis();
                if (this.isNotChunkTransfer) {
                    this.count = this.in.read(this.buf, 0, Math.min(this.contentLen - this.nread, this.buf.length));
                    if (this.count < 0) {
                        this.complain();
                    }
                } else {
                    this.count = this.in.read(this.buf, 0, this.buf.length);
                    if (this.count == -1) {
                        return -1;
                    }
                }
                this.timeReading += System.currentTimeMillis() - l;
            }
            ++this.nread;
            this.ms.incrementBytesReceivedCount(1L);
            return this.buf[this.pos++] & 0xFF;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.setTimedOut(true);
            throw socketTimeoutException;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkTimedOut();
        try {
            int n3;
            if (this.isNotChunkTransfer) {
                n3 = this.contentLen - this.nread;
                if (n3 == 0) {
                    return -1;
                }
                if (n2 > n3) {
                    n2 = n3;
                }
            } else {
                for (int i = n2; i > 0; --i) {
                    int n4 = this.read();
                    if (n4 < 0) {
                        return -1;
                    }
                    byArray[n++] = (byte)n4;
                }
                return n2;
            }
            n3 = this.count - this.pos;
            if (n3 == 0) {
                this.checkPostTime();
                long l = System.currentTimeMillis();
                int n5 = this.in.read(byArray, n, n2);
                this.timeReading += System.currentTimeMillis() - l;
                if (this.isNotChunkTransfer && n5 < 0) {
                    this.complain();
                }
                this.ms.incrementBytesReceivedCount(n5);
                this.nread += n5;
                return n5;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n2);
            this.pos += n2;
            this.nread += n2;
            return n2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.setTimedOut(true);
            throw socketTimeoutException;
        }
    }

    public int available() throws IOException {
        int n = this.count - this.pos;
        int n2 = n + this.in.available();
        return this.isNotChunkTransfer ? Math.min(n2, this.contentLen) : n2;
    }

    private void skipUnreadBody() throws IOException {
        if (this.isNotChunkTransfer && this.nread < this.contentLen) {
            this.skip(this.contentLen - this.nread);
        }
    }

    public void close() throws IOException {
        this.skipUnreadBody();
    }

    private void checkTimedOut() throws SocketTimeoutException {
        if (this.timedOut) {
            throw new SocketTimeoutException("read is alrady timed out");
        }
    }

    private void setTimedOut(boolean bl) {
        this.timedOut = bl;
    }
}

