/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.rmi.RemoteException;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ROIDLookup;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.ReplicatedSessionContext;
import weblogic.servlet.internal.session.SessionContext;

public final class ROIDLookupImpl
implements ROIDLookup {
    HttpServer httpSrvr = null;

    public ROIDLookupImpl(HttpServer httpServer) {
        this.httpSrvr = httpServer;
    }

    public ROID lookupROID(String string, String string2, String string3) throws RemoteException {
        WebAppServletContext[] webAppServletContextArray = this.httpSrvr.getServletContextManager().getAllContexts();
        if (webAppServletContextArray == null) {
            return null;
        }
        for (int i = 0; i < webAppServletContextArray.length; ++i) {
            ReplicatedSessionContext replicatedSessionContext;
            ROID rOID;
            SessionContext sessionContext = webAppServletContextArray[i].getSessionContext();
            if (!(sessionContext instanceof ReplicatedSessionContext) || !sessionContext.getConfigMgr().getCookieName().equals(string2) || !sessionContext.getConfigMgr().getCookiePath().equals(string3) || (rOID = (replicatedSessionContext = (ReplicatedSessionContext)sessionContext).getROID(string)) == null) continue;
            return rOID;
        }
        return null;
    }

    public void updateLastAccessTimes(ROID[] rOIDArray, long[] lArray, long l, String string) throws RemoteException {
        if (rOIDArray == null || rOIDArray.length < 1) {
            return;
        }
        long l2 = System.currentTimeMillis() - l;
        WebAppServletContext webAppServletContext = this.httpSrvr.getServletContextManager().getContextForContextPath(string);
        if (webAppServletContext == null) {
            return;
        }
        try {
            ReplicatedSessionContext replicatedSessionContext = (ReplicatedSessionContext)webAppServletContext.getSessionContext();
            for (int i = 0; i < rOIDArray.length; ++i) {
                replicatedSessionContext.updateSecondaryLAT(rOIDArray[i], lArray[i] + l2);
            }
        }
        catch (ClassCastException classCastException) {
            HTTPSessionLogger.logPersistentStoreTypeNotReplicated((String)string, (String)"updateLastAccessTimes");
            return;
        }
    }

    public void unregister(ROID rOID, Object[] objectArray) throws RemoteException {
        for (int i = 0; i < objectArray.length; ++i) {
            ReplicationManager.services().unregister(rOID, objectArray[i]);
        }
    }
}

