/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.servlet.internal.CharChunkOutput;
import weblogic.servlet.internal.ChunkOutput;
import weblogic.servlet.internal.RequestCallback;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.io.FilenameEncoder;

final class RequestCallbackImpl
implements RequestCallback {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private ServletResponseImpl respImpl;
    private static final String JSP_ERROR_SENT_ATTRIBUTE = "wl.jsp.errorSent";

    public RequestCallbackImpl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletResponseImpl servletResponseImpl) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.respImpl = servletResponseImpl;
    }

    private void reportJSPFailure(String string) throws IOException {
        if (this.respImpl.isOutputStreamInitialized()) {
            return;
        }
        if (this.request.getAttribute(JSP_ERROR_SENT_ATTRIBUTE) != null) {
            return;
        }
        this.request.setAttribute(JSP_ERROR_SENT_ATTRIBUTE, (Object)Boolean.TRUE);
        String string2 = System.getProperty("file.encoding");
        ChunkOutput chunkOutput = null;
        ServletOutputStream servletOutputStream = this.respImpl.getOutputStreamNoCheck();
        if (servletOutputStream != null && servletOutputStream instanceof ServletOutputStreamImpl) {
            chunkOutput = ((ServletOutputStreamImpl)servletOutputStream).getOutput().getOutput();
        }
        if (chunkOutput != null && chunkOutput instanceof CharChunkOutput) {
            this.respImpl.setHeaderInternal("Content-Type", "text/html");
        } else {
            this.respImpl.setHeaderInternal("Content-Type", "text/html; charset=" + string2);
        }
        PrintWriter printWriter = this.response.getWriter();
        this.response.setStatus(500);
        printWriter.print(string);
        printWriter.flush();
    }

    public void reportJSPTranslationFailure(String string, String string2) throws IOException {
        this.reportJSPFailure(string2);
    }

    public void reportJSPCompilationFailure(String string, String string2) throws IOException {
        this.reportJSPFailure(string2);
    }

    public String getIncludeURI() {
        StringBuilder stringBuilder = new StringBuilder(30);
        String string = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
        String string2 = (String)this.request.getAttribute("javax.servlet.include.path_info");
        if (string == null && string2 == null) {
            string = this.request.getServletPath();
            string2 = this.request.getPathInfo();
        }
        if (string != null) {
            stringBuilder.append(string);
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        String string3 = stringBuilder.toString();
        string3 = FilenameEncoder.resolveRelativeURIPath((String)HttpParsing.unescape((String)string3));
        return string3;
    }
}

