/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpSession;
import weblogic.servlet.internal.FilterChainImpl;
import weblogic.servlet.internal.NestedServletResponse;
import weblogic.servlet.internal.RemoveWrapperOnForward;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.utils.http.HttpParsing;

public final class RequestDispatcherImpl
implements RequestDispatcher {
    public static final String REQUEST_URI_INCLUDE = "javax.servlet.include.request_uri";
    public static final String CONTEXT_PATH_INCLUDE = "javax.servlet.include.context_path";
    public static final String SERVLET_PATH_INCLUDE = "javax.servlet.include.servlet_path";
    public static final String PATH_INFO_INCLUDE = "javax.servlet.include.path_info";
    public static final String QUERY_STRING_INCLUDE = "javax.servlet.include.query_string";
    public static final String REQUEST_URI_FORWARD = "javax.servlet.forward.request_uri";
    private static final String CONTEXT_PATH_FORWARD = "javax.servlet.forward.context_path";
    private static final String SERVLET_PATH_FORWARD = "javax.servlet.forward.servlet_path";
    private static final String PATH_INFO_FORWARD = "javax.servlet.forward.path_info";
    private static final String QUERY_STRING_FORWARD = "javax.servlet.forward.query_string";
    private static final String SERVLET_PATH_FORWARD_TARGET = "weblogic.servlet.forward.target_servlet_path";
    static final String CROSS_CONTEXT_PATH = "weblogic.servlet.internal.crosscontext.path";
    static final String CROSS_CONTEXT_TYPE = "weblogic.servlet.internal.crosscontext.type";
    static final String INCLUDE = "include";
    static final String FORWARD = "forward";
    private final WebAppServletContext context;
    private final String requestPath;
    private final String param;
    private final int mode;
    private ServletStubImpl sstub;
    private boolean filtersDiabled = false;
    private boolean namedDispatcher = false;

    public RequestDispatcherImpl(String string, WebAppServletContext webAppServletContext, int n) {
        this(string, null, webAppServletContext, n);
    }

    public RequestDispatcherImpl(String string, String string2, WebAppServletContext webAppServletContext, int n) {
        this.context = webAppServletContext;
        String string3 = webAppServletContext.getContextPath();
        this.requestPath = string3 != null && string3.length() > 1 ? string3 + string : string;
        this.param = string2;
        this.sstub = null;
        this.mode = n;
    }

    public RequestDispatcherImpl(ServletStubImpl servletStubImpl, WebAppServletContext webAppServletContext, int n) {
        this.requestPath = null;
        this.param = null;
        this.context = webAppServletContext;
        this.sstub = servletStubImpl;
        this.mode = n;
        this.namedDispatcher = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest(servletRequest);
        ServletResponseImpl servletResponseImpl = null;
        try {
            servletResponseImpl = ServletResponseImpl.getOriginalResponse(servletResponse);
        }
        catch (ClassCastException classCastException) {
            servletResponseImpl = servletRequestImpl.getResponse();
        }
        if (servletResponse.isCommitted()) {
            throw new IllegalStateException("Cannot forward a response that is already committed");
        }
        boolean bl = servletResponse instanceof ServletResponseWrapper;
        if (bl) {
            servletResponse.resetBuffer();
        } else {
            servletResponseImpl.resetBuffer();
        }
        servletResponseImpl.resetOutputState();
        this.clearIncludeAttributes(servletRequest);
        Object object = servletRequest.getAttribute(REQUEST_URI_FORWARD);
        Object object2 = servletRequest.getAttribute(CONTEXT_PATH_FORWARD);
        Object object3 = servletRequest.getAttribute(SERVLET_PATH_FORWARD);
        Object object4 = servletRequest.getAttribute(PATH_INFO_FORWARD);
        Object object5 = servletRequest.getAttribute(QUERY_STRING_FORWARD);
        Object object6 = servletRequest.getAttribute(SERVLET_PATH_FORWARD_TARGET);
        if (this.sstub == null && servletRequest.getAttribute(REQUEST_URI_FORWARD) == null) {
            this.setAttributesForForward(servletRequest, servletRequestImpl);
        }
        boolean bl2 = false;
        HttpSession httpSession = null;
        boolean bl3 = false;
        WebAppServletContext webAppServletContext = servletRequestImpl.getContext();
        boolean bl4 = webAppServletContext != this.context;
        ClassLoader classLoader = null;
        Thread thread2 = null;
        Object object7 = null;
        try {
            try {
                int n;
                if (bl4) {
                    thread2 = Thread.currentThread();
                    classLoader = this.context.pushEnvironment(thread2);
                    object7 = servletRequestImpl.getAttribute(CROSS_CONTEXT_TYPE);
                    servletRequestImpl.initContext(this.context);
                    servletResponseImpl.initContext(this.context);
                    servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, FORWARD);
                    httpSession = servletRequestImpl.getSession(false);
                    bl3 = servletRequestImpl.getSessionHelper().getSessionExistanceChecked();
                    if (httpSession != null) {
                        if (httpSession.isNew()) {
                            servletRequestImpl.getSessionHelper().rememberSessionID(webAppServletContext.getSessionContext().getConfigMgr().getCookieName(), webAppServletContext.getSessionContext().getConfigMgr().getCookiePath(), ((SessionInternal)httpSession).getIdWithServerInfo());
                        }
                        webAppServletContext.exitingContext(servletRequestImpl, servletResponseImpl, httpSession);
                    }
                    boolean bl5 = !this.isSessionCookieShared(webAppServletContext);
                    servletRequestImpl.getSessionHelper().resetSession(bl5);
                }
                if (!this.namedDispatcher) {
                    if (this.requestPath == null) {
                        throw new ServletException("Cannot resolve request - requestPath was null");
                    }
                    servletRequestImpl.initFromRequestURI(this.requestPath);
                    servletRequestImpl.addForwardParameter(this.param);
                    servletRequestImpl.initInputEncoding();
                    this.sstub = this.context.resolveForwardedRequest(servletRequestImpl, servletRequest);
                    if (servletRequestImpl.getSendRedirect()) {
                        servletResponseImpl.sendRedirect(servletRequestImpl.getRedirectURI());
                        Object var25_24 = null;
                        try {
                            if (!bl2) {
                                ServletOutputStreamImpl servletOutputStreamImpl = (ServletOutputStreamImpl)servletResponseImpl.getOutputStreamNoCheck();
                                if (bl) {
                                    servletResponse.flushBuffer();
                                } else {
                                    servletOutputStreamImpl.getOutput().setWriteEnabled(false);
                                    servletOutputStreamImpl.commit();
                                }
                            }
                            Object var28_32 = null;
                            if (bl4) {
                                HttpSession httpSession2 = servletRequestImpl.getSession(false);
                                if (httpSession2 != null) {
                                    this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession2);
                                }
                                WebAppServletContext.popEnvironment(thread2, classLoader);
                                servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object7);
                                servletRequestImpl.initContext(webAppServletContext);
                                servletResponseImpl.initContext(webAppServletContext);
                                servletRequestImpl.getSessionHelper().setSession(httpSession);
                                servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
                                if (httpSession != null) {
                                    webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
                                }
                            }
                            if (this.param != null && !this.namedDispatcher) {
                                servletRequestImpl.removeRequestDispatcherQueryString();
                            }
                            servletRequestImpl.initFromRequestParser();
                            servletRequest.setAttribute(REQUEST_URI_FORWARD, object);
                            servletRequest.setAttribute(CONTEXT_PATH_FORWARD, object2);
                            servletRequest.setAttribute(SERVLET_PATH_FORWARD, object3);
                            servletRequest.setAttribute(PATH_INFO_FORWARD, object4);
                            servletRequest.setAttribute(QUERY_STRING_FORWARD, object5);
                            servletRequest.setAttribute(SERVLET_PATH_FORWARD_TARGET, object6);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var28_33 = null;
                            if (bl4) {
                                HttpSession httpSession3 = servletRequestImpl.getSession(false);
                                if (httpSession3 != null) {
                                    this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession3);
                                }
                                WebAppServletContext.popEnvironment(thread2, classLoader);
                                servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object7);
                                servletRequestImpl.initContext(webAppServletContext);
                                servletResponseImpl.initContext(webAppServletContext);
                                servletRequestImpl.getSessionHelper().setSession(httpSession);
                                servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
                                if (httpSession != null) {
                                    webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
                                }
                            }
                            if (this.param != null && !this.namedDispatcher) {
                                servletRequestImpl.removeRequestDispatcherQueryString();
                            }
                            servletRequestImpl.initFromRequestParser();
                            servletRequest.setAttribute(REQUEST_URI_FORWARD, object);
                            servletRequest.setAttribute(CONTEXT_PATH_FORWARD, object2);
                            servletRequest.setAttribute(SERVLET_PATH_FORWARD, object3);
                            servletRequest.setAttribute(PATH_INFO_FORWARD, object4);
                            servletRequest.setAttribute(QUERY_STRING_FORWARD, object5);
                            servletRequest.setAttribute(SERVLET_PATH_FORWARD_TARGET, object6);
                            throw throwable;
                        }
                    }
                    if (this.sstub == null) {
                        throw new ServletException("Cannot forward request - servlet for path: '" + this.requestPath + "' not found.");
                    }
                }
                if (this.context.getConfigManager().isCheckAuthOnForwardEnabled() && !this.namedDispatcher && !this.context.getSecurityManager().checkAccess(servletRequestImpl, servletResponseImpl, false)) {
                    Object var25_25 = null;
                    try {}
                    catch (Throwable throwable) {
                        Object var28_35 = null;
                        if (bl4) {
                            HttpSession httpSession4 = servletRequestImpl.getSession(false);
                            if (httpSession4 != null) {
                                this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession4);
                            }
                            WebAppServletContext.popEnvironment(thread2, classLoader);
                            servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object7);
                            servletRequestImpl.initContext(webAppServletContext);
                            servletResponseImpl.initContext(webAppServletContext);
                            servletRequestImpl.getSessionHelper().setSession(httpSession);
                            servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
                            if (httpSession != null) {
                                webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
                            }
                        }
                        if (this.param != null && !this.namedDispatcher) {
                            servletRequestImpl.removeRequestDispatcherQueryString();
                        }
                        servletRequestImpl.initFromRequestParser();
                        servletRequest.setAttribute(REQUEST_URI_FORWARD, object);
                        servletRequest.setAttribute(CONTEXT_PATH_FORWARD, object2);
                        servletRequest.setAttribute(SERVLET_PATH_FORWARD, object3);
                        servletRequest.setAttribute(PATH_INFO_FORWARD, object4);
                        servletRequest.setAttribute(QUERY_STRING_FORWARD, object5);
                        servletRequest.setAttribute(SERVLET_PATH_FORWARD_TARGET, object6);
                        throw throwable;
                    }
                    if (!bl2) {
                        ServletOutputStreamImpl servletOutputStreamImpl = (ServletOutputStreamImpl)servletResponseImpl.getOutputStreamNoCheck();
                        if (bl) {
                            servletResponse.flushBuffer();
                        } else {
                            servletOutputStreamImpl.getOutput().setWriteEnabled(false);
                            servletOutputStreamImpl.commit();
                        }
                    }
                    Object var28_34 = null;
                    if (bl4) {
                        HttpSession httpSession5 = servletRequestImpl.getSession(false);
                        if (httpSession5 != null) {
                            this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession5);
                        }
                        WebAppServletContext.popEnvironment(thread2, classLoader);
                        servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object7);
                        servletRequestImpl.initContext(webAppServletContext);
                        servletResponseImpl.initContext(webAppServletContext);
                        servletRequestImpl.getSessionHelper().setSession(httpSession);
                        servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
                        if (httpSession != null) {
                            webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
                        }
                    }
                    if (this.param != null && !this.namedDispatcher) {
                        servletRequestImpl.removeRequestDispatcherQueryString();
                    }
                    servletRequestImpl.initFromRequestParser();
                    servletRequest.setAttribute(REQUEST_URI_FORWARD, object);
                    servletRequest.setAttribute(CONTEXT_PATH_FORWARD, object2);
                    servletRequest.setAttribute(SERVLET_PATH_FORWARD, object3);
                    servletRequest.setAttribute(PATH_INFO_FORWARD, object4);
                    servletRequest.setAttribute(QUERY_STRING_FORWARD, object5);
                    servletRequest.setAttribute(SERVLET_PATH_FORWARD_TARGET, object6);
                    return;
                }
                ServletResponse servletResponse2 = servletResponse;
                ServletResponseWrapper servletResponseWrapper = null;
                boolean bl6 = false;
                if (servletResponse instanceof ServletResponseWrapper && !(servletResponse instanceof RemoveWrapperOnForward)) {
                    bl6 = true;
                    servletResponseWrapper = (ServletResponseWrapper)servletResponse;
                }
                while (servletResponse2 instanceof ServletResponseWrapper) {
                    if ((servletResponse2 = ((ServletResponseWrapper)servletResponse2).getResponse()) instanceof RemoveWrapperOnForward) continue;
                    if (!bl6) {
                        servletResponse = servletResponse2;
                        bl6 = true;
                    }
                    if (servletResponseWrapper != null) {
                        servletResponseWrapper.setResponse(servletResponse2);
                    }
                    if (!(servletResponse2 instanceof ServletResponseWrapper)) continue;
                    servletResponseWrapper = (ServletResponseWrapper)servletResponse2;
                }
                servletRequest.setAttribute(SERVLET_PATH_FORWARD_TARGET, (Object)(this.namedDispatcher ? null : servletRequestImpl.getServletPath()));
                if (servletResponse instanceof ServletResponseImpl) {
                    bl = false;
                }
                if ((n = this.mode) == -1) {
                    n = 1;
                }
                this.invokeServlet(bl4, servletRequest, servletResponse, servletResponseImpl, n);
            }
            catch (Throwable throwable) {
                if (!servletResponseImpl.isCommitted()) {
                    bl2 = true;
                }
                if (throwable instanceof ServletException) {
                    throw (ServletException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                bl2 = false;
                throw new ServletException(throwable);
            }
            Object var25_26 = null;
            try {}
            catch (Throwable throwable) {
                Object var28_37 = null;
                if (bl4) {
                    HttpSession httpSession6 = servletRequestImpl.getSession(false);
                    if (httpSession6 != null) {
                        this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession6);
                    }
                    WebAppServletContext.popEnvironment(thread2, classLoader);
                    servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object7);
                    servletRequestImpl.initContext(webAppServletContext);
                    servletResponseImpl.initContext(webAppServletContext);
                    servletRequestImpl.getSessionHelper().setSession(httpSession);
                    servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
                    if (httpSession != null) {
                        webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
                    }
                }
                if (this.param != null && !this.namedDispatcher) {
                    servletRequestImpl.removeRequestDispatcherQueryString();
                }
                servletRequestImpl.initFromRequestParser();
                servletRequest.setAttribute(REQUEST_URI_FORWARD, object);
                servletRequest.setAttribute(CONTEXT_PATH_FORWARD, object2);
                servletRequest.setAttribute(SERVLET_PATH_FORWARD, object3);
                servletRequest.setAttribute(PATH_INFO_FORWARD, object4);
                servletRequest.setAttribute(QUERY_STRING_FORWARD, object5);
                servletRequest.setAttribute(SERVLET_PATH_FORWARD_TARGET, object6);
                throw throwable;
            }
            if (!bl2) {
                ServletOutputStreamImpl servletOutputStreamImpl = (ServletOutputStreamImpl)servletResponseImpl.getOutputStreamNoCheck();
                if (bl) {
                    servletResponse.flushBuffer();
                } else {
                    servletOutputStreamImpl.getOutput().setWriteEnabled(false);
                    servletOutputStreamImpl.commit();
                }
            }
            Object var28_36 = null;
            if (bl4) {
                HttpSession httpSession7 = servletRequestImpl.getSession(false);
                if (httpSession7 != null) {
                    this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession7);
                }
                WebAppServletContext.popEnvironment(thread2, classLoader);
                servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object7);
                servletRequestImpl.initContext(webAppServletContext);
                servletResponseImpl.initContext(webAppServletContext);
                servletRequestImpl.getSessionHelper().setSession(httpSession);
                servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
                if (httpSession != null) {
                    webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
                }
            }
            if (this.param != null && !this.namedDispatcher) {
                servletRequestImpl.removeRequestDispatcherQueryString();
            }
            servletRequestImpl.initFromRequestParser();
            servletRequest.setAttribute(REQUEST_URI_FORWARD, object);
            servletRequest.setAttribute(CONTEXT_PATH_FORWARD, object2);
            servletRequest.setAttribute(SERVLET_PATH_FORWARD, object3);
            servletRequest.setAttribute(PATH_INFO_FORWARD, object4);
            servletRequest.setAttribute(QUERY_STRING_FORWARD, object5);
            servletRequest.setAttribute(SERVLET_PATH_FORWARD_TARGET, object6);
            return;
        }
        catch (Throwable throwable) {
            Object var25_27 = null;
            try {}
            catch (Throwable throwable2) {
                Object var28_39 = null;
                if (bl4) {
                    HttpSession httpSession8 = servletRequestImpl.getSession(false);
                    if (httpSession8 != null) {
                        this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession8);
                    }
                    WebAppServletContext.popEnvironment(thread2, classLoader);
                    servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object7);
                    servletRequestImpl.initContext(webAppServletContext);
                    servletResponseImpl.initContext(webAppServletContext);
                    servletRequestImpl.getSessionHelper().setSession(httpSession);
                    servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
                    if (httpSession != null) {
                        webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
                    }
                }
                if (this.param != null && !this.namedDispatcher) {
                    servletRequestImpl.removeRequestDispatcherQueryString();
                }
                servletRequestImpl.initFromRequestParser();
                servletRequest.setAttribute(REQUEST_URI_FORWARD, object);
                servletRequest.setAttribute(CONTEXT_PATH_FORWARD, object2);
                servletRequest.setAttribute(SERVLET_PATH_FORWARD, object3);
                servletRequest.setAttribute(PATH_INFO_FORWARD, object4);
                servletRequest.setAttribute(QUERY_STRING_FORWARD, object5);
                servletRequest.setAttribute(SERVLET_PATH_FORWARD_TARGET, object6);
                throw throwable2;
            }
            if (!bl2) {
                ServletOutputStreamImpl servletOutputStreamImpl = (ServletOutputStreamImpl)servletResponseImpl.getOutputStreamNoCheck();
                if (bl) {
                    servletResponse.flushBuffer();
                } else {
                    servletOutputStreamImpl.getOutput().setWriteEnabled(false);
                    servletOutputStreamImpl.commit();
                }
            }
            Object var28_38 = null;
            if (bl4) {
                HttpSession httpSession9 = servletRequestImpl.getSession(false);
                if (httpSession9 != null) {
                    this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession9);
                }
                WebAppServletContext.popEnvironment(thread2, classLoader);
                servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object7);
                servletRequestImpl.initContext(webAppServletContext);
                servletResponseImpl.initContext(webAppServletContext);
                servletRequestImpl.getSessionHelper().setSession(httpSession);
                servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
                if (httpSession != null) {
                    webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
                }
            }
            if (this.param != null && !this.namedDispatcher) {
                servletRequestImpl.removeRequestDispatcherQueryString();
            }
            servletRequestImpl.initFromRequestParser();
            servletRequest.setAttribute(REQUEST_URI_FORWARD, object);
            servletRequest.setAttribute(CONTEXT_PATH_FORWARD, object2);
            servletRequest.setAttribute(SERVLET_PATH_FORWARD, object3);
            servletRequest.setAttribute(PATH_INFO_FORWARD, object4);
            servletRequest.setAttribute(QUERY_STRING_FORWARD, object5);
            servletRequest.setAttribute(SERVLET_PATH_FORWARD_TARGET, object6);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl2;
        ServletOutputStreamImpl servletOutputStreamImpl;
        ServletRequestImpl servletRequestImpl;
        block18: {
            Object object6;
            Object object7;
            ClassLoader classLoader;
            Thread thread2;
            WebAppServletContext webAppServletContext;
            boolean bl3;
            HttpSession httpSession;
            ServletResponseImpl servletResponseImpl;
            block19: {
                servletRequestImpl = ServletRequestImpl.getOriginalRequest(servletRequest);
                servletResponseImpl = servletRequestImpl.getResponse();
                servletOutputStreamImpl = (ServletOutputStreamImpl)servletResponseImpl.getOutputStreamNoCheck();
                bl2 = servletOutputStreamImpl.getDoFinish();
                object5 = servletRequest.getAttribute(REQUEST_URI_INCLUDE);
                object4 = servletRequest.getAttribute(CONTEXT_PATH_INCLUDE);
                object3 = servletRequest.getAttribute(SERVLET_PATH_INCLUDE);
                object2 = servletRequest.getAttribute(PATH_INFO_INCLUDE);
                object = servletRequest.getAttribute(QUERY_STRING_INCLUDE);
                httpSession = null;
                bl3 = false;
                webAppServletContext = servletRequestImpl.getContext();
                boolean bl4 = webAppServletContext != this.context;
                bl = servletResponse instanceof ServletResponseWrapper;
                thread2 = null;
                classLoader = null;
                object7 = null;
                object6 = null;
                try {
                    if (bl4) {
                        thread2 = Thread.currentThread();
                        classLoader = this.context.pushEnvironment(thread2);
                        httpSession = servletRequestImpl.getSession(false);
                        bl3 = servletRequestImpl.getSessionHelper().getSessionExistanceChecked();
                        object7 = servletRequestImpl.getAttribute(CROSS_CONTEXT_PATH);
                        object6 = servletRequestImpl.getAttribute(CROSS_CONTEXT_TYPE);
                        servletRequestImpl.initContext(this.context);
                        servletResponseImpl.initContext(this.context);
                        servletRequestImpl.setAttribute(CROSS_CONTEXT_PATH, webAppServletContext.getContextPath());
                        servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, INCLUDE);
                        if (httpSession != null) {
                            if (httpSession.isNew()) {
                                servletRequestImpl.getSessionHelper().rememberSessionID(webAppServletContext.getSessionContext().getConfigMgr().getCookieName(), webAppServletContext.getSessionContext().getConfigMgr().getCookiePath(), ((SessionInternal)httpSession).getIdWithServerInfo());
                            }
                            webAppServletContext.exitingContext(servletRequestImpl, servletResponseImpl, httpSession);
                        }
                        boolean bl5 = !this.isSessionCookieShared(webAppServletContext);
                        servletRequestImpl.getSessionHelper().resetSession(bl5);
                    }
                    if (!this.namedDispatcher) {
                        if (this.requestPath == null) {
                            throw new ServletException("requestPath was null");
                        }
                        String string = this.requestPath;
                        servletRequest.setAttribute(CONTEXT_PATH_INCLUDE, (Object)this.context.getContextPath());
                        if (this.param != null) {
                            servletRequest.setAttribute(QUERY_STRING_INCLUDE, (Object)this.param);
                            servletRequestImpl.addIncludeParameter(this.param);
                        }
                        string = HttpParsing.unescape((String)string).trim();
                        servletRequest.setAttribute(REQUEST_URI_INCLUDE, (Object)string);
                        this.sstub = this.context.resolveIncludedRequest(servletRequestImpl, servletRequest);
                        if (this.sstub == null) {
                            throw new ServletException("Failed to resolve path: " + string);
                        }
                    }
                    Object object8 = !bl ? new NestedServletResponse((ServletResponse)servletResponseImpl) : RequestDispatcherImpl.nestWrapperResponse(servletResponse);
                    servletOutputStreamImpl.setDoFinish(false);
                    int n = this.mode;
                    if (n == -1) {
                        n = 2;
                    }
                    this.invokeServlet(bl4, servletRequest, (ServletResponse)object8, servletResponseImpl, n);
                    Object var24_25 = null;
                    if (!bl4) break block18;
                    HttpSession httpSession2 = servletRequestImpl.getSession(false);
                    if (httpSession2 == null) break block19;
                    this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession2);
                }
                catch (Throwable throwable) {
                    Object var24_26 = null;
                    if (bl4) {
                        HttpSession httpSession3 = servletRequestImpl.getSession(false);
                        if (httpSession3 != null) {
                            this.context.exitingContext(servletRequestImpl, servletResponseImpl, httpSession3);
                        }
                        WebAppServletContext.popEnvironment(thread2, classLoader);
                        servletRequestImpl.initContext(webAppServletContext);
                        servletResponseImpl.initContext(webAppServletContext);
                        if (httpSession != null) {
                            webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
                        }
                        servletRequestImpl.getSessionHelper().setSession(httpSession);
                        servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
                        servletRequestImpl.setAttribute(CROSS_CONTEXT_PATH, object7);
                        servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object6);
                    }
                    servletOutputStreamImpl.setDoFinish(bl2);
                    if (this.param != null && !this.namedDispatcher) {
                        servletRequestImpl.removeRequestDispatcherQueryString();
                    }
                    servletRequest.setAttribute(REQUEST_URI_INCLUDE, object5);
                    servletRequest.setAttribute(CONTEXT_PATH_INCLUDE, object4);
                    servletRequest.setAttribute(SERVLET_PATH_INCLUDE, object3);
                    servletRequest.setAttribute(PATH_INFO_INCLUDE, object2);
                    servletRequest.setAttribute(QUERY_STRING_INCLUDE, object);
                    if (bl) {
                        servletResponse = RequestDispatcherImpl.unsetNestedWrapper(servletResponse);
                    }
                    throw throwable;
                }
            }
            WebAppServletContext.popEnvironment(thread2, classLoader);
            servletRequestImpl.initContext(webAppServletContext);
            servletResponseImpl.initContext(webAppServletContext);
            if (httpSession != null) {
                webAppServletContext.enteringContext(servletRequestImpl, servletResponseImpl, httpSession);
            }
            servletRequestImpl.getSessionHelper().setSession(httpSession);
            servletRequestImpl.getSessionHelper().setSessionExistanceChecked(bl3);
            servletRequestImpl.setAttribute(CROSS_CONTEXT_PATH, object7);
            servletRequestImpl.setAttribute(CROSS_CONTEXT_TYPE, object6);
        }
        servletOutputStreamImpl.setDoFinish(bl2);
        if (this.param != null && !this.namedDispatcher) {
            servletRequestImpl.removeRequestDispatcherQueryString();
        }
        servletRequest.setAttribute(REQUEST_URI_INCLUDE, object5);
        servletRequest.setAttribute(CONTEXT_PATH_INCLUDE, object4);
        servletRequest.setAttribute(SERVLET_PATH_INCLUDE, object3);
        servletRequest.setAttribute(PATH_INFO_INCLUDE, object2);
        servletRequest.setAttribute(QUERY_STRING_INCLUDE, object);
        if (bl) {
            servletResponse = RequestDispatcherImpl.unsetNestedWrapper(servletResponse);
        }
    }

    private boolean isSessionCookieShared(WebAppServletContext webAppServletContext) {
        return webAppServletContext.getSessionContext().getConfigMgr().getCookieName().equals(this.context.getSessionContext().getConfigMgr().getCookieName()) && webAppServletContext.getSessionContext().getConfigMgr().getCookiePath().equals(this.context.getSessionContext().getConfigMgr().getCookiePath());
    }

    private void clearIncludeAttributes(ServletRequest servletRequest) {
        servletRequest.setAttribute(REQUEST_URI_INCLUDE, null);
        servletRequest.setAttribute(CONTEXT_PATH_INCLUDE, null);
        servletRequest.setAttribute(SERVLET_PATH_INCLUDE, null);
        servletRequest.setAttribute(PATH_INFO_INCLUDE, null);
        servletRequest.setAttribute(QUERY_STRING_INCLUDE, null);
        servletRequest.setAttribute("weblogic.servlet.BodyTagOutput", null);
        servletRequest.setAttribute("javax.servlet.jsp.PageContext.out", null);
    }

    private void setAttributesForForward(ServletRequest servletRequest, ServletRequestImpl servletRequestImpl) {
        servletRequest.setAttribute(REQUEST_URI_FORWARD, (Object)servletRequestImpl.getRequestURI());
        servletRequest.setAttribute(CONTEXT_PATH_FORWARD, (Object)servletRequestImpl.getContextPath());
        servletRequest.setAttribute(SERVLET_PATH_FORWARD, (Object)servletRequestImpl.getServletPath());
        servletRequest.setAttribute(PATH_INFO_FORWARD, (Object)servletRequestImpl.getPathInfo());
        servletRequest.setAttribute(QUERY_STRING_FORWARD, (Object)servletRequestImpl.getOriginalQueryString());
    }

    public void disableFilters() {
        this.filtersDiabled = true;
    }

    private void invokeServlet(boolean bl, ServletRequest servletRequest, ServletResponse servletResponse, ServletResponseImpl servletResponseImpl, int n) throws IOException, ServletException {
        boolean bl2;
        boolean bl3 = bl2 = bl && this.context.getEventsManager().hasRequestListeners();
        if (!this.filtersDiabled && (this.context.getFilterManager().hasFilters() || bl2)) {
            FilterChainImpl filterChainImpl = this.context.getFilterManager().getFilterChain(this.sstub, servletRequest, (ServletResponse)servletResponseImpl, bl2, n);
            if (filterChainImpl == null) {
                this.sstub.execute(servletRequest, servletResponse);
            } else {
                filterChainImpl.doFilter(servletRequest, servletResponse);
            }
        } else {
            this.sstub.execute(servletRequest, servletResponse);
        }
    }

    private static ServletResponse nestWrapperResponse(ServletResponse servletResponse) {
        ServletResponse servletResponse2 = servletResponse;
        ServletResponseWrapper servletResponseWrapper = null;
        while (servletResponse instanceof ServletResponseWrapper) {
            servletResponseWrapper = (ServletResponseWrapper)servletResponse;
            servletResponse = ((ServletResponseWrapper)servletResponse).getResponse();
        }
        if (servletResponseWrapper != null) {
            servletResponseWrapper.setResponse((ServletResponse)new NestedServletResponse(servletResponse));
        }
        return servletResponse2;
    }

    private static ServletResponse unsetNestedWrapper(ServletResponse servletResponse) {
        ServletResponse servletResponse2;
        ServletResponse servletResponse3 = servletResponse;
        ServletResponseWrapper servletResponseWrapper = null;
        while (servletResponse instanceof ServletResponseWrapper) {
            servletResponseWrapper = (ServletResponseWrapper)servletResponse;
            servletResponse = ((ServletResponseWrapper)servletResponse).getResponse();
        }
        if (servletResponse instanceof NestedServletResponse && (servletResponse2 = ((NestedServletResponse)servletResponse).getOriginalResponse()) instanceof ServletResponseImpl && servletResponseWrapper != null) {
            servletResponseWrapper.setResponse(servletResponse2);
        }
        return servletResponse3;
    }
}

