/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import weblogic.management.DeploymentException;
import weblogic.servlet.internal.EventsManager;
import weblogic.servlet.internal.WebAppServletContext;

public final class RequestEventsFilter
implements Filter {
    private EventsManager eventsManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        this.eventsManager.notifyRequestLifetimeEvent(servletRequest, true);
        try {
            filterChain.doFilter((ServletRequest)new EventsRequestWrapper((HttpServletRequest)servletRequest), servletResponse);
            Object var5_4 = null;
            this.eventsManager.notifyRequestLifetimeEvent(servletRequest, false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.eventsManager.notifyRequestLifetimeEvent(servletRequest, false);
            throw throwable;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        if (!(servletContext instanceof WebAppServletContext)) {
            throw new ServletException((Throwable)((Object)new DeploymentException("Incorrect ServletContext runtime type in FilterConfig. Expecting 'WebAppServletContext', but got '" + servletContext.getClass().getName() + "'.")));
        }
        this.eventsManager = ((WebAppServletContext)servletContext).getEventsManager();
    }

    public void destroy() {
        this.eventsManager = null;
    }

    private class EventsRequestWrapper
    extends HttpServletRequestWrapper {
        private EventsRequestWrapper(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        public void setAttribute(String string, Object object) {
            Object object2 = this.getAttribute(string);
            super.setAttribute(string, object);
            RequestEventsFilter.this.eventsManager.notifyRequestAttributeEvent((ServletRequest)this, string, object2, object);
        }

        public void removeAttribute(String string) {
            Object object = this.getAttribute(string);
            super.removeAttribute(string);
            RequestEventsFilter.this.eventsManager.notifyRequestAttributeEvent((ServletRequest)this, string, object, null);
        }
    }
}

