/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.security.Utils;
import weblogic.utils.StringUtils;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.IteratorEnumerator;
import weblogic.utils.http.BytesToString;

public final class RequestHeaders {
    private ArrayList headerNames;
    private ArrayList headerValues;
    private final ArrayList cookies = new ArrayList();
    private int contentLength = -1;
    private String contentType;
    private String proxyAuthType;
    private String remoteUser = null;
    private String host;
    private int port = -1;
    private String transferEncoding;
    private boolean isChunked = false;
    private String acceptLanguages;
    private String expect;
    private boolean contentLengthSet = false;
    private String connection;
    private String userAgent;
    private boolean wlProxyFound = false;
    private String authorization;
    private String xWeblogicRequestClusterInfo;
    private String xWeblogicClusterHash;
    private String xWeblogicClusterList;
    private String xWeblogicLoad;
    private String xWeblogicJvmId;
    private String xWeblogicForceJvmId;
    private String xWeblogicKeepaliveSecs;

    public void reset() {
        this.headerNames = null;
        this.headerValues = null;
        this.cookies.clear();
        this.contentLength = -1;
        this.contentType = null;
        this.proxyAuthType = null;
        this.host = null;
        this.port = -1;
        this.transferEncoding = null;
        this.isChunked = false;
        this.acceptLanguages = null;
        this.expect = null;
        this.contentLengthSet = false;
        this.remoteUser = null;
        this.connection = null;
        this.userAgent = null;
        this.wlProxyFound = false;
        this.authorization = null;
        this.xWeblogicRequestClusterInfo = null;
        this.xWeblogicClusterHash = null;
        this.xWeblogicClusterList = null;
        this.xWeblogicLoad = null;
        this.xWeblogicJvmId = null;
        this.xWeblogicForceJvmId = null;
        this.xWeblogicKeepaliveSecs = null;
    }

    public String getHeader(String string, String string2) {
        if (this.headerNames == null) {
            return null;
        }
        int n = this.headerNames.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase((String)this.headerNames.get(i))) continue;
            return this.getHeaderValue(i, string2);
        }
        return null;
    }

    public byte[] getHeaderAsBytes(String string) {
        if (this.headerNames == null) {
            return null;
        }
        int n = this.headerNames.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase((String)this.headerNames.get(i))) continue;
            return (byte[])this.headerValues.get(i);
        }
        return null;
    }

    public Enumeration getHeaderNames() {
        ArrayList arrayList = this.getHeaderNamesAsArrayList();
        if (arrayList == null) {
            return new EmptyEnumerator();
        }
        return new IteratorEnumerator(arrayList.iterator());
    }

    public Enumeration getHeaders(String string, String string2) {
        if (this.headerNames == null) {
            return new EmptyEnumerator();
        }
        ArrayList<String> arrayList = new ArrayList<String>(16);
        int n = this.headerNames.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase((String)this.headerNames.get(i))) continue;
            arrayList.add(this.getHeaderValue(i, string2));
        }
        return new IteratorEnumerator(arrayList.iterator());
    }

    String getHeaderValue(int n, String string) {
        byte[] byArray = (byte[])this.headerValues.get(n);
        if (byArray == null) {
            return null;
        }
        return BytesToString.newString((byte[])byArray, (String)string);
    }

    public ArrayList getHeaderNamesAsArrayList() {
        return this.headerNames;
    }

    public ArrayList getHeaderValuesAsArrayList() {
        return this.headerValues;
    }

    public void setHeaders(ArrayList arrayList, ArrayList arrayList2) {
        this.headerNames = arrayList;
        this.headerValues = arrayList2;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)this.headerNames.get(i);
            byte[] byArray = (byte[])this.headerValues.get(i);
            this.processHeader(string, byArray);
        }
    }

    private void processHeader(String string, byte[] byArray) {
        int n = string.length();
        switch (n) {
            case 4: {
                if (!ServletRequestImpl.eq(string, "Host", 4)) break;
                String string2 = StringUtils.getString((byte[])byArray);
                int n2 = string2.lastIndexOf(58);
                if (n2 < 0) {
                    this.host = Utils.encodeXSS(string2);
                    this.port = -1;
                } else {
                    if (n2 != 0) {
                        this.host = Utils.encodeXSS(string2.substring(0, n2));
                    }
                    if (n2 < string2.length() - 1) {
                        try {
                            this.port = Integer.parseInt(string2.substring(n2 + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.port = -1;
                        }
                    }
                }
                return;
            }
            case 6: {
                if (ServletRequestImpl.eq(string, "Cookie", 6)) {
                    this.cookies.add(byArray);
                    return;
                }
                if (!ServletRequestImpl.eq(string, "Expect", 6)) break;
                this.expect = StringUtils.getString((byte[])byArray);
                return;
            }
            case 9: {
                if (!ServletRequestImpl.eq(string, "AUTH_TYPE", 9)) break;
                this.proxyAuthType = StringUtils.getString((byte[])byArray);
                return;
            }
            case 11: {
                if (!ServletRequestImpl.eq(string, "REMOTE_USER", 11)) break;
                this.remoteUser = StringUtils.getString((byte[])byArray);
                return;
            }
            case 12: {
                if (!ServletRequestImpl.eq(string, "Content-Type", 12)) break;
                this.contentType = StringUtils.getString((byte[])byArray);
                return;
            }
            case 13: {
                if (!ServletRequestImpl.eq(string, "Authorization", 13)) break;
                this.authorization = StringUtils.getString((byte[])byArray);
                return;
            }
            case 14: {
                if (!ServletRequestImpl.eq(string, "Content-Length", 14)) break;
                if (this.contentLengthSet) {
                    throw new IllegalArgumentException("Duplicate content-length header. This request may be malicious.");
                }
                try {
                    String string3 = StringUtils.getString((byte[])byArray);
                    this.contentLength = Integer.parseInt(string3.trim());
                    this.contentLengthSet = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return;
            }
            case 15: {
                if (ServletRequestImpl.eq(string, "Proxy-Auth-Type", 15)) {
                    this.proxyAuthType = StringUtils.getString((byte[])byArray);
                    return;
                }
                if (ServletRequestImpl.eq(string, "Accept-Language", 15)) {
                    this.acceptLanguages = StringUtils.getString((byte[])byArray);
                    return;
                }
                if (!ServletRequestImpl.eq(string, "X-WebLogic-Load", 15)) break;
                this.xWeblogicLoad = StringUtils.getString((byte[])byArray);
                return;
            }
            case 16: {
                if (!ServletRequestImpl.eq(string, "X-WebLogic-JVMID", 16)) break;
                this.xWeblogicJvmId = StringUtils.getString((byte[])byArray);
                return;
            }
            case 17: {
                if (ServletRequestImpl.eq(string, "Transfer-Encoding", 17)) {
                    this.transferEncoding = StringUtils.getString((byte[])byArray);
                    this.isChunked = ServletRequestImpl.eq(this.transferEncoding, "chunked", 7);
                    return;
                }
                if (!ServletRequestImpl.eq(string, "Proxy-Remote-User", 17)) break;
                this.remoteUser = StringUtils.getString((byte[])byArray);
                return;
            }
            case 22: {
                if (!ServletRequestImpl.eq(string, "X-WebLogic-Force-JVMID", 22)) break;
                this.xWeblogicForceJvmId = StringUtils.getString((byte[])byArray);
                return;
            }
            case 23: {
                if (ServletRequestImpl.eq(string, "X-WebLogic-Cluster-Hash", 23)) {
                    this.xWeblogicClusterHash = StringUtils.getString((byte[])byArray);
                    return;
                }
                if (!ServletRequestImpl.eq(string, "X-WebLogic-Cluster-List", 23)) break;
                this.xWeblogicClusterList = StringUtils.getString((byte[])byArray);
                return;
            }
            case 24: {
                if (!ServletRequestImpl.eq(string, "X-WebLogic-KeepAliveSecs", 24)) break;
                this.xWeblogicKeepaliveSecs = StringUtils.getString((byte[])byArray);
                return;
            }
            case 30: {
                if (!ServletRequestImpl.eq(string, "X-WebLogic-Request-ClusterInfo", 30)) break;
                this.xWeblogicRequestClusterInfo = StringUtils.getString((byte[])byArray);
                return;
            }
        }
        if (StringUtils.indexOfIgnoreCase((String)string, (String)"WL-Proxy-") >= 0) {
            this.wlProxyFound = true;
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void ignoreContentLength() {
        this.contentLength = -1;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getProxyAuthType() {
        return this.proxyAuthType;
    }

    String getRemoteUser() {
        return this.remoteUser;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransferEncoding() {
        return this.transferEncoding;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public String getAcceptLanguages() {
        return this.acceptLanguages;
    }

    public String getExpect() {
        return this.expect;
    }

    public List getCookieHeaders() {
        return this.cookies;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isWlProxyFound() {
        return this.wlProxyFound;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getXWeblogicRequestClusterInfo() {
        return this.xWeblogicRequestClusterInfo;
    }

    public String getXWeblogicClusterHash() {
        return this.xWeblogicClusterHash;
    }

    public String getXWeblogicClusterList() {
        return this.xWeblogicClusterList;
    }

    public String getXWeblogicLoad() {
        return this.xWeblogicLoad;
    }

    public String getXWeblogicForceJvmId() {
        return this.xWeblogicForceJvmId;
    }

    public String getXWeblogicJvmId() {
        return this.xWeblogicJvmId;
    }

    public String getXWeblogicKeepaliveSecs() {
        return this.xWeblogicKeepaliveSecs;
    }
}

