/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebService;
import weblogic.utils.StringUtils;
import weblogic.utils.collections.ArrayMap;
import weblogic.utils.http.BytesToString;
import weblogic.utils.http.HttpRequestParser;
import weblogic.utils.io.ChunkedDataOutputStream;
import weblogic.utils.string.ThreadLocalDateFormat;

final class ResponseHeaders {
    private static final String SYSTEM_ENCODING = System.getProperty("file.encoding");
    public static final String CACHE_CONTROL = "Cache-Control";
    private static final String CONNECTION = "Connection";
    public static final String DATE = "Date";
    private static final String PRAGMA = "Pragma";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String LOCATION = "Location";
    public static final String SERVER = "Server";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String EXPIRES = "Expires";
    private static final String LAST_MODIFIED = "Last-Modified";
    public static final String SET_COOKIE = "Set-Cookie";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String WL_RESULT = "WL-Result";
    public static final String P3P = "P3P";
    public static final String X_POWERED_BY = "X-Powered-By";
    private static final String NO_CACHE = "no-cache";
    private static final String EQUAL = "=";
    private static final String QUOTE = "\"";
    private static final String COMMA = ",";
    private static final String NO_CACHE_SET_COOKIE = "no-cache=\"Set-Cookie\"";
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] COLON_SPACE = new byte[]{58, 32};
    private static final byte[][] standardHeadersAsBytes = new byte[][]{ResponseHeaders.getValueBytes("Cache-Control"), ResponseHeaders.getValueBytes("Connection"), ResponseHeaders.getValueBytes("Date"), ResponseHeaders.getValueBytes("Pragma"), ResponseHeaders.getValueBytes("Transfer-Encoding"), ResponseHeaders.getValueBytes("Accept-Ranges"), ResponseHeaders.getValueBytes("Location"), ResponseHeaders.getValueBytes("Server"), ResponseHeaders.getValueBytes("Content-Length"), ResponseHeaders.getValueBytes("Content-Type"), ResponseHeaders.getValueBytes("Expires"), ResponseHeaders.getValueBytes("Last-Modified"), ResponseHeaders.getValueBytes("Content-Disposition"), ResponseHeaders.getValueBytes("WL-Result")};
    private static final int CACHE_CONTROL_OFFSET = 0;
    private static final int CONNECTION_OFFSET = 1;
    private static final int DATE_OFFSET = 2;
    private static final int PRAGMA_OFFSET = 3;
    private static final int TRANSFER_ENCODING_OFFSET = 4;
    private static final int ACCEPT_RANGES_OFFSET = 5;
    private static final int LOCATION_OFFSET = 6;
    private static final int SERVER_OFFSET = 7;
    private static final int CONTENT_LENGTH_OFFSET = 8;
    private static final int CONTENT_TYPE_OFFSET = 9;
    private static final int EXPIRES_OFFSET = 10;
    private static final int LAST_MODIFIED_OFFSET = 11;
    private static final int CONTENT_DISPOSITION_OFFSET = 12;
    private static final int WL_RESULT_OFFSET = 13;
    private static final int NUM_HEADERS = 14;
    private final Object[] values = new Object[14];
    private ArrayMap genericHeaders;
    private final ServletResponseImpl response;
    private String encoding;

    private static byte[] getValueBytes(String string) {
        try {
            return (string + ": ").getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return (string + ": ").getBytes();
        }
    }

    public ResponseHeaders(ServletResponseImpl servletResponseImpl) {
        this.response = servletResponseImpl;
        this.setEncoding(SYSTEM_ENCODING);
    }

    private static boolean eq(String string, String string2, int n) {
        return string == string2 || string2.regionMatches(true, 0, string, 0, n);
    }

    private static int getHeaderOffset(String string) {
        switch (string.length()) {
            case 4: {
                if (!ResponseHeaders.eq(string, DATE, 4)) break;
                return 2;
            }
            case 6: {
                if (ResponseHeaders.eq(string, SERVER, 6)) {
                    return 7;
                }
                if (!ResponseHeaders.eq(string, PRAGMA, 6)) break;
                return 3;
            }
            case 7: {
                if (!ResponseHeaders.eq(string, EXPIRES, 7)) break;
                return 10;
            }
            case 8: {
                if (!ResponseHeaders.eq(string, LOCATION, 8)) break;
                return 6;
            }
            case 9: {
                if (!ResponseHeaders.eq(string, WL_RESULT, 9)) break;
                return 13;
            }
            case 10: {
                if (!ResponseHeaders.eq(string, CONNECTION, 10)) break;
                return 1;
            }
            case 12: {
                if (!ResponseHeaders.eq(string, CONTENT_TYPE, 12)) break;
                return 9;
            }
            case 13: {
                if (ResponseHeaders.eq(string, LAST_MODIFIED, 13)) {
                    return 11;
                }
                if (ResponseHeaders.eq(string, ACCEPT_RANGES, 13)) {
                    return 5;
                }
                if (!ResponseHeaders.eq(string, CACHE_CONTROL, 13)) break;
                return 0;
            }
            case 14: {
                if (!ResponseHeaders.eq(string, CONTENT_LENGTH, 14)) break;
                return 8;
            }
            case 17: {
                if (ResponseHeaders.eq(string, TRANSFER_ENCODING, 17)) {
                    return 4;
                }
            }
            case 19: {
                if (!ResponseHeaders.eq(string, CONTENT_DISPOSITION, 19)) break;
                return 12;
            }
        }
        return -1;
    }

    void addHeader(String string, String string2) {
        int n = ResponseHeaders.getHeaderOffset(string);
        if (n > -1) {
            Object object = this.values[n];
            this.values[n] = this.isDuplicateStdHeaderAllowed(n) ? this.mergeHeaderValue(object, string2) : string2;
            return;
        }
        if (this.genericHeaders == null) {
            this.genericHeaders = new ArrayMap(8);
        }
        Object object = this.genericHeaders.get((Object)string);
        this.genericHeaders.put((Object)string, this.mergeHeaderValue(object, string2));
    }

    private Object mergeHeaderValue(Object object, String string) {
        if (object == null) {
            return string;
        }
        if (object instanceof String) {
            String[] stringArray = new String[]{(String)object, string};
            return stringArray;
        }
        String[] stringArray = (String[])object;
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    private boolean isDuplicateStdHeaderAllowed(int n) {
        switch (n) {
            case 0: 
            case 3: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    void setHeader(String string, String string2) {
        int n = ResponseHeaders.getHeaderOffset(string);
        if (n > -1) {
            this.values[n] = string2;
            return;
        }
        if (this.genericHeaders == null) {
            this.genericHeaders = new ArrayMap();
        }
        this.genericHeaders.put((Object)string, (Object)string2);
    }

    String getHeader(String string) {
        int n = ResponseHeaders.getHeaderOffset(string);
        if (n > -1) {
            return this.getHeaderValue(n);
        }
        if (this.genericHeaders == null) {
            return null;
        }
        Object object = this.genericHeaders.get((Object)string);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return ((String[])object)[0];
    }

    private String getHeaderValue(int n) {
        Object object = this.values[n];
        if (object == null) {
            return null;
        }
        if (object instanceof String[]) {
            return ((String[])object)[0];
        }
        return object.toString();
    }

    void unsetHeader(String string) {
        int n = ResponseHeaders.getHeaderOffset(string);
        if (n > -1) {
            this.values[n] = null;
            return;
        }
        if (this.genericHeaders != null) {
            this.genericHeaders.remove((Object)string);
        }
    }

    boolean containsHeader(String string) {
        int n = ResponseHeaders.getHeaderOffset(string);
        if (n > -1) {
            return this.values[n] != null;
        }
        if (this.genericHeaders == null) {
            return false;
        }
        return this.genericHeaders.containsKey((Object)string);
    }

    void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    void setDateHeader(String string, long l) {
        this.setHeader(string, ResponseHeaders.getDateString(l));
    }

    void addIntHeader(String string, int n) {
        this.addHeader(string, Integer.toString(n));
    }

    void addDateHeader(String string, long l) {
        this.addHeader(string, ResponseHeaders.getDateString(l));
    }

    void setContentLength(int n) {
        this.values[8] = Integer.toString(n);
    }

    void setContentType(String string) {
        this.values[9] = string;
    }

    void setDate(long l) {
        this.values[2] = ThreadLocalDateFormat.getInstance().getDate(l);
    }

    void setServer(String string) {
        this.values[7] = string;
    }

    boolean getKeepAlive() {
        return "Keep-Alive".equalsIgnoreCase(this.getHeaderValue(1));
    }

    void setConnection(String string) {
        this.values[1] = string;
    }

    void disableCacheControlForCookie() {
        Object object = this.values[0];
        if (object == null) {
            this.values[0] = NO_CACHE_SET_COOKIE;
            return;
        }
        String string = null;
        string = object instanceof String[] ? StringUtils.join((String[])((String[])object), (String)COMMA) : (String)object;
        String string2 = string.toLowerCase();
        if (string2.indexOf(NO_CACHE) < 0) {
            this.values[0] = object + COMMA + NO_CACHE_SET_COOKIE;
            return;
        }
        String string3 = "no-cache=\"";
        int n = string2.indexOf(string3);
        if (n >= 0) {
            int n2 = n + string3.length();
            int n3 = string2.indexOf(QUOTE, n2);
            String string4 = string.substring(n2, n3);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string.substring(0, n2)).append(SET_COOKIE).append(COMMA).append(string4).append(string.substring(n3));
            this.values[0] = stringBuilder.toString();
        }
    }

    int writeHeaders(ServletOutputStreamImpl servletOutputStreamImpl, String string) throws IOException {
        int n;
        ChunkedDataOutputStream chunkedDataOutputStream = new ChunkedDataOutputStream(){

            protected void getBytes(String string, int n, int n2, byte[] byArray, int n3) {
                StringUtils.getBytes((String)string, (int)n, (int)n2, (byte[])byArray, (int)n3);
            }
        };
        chunkedDataOutputStream.writeBytes(string);
        for (n = 0; n < 14; ++n) {
            Object object = this.values[n];
            if (object == null) continue;
            if (this.isDuplicateStdHeaderAllowed(n)) {
                this.writeStandardDuplicateHeader(chunkedDataOutputStream, n, object);
                continue;
            }
            chunkedDataOutputStream.write(standardHeadersAsBytes[n]);
            if (n == 6) {
                chunkedDataOutputStream.write(((String)object).getBytes(HttpRequestParser.getURIDecodeEncoding()));
                chunkedDataOutputStream.write(CRLF);
                continue;
            }
            if (n == 12) {
                this.writeContentDisposition(chunkedDataOutputStream, CONTENT_DISPOSITION, object);
                continue;
            }
            chunkedDataOutputStream.writeBytes((String)object);
            chunkedDataOutputStream.write(CRLF);
        }
        if (this.genericHeaders != null) {
            for (Object object : this.genericHeaders.entrySet()) {
                String string2 = (String)object.getKey();
                chunkedDataOutputStream.writeBytes(string2);
                chunkedDataOutputStream.write(COLON_SPACE);
                ResponseHeaders.writeHeaderValue(chunkedDataOutputStream, string2, object.getValue());
            }
        }
        chunkedDataOutputStream.write(CRLF);
        n = chunkedDataOutputStream.getSize();
        servletOutputStreamImpl.writeHeader(chunkedDataOutputStream);
        return n;
    }

    private void writeStandardDuplicateHeader(ChunkedDataOutputStream chunkedDataOutputStream, int n, Object object) throws IOException {
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                chunkedDataOutputStream.write(standardHeadersAsBytes[n]);
                chunkedDataOutputStream.writeBytes(stringArray[i]);
                chunkedDataOutputStream.write(CRLF);
            }
            return;
        }
        chunkedDataOutputStream.write(standardHeadersAsBytes[n]);
        chunkedDataOutputStream.writeBytes(object.toString());
        chunkedDataOutputStream.write(CRLF);
    }

    private void writeContentDisposition(ChunkedDataOutputStream chunkedDataOutputStream, String string, Object object) throws IOException, UnsupportedEncodingException {
        HttpServer httpServer = this.response.getContext() == null ? WebService.defaultHttpServer() : this.response.getContext().getServer();
        if (httpServer.getMBean().isUseHeaderEncoding()) {
            if (object instanceof String) {
                this.writeEncodedString(chunkedDataOutputStream, (String)object);
                chunkedDataOutputStream.write(CRLF);
            } else {
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        chunkedDataOutputStream.writeBytes(string);
                        chunkedDataOutputStream.write(COLON_SPACE);
                    }
                    this.writeEncodedString(chunkedDataOutputStream, stringArray[i]);
                    chunkedDataOutputStream.write(CRLF);
                }
            }
        } else {
            ResponseHeaders.writeHeaderValue(chunkedDataOutputStream, string, object);
        }
    }

    private static void writeHeaderValue(ChunkedDataOutputStream chunkedDataOutputStream, String string, Object object) throws IOException {
        if (object == null) {
            chunkedDataOutputStream.write(CRLF);
        } else if (object instanceof String) {
            chunkedDataOutputStream.writeBytes((String)object);
            chunkedDataOutputStream.write(CRLF);
        } else {
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    chunkedDataOutputStream.writeBytes(string);
                    chunkedDataOutputStream.write(COLON_SPACE);
                }
                chunkedDataOutputStream.writeBytes(stringArray[i]);
                chunkedDataOutputStream.write(CRLF);
            }
        }
    }

    public void setEncoding(String string) {
        this.encoding = BytesToString.is8BitUnicodeSubset((String)string) ? null : string;
    }

    private void writeEncodedString(ChunkedDataOutputStream chunkedDataOutputStream, String string) throws UnsupportedEncodingException, IOException {
        if (this.encoding == null) {
            chunkedDataOutputStream.writeBytes(string);
        } else {
            chunkedDataOutputStream.write(string.getBytes(this.encoding));
        }
    }

    static String getDateString(long l) {
        return ThreadLocalDateFormat.getInstance().getDate(l);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        for (int i = 0; i < 14; ++i) {
            if (this.values[i] == null) continue;
            stringBuilder.append(new String(standardHeadersAsBytes[i])).append(": ").append(this.values[i]).append('\n');
        }
        if (this.genericHeaders != null) {
            for (String string : this.genericHeaders.keySet()) {
                stringBuilder.append(string).append(": ").append(this.genericHeaders.get((Object)string)).append('\n');
            }
        }
        return stringBuilder.toString();
    }
}

