/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.servlet.internal.ProtocolHandlerHTTP;
import weblogic.servlet.internal.ProtocolHandlerHTTPS;
import weblogic.servlet.utils.ServletObjectInputStream;
import weblogic.servlet.utils.ServletObjectOutputStream;

public final class ServerHelper {
    private static final String CLUSTER_LIST_IPV6_PREFIX = "ipv6_";
    private static final boolean useExtendedSessionFormat;
    private static final Pattern ipv6regex;

    public static final String createServerEntry(String string, ServerIdentity serverIdentity, String string2) {
        return ServerHelper.createServerEntry(string, serverIdentity, string2, true);
    }

    public static final String createServerEntry(String string, ServerIdentity serverIdentity, String string2, boolean bl) {
        ServerChannel serverChannel = ServerChannelManager.findServerChannel((HostID)serverIdentity, (String)string);
        if (serverChannel == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(serverIdentity.hashCode()).append(string2);
        if (bl) {
            stringBuilder.append(ServerHelper.getRawAddress(serverChannel.getPublicAddress()));
        } else {
            stringBuilder.append(serverChannel.getPublicAddress());
        }
        stringBuilder.append(string2);
        if (serverChannel.supportsTLS()) {
            ServerChannel serverChannel2 = ServerChannelManager.findRelatedServerChannel((HostID)serverIdentity, (Protocol)ProtocolHandlerHTTP.PROTOCOL_HTTP, (String)serverChannel.getPublicAddress());
            stringBuilder.append(serverChannel2 == null ? -1 : serverChannel2.getPublicPort()).append(string2);
            stringBuilder.append(serverChannel.getPublicPort());
        } else {
            ServerChannel serverChannel3 = ServerChannelManager.findRelatedServerChannel((HostID)serverIdentity, (Protocol)ProtocolHandlerHTTPS.PROTOCOL_HTTPS, (String)serverChannel.getPublicAddress());
            stringBuilder.append(serverChannel.getPublicPort()).append(string2);
            stringBuilder.append(serverChannel3 == null ? -1 : serverChannel3.getPublicPort());
        }
        return stringBuilder.toString();
    }

    public static final String getRawAddress(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            boolean bl = inetAddress instanceof Inet6Address;
            if (bl ? !ipv6regex.matcher(string).matches() : !inetAddress.getHostAddress().equals(string)) {
                return string;
            }
            byte[] byArray = inetAddress.getAddress();
            if (bl) {
                BigInteger bigInteger = new BigInteger(byArray);
                return CLUSTER_LIST_IPV6_PREFIX + bigInteger.toString();
            }
            long l = 0L;
            for (int i = 0; i < byArray.length; ++i) {
                l += (long)((byArray[byArray.length - (i + 1)] & 0xFF) << i * 8);
            }
            return Long.toString(l);
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    public static final boolean useExtendedSessionFormat() {
        return useExtendedSessionFormat;
    }

    public static final String getNetworkChannelName() {
        ServerChannel serverChannel = weblogic.rmi.extensions.server.ServerHelper.getServerChannel();
        if (serverChannel != null) {
            return serverChannel.getChannelName();
        }
        return "Default";
    }

    public static byte[] passivate(Object object) throws IOException {
        ServletObjectOutputStream servletObjectOutputStream = ServletObjectOutputStream.getOutputStream();
        servletObjectOutputStream.writeObject(object);
        return servletObjectOutputStream.toByteArray();
    }

    public static Object activate(byte[] byArray) throws IOException, ClassNotFoundException {
        ServletObjectInputStream servletObjectInputStream = ServletObjectInputStream.getInputStream(byArray);
        return servletObjectInputStream.readObject();
    }

    public static byte[] zipBytes(byte[] byArray) {
        Deflater deflater = new Deflater(9);
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static void unzipBytes(byte[] byArray, byte[] byArray2) throws DataFormatException {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, 0, byArray.length);
        inflater.end();
        inflater.inflate(byArray2);
    }

    static {
        ipv6regex = Pattern.compile("((:?([0-9a-fA-F]{0,4})){0,8})((\\.?[0-9]{1,3}){0,4})");
        useExtendedSessionFormat = "true".equalsIgnoreCase(System.getProperty("weblogic.servlet.useExtendedSessionFormat"));
    }
}

