/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ContextVersionManager;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.utils.ServletMapping;
import weblogic.utils.http.HttpParsing;

public final class ServletContextManager
implements PropertyChangeListener {
    private final Hashtable preservedState = new Hashtable();
    private final WebServerMBean svrMBean;
    private ServletMapping contextTable;

    ServletContextManager(WebServerMBean webServerMBean) {
        this.svrMBean = webServerMBean;
        this.contextTable = new ServletMapping();
        if (!HttpServer.isProductionModeEnabled()) {
            this.svrMBean.addPropertyChangeListener(this);
        }
    }

    public WebAppServletContext getContext(String string) {
        if (string == null) {
            return null;
        }
        string = HttpParsing.ensureStartingSlash((String)string);
        return this.getContextForURI(string);
    }

    ContextVersionManager resolveVersionManagerForURI(String string) {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("ServletContextManager: resolving VersionManager for URI : " + string);
        }
        ContextVersionManager contextVersionManager = this.lookupVersionManager(string);
        if (HTTPDebugLogger.isEnabled()) {
            if (contextVersionManager == null) {
                HTTPDebugLogger.debug("Context not found for uri " + string);
            } else {
                HTTPDebugLogger.debug("Found context: " + contextVersionManager.toString() + " for: " + string);
            }
        }
        return contextVersionManager;
    }

    ContextVersionManager lookupVersionManager(String string) {
        return (ContextVersionManager)this.contextTable.get(string);
    }

    public WebAppServletContext getContextForContextPath(String string) {
        ContextVersionManager contextVersionManager = this.lookupVersionManagerForContextPath(string);
        if (contextVersionManager == null) {
            return null;
        }
        return contextVersionManager.getContext(null);
    }

    public WebAppServletContext getContextForContextPath(String string, String string2) {
        ContextVersionManager contextVersionManager = this.lookupVersionManagerForContextPath(string);
        if (contextVersionManager == null) {
            return null;
        }
        return contextVersionManager.getContext(string2);
    }

    private WebAppServletContext getContextForURI(String string) {
        if (string == null) {
            return null;
        }
        ContextVersionManager contextVersionManager = this.lookupVersionManager(string = HttpParsing.ensureStartingSlash((String)string));
        if (contextVersionManager == null) {
            return null;
        }
        return contextVersionManager.getContext(false);
    }

    ContextVersionManager lookupVersionManagerForContextPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 1 && string.charAt(0) == '/') {
            string = "";
        } else if (n > 0 && (string = HttpParsing.ensureStartingSlash((String)string)).endsWith("/")) {
            string = string.substring(0, n - 1);
        }
        ContextVersionManager contextVersionManager = this.lookupVersionManager(string);
        if (contextVersionManager == null) {
            return null;
        }
        if (!contextVersionManager.getContextPath().equals(string)) {
            return null;
        }
        return contextVersionManager;
    }

    public WebAppServletContext getDefaultContext() {
        ContextVersionManager contextVersionManager = (ContextVersionManager)this.contextTable.getDefault();
        if (contextVersionManager == null) {
            return null;
        }
        return contextVersionManager.getActiveContext(false);
    }

    public WebAppServletContext[] getAllContexts() {
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = this.contextTable.values();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.addAll(((ContextVersionManager)objectArray[i]).getServletContexts());
        }
        WebAppServletContext[] webAppServletContextArray = new WebAppServletContext[arrayList.size()];
        return arrayList.toArray(webAppServletContextArray);
    }

    public WebAppServletContext getServletContextFor(WebAppComponentMBean webAppComponentMBean) {
        WebAppServletContext[] webAppServletContextArray = this.getAllContexts();
        for (int i = 0; i < webAppServletContextArray.length; ++i) {
            WebAppComponentMBean webAppComponentMBean2;
            WebAppServletContext webAppServletContext = webAppServletContextArray[i];
            if (webAppServletContext == null || (webAppComponentMBean2 = webAppServletContext.getMBean()) == null || !webAppComponentMBean2.getName().equals(webAppComponentMBean.getName())) continue;
            return webAppServletContext;
        }
        return null;
    }

    synchronized void registerContext(WebAppServletContext webAppServletContext) throws DeploymentException {
        String string = webAppServletContext.getContextPath();
        this.registerContext(webAppServletContext, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void registerContext(WebAppServletContext webAppServletContext, String string) throws DeploymentException {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Registering ServletContext with context-root: '" + string + "'");
        }
        this.reinstateSessionState(webAppServletContext);
        ServletMapping servletMapping = this.contextTable;
        synchronized (servletMapping) {
            Object object;
            Object object2;
            ContextVersionManager contextVersionManager = (ContextVersionManager)this.contextTable.get(string);
            ContextVersionManager contextVersionManager2 = null;
            if (contextVersionManager != null && contextVersionManager.getContextPath().equals(string) && (contextVersionManager != this.contextTable.getDefault() || ServletContextManager.toPattern(string).equals("/"))) {
                if (!contextVersionManager.getAppName().equals(webAppServletContext.getAppName())) {
                    Loggable loggable = HTTPLogger.logContextAlreadyRegisteredLoggable((String)webAppServletContext.toString(), (String)webAppServletContext.getDocroot(), (String)this.svrMBean.getName(), (String)contextVersionManager.getContext().toString(), (String)contextVersionManager.getContext().getDocroot(), (String)string);
                    loggable.log();
                    throw new DeploymentException(loggable.getMessage());
                }
                object2 = contextVersionManager.getContext(webAppServletContext.getVersionId());
                if (object2 == null && webAppServletContext.getVersionId() != null && (object = contextVersionManager.getContext()) != null && ((WebAppServletContext)object).getVersionId() == null) {
                    Loggable loggable = HTTPLogger.logNonVersionedContextAlreadyRegisteredLoggable((String)webAppServletContext.toString(), (String)webAppServletContext.getDocroot(), (String)this.svrMBean.getName(), (String)((WebAppServletContext)object).toString(), (String)((WebAppServletContext)object).getDocroot(), (String)string);
                    loggable.log();
                    throw new DeploymentException(loggable.getMessage());
                }
                contextVersionManager2 = contextVersionManager;
            }
            object2 = new ContextVersionManager(contextVersionManager2, webAppServletContext.getApplicationName(), webAppServletContext.getContextPath());
            ((ContextVersionManager)object2).putContext(webAppServletContext.getVersionId(), webAppServletContext);
            object = (ServletMapping)this.contextTable.clone();
            ((ServletMapping)object).put(ServletContextManager.toPattern(string), object2);
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("WASC registered: " + ServletContextManager.toPattern(string) + " with versionId=" + webAppServletContext.getVersionId() + ", ctx=" + webAppServletContext + ", newCtxManager=" + object2);
            }
            this.contextTable = object;
        }
    }

    synchronized void removeContext(String string) {
        this.contextTable.remove(string);
    }

    private static String toPattern(String string) {
        if (string.equals("") || string.equals("/")) {
            return "/";
        }
        return string.endsWith("/") ? string + "*" : string + "/*";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyContext(WebAppServletContext webAppServletContext, String string) {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Destroying ServletContext with context-root: '" + webAppServletContext.getContextPath() + "'");
        }
        this.preserveSessionState(webAppServletContext);
        String string2 = webAppServletContext.getContextPath();
        ServletMapping servletMapping = this.contextTable;
        synchronized (servletMapping) {
            ContextVersionManager contextVersionManager = (ContextVersionManager)this.contextTable.get(string2);
            if (contextVersionManager == null) {
                return;
            }
            ServletMapping servletMapping2 = (ServletMapping)this.contextTable.clone();
            if (contextVersionManager.getServletContexts().size() == 1) {
                servletMapping2.remove(ServletContextManager.toPattern(string2));
            } else {
                contextVersionManager.removeContext(string);
            }
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("WASC destroyed: " + ServletContextManager.toPattern(string2) + " with versionId=" + webAppServletContext.getVersionId() + ", ctx=" + webAppServletContext + ", oldCtxManager=" + contextVersionManager);
            }
            this.contextTable = servletMapping2;
        }
        webAppServletContext.destroy();
    }

    private void preserveSessionState(WebAppServletContext webAppServletContext) {
        WebAppModule webAppModule = webAppServletContext.getWebAppModule();
        if (webAppModule == null || !webAppServletContext.getSessionContext().getConfigMgr().isSaveSessionsOnRedeployEnabled()) {
            return;
        }
        SessionContext sessionContext = webAppServletContext.getSessionContext();
        sessionContext.storeAttributesInBytes();
        this.preservedState.put(webAppServletContext.getContextPath(), new PreservedState(sessionContext.getSessionsMap(), sessionContext.getCurrOpenSessionsCount(), sessionContext.getTotalOpenSessionsCount(), sessionContext.getMaxOpenSessionsCount(), sessionContext.getPersistentStoreType()));
    }

    private void reinstateSessionState(WebAppServletContext webAppServletContext) {
        WebAppModule webAppModule = webAppServletContext.getWebAppModule();
        if (webAppModule == null) {
            return;
        }
        String string = webAppServletContext.getContextPath();
        PreservedState preservedState = (PreservedState)this.preservedState.get(string);
        if (preservedState == null) {
            return;
        }
        SessionContext sessionContext = webAppServletContext.getSessionContext();
        if (preservedState.storeType.equals(sessionContext.getPersistentStoreType())) {
            sessionContext.setSessionsMap(preservedState.sessions);
            sessionContext.setCurrOpenSessionsCount(preservedState.curSessCnt);
            sessionContext.setTotalOpenSessionsCount(preservedState.totalSessCnt);
            sessionContext.setMaxOpenSessionsCount(preservedState.maxSessCnt);
        }
        this.preservedState.remove(string);
    }

    void removeSavedSessionState(String string) {
        this.preservedState.remove(string);
    }

    public String toString() {
        return "ServletContextManager(" + this.svrMBean.getName() + ")";
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (!propertyChangeEvent.getPropertyName().equalsIgnoreCase("DefaultWebAppContextRoot")) {
            return;
        }
        Object object2 = propertyChangeEvent.getOldValue();
        Object object3 = propertyChangeEvent.getNewValue();
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Received a PropertyChangeEvent with oldvalue=" + object2 + " and newValue=" + object3);
        }
        if (object3 == null) {
            return;
        }
        if (this.contextTable.getDefault() != null) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("We already have a default webapp, cannot assign a new default webapp");
            }
            return;
        }
        String string = (String)object3;
        if (string.length() < 2) {
            return;
        }
        if (object2 != null && string.equals(object = (String)object2)) {
            return;
        }
        object = this.getContextForContextPath(string);
        if (object == null) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Didn't find a ServletContext with context-root=" + string);
            }
            return;
        }
        ((WebAppServletContext)object).setDefaultContext();
        this.contextTable.remove(ServletContextManager.toPattern(string));
        ContextVersionManager contextVersionManager = ((WebAppServletContext)object).getContextManager();
        if (contextVersionManager == null) {
            contextVersionManager = new ContextVersionManager(null, ((WebAppServletContext)object).getApplicationName(), ((WebAppServletContext)object).getContextPath());
        }
        this.contextTable.put(ServletContextManager.toPattern(((WebAppServletContext)object).getContextPath()), contextVersionManager);
    }

    private static final class PreservedState {
        Hashtable sessions = null;
        int curSessCnt = 0;
        int totalSessCnt = 0;
        int maxSessCnt = 0;
        String storeType = null;

        PreservedState(Hashtable hashtable, int n, int n2, int n3, String string) {
            this.sessions = hashtable;
            this.curSessCnt = n;
            this.totalSessCnt = n2;
            this.maxSessCnt = n3;
            this.storeType = string;
        }
    }
}

