/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import weblogic.utils.http.HttpChunkInputStream;
import weblogic.utils.io.Chunk;

public final class ServletInputStreamImpl
extends ServletInputStream {
    private InputStream in = this;
    private int nread;
    private boolean isClosed = false;

    public ServletInputStreamImpl(InputStream inputStream) {
        this.in = inputStream;
        this.nread = 0;
    }

    int getBytesRead() {
        return this.nread;
    }

    boolean isClosed() {
        return this.isClosed;
    }

    void ensureChunkedConsumed() throws IOException {
        HttpChunkInputStream httpChunkInputStream;
        if (this.in instanceof HttpChunkInputStream && (httpChunkInputStream = (HttpChunkInputStream)this.in).hasUnconsumedChunk()) {
            httpChunkInputStream.skipAllChunk();
        }
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        this.isClosed = true;
    }

    public void mark(int n) {
        if (!this.in.markSupported()) {
            this.in = new FilterInputStream(this.in){
                private int pos;
                private int size;
                private byte[] markBuffer;
                private boolean markSet;
                {
                    this.pos = -1;
                    this.size = -1;
                    this.markSet = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public long skip(long l) throws IOException {
                    int n;
                    if (l <= 0L) {
                        return 0L;
                    }
                    long l2 = l;
                    if (this.markSet && this.size > this.pos) {
                        n = this.size - this.pos;
                        if ((long)n >= l2) {
                            this.pos = (int)((long)this.pos + l2);
                            return l2;
                        }
                        this.markSet = false;
                        l2 -= (long)n;
                    }
                    Chunk chunk = Chunk.getChunk();
                    try {
                        while (l2 > 0L && (n = this.read(chunk.buf, 0, (int)Math.min((long)Chunk.CHUNK_SIZE, l2))) >= 0) {
                            l2 -= (long)n;
                        }
                        long l3 = l - l2;
                        return l3;
                    }
                    finally {
                        Chunk.releaseChunk((Chunk)chunk);
                    }
                }

                public void mark(int n) {
                    if (this.pos != this.size) {
                        int n2 = this.size - this.pos;
                        if (this.markBuffer != null && this.markBuffer.length < n + n2) {
                            byte[] byArray = new byte[n + n2];
                            System.arraycopy(this.markBuffer, this.pos, byArray, 0, n2);
                            this.markBuffer = byArray;
                        } else {
                            System.arraycopy(this.markBuffer, this.pos, this.markBuffer, 0, n2);
                        }
                        this.size = n2;
                    } else {
                        if (this.markBuffer == null || this.markBuffer.length < n) {
                            this.markBuffer = new byte[n];
                        }
                        this.size = 0;
                    }
                    this.markSet = true;
                    this.pos = 0;
                }

                public int available() throws IOException {
                    return super.available() + (this.size - this.pos);
                }

                public boolean markSupported() {
                    return true;
                }

                public int read() throws IOException {
                    if (!this.markSet) {
                        return this.in.read();
                    }
                    if (this.pos == this.size) {
                        int n = this.in.read();
                        if (n == -1) {
                            return -1;
                        }
                        if (this.size == this.markBuffer.length) {
                            this.markSet = false;
                            return n;
                        }
                        this.markBuffer[this.size++] = (byte)n;
                    }
                    return this.markBuffer[this.pos++] & 0xFF;
                }

                public int read(byte[] byArray, int n, int n2) throws IOException {
                    if (!this.markSet) {
                        return this.in.read(byArray, n, n2);
                    }
                    int n3 = 0;
                    int n4 = this.size - this.pos;
                    int n5 = n2 - n4;
                    if (n5 > 0) {
                        byte[] byArray2 = new byte[n5];
                        n3 = this.in.read(byArray2, 0, n5);
                        if (n3 == -1) {
                            if (n4 == 0) {
                                return -1;
                            }
                            n3 = 0;
                        }
                        if (this.size + n3 > this.markBuffer.length) {
                            this.markSet = false;
                            System.arraycopy(this.markBuffer, this.pos, byArray, n, n4);
                            System.arraycopy(byArray2, 0, byArray, n + n4, n3);
                            return n4 + n3;
                        }
                        System.arraycopy(byArray2, 0, this.markBuffer, this.size, n3);
                        this.size += n3;
                    }
                    int n6 = Math.min(this.size - this.pos, n2);
                    System.arraycopy(this.markBuffer, this.pos, byArray, n, n6);
                    this.pos += n6;
                    return n6;
                }

                public void reset() {
                    this.pos = 0;
                }
            };
        }
        this.in.mark(n);
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n > 0) {
            ++this.nread;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n > 0) {
            this.nread += n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.nread += n3;
        }
        return n3;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.nread = 0;
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }
}

