/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.SocketException;
import javax.servlet.ServletOutputStream;
import weblogic.servlet.internal.ChunkOutput;
import weblogic.servlet.internal.ChunkOutputWrapper;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebService;
import weblogic.socket.NIOConnection;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedDataOutputStream;

public final class ServletOutputStreamImpl
extends ServletOutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final ServletResponseImpl response;
    private final OutputStream out;
    private boolean headersSent;
    private boolean inFinish = false;
    private ChunkOutputWrapper co;
    private int clen;
    private boolean nativeControlsPipe = false;
    private boolean enforceCL;
    private boolean flushOK = true;
    private boolean doFinish = true;
    private HttpServer httper;
    private boolean commitCalled = false;
    private boolean writeBody;
    private static final byte[] FINAL_CHUNK = new byte[]{48, 48, 48, 48, 13, 10, 13, 10};

    public ServletOutputStreamImpl(OutputStream outputStream, ServletResponseImpl servletResponseImpl) {
        NIOConnection nIOConnection;
        this.setHttpServer(WebService.defaultHttpServer());
        this.response = servletResponseImpl;
        this.out = outputStream;
        int n = 8192;
        if (outputStream instanceof NIOConnection && (nIOConnection = (NIOConnection)outputStream).supportsGatheredWrites()) {
            n = nIOConnection.getOptimalNumberOfBuffers() * Chunk.CHUNK_SIZE;
        }
        this.co = new ChunkOutputWrapper(ChunkOutput.create(n, true, this.out, this));
        this.setBufferSize(n);
        this.co.setChunking(false);
        this.clen = -1;
    }

    public void flush() throws IOException {
        block6: {
            try {
                if (this.flushOK) {
                    if (!this.headersSent) {
                        this.sendHeaders();
                    }
                    this.co.flush();
                }
            }
            catch (IOException iOException) {
                if (!this.handleIOException(iOException)) {
                    throw iOException;
                }
            }
            catch (RuntimeException runtimeException) {
                if (this.handleRuntimeException(runtimeException)) break block6;
                throw runtimeException;
            }
        }
    }

    public void write(int n) throws IOException {
        block5: {
            if (this.flushOK) {
                this.checkCL(1);
                try {
                    this.co.writeByte(n);
                }
                catch (IOException iOException) {
                    if (!this.handleIOException(iOException)) {
                        throw iOException;
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (this.handleRuntimeException(runtimeException)) break block5;
                    throw runtimeException;
                }
            }
        }
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        block5: {
            if (this.flushOK) {
                this.checkCL(n2);
                try {
                    this.co.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    if (!this.handleIOException(iOException)) {
                        throw iOException;
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (this.handleRuntimeException(runtimeException)) break block5;
                    throw runtimeException;
                }
            }
        }
    }

    static boolean supportsGatheredWrites(OutputStream outputStream) {
        return outputStream instanceof NIOConnection ? ((NIOConnection)outputStream).supportsGatheredWrites() : false;
    }

    void writeHeader(ChunkedDataOutputStream chunkedDataOutputStream) throws IOException {
        if (ServletOutputStreamImpl.supportsGatheredWrites(this.out) && this.writeBody) {
            this.co.setHttpHeaders(chunkedDataOutputStream.getChunks());
        } else {
            chunkedDataOutputStream.writeTo(this.out);
        }
    }

    public void print(String string) throws IOException {
        if (this.flushOK) {
            if (string == null) {
                this.checkCL("null".length());
                this.co.print("null");
                return;
            }
            int n = string.length();
            this.checkCL(n);
            this.co.print(string);
        }
    }

    private final void checkCL(int n) throws IOException {
        if (!this.enforceCL) {
            return;
        }
        if (this.co.getTotal() + this.co.getCount() + n > this.clen) {
            throw new ProtocolException("Exceeded stated content-length of: '" + this.clen + "' bytes");
        }
    }

    private boolean handleIOException(IOException iOException) {
        this.flushOK = false;
        if (this.inFinish && iOException instanceof SocketException) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Socket issue", iOException);
            }
            return true;
        }
        return false;
    }

    private boolean handleRuntimeException(RuntimeException runtimeException) {
        if (this.inFinish && ServletOutputStreamImpl.isNestedSocketException(runtimeException)) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Socket issue", runtimeException);
            }
            this.flushOK = false;
            return true;
        }
        return false;
    }

    private static boolean isNestedSocketException(RuntimeException runtimeException) {
        Throwable throwable;
        for (throwable = runtimeException; throwable != null && !(throwable instanceof SocketException); throwable = throwable.getCause()) {
        }
        return throwable instanceof SocketException;
    }

    void sendHeaders() throws IOException {
        block9: {
            try {
                if (this.flushOK) {
                    if (this.headersSent) {
                        return;
                    }
                    if (this.response.getStatus() == 304) {
                        this.clearCurrentBuffer();
                        this.setWriteEnabled(false);
                    } else if (!this.inFinish && this.clen == -1) {
                        if (this.response.getRequest().getInputHelper().getRequestParser().isProtocolVersion_1_1() && !this.httper.getMBean().isChunkedTransferDisabled()) {
                            this.co.setChunking(true);
                            this.response.addHeader("Transfer-Encoding", "chunked");
                        } else {
                            this.response.disableKeepAlive();
                        }
                    }
                    this.response.writeHeaders();
                    this.headersSent = true;
                }
            }
            catch (IOException iOException) {
                if (!this.flushOK || this.handleIOException(iOException)) break block9;
                throw iOException;
            }
        }
    }

    boolean headersSent() {
        return this.headersSent;
    }

    void flushBuffer() throws IOException {
        this.flush();
    }

    boolean isCommitted() {
        return this.headersSent;
    }

    void reset() throws IllegalStateException {
        this.clearBuffer();
        this.enforceCL = false;
        this.clen = -1;
        this.co.setChunking(false);
        this.nativeControlsPipe = false;
    }

    int getBufferSize() {
        return this.co.getBufferSize();
    }

    void setBufferSize(int n) {
        this.co.setBufferSize(n);
    }

    public void setNativeControlsPipe(boolean bl) throws IOException {
        if (!this.nativeControlsPipe && bl) {
            this.clearCurrentBuffer();
            this.setEnforceContentLength(false);
            this.response.writeHeaders();
            this.headersSent = true;
            this.co.setNativeControlsPipe(true);
        } else if (this.nativeControlsPipe && !bl) {
            this.clearCurrentBuffer();
            this.setEnforceContentLength(false);
            this.clen = -1;
            this.co.setChunking(false);
            this.co.setNativeControlsPipe(false);
        }
        this.nativeControlsPipe = bl;
    }

    private void setEnforceContentLength(boolean bl) {
        if (!this.writeBody) {
            this.enforceCL = false;
            return;
        }
        this.enforceCL = bl;
    }

    public void clearBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        this.clearCurrentBuffer();
    }

    public void clearCurrentBuffer() {
        this.co.clearBuffer();
    }

    public int getCount() {
        return this.co.getCount();
    }

    int getTotal() {
        return this.co.getTotal();
    }

    void setOutput(ChunkOutputWrapper chunkOutputWrapper) {
        this.co = chunkOutputWrapper;
    }

    public ChunkOutputWrapper getOutput() {
        return this.co;
    }

    void setHttpServer(HttpServer httpServer) {
        this.httper = httpServer;
    }

    public void setContentLength(int n) throws ProtocolException {
        if (this.enforceCL && this.headersSent) {
            throw new ProtocolException("Content-Length already set");
        }
        if (this.writeBody) {
            this.enforceCL = true;
        }
        this.clen = n;
        this.co.setCL(this.clen);
        if (this.useKeepAliveHeader()) {
            this.response.setHeaderInternal("Connection", "Keep-Alive");
        }
    }

    private boolean useKeepAliveHeader() {
        if (this.response.getRequest().getInputHelper().getRequestParser().isProtocolVersion_1_1()) {
            return false;
        }
        if (this.response.hasKeepAliveHeader()) {
            return false;
        }
        return this.response.getUseKeepAlive();
    }

    boolean getDoFinish() {
        return this.doFinish;
    }

    public void setDoFinish(boolean bl) {
        this.doFinish = bl;
    }

    static void p(String string) {
        System.err.println("[ServletOS]: " + string);
    }

    void ensureContentLength(long l) throws IOException {
        if (!(this.enforceCL && this.flushOK && this.writeBody)) {
            return;
        }
        long l2 = (long)(this.co.getTotal() + this.co.getCount()) + l;
        if ((long)this.clen != l2) {
            if (!this.isCommitted()) {
                try {
                    this.response.sendError(500);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new ProtocolException("Didn't meet stated Content-Length, wrote: '" + l2 + "' bytes instead of stated: '" + this.clen + "' bytes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        block14: {
            if (this.commitCalled) {
                return;
            }
            if (!this.doFinish) {
                return;
            }
            if (this.nativeControlsPipe) {
                return;
            }
            if (!this.headersSent && !this.enforceCL) {
                if (!this.writeBody) {
                    this.response.setContentLength(this.clen);
                } else if (this.response.getStatus() != 304) {
                    this.response.setContentLength(this.co.getTotal() + this.co.getCount());
                }
            }
            try {
                block15: {
                    this.inFinish = true;
                    this.flush();
                    if (!this.co.isChunking() || !this.flushOK || !this.writeBody) break block14;
                    try {
                        this.out.write(FINAL_CHUNK);
                    }
                    catch (IOException iOException) {
                        if (!this.handleIOException(iOException)) {
                            throw iOException;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        if (this.handleRuntimeException(runtimeException)) break block15;
                        throw runtimeException;
                    }
                }
                this.response.incrementBytesSentCount(FINAL_CHUNK.length);
            }
            finally {
                this.inFinish = false;
                this.co.setChunking(false);
                this.clen = -1;
                this.enforceCL = false;
                this.co.setWriteEnabled(false);
                this.commitCalled = true;
            }
        }
    }

    public void finish() throws IOException {
        if (!this.commitCalled) {
            this.commit();
        }
        this.response.resetOutputState();
        this.commitCalled = false;
        this.co.setWriteEnabled(true);
        this.co.setAutoFlush(true);
        if (this.flushOK && this.response.getUseKeepAlive()) {
            this.co.reset();
            if (this.co.getEncoding() != null) {
                this.co.changeToCharset(null, this.response.getContext().getConfigManager().getCharsetMap());
            }
            this.headersSent = false;
        } else {
            this.co.release();
        }
    }

    public void writeStream(InputStream inputStream) throws IOException {
        this.writeStream(inputStream, -1);
    }

    public void writeStream(InputStream inputStream, int n) throws IOException {
        block4: {
            try {
                this.co.writeStream(inputStream, n);
            }
            catch (IOException iOException) {
                if (!this.handleIOException(iOException)) {
                    throw iOException;
                }
            }
            catch (RuntimeException runtimeException) {
                if (this.handleRuntimeException(runtimeException)) break block4;
                throw runtimeException;
            }
        }
    }

    public void writeStreamWithEncoding(InputStream inputStream) throws IOException {
        this.writeStream(inputStream, -1);
    }

    OutputStream getRawOutputStream() {
        return this.out;
    }

    void setWriteEnabled(boolean bl) {
        this.writeBody = bl;
        this.co.setWriteEnabled(this.writeBody);
    }
}

