/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.security.Principal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.logging.Loggable;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelStream;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.AttributesMap;
import weblogic.servlet.internal.ContextVersionManager;
import weblogic.servlet.internal.CookieParser;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.MalformedCookieHeaderException;
import weblogic.servlet.internal.MuxableSocketHTTP;
import weblogic.servlet.internal.RequestDispatcherImpl;
import weblogic.servlet.internal.RequestHeaders;
import weblogic.servlet.internal.ServerHelper;
import weblogic.servlet.internal.ServletInputStreamImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.VirtualConnection;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.ReplicatedSessionContext;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.internal.session.SharedSessionData;
import weblogic.servlet.logging.HttpAccountingInfoImpl;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.servlet.security.internal.WebAppContextHandler;
import weblogic.utils.Debug;
import weblogic.utils.NestedRuntimeException;
import weblogic.utils.StringUtils;
import weblogic.utils.collections.ArrayMap;
import weblogic.utils.collections.Iterators;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.IteratorEnumerator;
import weblogic.utils.http.BytesToString;
import weblogic.utils.http.HttpConstants;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.http.HttpRequestParser;
import weblogic.utils.http.QueryParams;
import weblogic.utils.io.FilenameEncoder;
import weblogic.utils.string.CachingDateFormat;
import weblogic.utils.string.ThreadLocalDateFormat;
import weblogic.work.ServerWorkAdapter;
import weblogic.work.WorkManager;

public final class ServletRequestImpl
extends ServerWorkAdapter
implements HttpServletRequest,
ServerChannelStream {
    protected static final String WL_DEBUG_SESSION = "wl_debug_session";
    private boolean futureResponse;
    private static final boolean isWLProxyHeadersAccessible;
    private static final boolean isRemoteUserHeaderAccessible;
    private WebAppServletContext context;
    private ContextVersionManager contextManager;
    private ServletResponseImpl response;
    private ServletInputStream inputStream;
    private WebAppContextHandler securityContextHandler;
    private final VirtualConnection connection;
    private final HttpAccountingInfoImpl accountInfo = new HttpAccountingInfoImpl(this);
    private final SessionHelper sessionHelper;
    private final RequestInputHelper inputHelper = new RequestInputHelper();
    private final RequestHeaders headers = new RequestHeaders();
    private final RequestParameters parameters = new RequestParameters(this);
    private final AttributesMap attributes = new AttributesMap("request");
    private ServletStubImpl sstub;
    private boolean useInputStream;
    private boolean useReader;
    private BufferedReader bufferedReader;
    private String relativeURI;
    private String servletPath;
    private String pathInfo;
    private boolean sendRedirect;
    private String redirectLocation;
    private boolean checkIndexFile;
    private String inputEncoding;
    private boolean inputEncodingInitialized;
    private String queryParamsEncoding;
    private String serverName;
    private int serverPort;
    private Locale[] locales;
    private Cookie[] cookies;
    private boolean cookiesParsed;
    private boolean underExecution;
    private boolean performOverloadAction;
    private String overloadRejectionMessage;
    private boolean preventRedispatch;
    static final long serialVersionUID = 1200336484278099024L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_Request_Run_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    ServletRequestImpl(MuxableSocketHTTP muxableSocketHTTP) {
        this.connection = new VirtualConnection(this, muxableSocketHTTP);
        this.sessionHelper = new SessionHelper(this, null);
    }

    private ServletRequestImpl(MuxableSocketHTTP muxableSocketHTTP, SessionHelper sessionHelper) {
        this.connection = new VirtualConnection(this, muxableSocketHTTP);
        this.sessionHelper = new SessionHelper(this, sessionHelper);
    }

    void reset() {
        this.skipUnreadBody();
        this.useInputStream = false;
        this.useReader = false;
        this.relativeURI = null;
        this.sendRedirect = false;
        this.redirectLocation = null;
        this.locales = null;
        this.sstub = null;
        this.inputStream = null;
        this.bufferedReader = null;
        this.servletPath = null;
        this.pathInfo = null;
        this.attributes.clear();
        this.inputEncoding = null;
        this.inputEncodingInitialized = false;
        this.serverName = null;
        this.checkIndexFile = false;
        this.cookiesParsed = false;
        this.cookies = null;
        this.connection.reset();
        this.accountInfo.clear();
        this.sessionHelper.reset();
        this.inputHelper.reset();
        this.headers.reset();
        this.parameters.reset();
        this.context = null;
        this.preventRedispatch = false;
    }

    void skipUnreadBody() {
        if (!this.inputHelper.getRequestParser().isMethodSafe()) {
            boolean bl = "Chunked".equalsIgnoreCase(this.headers.getTransferEncoding());
            ServletInputStreamImpl servletInputStreamImpl = this.getServletInputStreamImpl();
            if (servletInputStreamImpl != null && !servletInputStreamImpl.isClosed()) {
                try {
                    if (bl) {
                        servletInputStreamImpl.ensureChunkedConsumed();
                    } else {
                        int n = this.getContentLength();
                        int n2 = servletInputStreamImpl.getBytesRead();
                        if (n2 < n) {
                            servletInputStreamImpl.skip(n - n2);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append(super.toString()).append("[\n").append(this.getMethod()).append(' ').append(this.getRequestURI());
        String string = this.getQueryString();
        if (string != null) {
            stringBuilder.append('?').append(string);
        }
        stringBuilder.append(' ').append(this.getProtocol()).append('\n');
        ArrayList arrayList = this.headers.getHeaderNamesAsArrayList();
        ArrayList arrayList2 = this.headers.getHeaderValuesAsArrayList();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2;
                byte[] byArray;
                String string3 = (String)arrayList.get(i);
                if (string3 == null || (byArray = (byte[])arrayList2.get(i)) == null || "Host".equalsIgnoreCase(string3)) continue;
                try {
                    string2 = new String(byArray, this.getInputEncoding());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (HTTPDebugLogger.isEnabled()) {
                        this.trace(unsupportedEncodingException, unsupportedEncodingException.getMessage());
                    }
                    string2 = new String(byArray);
                }
                stringBuilder.append(string3).append(": ").append(string2).append('\n');
            }
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    public String toStringSimple() {
        return "HttpRequest@" + super.hashCode() + " - " + this.getRequestURI();
    }

    public RequestInputHelper getInputHelper() {
        return this.inputHelper;
    }

    public RequestHeaders getRequestHeaders() {
        return this.headers;
    }

    public RequestParameters getRequestParameters() {
        return this.parameters;
    }

    void initFromRequestParser(HttpRequestParser httpRequestParser) {
        this.inputHelper.initFromRequestParser(httpRequestParser, this.parameters);
        this.headers.setHeaders(httpRequestParser.getHeaderNames(), httpRequestParser.getHeaderValues());
        this.getConnection().init();
        this.initProxyHeaders();
        this.relativeURI = this.computeRelativeUri(this.inputHelper.getNormalizedURI());
    }

    void initFromRequestParser() {
        this.inputHelper.restore();
        this.relativeURI = this.computeRelativeUri(this.inputHelper.getNormalizedURI());
    }

    void initFromRequestURI(String string) {
        this.inputHelper.initFromRequestURI(string);
        this.relativeURI = this.computeRelativeUri(this.inputHelper.getNormalizedURI());
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("URI: " + this.inputHelper.getNormalizedURI());
        }
    }

    void addForwardParameter(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.parameters.addForwardQueryString(string);
    }

    void addIncludeParameter(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.parameters.addIncludeQueryString(string);
    }

    void removeRequestDispatcherQueryString() {
        this.parameters.removeRequestDispatcherQueryString();
    }

    private void initProxyHeaders() {
        if (!this.headers.isWlProxyFound()) {
            return;
        }
        ArrayList arrayList = this.headers.getHeaderNamesAsArrayList();
        ArrayList arrayList2 = this.headers.getHeaderValuesAsArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            byte[] byArray = (byte[])arrayList2.get(i);
            if (StringUtils.indexOfIgnoreCase((String)string, (String)"WL-Proxy-") < 0) continue;
            this.getConnection().processProxyHeader(string, byArray);
            if (isWLProxyHeadersAccessible) continue;
            arrayList.remove(i);
            arrayList2.remove(i);
            --i;
        }
    }

    void initContext(WebAppServletContext webAppServletContext) {
        WebAppServletContext webAppServletContext2 = this.context;
        this.context = webAppServletContext;
        if (webAppServletContext2 == null) {
            this.relativeURI = this.computeRelativeUri(this.inputHelper.getNormalizedURI());
        }
    }

    void initContextManager(ContextVersionManager contextVersionManager) {
        this.contextManager = contextVersionManager;
        this.context = null;
        if (contextVersionManager != null) {
            this.sessionHelper.initSessionInfo();
        }
    }

    private void initServerNameAndPort() {
        int n;
        int n2;
        String string = this.headers.getHost();
        int n3 = this.headers.getPort();
        HttpServer httpServer = this.context.getServer();
        String string2 = httpServer.getFrontendHost();
        if (string2 != null) {
            this.setServerName(string2);
        } else if (string != null) {
            this.setServerName(string);
        } else {
            this.setServerName(httpServer.getListenAddress());
        }
        if (this.connection.isSecure()) {
            n2 = httpServer.getFrontendHTTPSPort();
            n = 443;
        } else {
            n2 = httpServer.getFrontendHTTPPort();
            n = 80;
        }
        if (n2 != 0) {
            this.setServerPort(n2);
            return;
        }
        if (n3 != -1) {
            this.setServerPort(n3);
            return;
        }
        if (string == null) {
            this.setServerPort(this.connection.getLocalPort());
        } else {
            this.setServerPort(n);
        }
    }

    public WebAppServletContext getContext() {
        return this.context;
    }

    public HttpAccountingInfoImpl getHttpAccountingInfo() {
        return this.accountInfo;
    }

    public String getInputEncoding() {
        if (this.inputEncoding != null) {
            return this.inputEncoding;
        }
        if (this.context != null) {
            return this.context.getConfigManager().getDefaultEncoding();
        }
        return "ISO-8859-1";
    }

    private String getQueryParamsEncoding() {
        if (this.queryParamsEncoding != null) {
            return this.queryParamsEncoding;
        }
        return this.getInputEncoding();
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        if (this.useReader) {
            return;
        }
        this.setCharacterEncodingInternal(string);
    }

    private void setCharacterEncodingInternal(String string) throws UnsupportedEncodingException {
        boolean bl;
        try {
            bl = Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException("Unsupported Encoding " + string);
        }
        if (!bl) {
            throw new UnsupportedEncodingException("Unsupported Encoding" + string);
        }
        String string2 = this.getQueryParamsEncoding();
        this.inputEncoding = this.context.getConfigManager().getCharsetMap().getJavaCharset(string);
        if (!this.inputEncoding.equals(string2)) {
            this.parameters.resetQueryParams();
        }
    }

    public String getCharacterEncoding() {
        try {
            this.initRequestEncoding();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return this.inputEncoding;
    }

    public void setQueryCharacterEncoding(String string) throws UnsupportedEncodingException {
        if (!Charset.isSupported(string)) {
            throw new UnsupportedEncodingException("Unsupported Encoding " + string);
        }
        this.queryParamsEncoding = this.context.getConfigManager().getCharsetMap().getJavaCharset(string);
        this.parameters.resetQueryParams();
    }

    public ServletResponseImpl getResponse() {
        return this.response;
    }

    void setResponse(ServletResponseImpl servletResponseImpl) {
        this.response = servletResponseImpl;
    }

    public ServletStubImpl getServletStub() {
        return this.sstub;
    }

    void setServletStub(ServletStubImpl servletStubImpl) {
        this.sstub = servletStubImpl;
    }

    void enableFutureResponse() {
        this.futureResponse = true;
        ((MuxableSocketHTTP)this.connection.getSocketRuntime()).disableRequestResponseReuse();
    }

    boolean isFutureResponseEnabled() {
        return this.futureResponse;
    }

    void disableFutureResponse() {
        this.futureResponse = false;
    }

    boolean getSendRedirect() {
        return this.sendRedirect;
    }

    void setRedirectURI(String string) {
        this.sendRedirect = true;
        this.redirectLocation = string;
    }

    String getRedirectURI() {
        return this.redirectLocation;
    }

    public String getMethod() {
        return this.inputHelper.getRequestParser().getMethod();
    }

    public void setMethod(String string) {
        this.inputHelper.getRequestParser().setMethod(string);
        this.response.getServletOutputStream().setWriteEnabled(!this.inputHelper.getRequestParser().isMethodHead());
    }

    public int getContentLength() {
        return this.headers.getContentLength();
    }

    public String getContentType() {
        return this.headers.getContentType();
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = new StringBuffer(this.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(this.serverName);
        stringBuffer.append(":");
        stringBuffer.append(this.serverPort);
        stringBuffer.append(this.inputHelper.getOriginalURI());
        return stringBuffer;
    }

    public String getRequestURI() {
        if (this.context != null) {
            String string = this.context.getSessionContext().getConfigMgr().getCookieName();
            return this.inputHelper.getRequestURI(string);
        }
        return this.inputHelper.getRequestURI(null);
    }

    public static String getResolvedURI(HttpServletRequest httpServletRequest) {
        if (httpServletRequest instanceof ServletRequestImpl) {
            return ((ServletRequestImpl)httpServletRequest).inputHelper.getNormalizedURI();
        }
        String string = HttpParsing.unescape((String)httpServletRequest.getRequestURI(), (String)HttpRequestParser.getURIDecodeEncoding()).trim();
        return FilenameEncoder.resolveRelativeURIPath((String)string);
    }

    public static String getResolvedContextPath(HttpServletRequest httpServletRequest) {
        if (httpServletRequest instanceof ServletRequestImpl) {
            return ((ServletRequestImpl)httpServletRequest).getContext().getContextPath();
        }
        String string = HttpParsing.unescape((String)httpServletRequest.getContextPath(), (String)HttpRequestParser.getURIDecodeEncoding()).trim();
        return FilenameEncoder.resolveRelativeURIPath((String)string);
    }

    public String getRealPath(String string) {
        return this.context.getRealPath(string);
    }

    public String getContextPath() {
        String string = null;
        String string2 = (String)this.getAttribute("weblogic.servlet.internal.crosscontext.type");
        if ("include" == string2) {
            string = (String)this.getAttribute("weblogic.servlet.internal.crosscontext.path");
        }
        if (string == null) {
            string = this.context.getContextPath();
        }
        if (string.length() < 2) {
            return "";
        }
        if ("forward" == string2) {
            return string;
        }
        int n = string.length();
        String string3 = this.inputHelper.getOriginalURI();
        int n2 = string3.length();
        String string4 = this.inputHelper.getNormalizedURI();
        if (string3.equals(string4)) {
            return string;
        }
        String string5 = null;
        String string6 = null;
        int n3 = 0;
        int n4 = n2 - n;
        int n5 = (n4 - n3) / 2;
        while (n5 != n3 || n5 != n4) {
            string5 = string3.substring(0, n5 + n);
            string6 = HttpParsing.unescape((String)string5, (String)HttpRequestParser.getURIDecodeEncoding());
            if ((string6 = FilenameEncoder.resolveRelativeURIPath((String)string6, (boolean)true)) == null) break;
            boolean bl = string6.startsWith(string);
            boolean bl2 = string6.endsWith(string);
            if (bl) {
                if (bl2 && string6.length() == string.length()) break;
                n4 = n5;
                n5 = n3 + (n4 - n3) / 2;
                continue;
            }
            if (string5.endsWith("/..")) {
                n5 -= "/..".length();
                continue;
            }
            n3 = n5;
            n5 = n4 - (n4 - n3) / 2;
        }
        Debug.assertion((string5 != null ? 1 : 0) != 0, (String)"Cannot determine encoded context path");
        return string5;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    void setServletPathAndPathInfo(String string, String string2) {
        this.servletPath = string2;
        this.pathInfo = ServletRequestImpl.computePathInfo(string, this.servletPath);
    }

    static String computePathInfo(String string, String string2) {
        int n = string2.length();
        if (n >= string.length()) {
            return null;
        }
        return string.substring(n);
    }

    public String getPathTranslated() {
        if (this.pathInfo != null) {
            return this.getRealPath(this.pathInfo);
        }
        return null;
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string, this.context);
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        this.attributes.put(string, object, this.context);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public Enumeration getAttributeNames() {
        if (this.attributes.isEmpty()) {
            return new EmptyEnumerator();
        }
        return new IteratorEnumerator(this.attributes.keys());
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.length() > 0) {
            int n;
            if (string.charAt(0) != '/') {
                String string3 = this.getRelativeUri();
                int n2 = string3.lastIndexOf(47);
                string = n2 < 1 ? "/" + string : string3.substring(0, n2 + 1) + string;
            }
            if ((n = string.indexOf(63)) > 0 && n < string.length()) {
                string2 = string.substring(n + 1);
                if (string2.equals("")) {
                    string2 = null;
                }
                string = string.substring(0, n);
            }
        }
        if ((string = FilenameEncoder.resolveRelativeURIPath((String)string, (boolean)true)) == null) {
            return null;
        }
        return new RequestDispatcherImpl(string, string2, this.context, -1);
    }

    public String getQueryString() {
        return this.parameters.getQueryString(this.getQueryParamsEncoding());
    }

    String getOriginalQueryString() {
        return this.parameters.getOriginalQueryString(this.getQueryParamsEncoding());
    }

    public String getParameter(String string) {
        return this.parameters.getParameter(string);
    }

    public Enumeration getParameterNames() {
        return this.parameters.getParameterNames();
    }

    public String[] getParameterValues(String string) {
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("Querying multiple: " + string);
        }
        return this.parameters.getParameterValues(string);
    }

    public String getProtocol() {
        return this.inputHelper.getRequestParser().getProtocol();
    }

    public String getServerName() {
        return this.serverName;
    }

    void setServerName(String string) {
        this.serverName = string;
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("Servername: " + string);
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    void setServerPort(int n) {
        this.serverPort = n;
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("Serverport: " + n);
        }
    }

    public String getRemoteUser() {
        String string;
        if (isRemoteUserHeaderAccessible && (string = this.headers.getRemoteUser()) != null) {
            return string;
        }
        string = SecurityModule.getCurrentUser(this.context.getServer(), this);
        if (string == null) {
            return null;
        }
        return SubjectUtils.getUsername((AuthenticatedSubject)string);
    }

    public Map getParameterMap() {
        ArrayMap arrayMap = new ArrayMap();
        Enumeration enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = this.getParameterValues(string);
            arrayMap.put((Object)string, (Object)stringArray);
        }
        return Collections.unmodifiableMap(arrayMap);
    }

    public String getRemoteAddr() {
        String string;
        String string2;
        if (this.context != null && (string2 = this.context.getServer().getClientIpHeader()) != null && (string = this.getHeader(string2)) != null) {
            int n = string.indexOf(44);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            return string;
        }
        return this.connection.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.connection.getRemoteHost();
    }

    public int getRemotePort() {
        return this.connection.getRemotePort();
    }

    public String getLocalAddr() {
        return this.connection.getLocalAddr();
    }

    public String getLocalName() {
        return this.connection.getLocalName();
    }

    public int getLocalPort() {
        return this.connection.getLocalPort();
    }

    public String getAuthType() {
        AuthenticatedSubject authenticatedSubject = SecurityModule.getCurrentUser(this.context.getServer(), this);
        if (authenticatedSubject == null) {
            return null;
        }
        String string = this.headers.getProxyAuthType();
        if (string != null) {
            return string;
        }
        return this.context.getSecurityManager().getWebAppSecurity().getAuthMethod();
    }

    public boolean isSecure() {
        return this.connection.isSecure();
    }

    public boolean isUserInRole(String string) {
        if (string == null) {
            return false;
        }
        AuthenticatedSubject authenticatedSubject = SecurityModule.getCurrentUser(this.context.getServer(), this);
        return this.context.getSecurityManager().getWebAppSecurity().isSubjectInRole(authenticatedSubject, string, this.getSecurityContextHandler(), this.sstub);
    }

    public WebAppContextHandler getSecurityContextHandler() {
        if (this.securityContextHandler == null) {
            this.securityContextHandler = new WebAppContextHandler(this, this.response);
        }
        return this.securityContextHandler;
    }

    public Principal getUserPrincipal() {
        AuthenticatedSubject authenticatedSubject = SecurityModule.getCurrentUser(this.context.getServer(), this);
        if (authenticatedSubject == null) {
            return null;
        }
        return SubjectUtils.getUserPrincipal((AuthenticatedSubject)authenticatedSubject);
    }

    public String getHeader(String string) {
        return this.headers.getHeader(string, this.getInputEncoding());
    }

    public int getIntHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public long getDateHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 != null) {
            DateFormat[] dateFormatArray = ThreadLocalDateFormat.getInstance().getDateFormats();
            long l = CachingDateFormat.parseDate((String)StringUtils.upto((String)string2, (char)';'), (DateFormat[])dateFormatArray);
            if (l != -1L) {
                return l;
            }
            throw new IllegalArgumentException("Bad date header: '" + string2 + "'");
        }
        return -1L;
    }

    public Enumeration getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    public Enumeration getHeaders(String string) {
        return this.headers.getHeaders(string, this.getInputEncoding());
    }

    public Locale getLocale() {
        if (this.locales == null) {
            this.initLocales();
        }
        return this.locales[0];
    }

    public Enumeration getLocales() {
        if (this.locales == null) {
            this.initLocales();
        }
        return new IteratorEnumerator(Arrays.asList((Object[])this.locales).iterator());
    }

    private void initLocales() {
        String string = this.headers.getAcceptLanguages();
        if (string == null || string.trim().length() == 0) {
            this.locales = new Locale[1];
            this.locales[0] = Locale.getDefault();
            return;
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)",");
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringUtils.split((String)stringArray[i], (char)';');
            String string2 = null;
            String string3 = "";
            String string4 = "";
            int n = stringArray2[0].indexOf(45);
            if (n < 0) {
                string2 = stringArray2[0].trim();
            } else {
                string2 = stringArray2[0].substring(0, n).trim();
                string3 = stringArray2[0].substring(n + 1).trim();
                int n2 = string3.indexOf(45);
                if (n2 > 0) {
                    string4 = string3.substring(n2 + 1).trim();
                    string3 = string3.substring(0, n2).trim();
                }
            }
            if (!ServletRequestImpl.isValid(string2) || !ServletRequestImpl.isValid(string3) || !ServletRequestImpl.isValid(string4)) continue;
            Locale locale = new Locale(string2, string3, string4);
            arrayList.add(locale);
        }
        if (arrayList.isEmpty()) {
            this.locales = new Locale[1];
            this.locales[0] = Locale.getDefault();
        } else {
            this.locales = arrayList.toArray(new Locale[arrayList.size()]);
        }
    }

    private static boolean isValid(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public void setInputStream(ServletInputStream servletInputStream) {
        this.inputStream = servletInputStream;
    }

    private ServletInputStreamImpl getServletInputStreamImpl() {
        return (ServletInputStreamImpl)this.inputStream;
    }

    public ServletInputStream getInputStream() {
        if (this.useReader) {
            throw new IllegalStateException("getInputStream() called after getReader() called");
        }
        this.useInputStream = true;
        return this.inputStream;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.useInputStream) {
            throw new IllegalStateException("getReader() called after getInputStream() called");
        }
        this.useReader = true;
        this.initReader();
        return this.bufferedReader;
    }

    private void initReader() throws UnsupportedEncodingException {
        if (this.bufferedReader != null) {
            return;
        }
        this.initRequestEncoding();
        this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.inputStream, this.getInputEncoding()));
    }

    private void initRequestEncoding() throws UnsupportedEncodingException {
        if (this.inputEncodingInitialized) {
            return;
        }
        String string = this.findCharSetFromContentType();
        if (string != null && string.length() != 0) {
            try {
                this.setCharacterEncodingInternal(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string2 = this.context == null ? "" : this.context.getLogContext();
                HTTPLogger.logUnsupportedEncoding((String)string2, (String)string, (Throwable)unsupportedEncodingException);
                throw unsupportedEncodingException;
            }
        }
        this.inputEncodingInitialized = true;
    }

    private String findCharSetFromContentType() {
        String string = this.getContentType();
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.length() - 1;
        int n2 = 0;
        while (n2 <= n && (n2 = string.indexOf(59, n2)) != -1) {
            int n3;
            ++n2;
            while (n2 <= n && HttpParsing.isWS((char)string.charAt(n2))) {
                ++n2;
            }
            if (!string.startsWith("charset", n2) && !string.startsWith("CHARSET", n2) || (n3 = string.indexOf(61, n2 + "charset".length())) == -1 || n3 >= n) continue;
            int n4 = string.indexOf(59, n3);
            String string2 = n4 == -1 ? string.substring(n3 + 1) : string.substring(n3 + 1, n4);
            return HttpParsing.StripHTTPFieldValue((String)string2.trim());
        }
        return null;
    }

    void initInputEncoding() {
        int n;
        String string;
        if (this.context == null) {
            return;
        }
        HashMap hashMap = this.context.getConfigManager().getInputEncodings();
        if (hashMap.isEmpty()) {
            return;
        }
        String string2 = this.getRelativeUri();
        while ((string = (String)hashMap.get(string2)) == null && (n = string2.lastIndexOf(47)) > 0) {
            string2 = string2.substring(0, n);
        }
        if (string == null) {
            string = (String)hashMap.get("");
        }
        if (string == null) {
            return;
        }
        if (this.getInputEncoding().equals(this.context.getConfigManager().getCharsetMap().getJavaCharset(string))) {
            return;
        }
        try {
            this.setCharacterEncoding(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRelativeUri() {
        return this.relativeURI;
    }

    private String computeRelativeUri(String string) {
        if (string == null || this.context == null || this.context.isDefaultContext()) {
            return string;
        }
        int n = this.context.getContextPath().length();
        if (string.length() <= n) {
            return "";
        }
        return string.substring(n);
    }

    void setInputStream(InputStream inputStream) {
        this.inputStream = new ServletInputStreamImpl(inputStream);
    }

    static boolean eq(String string, String string2, int n) {
        return string == string2 || string2.regionMatches(true, 0, string, 0, n);
    }

    public String getScheme() {
        if (this.connection.isSecure()) {
            return "https";
        }
        return "http";
    }

    public Cookie[] getCookies() {
        if (this.cookies == null && !this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    private void parseCookies() {
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("Parsing cookies");
        }
        this.cookiesParsed = true;
        ArrayList arrayList = new ArrayList();
        List list = this.headers.getCookieHeaders();
        for (byte[] byArray : list) {
            String string = BytesToString.newString((byte[])byArray, (String)this.getInputEncoding());
            try {
                Iterators.addAll(arrayList, (Iterator)CookieParser.parseCookies(string));
            }
            catch (MalformedCookieHeaderException malformedCookieHeaderException) {
                HTTPLogger.logBadCookieHeader((String)this.getContext().getLogContext(), (String)malformedCookieHeaderException.getHeader(), (String)this.headers.getUserAgent(), (Throwable)malformedCookieHeaderException);
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        this.cookies = arrayList.toArray(new Cookie[arrayList.size()]);
    }

    public SessionHelper getSessionHelper() {
        return this.sessionHelper;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        HttpSession httpSession = this.sessionHelper.getSession(bl);
        this.checkAndSetDebugSessionFlag(httpSession);
        return httpSession;
    }

    public String getRequestedSessionId() {
        return this.sessionHelper.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.sessionHelper.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.sessionHelper.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.sessionHelper.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdValid() {
        return this.sessionHelper.isRequestedSessionIdValid();
    }

    private void trace(String string) {
        HTTPDebugLogger.debug(this.toStringSimple() + ": " + string);
    }

    private void trace(Exception exception, String string) {
        HTTPDebugLogger.debug(this.toStringSimple() + ": " + string, exception);
    }

    public ServerChannel getServerChannel() {
        return this.connection.getChannel();
    }

    public boolean isAdminChannelRequest() {
        if (this.getConnection().isInternalDispatch()) {
            return ApplicationVersionUtils.getCurrentAdminMode();
        }
        return ChannelHelper.isAdminChannel((ServerChannel)this.getServerChannel());
    }

    private final void checkAndSetDebugSessionFlag(HttpSession httpSession) {
        if (!HttpServer.isProductionModeEnabled() && httpSession != null && httpSession instanceof SessionData && !((SessionData)httpSession).isDebuggingSession() && this.parameters.peekQueryParameter(WL_DEBUG_SESSION) != null) {
            ((SessionData)httpSession).setDebugFlag(true);
        }
    }

    boolean validate(HttpServer httpServer) throws IOException {
        int n;
        if (this.inputHelper.getRequestParser().isProtocolVersion_1_1() && this.headers.getHost() == null) {
            ((MuxableSocketHTTP)this.connection.getSocketRuntime()).sendError(this.response, 400);
            if (HTTPDebugLogger.isEnabled()) {
                this.trace("HOST header was missing from HTTP1.1 request");
            }
            return false;
        }
        if (this.inputHelper.getNormalizedURI() == null) {
            ((MuxableSocketHTTP)this.connection.getSocketRuntime()).sendError(this.response, 404);
            return false;
        }
        if (this.response.getContext() == null) {
            if (HTTPDebugLogger.isEnabled()) {
                Loggable loggable = HTTPLogger.logNoContextLoggable((String)httpServer.toString(), (String)this.inputHelper.getNormalizedURI());
                HTTPDebugLogger.debug(loggable.getMessage());
            }
            ((MuxableSocketHTTP)this.connection.getSocketRuntime()).sendError(this.response, 404);
            return false;
        }
        if (!this.response.getContext().isStarted()) {
            ((MuxableSocketHTTP)this.connection.getSocketRuntime()).sendError(this.response, 503);
            return false;
        }
        int n2 = this.getContentLength();
        if (n2 > 0 && (n = httpServer.getMaxPostSize()) > 0 && n2 > n) {
            HTTPLogger.logPOSTSizeExceeded((int)n);
            ((MuxableSocketHTTP)this.connection.getSocketRuntime()).sendError(this.response, 413);
            return false;
        }
        return true;
    }

    void setCheckIndexFile(boolean bl) {
        this.checkIndexFile = bl;
    }

    public static ServletRequestImpl getOriginalRequest(ServletRequest servletRequest) {
        if (servletRequest == null) {
            return null;
        }
        while (servletRequest instanceof ServletRequestWrapper) {
            servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
        }
        if (servletRequest == null) {
            throw new AssertionError((Object)"Original request not available");
        }
        return (ServletRequestImpl)servletRequest;
    }

    public VirtualConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block27: {
            block26: {
                bl = _WLDF$INST_FLD_Servlet_Request_Run_Around_Medium.isEnabledAndNotDyeFiltered();
                diagnosticActionArray = null;
                diagnosticActionStateArray = null;
                Object var10_4 = null;
                if (bl) {
                    Object[] objectArray = null;
                    if (_WLDF$INST_FLD_Servlet_Request_Run_Around_Medium.isArgumentsCaptureNeeded()) {
                        objectArray = new Object[]{this};
                    }
                    DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                    DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_Request_Run_Around_Medium;
                    diagnosticActionArray = delegatingMonitor.getActions();
                    diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                    InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                }
                try {
                    WebAppServletContext webAppServletContext = this.context;
                    if (this.dispatchDueToRemoteSessionFetching()) {
                        Object var8_9 = null;
                        if (!bl) return;
                        break block26;
                    }
                    try {
                        this.underExecution = true;
                        if (ServerHelper.useExtendedSessionFormat()) {
                            weblogic.rmi.extensions.server.ServerHelper.setServerChannel((ServerChannel)this.connection.getChannel());
                        }
                        if (this.context.getVersionId() != null && this.dispatchVersion()) {
                        }
                        MethodInvocationHelper.pushMethodObject(null);
                        this.context.getSecurityManager().getWebAppSecurity().initContextHandler(this);
                        try {
                            if (!this.context.getServer().getMBean().isKeepAliveEnabled()) {
                                this.response.disableKeepAlive();
                            }
                            this.initServerNameAndPort();
                            this.connection.initCerts();
                            if (this.checkIndexFile) {
                                ServletStubImpl servletStubImpl = this.context.getIndexServletStub(this.getRelativeUri(), this, (ServletRequest)this);
                                if (servletStubImpl != null) {
                                    this.setServletStub(servletStubImpl);
                                }
                                this.checkIndexFile = false;
                            }
                            if (this.performOverloadAction) {
                                this.sendOverLoadResponse(webAppServletContext);
                                break block27;
                            } else {
                                this.context.execute(this, this.response);
                            }
                            break block27;
                        }
                        finally {
                            MethodInvocationHelper.popMethodObject(null);
                            webAppServletContext.getSecurityManager().getWebAppSecurity().resetContextHandler();
                            if (!this.isFutureResponseEnabled() && !this.performOverloadAction) {
                                this.response.send();
                            }
                            this.performOverloadAction = false;
                        }
                    }
                    catch (SocketException socketException) {
                        if (HTTPDebugLogger.isEnabled()) {
                            HTTPLogger.logServletFailed((String)webAppServletContext.getLogContext(), (Throwable)socketException);
                        }
                        break block27;
                    }
                    catch (IOException iOException) {
                        HTTPLogger.logServletFailed((String)webAppServletContext.getLogContext(), (Throwable)iOException);
                        break block27;
                    }
                    finally {
                        if (ServerHelper.useExtendedSessionFormat()) {
                            weblogic.rmi.extensions.server.ServerHelper.setServerChannel(null);
                        }
                        this.underExecution = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    if (!bl) throw throwable;
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Run_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
                    throw throwable;
                }
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Run_Around_Medium, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
            return;
        }
        Object var8_11 = null;
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Run_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOverLoadResponse(WebAppServletContext webAppServletContext) throws IOException {
        this.setAttribute("javax.servlet.error.message", this.overloadRejectionMessage);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(webAppServletContext.getServletClassLoader());
            this.response.sendError(this.context.getServer().getMBean().getOverloadResponseCode());
        }
        finally {
            this.context.getServer().getLogManager().log(this, this.response);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public Runnable overloadAction(String string) {
        if (this.context.isInternalApp() || this.isAdminChannelRequest()) {
            return null;
        }
        this.performOverloadAction = true;
        this.overloadRejectionMessage = string;
        return this;
    }

    public Runnable cancel(String string) {
        if (this.underExecution) {
            return null;
        }
        return this.overloadAction(string);
    }

    protected AuthenticatedSubject getAuthenticatedSubject() {
        SessionContext sessionContext = this.context.getSessionContext();
        SessionInternal sessionInternal = this.sessionHelper.getSessionOnThisServer(sessionContext);
        if (sessionInternal == null) {
            String string = this.sessionHelper.getRequestedSessionId(false);
            if (string == null) {
                return null;
            }
            return this.context.getServer().getSessionLogin().getUser(RSID.getID(string));
        }
        return SecurityModule.getCurrentUser(this.context.getServer(), this, sessionInternal);
    }

    public void send100ContinueResponse() throws IOException {
        OutputStream outputStream = this.getConnection().getSocket().getOutputStream();
        outputStream.write(HttpConstants.SC_CONTINUE_RESPONSE, 0, HttpConstants.SC_CONTINUE_RESPONSE.length);
    }

    private void reInitContextIfNeeded(SessionInternal sessionInternal) {
        if (this.context == null || this.context.getVersionId() != null && !this.context.getVersionId().equals(sessionInternal.getVersionId())) {
            WebAppServletContext webAppServletContext = (WebAppServletContext)((HttpSession)sessionInternal).getServletContext();
            if (HTTPDebugLogger.isEnabled()) {
                this.trace("reInitContext from session for session=" + this.sessionHelper.getSessionID() + ", old version=" + this.context.getVersionId() + ", new ctx=" + webAppServletContext);
            }
            this.initContext(webAppServletContext);
            this.response.initContext(webAppServletContext);
        }
    }

    private boolean dispatchDueToRemoteSessionFetching() {
        if (this.preventRedispatch) {
            return false;
        }
        WorkManager workManager = this.getServletStub().getWorkManagerForSessionFetching();
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("[RemoteSessionFetching] obtained workManager: " + workManager);
        }
        if (workManager == null) {
            return false;
        }
        SessionContext sessionContext = this.context.getSessionContext();
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("[RemoteSessionFetching] obtained session context: " + sessionContext);
        }
        if (!(sessionContext instanceof ReplicatedSessionContext)) {
            return false;
        }
        String string = this.sessionHelper.getRequestedSessionId(false);
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("[RemoteSessionFetching] obtained sessionId: " + string);
        }
        if (((ReplicatedSessionContext)sessionContext).isPrimaryOrSecondary(string)) {
            if (HTTPDebugLogger.isEnabled()) {
                this.trace("[RemoteSessionFetching] session is primary or secondary !");
            }
            return false;
        }
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("[RemoteSessionFetching] obtained sessionFetchingWorkManager and dispatching to " + workManager);
        }
        this.preventRedispatch = true;
        workManager.schedule((Runnable)((Object)this));
        return true;
    }

    private boolean dispatchVersion() throws IOException {
        WebAppServletContext webAppServletContext = this.getContext();
        WebAppServletContext webAppServletContext2 = this.findVersionedContext();
        if (webAppServletContext2 == null || webAppServletContext2 == webAppServletContext) {
            if (HTTPDebugLogger.isEnabled()) {
                this.trace("dispatch request to " + webAppServletContext);
            }
            return false;
        }
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("re-dispatch request to " + webAppServletContext2);
        }
        this.initContext(webAppServletContext2);
        this.response.initContext(webAppServletContext2);
        MuxableSocketHTTP muxableSocketHTTP = (MuxableSocketHTTP)this.connection.getSocketRuntime();
        if (muxableSocketHTTP != null && muxableSocketHTTP.initAndValidateRequest(webAppServletContext2)) {
            WorkManager workManager = this.getServletStub().getWorkManager();
            if (workManager == null) {
                throw new AssertionError((Object)("Could not determine WorkManager for : " + (Object)((Object)this)));
            }
            workManager.schedule((Runnable)((Object)this));
        }
        return true;
    }

    private WebAppServletContext findVersionedContext() {
        WebAppServletContext webAppServletContext = this.getContext();
        if (this.contextManager == null) {
            return webAppServletContext;
        }
        String string = this.sessionHelper.getRequestedSessionId(false);
        if (string == null) {
            return webAppServletContext;
        }
        WebAppServletContext webAppServletContext2 = this.contextManager.getContextForSession(string);
        if (webAppServletContext2 == null) {
            if (HTTPDebugLogger.isEnabled()) {
                this.trace("Finding Versioned ServletContext with Application Version Info for SessionID : " + string);
            }
            String string2 = null;
            try {
                string2 = webAppServletContext.getSessionContext().lookupAppVersionIdForSession(string, this, this.response);
            }
            catch (Throwable throwable) {
                HTTPLogger.logErrorWithThrowable((String)webAppServletContext.getLogContext(), (String)"Error Fetching Version Infomation for Application Version ", (Throwable)throwable);
            }
            if (string2 == null) {
                boolean bl = this.isAdminChannelRequest();
                Iterator iterator = this.contextManager.getServletContexts(bl);
                while (string2 == null && iterator.hasNext()) {
                    WebAppServletContext webAppServletContext3 = (WebAppServletContext)iterator.next();
                    if (webAppServletContext3 == null || webAppServletContext3 == webAppServletContext) continue;
                    try {
                        string2 = webAppServletContext3.getSessionContext().lookupAppVersionIdForSession(string, this, this.getResponse());
                    }
                    catch (Throwable throwable) {
                        HTTPLogger.logErrorWithThrowable((String)webAppServletContext3.getLogContext(), (String)"Error Fetching Version Infomation for Application Version ", (Throwable)throwable);
                    }
                }
            }
            if (string2 != null) {
                webAppServletContext2 = this.contextManager.getContext(string2);
            }
        }
        return webAppServletContext2 == null ? webAppServletContext : webAppServletContext2;
    }

    HttpServletRequest copy() {
        Object object;
        if (this.sessionHelper.isClone) {
            throw new IllegalStateException("Cannot clone a request from a cloned request.");
        }
        ServletRequestImpl servletRequestImpl = new ServletRequestImpl((MuxableSocketHTTP)this.connection.getSocketRuntime(), this.sessionHelper);
        servletRequestImpl.initFromRequestParser(this.getInputHelper().getRequestParser());
        if (this.getAttribute("javax.servlet.forward.request_uri") != null) {
            object = this.getRequestURI();
            servletRequestImpl.initFromRequestURI((String)object);
        }
        servletRequestImpl.setResponse(this.getResponse());
        if (this.contextManager != null && this.contextManager.isVersioned()) {
            servletRequestImpl.initContextManager(this.contextManager);
        } else {
            servletRequestImpl.initContext(this.context);
        }
        if (this.inputEncoding != null) {
            try {
                servletRequestImpl.setCharacterEncoding(this.inputEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        servletRequestImpl.initLocales();
        servletRequestImpl.setInputStream(this.inputStream);
        servletRequestImpl.setServletStub(this.getServletStub());
        servletRequestImpl.useInputStream = this.useInputStream;
        servletRequestImpl.useReader = this.useReader;
        servletRequestImpl.setServerName(this.serverName);
        servletRequestImpl.setServerPort(this.serverPort);
        servletRequestImpl.servletPath = this.servletPath;
        servletRequestImpl.pathInfo = this.pathInfo;
        servletRequestImpl.setCheckIndexFile(this.checkIndexFile);
        if (this.getSendRedirect()) {
            servletRequestImpl.setRedirectURI(this.redirectLocation);
        }
        this.parameters.parseQueryParams(true);
        servletRequestImpl.parameters.setQueryParams(this.parameters.getQueryParams());
        servletRequestImpl.parameters.setExtraQueryParams(this.parameters.getExtraQueryParams());
        object = this.attributes.keys();
        while (object.hasNext()) {
            String string = (String)object.next();
            servletRequestImpl.attributes.put(string, this.attributes.get(string, this.context));
        }
        return servletRequestImpl;
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.servlet.internal.ServletRequestImpl");
        _WLDF$INST_FLD_Servlet_Request_Run_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_Request_Run_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ServletRequestImpl.java", (String)"weblogic.servlet.internal.ServletRequestImpl", (String)"run", (String)"()V", (int)1457, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_Request_Run_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"req", (String)"weblogic.diagnostics.instrumentation.gathering.ServletRequestRenderer", (boolean)false, (boolean)true), null, null)}), (boolean)false);
        isWLProxyHeadersAccessible = Boolean.getBoolean("weblogic.http.isWLProxyHeadersAccessible");
        isRemoteUserHeaderAccessible = Boolean.getBoolean("weblogic.http.enableRemoteUserHeader");
    }

    public static final class SessionHelper {
        private final ServletRequestImpl request;
        private HttpSession session;
        private final Map allSessions;
        private boolean sessionInitialized;
        private boolean fromCookie;
        private boolean fromURL;
        private boolean sessionExistanceChecked;
        private String sessionID;
        private String requestedSessionID;
        private String encodedSessionID;
        private final HashMap sessionIds;
        private final boolean isClone;

        private SessionHelper(ServletRequestImpl servletRequestImpl, SessionHelper sessionHelper) {
            this.request = servletRequestImpl;
            if (sessionHelper != null) {
                this.allSessions = sessionHelper.allSessions;
                this.sessionIds = sessionHelper.sessionIds;
                this.isClone = true;
            } else {
                this.allSessions = new HashMap();
                this.sessionIds = new HashMap();
                this.isClone = false;
            }
        }

        private void reset() {
            this.sessionInitialized = false;
            this.sessionExistanceChecked = false;
            this.fromCookie = false;
            this.fromURL = false;
            this.sessionIds.clear();
            this.session = null;
            this.allSessions.clear();
            this.encodedSessionID = null;
            this.sessionID = null;
            this.requestedSessionID = null;
        }

        private String getSessionIDFromMap(String string, String string2) {
            return (String)this.sessionIds.get(new CookieKey(string, string2));
        }

        void rememberSessionID(String string, String string2, String string3) {
            this.sessionIds.put(new CookieKey(string, string2), string3);
        }

        void setSession(HttpSession httpSession) {
            this.session = httpSession;
            this.sessionInitialized = true;
        }

        public String getEncodedSessionID() {
            return this.encodedSessionID;
        }

        boolean getSessionExistanceChecked() {
            return this.sessionExistanceChecked;
        }

        void setSessionExistanceChecked(boolean bl) {
            this.sessionExistanceChecked = bl;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpSession getSession(boolean bl) {
            if (!this.isClone) {
                return this.getSessionInternal(bl);
            }
            Map map = this.allSessions;
            synchronized (map) {
                return this.getSessionInternal(bl);
            }
        }

        private HttpSession getSessionInternal(boolean bl) {
            if (!this.sessionInitialized) {
                this.initSessionInfo();
            }
            if (this.session != null) {
                if (((SessionInternal)this.session).isValid()) {
                    return this.session;
                }
                this.session = null;
            }
            this.session = (HttpSession)this.allSessions.get(this.request.getContext().getContextPath());
            if (this.session != null) {
                if (((SessionInternal)this.session).isValid()) {
                    return this.session;
                }
                this.allSessions.remove(this.request.getContext().getContextPath());
                this.session = null;
            }
            if (!bl && this.sessionExistanceChecked) {
                return null;
            }
            this.sessionExistanceChecked = true;
            String string = this.getSessionIDFromMap(this.request.getContext().getSessionContext().getConfigMgr().getCookieName(), this.request.getContext().getSessionContext().getConfigMgr().getCookiePath());
            if (string == null) {
                string = this.requestedSessionID;
            }
            if (string == null) {
                if (!bl) {
                    return null;
                }
                this.getNewSession(null);
            } else {
                this.session = this.getValidSession(string);
                if (this.session == null) {
                    if (!bl) {
                        return null;
                    }
                    this.getNewSession(string);
                    if (this.session == null) {
                        return null;
                    }
                }
                if (this.sessionID.length() != this.request.getContext().getSessionContext().getConfigMgr().getIDLength()) {
                    this.updateSessionId();
                }
            }
            this.storeSessionInAllSessions(this.request.getContext().getContextPath(), this.session);
            return this.session;
        }

        public void killOldSession() {
            Object object2;
            for (Object object2 : this.allSessions.values()) {
                if (!((SessionInternal)object2).isValid()) continue;
                object2.invalidate();
            }
            object2 = this.request.getContext().getSessionContext().getConfigMgr().getCookieName();
            String string = this.request.getContext().getSessionContext().getConfigMgr().getCookiePath();
            this.invalidateCookie((String)object2, string);
            if (this.request.getContext().getServer().isAuthCookieEnabled()) {
                this.invalidateCookie(SecurityModule.getWLSAuthCookieName((SessionInternal)this.session), string);
            }
            this.allSessions.clear();
            this.session = null;
            this.sessionID = null;
            this.requestedSessionID = null;
        }

        void invalidateCookie(String string, String string2) {
            Cookie cookie = this.request.getResponse().getCookie(string);
            if (cookie != null) {
                cookie.setValue("");
                cookie.setMaxAge(0);
            } else {
                cookie = new Cookie(string, "");
                cookie.setValue("");
                cookie.setMaxAge(0);
                String string3 = this.request.getContext().getSessionContext().getConfigMgr().getCookieDomain();
                if (string3 != null) {
                    cookie.setDomain(string3);
                }
                cookie.setPath(string2);
                if (this.request.getContext().getSessionContext().getConfigMgr().isCookieSecure()) {
                    cookie.setSecure(true);
                }
                this.request.getResponse().addCookie(cookie);
            }
        }

        String getIncomingSessionCookieValue() {
            return this.requestedSessionID;
        }

        public String getRequestedSessionId() {
            return this.getRequestedSessionId(true);
        }

        private String getRequestedSessionId(boolean bl) {
            block5: {
                if (!this.sessionInitialized) {
                    this.initSessionInfo();
                }
                if (this.requestedSessionID != null && bl) {
                    HttpSession httpSession = this.getSession(false);
                    try {
                        if (httpSession != null && !httpSession.isNew()) {
                            return httpSession.getId();
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        SessionInternal sessionInternal = (SessionInternal)httpSession;
                        if (!sessionInternal.isValid()) break block5;
                        throw illegalStateException;
                    }
                }
            }
            return this.requestedSessionID;
        }

        String getSessionID() {
            return this.sessionID;
        }

        public boolean isRequestedSessionIdFromCookie() {
            if (!this.sessionInitialized) {
                this.initSessionInfo();
            }
            return this.fromCookie;
        }

        public boolean isRequestedSessionIdFromURL() {
            if (!this.sessionInitialized) {
                this.initSessionInfo();
            }
            return this.fromURL;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdValid() {
            SessionInternal sessionInternal;
            if (this.requestedSessionID == null) {
                return false;
            }
            if (!this.sessionInitialized) {
                this.initSessionInfo();
            }
            if ((sessionInternal = (SessionInternal)this.getSession(false)) == null) {
                return false;
            }
            String string = RSID.getID(this.requestedSessionID);
            String string2 = sessionInternal.getInternalId();
            return string.equals(string2);
        }

        private boolean getSessionIdFromCookieHeaders(String string) {
            List list = this.request.getRequestHeaders().getCookieHeaders();
            if (list.size() == 0) {
                return false;
            }
            int n = string.length();
            byte by = (byte)string.charAt(0);
            for (int i = list.size() - 1; i > -1; --i) {
                byte[] byArray = (byte[])list.get(i);
                int n2 = byArray.length;
                int n3 = n2 - n;
                for (int j = 0; j < n3; ++j) {
                    if (byArray[j] == by) {
                        int n4;
                        for (n4 = 1; n4 < n && byArray[j + n4] == (byte)string.charAt(n4); ++n4) {
                        }
                        if (n4 < n || byArray[j + n4] != 61) continue;
                        j += n4;
                        boolean bl = false;
                        while (j < n2 && byArray[j] == 32) {
                            ++j;
                        }
                        while (j < n2 && byArray[j] == 61) {
                            ++j;
                        }
                        while (j < n2 && byArray[j] == 32) {
                            ++j;
                        }
                        while (j < n2 && byArray[j] == 34) {
                            ++j;
                        }
                        n4 = 0;
                        while (j + n4 < n2) {
                            byte by2 = byArray[j + n4];
                            if (by2 == 59 || by2 == 44 || by2 == 34) {
                                bl = true;
                                break;
                            }
                            ++n4;
                        }
                        this.requestedSessionID = bl ? StringUtils.getString((byte[])byArray, (int)j, (int)n4) : StringUtils.getString((byte[])byArray, (int)j, (int)(n2 - j));
                        return true;
                    }
                    if (byArray[j] == 32) continue;
                    while (j < n3 && byArray[j] != 59 && byArray[j] != 44) {
                        ++j;
                    }
                }
            }
            return false;
        }

        private void initSessionInfo() {
            if (this.sessionInitialized) {
                return;
            }
            WebAppServletContext webAppServletContext = this.request.getContext();
            if (webAppServletContext != null) {
                this.initSessionInfoWithContext(webAppServletContext);
            } else {
                boolean bl = this.request.isAdminChannelRequest();
                WebAppServletContext webAppServletContext2 = this.request.contextManager.getActiveContext(bl);
                if (webAppServletContext2 != null && webAppServletContext2.getVersionId() == null) {
                    this.initSessionInfoWithContext(webAppServletContext2);
                } else {
                    Object object;
                    WebAppServletContext webAppServletContext3 = null;
                    if (webAppServletContext2 == null || !this.initSessionInfoWithContext(webAppServletContext2)) {
                        object = this.request.contextManager.getServletContexts(bl);
                        while (object.hasNext()) {
                            WebAppServletContext webAppServletContext4 = (WebAppServletContext)object.next();
                            if (webAppServletContext4 == webAppServletContext2 || !this.initSessionInfoWithContext(webAppServletContext4)) continue;
                            webAppServletContext3 = webAppServletContext4;
                            break;
                        }
                    }
                    if (this.sessionID != null) {
                        object = this.request.contextManager.getContextForSession(this.sessionID);
                        this.request.initContext((WebAppServletContext)object);
                        if (HTTPDebugLogger.isEnabled() && object != null) {
                            this.request.trace("initContext from ctxManager lookup for sessionID=" + this.requestedSessionID + ", context=" + object);
                        }
                    }
                    if (this.request.context == null) {
                        if (webAppServletContext2 != null) {
                            this.request.initContext(webAppServletContext2);
                            if (HTTPDebugLogger.isEnabled()) {
                                this.request.trace("initContext with active context=" + webAppServletContext2);
                            }
                        } else {
                            this.request.initContext(webAppServletContext3);
                            if (HTTPDebugLogger.isEnabled()) {
                                this.request.trace("initContext with sessionId context=" + webAppServletContext3);
                            }
                        }
                    }
                }
            }
            this.sessionInitialized = true;
        }

        private boolean initSessionInfoWithContext(WebAppServletContext webAppServletContext) {
            if (!webAppServletContext.getSessionContext().getConfigMgr().isSessionTrackingEnabled()) {
                return false;
            }
            String string = webAppServletContext.getSessionContext().getConfigMgr().getCookieName();
            if (string == null) {
                if (HTTPDebugLogger.isEnabled()) {
                    this.request.trace("session-cookie-name is set to null");
                }
                return false;
            }
            if (webAppServletContext.getSessionContext().getConfigMgr().isSessionCookiesEnabled()) {
                if (this.request.cookiesParsed) {
                    this.getSessionIdFromParsedCookies(string);
                } else if (this.getSessionIdFromCookieHeaders(string)) {
                    if (HTTPDebugLogger.isEnabled()) {
                        this.request.trace("SessionID: " + this.requestedSessionID + " found in cookie header");
                    }
                    this.fromCookie = true;
                }
            }
            if (this.requestedSessionID == null && this.isUrlRewritingEnabled(webAppServletContext)) {
                this.getSessionIdFromEncodedURL(string);
                if (this.requestedSessionID == null) {
                    this.getSessionIdFromQueryParams(string);
                }
                if (this.requestedSessionID == null) {
                    this.getSessionIdFromPostData(string);
                }
            }
            if (this.requestedSessionID != null) {
                this.sessionID = RSID.getID(this.requestedSessionID);
                if (HTTPDebugLogger.isEnabled()) {
                    this.request.trace("SessionID= " + this.sessionID + " found for WASC=" + webAppServletContext);
                }
            } else if (HTTPDebugLogger.isEnabled()) {
                this.request.trace("SessionID not found for WASC=" + webAppServletContext);
            }
            return this.requestedSessionID != null;
        }

        private boolean isUrlRewritingEnabled(WebAppServletContext webAppServletContext) {
            return webAppServletContext.getSessionContext().getConfigMgr().isUrlRewritingEnabled();
        }

        private void getSessionIdFromQueryParams(String string) {
            this.requestedSessionID = this.request.getRequestParameters().peekQueryParameter(string);
            if (this.requestedSessionID != null) {
                if (HTTPDebugLogger.isEnabled()) {
                    this.request.trace("SessionID: " + this.requestedSessionID + " found in query params or URL");
                }
                this.fromURL = true;
            }
        }

        private void getSessionIdFromEncodedURL(String string) {
            String string2 = this.request.getInputHelper().getPathParameters();
            if (string2 == null) {
                return;
            }
            int n = string2.toLowerCase().indexOf(";" + string.toLowerCase() + "=");
            if (n < 0) {
                return;
            }
            this.encodedSessionID = string2.substring(n + string.length() + 2);
            n = this.encodedSessionID.indexOf(59);
            if (n != -1) {
                this.encodedSessionID = this.encodedSessionID.substring(0, n);
            }
            this.requestedSessionID = this.encodedSessionID;
            if (HTTPDebugLogger.isEnabled()) {
                this.request.trace("SessionID: " + this.requestedSessionID + " found encoded with the URL");
            }
            this.fromURL = true;
        }

        private void getSessionIdFromParsedCookies(String string) {
            Cookie[] cookieArray = this.request.getCookies();
            if (cookieArray == null) {
                return;
            }
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equalsIgnoreCase(cookieArray[i].getName())) continue;
                this.requestedSessionID = cookieArray[i].getValue();
                if (HTTPDebugLogger.isEnabled()) {
                    this.request.trace("SessionID: " + this.requestedSessionID + " found in cookie");
                }
                this.fromCookie = true;
                break;
            }
        }

        private void getSessionIdFromPostData(String string) {
            this.requestedSessionID = this.request.getRequestParameters().peekPostParameter(string);
            if (this.requestedSessionID != null) {
                if (HTTPDebugLogger.isEnabled()) {
                    this.request.trace("SessionID: " + this.requestedSessionID + " found in post data");
                }
                this.fromURL = true;
            }
        }

        void syncSession() {
            if (this.request.getContext() != null) {
                this.request.getContext().getServer().getWorkContextManager().copyThreadContexts(this.request.getContext(), this.request);
            }
            for (HttpSession httpSession : this.allSessions.values()) {
                this.syncSession(httpSession, this.request.getHttpAccountingInfo().getInvokeTime());
            }
            this.session = null;
            this.allSessions.clear();
            this.sessionInitialized = false;
        }

        private void syncSession(HttpSession httpSession, long l) {
            block6: {
                SessionInternal sessionInternal;
                if (httpSession instanceof SharedSessionData) {
                    httpSession = ((SharedSessionData)httpSession).getSession();
                }
                if (!(sessionInternal = (SessionInternal)httpSession).isValid()) {
                    return;
                }
                SessionContext sessionContext = sessionInternal.getContext();
                if (!sessionContext.getConfigMgr().isSessionTrackingEnabled()) {
                    httpSession.invalidate();
                    return;
                }
                try {
                    if (httpSession.isNew() || sessionInternal.getLAT() < l) {
                        sessionInternal.setLastAccessedTime(l);
                    }
                    sessionInternal.setNew(false);
                    sessionContext.sync(httpSession);
                }
                catch (IllegalStateException illegalStateException) {
                    if (!sessionInternal.isValid()) break block6;
                    throw illegalStateException;
                }
            }
        }

        private void getNewSession(String string) {
            if (HTTPDebugLogger.isEnabled()) {
                this.request.trace("Creating new session");
            }
            this.session = this.request.getContext().getSessionContext().getNewSession(string, this.request, this.request.getResponse());
            if (this.session == null) {
                this.sessionID = null;
                HTTPLogger.logSessionCreateError((String)this.request.getContext().getLogContext());
            } else {
                this.sessionID = ((SessionInternal)this.session).getInternalId();
                if (HTTPDebugLogger.isEnabled()) {
                    this.request.trace("New Session: " + this.sessionID);
                }
                this.request.getResponse().setSessionCookie(this.session);
                this.request.getContext().getServer().getSessionLogin().register(((SessionInternal)this.session).getInternalId(), this.request.getContext().getContextPath());
            }
        }

        private HttpSession getValidSession(String string) {
            SessionData sessionData;
            if (string == null || string.length() < 1) {
                return null;
            }
            if (HTTPDebugLogger.isEnabled()) {
                this.request.trace("Trying to find session: " + string);
            }
            try {
                sessionData = this.request.getContext().getSessionContext().getSessionInternal(string, this.request, this.request.getResponse());
            }
            catch (IllegalStateException illegalStateException) {
                if (HTTPDebugLogger.isEnabled()) {
                    this.request.trace(illegalStateException, "Exception finding session for id: " + string);
                }
                sessionData = null;
            }
            if (sessionData == null) {
                if (HTTPDebugLogger.isEnabled()) {
                    this.request.trace("Trying other contexts to find valid session for id: " + string);
                }
                sessionData = this.request.getContext().getSessionContext().getSessionFromOtherContexts(string, this.request, this.request.getResponse());
            }
            if (sessionData == null) {
                sessionData = this.request.getContext().getSessionContext().getSharedSession(string, this.request, this.request.getResponse());
            }
            if (sessionData == null) {
                if (HTTPDebugLogger.isEnabled()) {
                    this.request.trace("Couldn't find valid session for id: " + string);
                }
                return null;
            }
            this.request.reInitContextIfNeeded(sessionData);
            this.request.getResponse().setSessionCookie(sessionData);
            return sessionData;
        }

        void resetSession(boolean bl) {
            this.session = null;
            if (bl) {
                this.sessionInitialized = false;
            }
            this.sessionExistanceChecked = false;
        }

        public void updateSessionId() {
            SessionData sessionData = null;
            HttpSession httpSession = this.session;
            String string = this.sessionID;
            this.getNewSession(null);
            WebAppServletContext[] webAppServletContextArray = this.request.getContext().getServer().getServletContextManager().getAllContexts();
            boolean bl = false;
            SessionContext sessionContext = ((SessionInternal)httpSession).getContext();
            if (sessionContext != null) {
                bl = sessionContext.getConfigMgr().isSessionSharingEnabled();
            }
            for (int i = 0; i < webAppServletContextArray.length; ++i) {
                Object object;
                HttpSession httpSession2;
                SessionContext sessionContext2 = webAppServletContextArray[i].getSessionContext();
                if (sessionContext2 == null || this.request.context != webAppServletContextArray[i] && bl && this.request.context.getApplicationContext() == webAppServletContextArray[i].getApplicationContext() || this.request.context != webAppServletContextArray[i] && (sessionData = sessionContext2.getSessionInternal(string, null, null)) == null) continue;
                if (this.request.context == webAppServletContextArray[i]) {
                    httpSession2 = this.session;
                    sessionData = httpSession;
                } else {
                    httpSession2 = sessionContext2.getNewSession(this.sessionID, this.request, this.request.getResponse());
                    webAppServletContextArray[i].getServer().getSessionLogin().register(((SessionInternal)httpSession2).getInternalId(), webAppServletContextArray[i].getContextPath());
                }
                httpSession2.setMaxInactiveInterval(sessionData.getMaxInactiveInterval());
                Enumeration enumeration = sessionData.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    ((SessionInternal)httpSession2).setAttribute((String)object, sessionData.getAttribute((String)object), false);
                }
                object = ((SessionInternal)sessionData).getInternalAttributeNames();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    ((SessionInternal)httpSession2).setInternalAttribute(string2, ((SessionInternal)sessionData).getInternalAttribute(string2));
                }
                this.storeSessionInAllSessions(webAppServletContextArray[i].getContextPath(), httpSession2);
                ((SessionInternal)sessionData).invalidate(false);
            }
        }

        SessionInternal getSessionOnThisServer(SessionContext sessionContext) {
            String string = this.getSessionIDFromMap(sessionContext.getConfigMgr().getCookieName(), sessionContext.getConfigMgr().getCookiePath());
            if (string == null) {
                string = this.requestedSessionID;
            }
            if (string == null) {
                return null;
            }
            return sessionContext.getSessionInternal(string, null, null);
        }

        private void storeSessionInAllSessions(String string, HttpSession httpSession) {
            if (httpSession == null) {
                this.allSessions.remove(string);
            } else {
                this.allSessions.put(string, httpSession);
            }
        }
    }

    public static final class RequestInputHelper {
        private HttpRequestParser parser = new HttpRequestParser();
        private String originalURI;
        private String normalizedURI;
        private String pathParameters;
        private boolean pathParamsParsed;

        private void reset() {
            this.normalizedURI = null;
            this.pathParamsParsed = false;
            this.pathParameters = null;
            this.originalURI = null;
            this.parser.reset();
        }

        void restore() {
            this.originalURI = this.parser.getRequestURI();
            this.pathParameters = this.parser.getPathParameters();
            this.pathParamsParsed = false;
            this.normalizedURI = this.parser.getNormalizedURI();
        }

        void initFromRequestParser(HttpRequestParser httpRequestParser, RequestParameters requestParameters) {
            this.parser = httpRequestParser;
            this.originalURI = this.parser.getRequestURI();
            this.pathParameters = this.parser.getPathParameters();
            this.pathParamsParsed = false;
            this.normalizedURI = this.parser.getNormalizedURI();
            RequestParameters.access$2002(requestParameters, this.parser.getHttpRequestBuffer());
            requestParameters.queryStringStart = this.parser.getQeuryStringStart();
            requestParameters.queryStringLength = this.parser.getQueryStringLength();
        }

        void initFromRequestURI(String string) {
            int n;
            assert (string.indexOf("://") == -1) : "passed in uri should not have scheme";
            assert (string.indexOf(63) == -1) : "passed in uri should not have request parameter";
            if (string.length() == 0) {
                string = "/";
            }
            if ((n = string.indexOf(59)) > 0) {
                this.originalURI = string.substring(0, n);
                this.pathParameters = string.substring(n);
                this.pathParamsParsed = false;
            } else {
                this.originalURI = string;
            }
            this.normalizedURI = HttpParsing.unescape((String)this.originalURI, (String)HttpRequestParser.getURIDecodeEncoding());
            this.normalizedURI = FilenameEncoder.resolveRelativeURIPath((String)this.normalizedURI, (boolean)true);
            if (this.normalizedURI == null) {
                throw new IllegalArgumentException("Unsafe path for the incoming request");
            }
        }

        public HttpRequestParser getRequestParser() {
            return this.parser;
        }

        public String getRequestURI(String string) {
            if (this.pathParameters != null && !this.pathParamsParsed) {
                if (string != null) {
                    int n = this.pathParameters.toLowerCase().indexOf(";" + string.toLowerCase() + "=");
                    if (n != -1) {
                        this.originalURI = this.originalURI + this.pathParameters.substring(0, n);
                        String string2 = this.pathParameters.substring(n + 1);
                        if ((n = string2.indexOf(59)) != -1) {
                            this.originalURI = this.originalURI + string2.substring(n);
                        }
                    } else {
                        this.originalURI = this.originalURI + this.pathParameters;
                    }
                } else {
                    this.originalURI = this.originalURI + this.pathParameters;
                }
                this.pathParamsParsed = true;
            }
            return this.originalURI;
        }

        public String getNormalizedURI() {
            return this.normalizedURI;
        }

        private String getOriginalURI() {
            return this.originalURI;
        }

        public String getPathParameters() {
            return this.pathParameters;
        }
    }

    public static final class RequestParameters {
        private final ServletRequestImpl request;
        private byte[] postData;
        private boolean postDataRead;
        private boolean postParamsParsed;
        private boolean queryParamsParsed;
        private final QueryParams queryParameters = new QueryParams();
        private List extraParameters = new ArrayList();
        private byte[] queryStringBuffer = null;
        private int queryStringStart = -1;
        private int queryStringLength = -1;

        public RequestParameters(ServletRequestImpl servletRequestImpl) {
            this.request = servletRequestImpl;
        }

        public void reset() {
            this.postParamsParsed = false;
            this.queryParamsParsed = false;
            this.postDataRead = false;
            this.postData = null;
            this.queryStringBuffer = null;
            this.queryStringStart = -1;
            this.queryStringLength = -1;
            this.queryParameters.clear();
            this.extraParameters.clear();
        }

        public String getQueryString(String string) {
            StringBuilder stringBuilder = null;
            int n = this.extraParameters.size();
            if (n > 0) {
                stringBuilder = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    String string2 = this.extraParameters.get(i).toString();
                    if (string2 != null && this.preferFowardQueryString() && !(this.extraParameters.get(i) instanceof ExtraIncludeParams)) {
                        return string2;
                    }
                    if (string2.length() == 0) continue;
                    stringBuilder.append(string2);
                    if (i >= n - 1 || this.extraParameters.get(i + 1).toString().length() <= 0) continue;
                    stringBuilder.append('&');
                }
            }
            if (this.queryStringBuffer == null || this.queryStringStart == -1 || this.queryStringLength == -1) {
                return stringBuilder == null || stringBuilder.length() == 0 ? null : stringBuilder.toString();
            }
            String string3 = BytesToString.newString((byte[])this.queryStringBuffer, (int)this.queryStringStart, (int)this.queryStringLength, (String)string);
            return stringBuilder == null || stringBuilder.length() == 0 ? string3 : stringBuilder.append('&').append(string3).toString();
        }

        private boolean preferFowardQueryString() {
            return this.request.getContext() != null && this.request.getContext().getConfigManager().isPreferForwardQueryString();
        }

        String getOriginalQueryString(String string) {
            if (this.queryStringStart == -1 || this.queryStringLength == -1) {
                return null;
            }
            return BytesToString.newString((byte[])this.queryStringBuffer, (int)this.queryStringStart, (int)this.queryStringLength, (String)string);
        }

        private void addForwardQueryString(String string) {
            this.extraParameters.add(0, new ExtraParams(string));
        }

        private void addIncludeQueryString(String string) {
            this.extraParameters.add(0, new ExtraIncludeParams(string));
        }

        private void removeRequestDispatcherQueryString() {
            this.extraParameters.remove(0);
        }

        public QueryParams getQueryParams() {
            this.parseQueryParams(false);
            return this.queryParameters;
        }

        public List getExtraQueryParams() {
            this.parseExtraQueryParams();
            return this.extraParameters;
        }

        public void setQueryParams(QueryParams queryParams) {
            this.queryParameters.clear();
            if (queryParams == null || queryParams.isEmpty()) {
                return;
            }
            for (String string : queryParams.keySet()) {
                String[] stringArray = queryParams.getValues((Object)string);
                if (stringArray == null) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.queryParameters.put((Object)string, (Object)stringArray[i]);
                }
            }
        }

        public void setExtraQueryParams(List list) {
            this.extraParameters.clear();
            if (list == null || list.isEmpty()) {
                return;
            }
            for (ExtraParams extraParams : list) {
                this.extraParameters.add(0, extraParams.clone());
            }
        }

        private Enumeration getParameterNames() {
            List list = this.getExtraQueryParams();
            if (list.size() == 0) {
                return new IteratorEnumerator(this.getQueryParams().keySet().iterator());
            }
            HashSet hashSet = new HashSet();
            for (ExtraParams extraParams : list) {
                hashSet.addAll(extraParams.params.keySet());
            }
            hashSet.addAll(this.getQueryParams().keySet());
            return new IteratorEnumerator(hashSet.iterator());
        }

        private String[] getParameterValues(String string) {
            List list = this.getExtraQueryParams();
            if (list.size() == 0) {
                return this.getQueryParams().getValues((Object)string);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ExtraParams extraParams : list) {
                QueryParams queryParams = extraParams.params;
                String[] stringArray = queryParams.getValues((Object)string);
                if (stringArray == null) continue;
                arrayList.addAll(Arrays.asList(stringArray));
            }
            String[] stringArray = this.getQueryParams().getValues((Object)string);
            if (stringArray != null) {
                arrayList.addAll(Arrays.asList(stringArray));
            }
            return arrayList.size() != 0 ? arrayList.toArray(new String[arrayList.size()]) : null;
        }

        private String getParameter(String string) {
            String string2 = this.getExtraParameter(string);
            return string2 != null ? string2 : this.getQueryParams().getValue((Object)string);
        }

        private String getExtraParameter(String string) {
            List list = this.getExtraQueryParams();
            for (ExtraParams extraParams : list) {
                QueryParams queryParams = extraParams.params;
                String string2 = queryParams.getValue((Object)string);
                if (string2 == null) continue;
                return string2;
            }
            return null;
        }

        void resetQueryParams() {
            this.queryParamsParsed = false;
            this.postParamsParsed = false;
            this.queryParameters.clear();
            for (ExtraParams extraParams : this.extraParameters) {
                extraParams.clear();
            }
        }

        private void parseQueryParams(boolean bl) {
            if (!this.queryParamsParsed) {
                this.mergeQueryParams();
            }
            if (!this.postParamsParsed) {
                this.mergePostParams(bl);
            }
        }

        private void parseExtraQueryParams() {
            for (ExtraParams extraParams : this.extraParameters) {
                extraParams.parseQueryParams(this.request.getQueryParamsEncoding());
            }
        }

        private void mergeQueryParams() {
            if (this.queryParamsParsed) {
                return;
            }
            this.queryParamsParsed = true;
            if (this.queryStringBuffer != null && this.queryStringStart != -1 && this.queryStringLength != -1) {
                HttpParsing.parseQueryString((byte[])this.queryStringBuffer, (int)this.queryStringStart, (int)this.queryStringLength, (Map)this.queryParameters, (String)this.request.getQueryParamsEncoding());
            }
        }

        private void mergePostParams(boolean bl) {
            if (this.postParamsParsed) {
                return;
            }
            this.postParamsParsed = true;
            String string = this.request.getContentType();
            if (!this.request.inputHelper.getRequestParser().isMethodPost() || string == null || !string.startsWith("application/x-www-form-urlencoded")) {
                return;
            }
            if (this.postDataRead && this.postData != null) {
                HttpParsing.parseQueryString((byte[])this.postData, (int)0, (int)this.postData.length, (Map)this.queryParameters, (String)this.request.getInputEncoding());
                return;
            }
            if (this.request.inputStream == null) {
                return;
            }
            if (((ServletInputStreamImpl)this.request.inputStream).getBytesRead() > 0) {
                if (bl) {
                    return;
                }
                HTTPLogger.logInvalidGetParameterInvocation((String)this.request.getContext().getLogContext());
                return;
            }
            int n = this.request.getContentLength();
            boolean bl2 = this.request.getRequestHeaders().isChunked();
            if (bl2) {
                n = 8192;
            }
            if (n < 1) {
                return;
            }
            this.postData = new byte[n];
            try {
                int n2;
                int n3;
                if (bl) {
                    this.request.inputStream.mark(n);
                }
                this.request.initRequestEncoding();
                for (n2 = 0; n2 < n; n2 += n3) {
                    n3 = this.request.inputStream.read(this.postData, n2, n - n2);
                    if (bl2 && n3 == -1) break;
                    Debug.assertion((n3 > -1 ? 1 : 0) != 0);
                }
                if (bl2 && n2 < this.postData.length) {
                    byte[] byArray = new byte[n2];
                    System.arraycopy(this.postData, 0, byArray, 0, n2);
                    this.postData = byArray;
                }
                if (bl) {
                    this.request.inputStream.reset();
                }
                this.mergeQueryParams();
                this.postDataRead = true;
                HttpParsing.parseQueryString((byte[])this.postData, (int)0, (int)this.postData.length, (Map)this.queryParameters, (String)this.request.getInputEncoding());
                this.postParamsParsed = true;
            }
            catch (IOException iOException) {
                throw new NestedRuntimeException("Cannot parse POST parameters of request: '" + this.request.getRequestURI() + "'", (Throwable)iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String peekQueryParameter(String string) {
            boolean bl = this.postParamsParsed;
            this.postParamsParsed = true;
            try {
                String string2 = this.peekParameter(string);
                return string2;
            }
            finally {
                this.postParamsParsed = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String peekPostParameter(String string) {
            boolean bl = this.queryParamsParsed;
            this.queryParamsParsed = true;
            try {
                String string2 = this.peekParameter(string);
                return string2;
            }
            finally {
                this.queryParamsParsed = bl;
            }
        }

        String peekParameter(String string) {
            String string2 = this.getExtraParameter(string);
            if (string2 != null) {
                return string2;
            }
            this.parseQueryParams(true);
            return this.queryParameters.getValue((Object)string);
        }

        static /* synthetic */ byte[] access$2002(RequestParameters requestParameters, byte[] byArray) {
            requestParameters.queryStringBuffer = byArray;
            return byArray;
        }
    }

    private static class ExtraIncludeParams
    extends ExtraParams {
        private ExtraIncludeParams() {
        }

        public ExtraIncludeParams(String string) {
            super(string);
        }

        public String toString() {
            return "";
        }

        protected Object clone() {
            ExtraIncludeParams extraIncludeParams = new ExtraIncludeParams();
            extraIncludeParams.parsed = this.parsed;
            extraIncludeParams.str = this.str;
            extraIncludeParams.params = (QueryParams)this.params.clone();
            return extraIncludeParams;
        }
    }

    private static class ExtraParams {
        protected String str;
        protected boolean parsed;
        protected QueryParams params;

        private ExtraParams() {
        }

        public ExtraParams(String string) {
            this.str = string;
            this.parsed = false;
            this.params = new QueryParams();
        }

        public void parseQueryParams(String string) {
            if (!this.parsed) {
                HttpParsing.parseQueryString((String)this.str, (Map)this.params, (String)string);
                this.parsed = true;
            }
        }

        public void clear() {
            this.parsed = false;
            this.params.clear();
        }

        public String toString() {
            return this.str;
        }

        protected Object clone() {
            ExtraParams extraParams = new ExtraParams();
            extraParams.parsed = this.parsed;
            extraParams.str = this.str;
            extraParams.params = (QueryParams)this.params.clone();
            return extraParams;
        }
    }

    private static final class CookieKey {
        private final String cookieName;
        private final String cookiePath;

        CookieKey(String string, String string2) {
            this.cookieName = string;
            this.cookiePath = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CookieKey)) {
                return false;
            }
            CookieKey cookieKey = (CookieKey)object;
            if (!this.cookieName.equals(cookieKey.cookieName)) {
                return false;
            }
            return this.cookiePath.equals(cookieKey.cookiePath);
        }

        public int hashCode() {
            int n = this.cookieName.hashCode();
            n = 29 * n + this.cookiePath.hashCode();
            return n;
        }
    }
}

