/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import com.bea.sslplus.SSLNioSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.Socket;
import java.nio.channels.WritableByteChannel;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WebAppContainerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.MessageSenderStatistics;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.ServletResponseAttributeEvent;
import weblogic.servlet.ServletResponseAttributeListener;
import weblogic.servlet.http.WLHttpServletResponse;
import weblogic.servlet.internal.CharsetMap;
import weblogic.servlet.internal.ChunkOutputWrapper;
import weblogic.servlet.internal.ChunkWriter;
import weblogic.servlet.internal.CookieParser;
import weblogic.servlet.internal.ErrorMessages;
import weblogic.servlet.internal.FileSenderImpl;
import weblogic.servlet.internal.FutureServletResponse;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.MembershipControllerImpl;
import weblogic.servlet.internal.ResponseHeaders;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.URLMatchHelper;
import weblogic.servlet.internal.UnsynchronizedPrintWriter;
import weblogic.servlet.internal.VirtualConnection;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.security.Utils;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.servlet.utils.URLMapping;
import weblogic.transaction.TxHelper;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.http.BytesToString;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.http.HttpReasonPhraseCoder;
import weblogic.utils.io.FilenameEncoder;
import weblogic.version;

public class ServletResponseImpl
implements HttpServletResponse,
FutureServletResponse,
WLHttpServletResponse,
MessageSenderStatistics {
    public static final String X_WEBLOGIC_REQUEST_CLUSTERINFO = "X-WebLogic-Request-ClusterInfo";
    public static final String X_WEBLOGIC_CLUSTER_HASH = "X-WebLogic-Cluster-Hash";
    public static final String X_WEBLOGIC_CLUSTER_LIST = "X-WebLogic-Cluster-List";
    public static final String X_WEBLOGIC_LOAD = "X-WebLogic-Load";
    public static final String X_WEBLOGIC_FORCE_JVMID = "X-WebLogic-Force-JVMID";
    public static final String X_WEBLOGIC_JVMID = "X-WebLogic-JVMID";
    public static final String X_WEBLOGIC_KEEPALIVE_SECS = "X-WebLogic-KeepAliveSecs";
    private static final String HTTP_VERSION_1_0 = "HTTP/1.0";
    private static final String HTTP_VERSION_1_1 = "HTTP/1.1";
    private static final String STATUS_OK_HEADER_1_0;
    private static final String STATUS_OK_HEADER_1_1;
    private static final boolean X_POWERED_BY_HEADER_ENABLED;
    private static final String X_POWERED_BY_HEADER;
    private static final boolean P3P_ENABLED;
    private static final String P3P_HEADER_VALUE;
    private static ArrayList<String> noHttpOnlyInternalApps;
    private final ServletRequestImpl request;
    private final ServletOutputStreamImpl outputStream;
    private WebAppServletContext context;
    private int statusCode = 200;
    private String statusMessage = null;
    private int contentLength = -1;
    private String encoding;
    private boolean encodingSetExplicitly;
    private PrintWriter printWriter;
    private ChunkWriter outputStreamWriter;
    private final ArrayList cookies = new ArrayList();
    private ResponseHeaders headers = new ResponseHeaders(this);
    private Locale locale;
    private boolean gotOutputStream;
    private boolean useKeepAlive = true;
    private static final String[] CRLF;
    private FileSenderImpl fileSender = null;
    private long bytesSent = 0L;
    private long messageSent = 0L;
    private Set attributeListeners = new HashSet(4);
    static final long serialVersionUID = -8811939890096004942L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_Response_Write_Headers_Around_Medium;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_Response_Send_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    ServletResponseImpl() {
        this.request = null;
        this.outputStream = null;
    }

    ServletResponseImpl(ServletRequestImpl servletRequestImpl, OutputStream outputStream) {
        this.outputStream = new ServletOutputStreamImpl(outputStream, this);
        this.request = servletRequestImpl;
        this.request.setResponse(this);
    }

    final void init() {
        this.statusCode = 200;
        this.statusMessage = null;
        this.contentLength = -1;
        this.headers = new ResponseHeaders(this);
        this.useKeepAlive = true;
        this.context = null;
        this.encoding = null;
        this.encodingSetExplicitly = false;
        this.printWriter = null;
        this.outputStreamWriter = null;
        this.cookies.clear();
        this.locale = null;
        this.gotOutputStream = false;
        this.fileSender = null;
        this.attributeListeners.clear();
    }

    public void flushBuffer() throws IOException {
        this.outputStream.flush();
    }

    public int getBufferSize() {
        return this.outputStream.getBufferSize();
    }

    public String getCharacterEncoding() {
        if (this.outputStreamWriter != null) {
            this.encoding = this.outputStreamWriter.getEncoding();
        }
        if (this.encoding == null) {
            this.encoding = this.context != null ? this.context.getConfigManager().getDefaultEncoding() : "ISO-8859-1";
        }
        return this.encoding;
    }

    public void setCharacterEncoding(String string) {
        if (this.isCommitted()) {
            return;
        }
        String string2 = this.getCharacterEncoding();
        this.encodingSetExplicitly = true;
        this.setEncoding(string);
        string = this.getCharacterEncoding();
        if (!string.equalsIgnoreCase(string2)) {
            String string3 = this.getHeader("Content-Type");
            if (string3 == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = string3.indexOf(59);
            if (n != -1) {
                stringBuilder.append(string3.substring(0, n));
            } else {
                stringBuilder.append(string3);
            }
            stringBuilder.append("; charset=");
            stringBuilder.append(string);
            this.headers.setHeader("Content-Type", stringBuilder.toString());
        }
    }

    final boolean isOutputStreamInitialized() {
        return this.gotOutputStream || this.printWriter != null;
    }

    final void resetOutputState() {
        this.gotOutputStream = false;
        this.printWriter = null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null && this.request != null && this.request.getAttribute("javax.servlet.include.request_uri") == null) {
            throw new IllegalStateException("strict servlet API: cannot call getOutputStream() after getWriter()");
        }
        this.gotOutputStream = true;
        return this.getOutputStreamNoCheck();
    }

    public ServletOutputStream getOutputStreamNoCheck() {
        return this.outputStream;
    }

    public final ServletOutputStreamImpl getServletOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.gotOutputStream && this.request != null && this.request.getAttribute("javax.servlet.include.request_uri") == null) {
            throw new IllegalStateException("strict servlet API: cannot call getWriter() after getOutputStream()");
        }
        this.initWriter();
        return this.printWriter;
    }

    protected final PrintWriter getWriterNoCheck() {
        this.initWriter();
        return this.printWriter;
    }

    public boolean isCommitted() {
        return this.outputStream.isCommitted();
    }

    public void reset() throws IllegalStateException {
        this.outputStream.reset();
        this.setStatus(200);
        this.headers = new ResponseHeaders(this);
        this.cookies.clear();
    }

    public void resetBuffer() {
        this.outputStream.clearBuffer();
    }

    public void setBufferSize(int n) {
        if (this.outputStream.getTotal() > 0) {
            throw new IllegalStateException("Cannot resize buffer - " + this.outputStream.getTotal() + " bytes have already been written (Servlet " + "2.3, sec. 5.1)");
        }
        this.setBufferSizeNoWriteCheck(n);
    }

    public void setBufferSizeNoWriteCheck(int n) {
        this.objectIfCommitted();
        this.outputStream.setBufferSize(n);
    }

    public void setContentLength(int n) {
        if (this.isCommitted()) {
            return;
        }
        if (n == -1) {
            return;
        }
        this.contentLength = n;
        this.headers.setContentLength(n);
        try {
            this.outputStream.setContentLength(n);
        }
        catch (ProtocolException protocolException) {
            throw new RuntimeException(protocolException.toString());
        }
    }

    public void setContentType(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (string == null) {
            this.headers.setContentType(null);
            return;
        }
        int n = StringUtils.indexOfIgnoreCase((String)string, (String)"charset");
        if (n != -1) {
            String string2 = null;
            int n2 = string.indexOf(59, n);
            int n3 = string.indexOf(61, n);
            if (n2 == -1) {
                if (n3 != -1 && n3 < string.length()) {
                    string2 = string.substring(n3 + 1).trim();
                }
            } else if (n3 != -1 && n3 < n2) {
                string2 = string.substring(n3 + 1, n2).trim();
            }
            if ((string2 = HttpParsing.StripHTTPFieldValue(string2)) != null && string2.length() != 0) {
                this.encodingSetExplicitly = true;
                if (!string2.equalsIgnoreCase(this.getCharacterEncoding())) {
                    this.setEncoding(string2);
                    if (!string2.equals(this.getCharacterEncoding())) {
                        int n4 = string.indexOf(";");
                        if (n4 != -1) {
                            string = string.substring(0, n4);
                        }
                        if (this.encoding != null && CharsetMap.isCharsetAllowedForType(string)) {
                            string = string + "; charset=" + this.encoding;
                        }
                    }
                }
            }
        } else if (string.toLowerCase().trim().startsWith("text/")) {
            if (this.printWriter != null) {
                string = string + "; charset=" + this.outputStreamWriter.getEncoding();
            } else {
                String string3 = this.outputStream.getOutput().getOutput().getEncoding();
                if (string3 != null && CharsetMap.isCharsetAllowedForType(string)) {
                    string = string + "; charset=" + string3;
                }
            }
        }
        this.headers.setContentType(string);
    }

    public final String getContentType() {
        return this.getHeader("Content-Type");
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        CharSequence charSequence;
        if (this.isCommitted()) {
            return;
        }
        if (locale == null) {
            return;
        }
        if (!this.encodingSetExplicitly) {
            charSequence = this.context.getConfigManager().getLocaleEncodingMap().getJavaCharset(locale);
            String string = this.getContentType();
            if (string == null) {
                this.setEncoding((String)charSequence);
            } else {
                int n = StringUtils.indexOfIgnoreCase((String)string, (String)"charset=");
                string = n > -1 ? string.substring(0, n + 8) : string + "; charset=";
                this.setEncoding((String)charSequence);
                this.headers.setHeader("Content-Type", string + (String)charSequence);
            }
        }
        charSequence = new StringBuffer(locale.getLanguage());
        if (!"".equals(locale.getCountry())) {
            ((StringBuffer)charSequence).append('-').append(locale.getCountry());
        }
        this.setHeader("Content-Language", ((StringBuffer)charSequence).toString());
        this.locale = locale;
    }

    public CharsetMap getCharsetMap() {
        return this.context.getConfigManager().getCharsetMap();
    }

    public void addCookie(Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("Invalid Cookie");
        }
        this.checkForCRLFChars(cookie);
        this.addCookieInternal(cookie);
    }

    public void addCookieInternal(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        this.cookies.add(cookie);
    }

    public final Cookie getCookie(String string) {
        if (this.cookies.size() > 0) {
            int n = this.cookies.size();
            while (--n > -1) {
                Cookie cookie = (Cookie)this.cookies.get(n);
                if (!cookie.getName().equals(string)) continue;
                return cookie;
            }
        }
        return null;
    }

    public final void removeCookie(String string, String string2) {
        if (this.cookies.size() < 1) {
            return;
        }
        int n = this.cookies.size();
        while (--n > -1) {
            Cookie cookie = (Cookie)this.cookies.get(n);
            if (cookie.getName() == null || !cookie.getName().equals(string) || cookie.getPath() == null || !cookie.getPath().equals(string2)) continue;
            this.cookies.remove(cookie);
            break;
        }
    }

    public void addDateHeader(String string, long l) {
        if (this.isCommitted()) {
            return;
        }
        this.headers.addDateHeader(string, l);
    }

    public void addHeader(String string, String string2) {
        this.checkForCRLFChars(string, string2);
        this.addHeaderInternal(string, string2);
    }

    public void addHeaderInternal(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        this.headers.addHeader(string, string2);
    }

    public void addIntHeader(String string, int n) {
        if (this.isCommitted()) {
            return;
        }
        this.headers.addIntHeader(string, n);
    }

    public boolean containsHeader(String string) {
        return this.headers.containsHeader(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeRedirectURL(String string) {
        if (string.startsWith("/")) {
            string = this.processProxyPathHeaders(string);
        }
        return this.encodeURL(string);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public String encodeURL(String string) {
        return this.encodeURL(string, this.request.getSession(false));
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, ErrorMessages.getErrorPage(n));
    }

    private void sendNoContentError() {
        this.disableKeepAlive();
        this.setContentLength(0);
        this.getWriterNoCheck().flush();
        this.outputStream.getOutput().setWriteEnabled(false);
        this.incrementBytesSentCount(this.outputStream.getTotal());
        this.incrementMessageSentCount();
    }

    private void sendContentError(int n, String string) {
        this.disableKeepAliveOnSendError(n);
        this.setContentType("text/html");
        this.setContentLength(string.length());
        this.setCharacterEncoding("UTF-8");
        this.getWriterNoCheck().print(string);
        this.getWriterNoCheck().flush();
        this.incrementBytesSentCount(this.outputStream.getOutput().getTotal());
        this.incrementMessageSentCount();
    }

    public void sendError(int n, String string) throws IOException {
        this.objectIfCommitted();
        this.outputStream.clearCurrentBuffer();
        this.resetOutputState();
        this.setStatus(n);
        this.setStatusMessage(string);
        if (n == 100 || n == 101 || n == 204 || n == 304) {
            this.sendNoContentError();
            return;
        }
        String string2 = this.request.getRequestURI();
        try {
            String string3;
            Object object;
            Integer n2;
            String string4 = null;
            if (this.context != null) {
                string4 = this.context.getErrorManager().getErrorLocation(String.valueOf(n));
            }
            if (this.request.getAttribute("javax.servlet.error.status_code") != null) {
                n2 = (Integer)this.request.getAttribute("javax.servlet.error.status_code");
                int n3 = n2;
                object = this.context.getErrorManager().getErrorLocation(String.valueOf(n3));
                if (n3 > 0 && object != null && n != n3 && string2.endsWith((String)object)) {
                    HTTPLogger.logNoLocation((String)this.context.getLogContext(), (String)object, (int)n3);
                }
            }
            if (string4 == null) {
                this.sendContentError(n, string);
                return;
            }
            if (string2.endsWith(string4)) {
                HTTPLogger.logNoLocation((String)this.context.getLogContext(), (String)string4, (int)n);
                this.sendContentError(n, string);
                return;
            }
            if (WebAppServletContext.isAbsoluteURL(string4)) {
                this.sendRedirect(string4);
                return;
            }
            try {
                if (n != 401) {
                    this.reset();
                }
                this.setStatus(n);
            }
            catch (Exception exception) {
                HTTPLogger.logUnableToServeErrorPage((String)this.context.getLogContext(), (String)string4, (int)n, (Throwable)exception);
                return;
            }
            URLMapping uRLMapping = this.context.getServletMapping();
            object = (URLMatchHelper)uRLMapping.get(string4);
            if (object == null || ((URLMatchHelper)object).getPattern().startsWith("*.") || ((URLMatchHelper)object).isFileOrJspServlet()) {
                n2 = this.context.getRequestDispatcher(string4, 3);
            } else {
                string3 = (String)this.request.getAttribute("weblogic.servlet.errorPage");
                if (string3 != null && string3.equals(string4)) {
                    HTTPLogger.logBadErrorPage((String)this.context.getLogContext(), (String)string4, (int)n);
                    this.sendContentError(n, string);
                    return;
                }
                this.request.setAttribute("weblogic.servlet.errorPage", string4);
                n2 = this.context.getNamedDispatcher(((URLMatchHelper)object).getServletStub().getServletName(), 3);
            }
            if (n2 == null) {
                this.sendContentError(n, string);
                return;
            }
            ServletStubImpl servletStubImpl = null;
            string3 = string2.startsWith(this.context.getContextPath()) ? string2.substring(this.context.getContextPath().length()) : string2;
            if (string3 != null) {
                servletStubImpl = this.context.getServletStub(string3);
            }
            this.setErrorAttributes(servletStubImpl, n, string);
            n2.forward((ServletRequest)this.request, (ServletResponse)this);
        }
        catch (ServletException servletException) {
            Throwable throwable = WebAppServletContext.getRootCause(servletException);
            HTTPLogger.logSendError((String)this.context.getLogContext(), (Throwable)throwable);
        }
    }

    private void disableKeepAliveOnSendError(int n) {
        switch (n) {
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 412: {
                break;
            }
            default: {
                this.disableKeepAlive();
            }
        }
    }

    private void setStatusMessage(String string) {
        if ((this.statusMessage == null || this.statusMessage.equals("Unknown")) && string != null) {
            this.statusMessage = string.length() < 256 ? Utils.encodeXSS(string) : Utils.encodeXSS(string.substring(0, 256));
        }
    }

    public String getURLForRedirect(String string) {
        string = this.processProxyPathHeaders(string);
        return this.getAbsoluteURL(string);
    }

    private String getAbsoluteURL(String string) {
        if (this.request.getRequestHeaders().getHost() == null && this.context.getServer().getFrontendHost() == null) {
            return string;
        }
        int n = this.request.getServerPort();
        String string2 = this.request.getScheme().toLowerCase();
        if (n == 80 && string2.equals("http") || n == 443 && string2.equals("https")) {
            return string2 + "://" + this.request.getServerName() + string;
        }
        return string2 + "://" + this.request.getServerName() + ':' + this.request.getServerPort() + string;
    }

    public final String processProxyPathHeaders(String string) {
        String string2 = string;
        String string3 = this.request.getHeader("WL-PATH-PREPEND");
        boolean bl = true;
        if (string3 != null) {
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if (string2.startsWith(string3 + '/') || string2.equals(string3)) {
                if ((string2 = string2.substring(string3.length())).length() == 0) {
                    string2 = "/";
                } else if (string2.charAt(0) != '/') {
                    string2 = "/" + string2;
                }
            } else {
                bl = false;
            }
        }
        String string4 = this.request.getHeader("WL-PATH-TRIM");
        if (bl && string4 != null) {
            if (string4.charAt(0) != '/') {
                string4 = "/" + string4;
            }
            if (!string2.startsWith(string4 + "/")) {
                string2 = string4 + string2;
            }
        }
        return string2;
    }

    public void sendRedirect(String string) throws IOException {
        String string2;
        this.objectIfCommitted();
        if (WebAppServletContext.isAbsoluteURL(string)) {
            if (this.request.getHeader(X_WEBLOGIC_KEEPALIVE_SECS) == null) {
                this.disableKeepAlive();
            }
        } else if (this.context.getConfigManager().isRedirectWithAbsoluteURLEnabled()) {
            if (string.startsWith("/")) {
                string = this.processProxyPathHeaders(string);
            } else {
                String string3 = string2 = this.request.getRequestURI();
                if (!string2.endsWith("/")) {
                    string3 = string3.substring(0, string3.lastIndexOf("/") + 1);
                }
                string3 = this.processProxyPathHeaders(string3);
                string = FilenameEncoder.resolveRelativeURIPath((String)(string3 + string));
            }
            string = this.getAbsoluteURL(string);
        }
        this.setHeader("Location", string);
        this.setStatus(302);
        string2 = this.headers.getHeader("Content-Type");
        if (string2 == null) {
            this.setContentType(this.context.getConfigManager().getDefaultMimeType());
        }
        this.outputStream.reset();
        this.outputStream.println("<html><head><title>302 Moved Temporarily</title></head>");
        this.outputStream.println("<body bgcolor=\"#FFFFFF\">");
        this.outputStream.println("<p>This document you requested has moved temporarily.</p>");
        string = Utils.encodeXSS(string);
        this.outputStream.println("<p>It's now at <a href=\"" + string + "\">" + string + "</a>.</p>");
        this.outputStream.println("</body></html>");
        this.outputStream.flush();
        this.incrementBytesSentCount(this.outputStream.getTotal());
        this.incrementMessageSentCount();
        this.outputStream.commit();
        this.outputStream.setWriteEnabled(false);
    }

    public void setDateHeader(String string, long l) {
        if (this.isCommitted()) {
            return;
        }
        this.headers.setDateHeader(string, l);
    }

    public void setHeader(String string, String string2) {
        this.checkForCRLFChars(string, string2);
        this.setHeaderInternal(string, string2);
    }

    public void setHeaderInternal(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.equalsIgnoreCase("Content-Type")) {
            this.setContentType(string2);
            return;
        }
        if (string.equalsIgnoreCase("Content-Length")) {
            try {
                this.setContentLength(Integer.parseInt(string2.trim()));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.headers.setHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        if (this.isCommitted()) {
            return;
        }
        this.headers.setIntHeader(string, n);
    }

    public void setStatus(int n) {
        if (this.isCommitted()) {
            return;
        }
        this.setStatus(n, HttpReasonPhraseCoder.getReasonPhrase((int)n));
    }

    public void setStatus(int n, String string) {
        if (this.isCommitted()) {
            return;
        }
        this.statusCode = n;
        this.statusMessage = string;
    }

    final void initHttpServer(HttpServer httpServer) {
        if (this.isCommitted()) {
            return;
        }
        if (httpServer.getMBean().isSendServerHeaderEnabled()) {
            this.headers.setHeader("Server", HttpServer.SERVER_INFO);
        }
        if (X_POWERED_BY_HEADER_ENABLED) {
            this.headers.setHeader("X-Powered-By", X_POWERED_BY_HEADER);
        }
        if (P3P_ENABLED) {
            this.headers.setHeader("P3P", P3P_HEADER_VALUE);
        }
    }

    final void initContext(WebAppServletContext webAppServletContext) {
        this.context = webAppServletContext;
    }

    final ServletRequestImpl getRequest() {
        return this.request;
    }

    final boolean hasKeepAliveHeader() {
        return this.headers.getKeepAlive();
    }

    public final void disableKeepAlive() {
        this.useKeepAlive = false;
    }

    final boolean getUseKeepAlive() {
        return this.request.getInputHelper().getRequestParser().isKeepAlive() && this.useKeepAlive;
    }

    public final String getHeader(String string) {
        String string2 = this.headers.getHeader(string);
        return string2;
    }

    public Socket getSocket() throws IOException {
        if (this.request == null) {
            return null;
        }
        VirtualConnection virtualConnection = this.request.getConnection();
        if (virtualConnection == null) {
            return null;
        }
        this.outputStream.setNativeControlsPipe(true);
        return virtualConnection.getSocket();
    }

    public WritableByteChannel getWritableByteChannel() throws IOException {
        Socket socket = this.getSocket();
        if (socket == null) {
            return null;
        }
        if (socket instanceof SSLNioSocket) {
            return ((SSLNioSocket)socket).getWritableByteChannel();
        }
        return socket.getChannel();
    }

    final void setDefaultEncoding(String string) {
        if (BytesToString.is8BitUnicodeSubset((String)string)) {
            return;
        }
        if (this.outputStream != null && this.context != null) {
            ChunkOutputWrapper chunkOutputWrapper = this.outputStream.getOutput();
            String string2 = chunkOutputWrapper.getEncoding();
            if (string != null && !string.equalsIgnoreCase(string2)) {
                try {
                    chunkOutputWrapper.changeToCharset(string, this.context.getConfigManager().getCharsetMap());
                    this.outputStream.setOutput(chunkOutputWrapper);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
    }

    private void setEncoding(String string) {
        Object object;
        if (string == null) {
            return;
        }
        if (this.printWriter != null && (object = this.getCharacterEncoding()) != null && !((String)object).equalsIgnoreCase(string)) {
            return;
        }
        object = this.outputStream.getOutput();
        try {
            CharsetMap charsetMap = this.context != null ? this.context.getConfigManager().getCharsetMap() : new CharsetMap(null);
            ((ChunkOutputWrapper)object).changeToCharset(string, charsetMap);
            for (ServletResponseAttributeListener servletResponseAttributeListener : this.attributeListeners) {
                servletResponseAttributeListener.attributeChanged(new ServletResponseAttributeEvent((ServletResponse)this, "ENCODING", this.encoding));
            }
            this.encoding = string;
            this.headers.setEncoding(charsetMap.getJavaCharset(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("unsupported encoding: '" + string + "': " + unsupportedEncodingException);
        }
    }

    private void initWriter() {
        if (this.printWriter != null) {
            return;
        }
        ChunkOutputWrapper chunkOutputWrapper = this.outputStream.getOutput();
        this.outputStreamWriter = new ChunkWriter(chunkOutputWrapper);
        this.printWriter = new UnsynchronizedPrintWriter(this.outputStreamWriter, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void writeHeaders() throws IOException {
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block29: {
            block28: {
                bl = _WLDF$INST_FLD_Servlet_Response_Write_Headers_Around_Medium.isEnabledAndNotDyeFiltered();
                diagnosticActionArray = null;
                diagnosticActionStateArray = null;
                Object var20_4 = null;
                if (bl) {
                    Object[] objectArray = null;
                    if (_WLDF$INST_FLD_Servlet_Response_Write_Headers_Around_Medium.isArgumentsCaptureNeeded()) {
                        objectArray = new Object[]{this};
                    }
                    DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                    DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_Response_Write_Headers_Around_Medium;
                    diagnosticActionArray = delegatingMonitor.getActions();
                    diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                    InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                }
                try {
                    String string;
                    HttpServer httpServer;
                    String string2;
                    SessionConfigManager sessionConfigManager;
                    if (this.isCommitted()) {
                        Object var18_8 = null;
                        if (!bl) return;
                        break block28;
                    }
                    if (HTTPDebugLogger.isEnabled()) {
                        this.trace("Writing headers for " + this.request.toStringSimple());
                    }
                    ServletOutputStreamImpl servletOutputStreamImpl = this.outputStream;
                    String string3 = this.buildFirstLine();
                    this.headers.setDate(this.request.getHttpAccountingInfo().getInvokeTime());
                    SessionConfigManager sessionConfigManager2 = sessionConfigManager = this.context == null ? null : this.context.getSessionContext().getConfigMgr();
                    if (this.cookies.size() > 0) {
                        for (int i = 0; i < this.cookies.size(); ++i) {
                            Cookie cookie = (Cookie)this.cookies.get(i);
                            boolean bl2 = false;
                            if (sessionConfigManager == null && (cookie.getName().equals("JSESSIONID") || cookie.getName().equals("_WL_AUTHCOOKIE_JSESSIONID"))) {
                                bl2 = true;
                            } else if (sessionConfigManager != null && (cookie.getName().equals(sessionConfigManager.getCookieName()) || cookie.getName().equals(sessionConfigManager.getWLSAuthCookieName()))) {
                                bl2 = sessionConfigManager.isCookieHttpOnly();
                            }
                            if (this.context.isInternalApp() && noHttpOnlyInternalApps.contains(this.context.getContextPath())) {
                                bl2 = false;
                            }
                            string2 = CookieParser.formatCookie(cookie, bl2);
                            if (HTTPDebugLogger.isEnabled()) {
                                this.trace("Wrote cookie: " + string2);
                            }
                            this.headers.addHeader("Set-Cookie", string2);
                        }
                        if (sessionConfigManager != null && !sessionConfigManager.isCacheSessionCookieEnabled()) {
                            this.headers.disableCacheControlForCookie();
                        }
                    }
                    if ((httpServer = this.getHttpServer()) != null) {
                        boolean bl3 = false;
                        ServerMBean serverMBean = ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getServer();
                        if (serverMBean.getCluster() != null && this.request.getRequestHeaders().getXWeblogicRequestClusterInfo() != null) {
                            String[] stringArray;
                            bl3 = true;
                            this.headers.unsetHeader(X_WEBLOGIC_CLUSTER_LIST);
                            this.headers.unsetHeader(X_WEBLOGIC_CLUSTER_HASH);
                            if (HTTPDebugLogger.isEnabled()) {
                                this.trace("writing server list for " + this.request.toString());
                            }
                            String string4 = (string2 = this.request.getRequestHeaders().getXWeblogicClusterHash()) == null ? "" : string2;
                            String string5 = MembershipControllerImpl.getInstance().getHash();
                            String string6 = this.headers.getHeader(X_WEBLOGIC_CLUSTER_HASH);
                            if (string5 != null && !string5.equals(string4) && (stringArray = MembershipControllerImpl.getInstance().getClusterList(this.request.getConnection().getChannel())) != null && stringArray.length > 0) {
                                StringBuffer stringBuffer = new StringBuffer();
                                for (int i = 0; i < stringArray.length; ++i) {
                                    String string7 = stringArray[i];
                                    stringBuffer.append(string7);
                                    if (i >= stringArray.length - 1) continue;
                                    stringBuffer.append('|');
                                }
                                this.headers.setHeader(X_WEBLOGIC_CLUSTER_HASH, string5);
                                this.headers.setHeader(X_WEBLOGIC_CLUSTER_LIST, stringBuffer.toString());
                            }
                        }
                        if (this.request.getRequestHeaders().getXWeblogicForceJvmId() != null) {
                            bl3 = true;
                            this.headers.unsetHeader(X_WEBLOGIC_JVMID);
                            this.headers.setHeader(X_WEBLOGIC_JVMID, httpServer.getServerHash());
                        }
                        if (bl3) {
                            this.headers.unsetHeader(X_WEBLOGIC_KEEPALIVE_SECS);
                            string2 = this.request.getRequestHeaders().getXWeblogicKeepaliveSecs();
                            if (this.context != null && string2 != null) {
                                int n = this.context.getServer().getMBean().getKeepAliveSecs();
                                try {
                                    int n2 = Integer.parseInt(string2);
                                    if (n2 > n) {
                                        this.headers.setHeader(X_WEBLOGIC_KEEPALIVE_SECS, "" + n);
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.headers.setHeader(X_WEBLOGIC_KEEPALIVE_SECS, "" + n);
                                }
                            }
                        }
                    }
                    if ((string = this.getHeader("Content-Type")) != null && this.request.getAttribute("weblogic.servlet.jsp") != null && string.toLowerCase().trim().startsWith("text/") && string.indexOf(59) < 0) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(string);
                        stringBuilder.append("; charset=");
                        stringBuilder.append(this.getCharacterEncoding());
                        this.headers.setContentType(stringBuilder.toString());
                    }
                    if (!this.getUseKeepAlive()) {
                        this.headers.setConnection("close");
                    }
                    int n = this.headers.writeHeaders(servletOutputStreamImpl, string3);
                    this.incrementBytesSentCount(n);
                    if (HTTPDebugLogger.isEnabled()) {
                        HTTPDebugLogger.debug("Response committed. request: '" + this.request.toStringSimple() + "' response: " + this.toString());
                    }
                    break block29;
                }
                catch (Throwable throwable) {
                    Object var18_10 = null;
                    if (!bl) throw throwable;
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Response_Write_Headers_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
                    throw throwable;
                }
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Response_Write_Headers_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
            return;
        }
        Object var18_9 = null;
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Response_Write_Headers_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    private final String buildFirstLine() {
        String string;
        if (this.statusCode == 200 && (this.statusMessage == null || "OK".equals(this.statusMessage))) {
            string = this.request == null || this.request.getInputHelper().getRequestParser().isProtocolVersion_1_1() || this.useHighestCompatibleHttpVersion() ? STATUS_OK_HEADER_1_1 : STATUS_OK_HEADER_1_0;
        } else {
            String string2 = this.request == null || this.request.getInputHelper().getRequestParser().isProtocolVersion_1_1() || this.useHighestCompatibleHttpVersion() ? HTTP_VERSION_1_1 : HTTP_VERSION_1_0;
            string = string2 + ' ' + this.statusCode + ' ' + this.statusMessage + "\r\n";
        }
        return string;
    }

    private String encodeURL(String string, HttpSession httpSession) {
        if (httpSession == null || this.request.isRequestedSessionIdFromCookie() || !this.context.getSessionContext().getConfigMgr().isSessionTrackingEnabled() || !this.context.getSessionContext().getConfigMgr().isUrlRewritingEnabled() || !((SessionInternal)httpSession).isValid()) {
            return string;
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(63);
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        } else {
            int n2 = string.indexOf(35);
            if (n2 != -1) {
                string3 = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
        }
        if (!this.context.getSessionContext().getConfigMgr().isEncodeSessionIdInQueryParamsEnabled()) {
            int n3;
            String string4 = this.context.getSessionContext().getConfigMgr().getCookieName();
            if (string4.equals("JSESSIONID")) {
                string4 = "jsessionid";
            }
            if ((n3 = string.indexOf(59)) == -1) {
                string = new StringBuffer(string).append(';').append(string4).append('=').append(((SessionInternal)httpSession).getIdWithServerInfo()).toString();
            } else {
                String string5 = string.substring(0, n3);
                string = new StringBuffer(string5).append(';').append(string4).append('=').append(((SessionInternal)httpSession).getIdWithServerInfo()).toString();
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(this.context.getSessionContext().getConfigMgr().getCookieName()).append('=').append(((SessionInternal)httpSession).getIdWithServerInfo());
            if (string2 != null) {
                stringBuffer.append('&').append(string2);
            }
            string2 = stringBuffer.toString();
        }
        if (string2 != null) {
            string = string + '?' + string2;
        } else if (string3 != null) {
            string = string + "#" + string3;
        }
        return string;
    }

    private void setErrorAttributes(ServletStubImpl servletStubImpl, int n, String string) {
        String string2 = this.request.getRequestURI();
        this.request.setAttribute("javax.servlet.error.status_code", new Integer(n));
        if (this.request.getAttribute("javax.servlet.error.message") == null) {
            String string3 = string != null ? string : ErrorMessages.getSection(n);
            this.request.setAttribute("javax.servlet.error.message", string3);
        }
        this.request.setAttribute("javax.servlet.error.request_uri", string2);
        if (servletStubImpl != null) {
            this.request.setAttribute("javax.servlet.error.servlet_name", servletStubImpl.getServletName());
        }
    }

    final void setSessionCookie(HttpSession httpSession) {
        if (!this.context.getSessionContext().getConfigMgr().isSessionCookiesEnabled() || !this.context.getSessionContext().getConfigMgr().isSessionTrackingEnabled()) {
            return;
        }
        SessionContext sessionContext = this.context.getSessionContext();
        this.removeCookie(sessionContext.getConfigMgr().getCookieName(), sessionContext.getConfigMgr().getCookiePath());
        Cookie cookie = new Cookie(sessionContext.getConfigMgr().getCookieName(), ((SessionInternal)httpSession).getIdWithServerInfo());
        if (this.requestHadCookie(cookie)) {
            return;
        }
        if (HTTPDebugLogger.isEnabled()) {
            this.trace("Setting cookie for " + this.request.toStringSimple());
        }
        cookie.setComment(sessionContext.getConfigMgr().getCookieComment());
        cookie.setMaxAge(sessionContext.getConfigMgr().getCookieMaxAgeSecs());
        String string = sessionContext.getConfigMgr().getCookieDomain();
        if (string != null) {
            cookie.setDomain(string);
        }
        cookie.setPath(sessionContext.getConfigMgr().getCookiePath());
        if (sessionContext.getConfigMgr().isCookieSecure()) {
            cookie.setSecure(true);
        }
        this.addCookie(cookie);
    }

    public final int getStatus() {
        return this.statusCode;
    }

    public final int getContentLength() {
        return this.contentLength > -1 ? this.contentLength : this.outputStream.getTotal();
    }

    private void ensureContentLength() throws IOException {
        if (this.fileSender != null && !this.fileSender.usesServletOutputStream()) {
            this.outputStream.ensureContentLength(this.fileSender.getBytesSent());
        } else {
            this.outputStream.ensureContentLength(0L);
        }
    }

    public void setResponseReady() {
        if (this.request != null) {
            this.request.disableFutureResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void send() throws IOException {
        boolean bl = _WLDF$INST_FLD_Servlet_Response_Send_Around_Medium.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var15_4 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_Servlet_Response_Send_Around_Medium.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_Response_Send_Around_Medium;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            HttpServer httpServer = this.getHttpServer();
            try {
                if (this.context == null) {
                    this.request.getConnection().close();
                    throw new AssertionError((Object)"context not available");
                }
                if (httpServer.getLogManager() != null && httpServer.getLogManager().isExtendedFormat()) {
                    try {
                        this.request.getHttpAccountingInfo().init(this.request, SecurityModule.getCurrentUser(httpServer, this.request));
                    }
                    catch (Error error) {
                        this.request.getConnection().close();
                        throw error;
                    }
                    catch (RuntimeException runtimeException) {
                        this.request.getConnection().close();
                        throw runtimeException;
                    }
                }
                Thread thread2 = Thread.currentThread();
                ClassLoader classLoader = this.context.pushEnvironment(thread2);
                AuthenticatedSubject authenticatedSubject = null;
                try {
                    authenticatedSubject = SecurityModule.getCurrentUser(httpServer, this.request);
                }
                catch (Error error) {
                    this.request.getConnection().close();
                    throw error;
                }
                catch (RuntimeException runtimeException) {
                    this.request.getConnection().close();
                    throw runtimeException;
                }
                if (authenticatedSubject == null) {
                    authenticatedSubject = SubjectUtils.getAnonymousSubject();
                }
                Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        try {
                            ServletResponseImpl.this.request.getSessionHelper().syncSession();
                        }
                        catch (Throwable throwable) {
                            return throwable;
                        }
                        return null;
                    }
                });
                WebAppServletContext.popEnvironment(thread2, classLoader);
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        this.request.getConnection().close();
                        throw (Error)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        this.request.getConnection().close();
                        throw (RuntimeException)throwable;
                    }
                    IOException iOException = new IOException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                    this.request.getConnection().deliverHasException(iOException);
                    throw iOException;
                }
                try {
                    this.ensureContentLength();
                    this.outputStream.commit();
                    this.incrementBytesSentCount(this.outputStream.getTotal());
                    this.incrementMessageSentCount();
                }
                catch (IOException iOException) {
                    this.request.getConnection().deliverHasException(iOException);
                    throw iOException;
                }
                finally {
                    this.abortActiveTx();
                }
            }
            finally {
                httpServer.getLogManager().log(this.request, this);
            }
            try {
                this.outputStream.finish();
            }
            catch (IOException iOException) {
                this.request.getConnection().deliverHasException(iOException);
                throw iOException;
            }
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Response finished for request '" + this.request.toStringSimple() + "'");
            }
            if (this.getUseKeepAlive()) {
                if (HTTPDebugLogger.isEnabled()) {
                    this.trace("Requeuing Keep-Alive connection");
                }
                this.request.getConnection().requeue();
            } else {
                if (HTTPDebugLogger.isEnabled()) {
                    this.trace("Closing non Keep-Alive connection");
                }
                try {
                    this.request.skipUnreadBody();
                }
                catch (Throwable throwable) {
                    if (HTTPDebugLogger.isEnabled()) {
                        this.trace(throwable.toString());
                    }
                }
                finally {
                    this.request.getConnection().close();
                }
            }
            Object var13_24 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var13_25 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Response_Send_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Response_Send_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    private void abortActiveTx() {
        if (this.request.isFutureResponseEnabled()) {
            return;
        }
        try {
            Transaction transaction = TxHelper.getTransactionManager().getTransaction();
            if (transaction == null) {
                return;
            }
            if (transaction.getStatus() == 1 || transaction.getStatus() == 0) {
                if (HTTPDebugLogger.isEnabled()) {
                    this.trace("Aborting unhandled Tx - " + transaction);
                }
                transaction.rollback();
            }
        }
        catch (SystemException systemException) {
            HTTPLogger.logFailedToLookupTransaction((String)this.context.getLogContext(), (Throwable)systemException);
        }
    }

    private void trace(String string) {
        HTTPDebugLogger.debug(this.request.toStringSimple() + ": " + string);
    }

    private boolean requestHadCookie(Cookie cookie) {
        if (!this.request.isRequestedSessionIdFromCookie()) {
            return false;
        }
        String string = this.request.getSessionHelper().getIncomingSessionCookieValue();
        if (string == null) {
            return false;
        }
        return string.startsWith(cookie.getValue());
    }

    public final WebAppServletContext getContext() {
        return this.context;
    }

    private boolean useHighestCompatibleHttpVersion() {
        return this.getHttpServer().getMBean().isUseHighestCompatibleHTTPVersion();
    }

    private HttpServer getHttpServer() {
        if (this.context == null) {
            return WebService.defaultHttpServer();
        }
        return this.context.getServer();
    }

    private void objectIfCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
    }

    public static ServletResponseImpl getOriginalResponse(ServletResponse servletResponse) {
        while (servletResponse instanceof ServletResponseWrapper) {
            servletResponse = ((ServletResponseWrapper)servletResponse).getResponse();
        }
        if (servletResponse == null) {
            throw new AssertionError((Object)"Original response not available");
        }
        return (ServletResponseImpl)servletResponse;
    }

    public final boolean isInternalDispatch() {
        return this.request.getConnection().isInternalDispatch();
    }

    public long getBytesSentCount() {
        return this.bytesSent;
    }

    public long getMessagesSentCount() {
        return this.messageSent;
    }

    public void registerAttributeListener(ServletResponseAttributeListener servletResponseAttributeListener) {
        if (servletResponseAttributeListener == null) {
            return;
        }
        this.attributeListeners.add(servletResponseAttributeListener);
    }

    private static String initXPoweredByHeaderValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Servlet/2.5 JSP/2.1");
        if (string.equals("MEDIUM")) {
            stringBuffer.append(" (").append("WebLogic/" + version.getPLInfo()[1]).append(")");
        } else if (string.equals("FULL")) {
            stringBuffer.append(" (").append("WebLogic/" + version.getPLInfo()[1]).append(" JDK/");
            stringBuffer.append(System.getProperty("java.version")).append(")");
        }
        return stringBuffer.toString();
    }

    private void checkForCRLFChars(String string, String string2) {
        if (ServletResponseImpl.containsCRLFChars(string2)) {
            throw new IllegalArgumentException("Header:" + string + " Cannot contain CRLF Charcters");
        }
    }

    private void checkForCRLFChars(Cookie cookie) {
        if (cookie != null && ServletResponseImpl.containsCRLFChars(cookie.getValue())) {
            throw new IllegalArgumentException("Cookie:" + cookie.getName() + " Cannot contain CRLF Charcters");
        }
    }

    private static boolean containsCRLFChars(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < CRLF.length; ++i) {
            if (!ServletResponseImpl.containsPattern(string, 0, CRLF[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsPattern(String string, int n, String string2) {
        int n2 = -1;
        n2 = string.indexOf(string2, n);
        if (n2 == -1) {
            return false;
        }
        int n3 = string2.length();
        if (n3 > 2 || n2 + n3 == string.length()) {
            return true;
        }
        char c = string.charAt(n2 + n3);
        if (c == ' ' || c == '\t') {
            return ServletResponseImpl.containsPattern(string, n2 + n3, string2);
        }
        return true;
    }

    void incrementBytesSentCount(long l) {
        this.bytesSent += l;
    }

    void incrementMessageSentCount() {
        ++this.messageSent;
    }

    FileSenderImpl getFileSender() {
        return this.fileSender;
    }

    void setFileSender(FileSenderImpl fileSenderImpl) {
        if (this.fileSender != null) {
            throw new AssertionError((Object)"Attempt to replace FileSender");
        }
        this.fileSender = fileSenderImpl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(super.toString()).append("[\n").append(this.buildFirstLine()).append(this.headers.toString()).append(']');
        return stringBuilder.toString();
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.servlet.internal.ServletResponseImpl");
        _WLDF$INST_FLD_Servlet_Response_Write_Headers_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_Response_Write_Headers_Around_Medium");
        _WLDF$INST_FLD_Servlet_Response_Send_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_Response_Send_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ServletResponseImpl.java", (String)"weblogic.servlet.internal.ServletResponseImpl", (String)"writeHeaders", (String)"()V", (int)1148, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_Response_Write_Headers_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"req", (String)"weblogic.diagnostics.instrumentation.gathering.ServletRequestRenderer", (boolean)false, (boolean)true), null, null)}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ServletResponseImpl.java", (String)"weblogic.servlet.internal.ServletResponseImpl", (String)"send", (String)"()V", (int)1458, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_Response_Send_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"req", (String)"weblogic.diagnostics.instrumentation.gathering.ServletRequestRenderer", (boolean)false, (boolean)true), null, null)}), (boolean)false);
        STATUS_OK_HEADER_1_0 = "HTTP/1.0 200 " + HttpReasonPhraseCoder.getReasonPhrase((int)200) + "\r\n";
        STATUS_OK_HEADER_1_1 = "HTTP/1.1 200 " + HttpReasonPhraseCoder.getReasonPhrase((int)200) + "\r\n";
        noHttpOnlyInternalApps = new ArrayList();
        WebAppContainerMBean webAppContainerMBean = ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getDomain().getWebAppContainer();
        String string = webAppContainerMBean.getXPoweredByHeaderLevel();
        X_POWERED_BY_HEADER_ENABLED = !string.equals("NONE");
        X_POWERED_BY_HEADER = ServletResponseImpl.initXPoweredByHeaderValue(string);
        P3P_HEADER_VALUE = webAppContainerMBean.getP3PHeaderValue();
        P3P_ENABLED = P3P_HEADER_VALUE != null;
        String string2 = System.getProperty("weblogic.cookies.HttpOnlyDisabledInternalApps");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            while (stringTokenizer.hasMoreTokens()) {
                noHttpOnlyInternalApps.add(stringTokenizer.nextToken().trim());
            }
        }
        CRLF = new String[]{"\r\n", "\r%0a", "%0d\n", "%0d%0a", "\r%0A", "%0D\n", "%0D%0A", "%0d%0A", "%0D%0a"};
    }
}

