/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.PrintStream;
import java.net.MalformedURLException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import javax.management.ObjectName;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServletRuntimeMBean;
import weblogic.protocol.ServerURL;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ProtocolHandlerHTTP;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.StubLifecycleHelper;
import weblogic.servlet.internal.URLMatchHelper;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.utils.URLMapping;
import weblogic.utils.concurrent.atomic.AtomicFactory;
import weblogic.utils.concurrent.atomic.AtomicInteger;
import weblogic.utils.concurrent.atomic.AtomicLong;

public final class ServletRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ServletRuntimeMBean {
    private static final long serialVersionUID = -7688216863798470821L;
    private int reloadCount;
    private final AtomicInteger invokeCount = AtomicFactory.createAtomicInteger();
    private final AtomicLong totalExecutionTime = AtomicFactory.createAtomicLong();
    private long highExecutionTime;
    private long lowExecutionTime = -1L;
    private ServletStubImpl stub;

    private ServletRuntimeMBeanImpl(String string, ServletStubImpl servletStubImpl) throws ManagementException {
        super(string, (RuntimeMBean)servletStubImpl.getContext().getRuntimeMBean(), true, "Servlets");
        this.stub = servletStubImpl;
    }

    public static ServletRuntimeMBeanImpl newInstance(final ServletStubImpl servletStubImpl) throws ManagementException {
        try {
            return (ServletRuntimeMBeanImpl)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new ServletRuntimeMBeanImpl(servletStubImpl.getServletName(), servletStubImpl);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            return null;
        }
    }

    public void destroy() {
        block2: {
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ManagementException {
                        ServletRuntimeMBeanImpl.this.unregister();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (!(exception instanceof ManagementException)) break block2;
                HTTPLogger.logErrorUnregisteringServletRuntime((ObjectName)this.getObjectName(), (Throwable)exception);
            }
        }
    }

    public String getServletName() {
        return this.stub.getServletName();
    }

    public String getServletClassName() {
        return this.stub.getClassName();
    }

    void incReloadCount() {
        ++this.reloadCount;
    }

    public int getReloadTotalCount() {
        return this.reloadCount;
    }

    void incInvocationCount() {
        this.invokeCount.incrementAndGet();
    }

    public int getInvocationTotalCount() {
        return this.invokeCount.get();
    }

    public int getPoolMaxCapacity() {
        StubLifecycleHelper stubLifecycleHelper = this.stub.getLifecycleHelper();
        if (stubLifecycleHelper == null) {
            return 0;
        }
        return stubLifecycleHelper.getPoolCapacity();
    }

    void addExecutionTimeTotal(long l) {
        this.totalExecutionTime.addAndGet(l);
    }

    public long getExecutionTimeTotal() {
        return this.totalExecutionTime.get();
    }

    void setExecutionTimeHighLow(long l) {
        if (l > this.highExecutionTime) {
            this.highExecutionTime = l;
        }
        if (l < this.lowExecutionTime || this.lowExecutionTime < 0L) {
            this.lowExecutionTime = l;
        }
    }

    public int getExecutionTimeHigh() {
        return (int)this.highExecutionTime;
    }

    public int getExecutionTimeLow() {
        return (int)(this.lowExecutionTime < 0L ? 0L : this.lowExecutionTime);
    }

    public int getExecutionTimeAverage() {
        int n = this.invokeCount.get();
        if (n <= 0) {
            return 0;
        }
        return (int)(this.getExecutionTimeTotal() / (long)n);
    }

    public String getServletPath() {
        URLMapping uRLMapping = this.getServletContext().getServletMapping();
        Object[] objectArray = uRLMapping.values();
        if (objectArray == null) {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            URLMatchHelper uRLMatchHelper = (URLMatchHelper)objectArray[i];
            if (uRLMatchHelper.getServletStub() != this.stub) continue;
            return uRLMatchHelper.getPattern();
        }
        return null;
    }

    public String getContextPath() {
        return this.getServletContext().getContextPath();
    }

    public String getURL() {
        ServerURL serverURL;
        String string;
        String string2;
        String string3 = this.getServletPath();
        if (string3 == null) {
            return null;
        }
        HttpServer httpServer = this.getServletContext().getServer();
        String string4 = httpServer.getVirtualHostNames()[0];
        if (string4 == null) {
            string4 = httpServer.getListenAddress();
        }
        if ((string2 = this.getContextPath()).equals("/")) {
            string2 = "";
        }
        if ((string = ChannelHelper.getURL(ProtocolHandlerHTTP.PROTOCOL_HTTP)) == null) {
            return null;
        }
        try {
            serverURL = new ServerURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        int n = serverURL.getPort();
        if (serverURL.getProtocol().equalsIgnoreCase("http") && n == 80) {
            n = -1;
        }
        return serverURL.getProtocol() + "://" + string4 + (n == -1 ? "" : ":" + n) + string2 + string3;
    }

    public String[] getURLPatterns() {
        URLMapping uRLMapping = this.getServletContext().getServletMapping();
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = uRLMapping.values();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                URLMatchHelper uRLMatchHelper = (URLMatchHelper)objectArray[i];
                if (uRLMatchHelper == null || uRLMatchHelper.getServletStub() != this.stub) continue;
                arrayList.add(uRLMatchHelper.getPattern());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean isInternalServlet() {
        return this.stub.isInternalServlet();
    }

    private WebAppServletContext getServletContext() {
        return (WebAppServletContext)this.stub.getServletContext();
    }

    public static void dumpServlet(PrintStream printStream, ServletRuntimeMBean servletRuntimeMBean) {
        ServletRuntimeMBeanImpl.println(printStream, "        SERVLET NAME: " + servletRuntimeMBean.getName());
        ServletRuntimeMBeanImpl.println(printStream, "        ReloadTotalCount: " + servletRuntimeMBean.getReloadTotalCount());
        ServletRuntimeMBeanImpl.println(printStream, "        InvocationTotalCount: " + servletRuntimeMBean.getInvocationTotalCount());
        ServletRuntimeMBeanImpl.println(printStream, "        PoolMaxCapacity: " + servletRuntimeMBean.getPoolMaxCapacity());
        ServletRuntimeMBeanImpl.println(printStream, "        ExecutionTimeTotal: " + servletRuntimeMBean.getExecutionTimeTotal());
        ServletRuntimeMBeanImpl.println(printStream, "        ExecutionTimeHigh: " + servletRuntimeMBean.getExecutionTimeHigh());
        ServletRuntimeMBeanImpl.println(printStream, "        ExecutionTimeLow: " + servletRuntimeMBean.getExecutionTimeLow());
        ServletRuntimeMBeanImpl.println(printStream, "        ExecutionTimeAverage: " + servletRuntimeMBean.getExecutionTimeAverage());
    }

    private static void println(PrintStream printStream, String string) {
        printStream.println(string + "<br>");
    }
}

