/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ServletRuntimeMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.FilterChainImpl;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.RequestCallback;
import weblogic.servlet.internal.RequestCallbackImpl;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.ServletRuntimeMBeanImpl;
import weblogic.servlet.internal.StubLifecycleHelper;
import weblogic.servlet.internal.StubSecurityHelper;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.AddToMapException;
import weblogic.servlet.jsp.CompilationException;
import weblogic.servlet.jsp.JspFileNotFoundException;
import weblogic.servlet.jsp.JspStub;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.ChangeAwareClassLoader;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.IteratorEnumerator;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class ServletStubImpl
implements ServletConfig {
    static final String DISPATCH_POLICY = "wl-dispatch-policy";
    private static final String CLASSPATH_SERVLET_NAME = "weblogic.servlet.ClasspathServlet";
    private static final String FILE_SERVLET_NAME = "weblogic.servlet.FileServlet";
    private static final String HTTP_CLUSTER_SERVLET_NAME = "weblogic.servlet.proxy.HttpClusterServlet";
    private static final String HTTP_PROXY_SERVLET_NAME = "weblogic.servlet.proxy.HttpProxyServlet";
    private static final String PUBSUB_CONTROLLER_SERVLET_NAME = "com.bea.httppubsub.servlet.ControllerServlet";
    private final String name;
    protected final String className;
    private final WebAppServletContext context;
    private final Map initParams;
    private final StubSecurityHelper securityHelper;
    private WorkManager workManager;
    private StubLifecycleHelper lifecycleHelper;
    private WorkManager sessionFetchingWorkManager;
    private boolean filtersInvoked = false;
    private boolean isInternalServlet = false;
    private final boolean isClasspathServlet;
    private final boolean isFileServlet;
    private final boolean isProxyServlet;
    private final boolean isPubSubControllerServlet;
    private boolean dynamicallyGenerated = false;
    private ServletRuntimeMBeanImpl runtime;
    static final long serialVersionUID = -7625015173865500484L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_Execute_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    public ServletStubImpl(String string, String string2, WebAppServletContext webAppServletContext, Map map) {
        this.name = string;
        this.className = string2;
        this.isClasspathServlet = CLASSPATH_SERVLET_NAME.equals(string2);
        this.isFileServlet = FILE_SERVLET_NAME.equals(string2);
        this.isProxyServlet = HTTP_CLUSTER_SERVLET_NAME.equals(string2) || HTTP_PROXY_SERVLET_NAME.equals(string2);
        this.isPubSubControllerServlet = PUBSUB_CONTROLLER_SERVLET_NAME.equals(string2);
        this.context = webAppServletContext;
        this.initParams = map;
        this.setDispatchPolicy(this.getInitParameter(DISPATCH_POLICY));
        String string3 = webAppServletContext.getServer().getMBean().getWorkManagerForRemoteSessionFetching();
        this.setWorkManagerForSessionFetching(string3);
        this.securityHelper = new StubSecurityHelper(this);
    }

    public final void initRuntime() throws ManagementException {
        Debug.assertion((this.context.getRuntimeMBean() != null ? 1 : 0) != 0);
        if (this.runtime != null) {
            return;
        }
        this.runtime = ServletRuntimeMBeanImpl.newInstance(this);
    }

    final void setDispatchPolicy(String string) {
        if (string != null) {
            this.workManager = WorkManagerFactory.getInstance().find(string, this.context.getApplicationId(), this.context.getId());
        }
    }

    private void setWorkManagerForSessionFetching(String string) {
        if (string != null) {
            this.sessionFetchingWorkManager = WorkManagerFactory.getInstance().find(string, this.context.getApplicationId(), this.context.getId());
        }
    }

    final WorkManager getWorkManagerForSessionFetching() {
        return this.sessionFetchingWorkManager;
    }

    final WorkManager getWorkManager() {
        if (this.workManager != null) {
            return this.workManager;
        }
        return this.context.getConfigManager().getWorkManager();
    }

    protected String getDefaultContentType() {
        return null;
    }

    final ServletRuntimeMBean getRuntimeMBean() {
        return this.runtime;
    }

    final boolean isSingleThreadModel() {
        if (this.lifecycleHelper == null) {
            return false;
        }
        return this.lifecycleHelper.isSingleThreadModel();
    }

    final boolean isFutureResponseServlet() {
        if (this.lifecycleHelper == null) {
            return false;
        }
        return this.lifecycleHelper.isFutureResponseServlet();
    }

    public final boolean isProxyServlet() {
        return this.isProxyServlet;
    }

    final boolean isInternalServlet() {
        return this.isInternalServlet;
    }

    final void setInternalServlet(boolean bl) {
        this.isInternalServlet = bl;
    }

    public final String getClassName() {
        return this.className;
    }

    public final boolean isClasspathServlet() {
        return this.isClasspathServlet;
    }

    public final boolean isFileServlet() {
        return this.isFileServlet;
    }

    public final boolean isPubSubControllerServlet() {
        return this.isPubSubControllerServlet;
    }

    public final void execute(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.execute(servletRequest, servletResponse, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ServletRequest servletRequest, ServletResponse servletResponse, FilterChainImpl filterChainImpl) throws ServletException, IOException {
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block36: {
            block35: {
                block34: {
                    bl = _WLDF$INST_FLD_Servlet_Execute_Around_Medium.isEnabledAndNotDyeFiltered();
                    diagnosticActionArray = null;
                    diagnosticActionStateArray = null;
                    Object var19_7 = null;
                    if (bl) {
                        Object[] objectArray = null;
                        if (_WLDF$INST_FLD_Servlet_Execute_Around_Medium.isArgumentsCaptureNeeded()) {
                            objectArray = new Object[]{this, servletRequest, servletResponse, filterChainImpl};
                        }
                        DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_Execute_Around_Medium;
                        diagnosticActionArray = delegatingMonitor.getActions();
                        diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                        InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                    }
                    try {
                        Servlet servlet;
                        void var7_18;
                        void var6_15;
                        ServletRequestImpl servletRequestImpl;
                        block37: {
                            Object object;
                            ServletResponseImpl servletResponseImpl;
                            block39: {
                                block38: {
                                    if (filterChainImpl == null) {
                                        servletRequestImpl = ServletRequestImpl.getOriginalRequest(servletRequest);
                                        servletResponseImpl = servletRequestImpl.getResponse();
                                    } else {
                                        if (!this.filtersInvoked) {
                                            this.filtersInvoked = true;
                                        }
                                        servletRequestImpl = filterChainImpl.getOrigRequest();
                                        servletResponseImpl = filterChainImpl.getOrigResponse();
                                    }
                                    if (servletRequest instanceof HttpServletRequest) {
                                        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                                    } else {
                                        ServletRequestImpl servletRequestImpl2 = servletRequestImpl;
                                    }
                                    if (servletResponse instanceof HttpServletResponse) {
                                        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                                    } else {
                                        ServletResponseImpl servletResponseImpl2 = servletResponseImpl;
                                    }
                                    if (this.getDefaultContentType() != null) {
                                        servletResponse.setContentType(this.getDefaultContentType());
                                    }
                                    try {
                                        object = new RequestCallbackImpl((HttpServletRequest)var6_15, (HttpServletResponse)var7_18, servletResponseImpl);
                                        if (this.lifecycleHelper != null) {
                                            this.checkForReload((RequestCallback)object);
                                        } else {
                                            ServletStubImpl servletStubImpl = this;
                                            synchronized (servletStubImpl) {
                                                if (this.lifecycleHelper == null) {
                                                    this.prepareServlet((RequestCallback)object);
                                                }
                                            }
                                        }
                                        servlet = this.lifecycleHelper.getServlet();
                                    }
                                    catch (JspFileNotFoundException jspFileNotFoundException) {
                                        this.context.removeServletStub(this, false);
                                        throw jspFileNotFoundException;
                                    }
                                    catch (CompilationException compilationException) {
                                        var6_15.setAttribute("javax.servlet.error.exception", (Object)compilationException);
                                        this.context.getErrorManager().setErrorAttributes((HttpServletRequest)var6_15, compilationException.getJavaFileName(), compilationException);
                                        this.context.removeServletStub(this, false);
                                        throw new ServletException((Throwable)compilationException);
                                    }
                                    if (!(servlet instanceof HttpJspPage) || (object = servletRequestImpl.getRequestParameters().peekParameter("jsp_precompile")) == null) break block37;
                                    if ("".equals(object)) break block38;
                                    if (!"true".equals(object)) break block39;
                                }
                                Object var17_25 = null;
                                if (!bl) return;
                                break block34;
                            }
                            if (!"false".equals(object)) {
                                servletResponseImpl.sendError(500);
                                break block35;
                            }
                        }
                        if (HTTPDebugLogger.isEnabled()) {
                            HTTPDebugLogger.debug("Start to execute servlet: " + this.toString());
                        }
                        long l = System.currentTimeMillis();
                        try {
                            Throwable throwable = this.securityHelper.invokeServlet(servletRequest, (HttpServletRequest)var6_15, servletRequestImpl, servletResponse, (HttpServletResponse)var7_18, servlet);
                            if (throwable == null) break block36;
                            if (throwable instanceof AddToMapException) {
                                this.onAddToMapException(throwable, servletRequestImpl, servletRequest, servletResponse, filterChainImpl);
                                break block36;
                            }
                            if (throwable instanceof UnavailableException) {
                                UnavailableException unavailableException = (UnavailableException)throwable;
                                if (unavailableException.isPermanent()) {
                                    this.context.removeServletStub(this, true);
                                    throw unavailableException;
                                }
                                this.lifecycleHelper.makeUnavailable(unavailableException);
                                throw unavailableException;
                            }
                            if (throwable instanceof ServletException) {
                                throw (ServletException)throwable;
                            }
                            if (throwable instanceof IOException) {
                                throw (IOException)throwable;
                            }
                            if (!(throwable instanceof RuntimeException)) throw new ServletException(throwable);
                            throw (RuntimeException)throwable;
                        }
                        finally {
                            this.recordInvoke(l);
                            if (HTTPDebugLogger.isEnabled()) {
                                HTTPDebugLogger.debug("Servlet execution completed: " + this.toString());
                            }
                            if (this.lifecycleHelper != null) {
                                this.lifecycleHelper.returnServlet(servlet);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_28 = null;
                        if (!bl) throw throwable;
                        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Execute_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
                        throw throwable;
                    }
                }
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Execute_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                return;
            }
            Object var17_26 = null;
            if (!bl) return;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Execute_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            return;
        }
        Object var17_27 = null;
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Execute_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAddToMapException(Throwable throwable, ServletRequestImpl servletRequestImpl, ServletRequest servletRequest, ServletResponse servletResponse, FilterChainImpl filterChainImpl) throws ServletException, IOException {
        ServletStubImpl servletStubImpl;
        AddToMapException addToMapException = (AddToMapException)((Object)throwable);
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.context.getLogContext() + ": registering servlet stub dynamically for the JSP : " + servletRequestImpl.getRequestURI());
        }
        WebAppServletContext webAppServletContext = this.context;
        synchronized (webAppServletContext) {
            servletStubImpl = this.context.getServletStub(addToMapException.pattern);
            if (servletStubImpl != null) {
                if (servletStubImpl.getClassName().equals(this.getClassName())) {
                    servletStubImpl = null;
                } else if (servletStubImpl != addToMapException.sstub) {
                    if (servletStubImpl instanceof JspStub && addToMapException.sstub instanceof JspStub) {
                        addToMapException.sstub.destroy();
                    } else {
                        servletStubImpl = null;
                    }
                }
            }
            if (servletStubImpl == null) {
                String string = addToMapException.pattern;
                if (!this.context.getJSPManager().isJspExactMapping()) {
                    string = string + "/*";
                }
                this.context.registerServletStub(string, addToMapException.sstub);
                this.context.registerServletMap(string, string, addToMapException.sstub);
                servletStubImpl = addToMapException.sstub;
                try {
                    servletStubImpl.initRuntime();
                }
                catch (ManagementException managementException) {
                    throw new ServletException((Throwable)managementException);
                }
            }
        }
        if (servletRequestImpl.getServletStub() == this) {
            servletRequestImpl.setServletStub(servletStubImpl);
        }
        servletStubImpl.dynamicallyGenerated = true;
        servletStubImpl.execute(servletRequest, servletResponse, filterChainImpl);
    }

    private void recordInvoke(long l) {
        if (this.runtime == null) {
            return;
        }
        this.runtime.incInvocationCount();
        long l2 = System.currentTimeMillis() - l;
        if (l2 >= 0L) {
            this.runtime.setExecutionTimeHighLow(l2);
            this.runtime.addExecutionTimeTotal(l2);
        }
    }

    protected final synchronized void destroy() {
        if (this.lifecycleHelper != null) {
            this.lifecycleHelper.destroy();
            this.lifecycleHelper = null;
        }
        if (this.runtime != null) {
            this.runtime.destroy();
            this.runtime = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForReload(RequestCallback requestCallback) throws ServletException, UnavailableException, IOException {
        long l = this.context.getConfigManager().getServletReloadCheckSecs();
        if (l < 0L) {
            return;
        }
        if (this.lifecycleHelper.getContextLoader() != this.context.getServletClassLoader()) {
            ServletStubImpl servletStubImpl = this;
            synchronized (servletStubImpl) {
                if (this.lifecycleHelper.getContextLoader() != this.context.getServletClassLoader()) {
                    this.lifecycleHelper.destroy();
                    this.context.removeTransientAttributes(this.lifecycleHelper.getContextLoader());
                    this.prepareServlet(requestCallback);
                }
            }
        }
        if (!this.filtersInvoked && this.checkReloadTimeout(l)) {
            ServletStubImpl servletStubImpl = this;
            synchronized (servletStubImpl) {
                if (this.lifecycleHelper.getContextLoader() != this.context.getServletClassLoader()) {
                    this.lifecycleHelper.destroy();
                    this.context.removeTransientAttributes(this.lifecycleHelper.getContextLoader());
                    this.prepareServlet(requestCallback);
                } else if (this.checkReloadTimeout(l) && this.needToReload()) {
                    this.lifecycleHelper.destroy();
                    this.context.reloadServletClassLoader();
                    this.prepareServlet(requestCallback);
                }
            }
        }
    }

    private boolean checkReloadTimeout(long l) {
        if (this.lifecycleHelper == null) {
            return true;
        }
        ClassLoader classLoader = this.lifecycleHelper.getContextLoader();
        if (!(classLoader instanceof ChangeAwareClassLoader)) {
            return false;
        }
        ChangeAwareClassLoader changeAwareClassLoader = (ChangeAwareClassLoader)classLoader;
        long l2 = System.currentTimeMillis();
        return l2 - l * 1000L > changeAwareClassLoader.getLastChecked();
    }

    private boolean needToReload() {
        if (this.lifecycleHelper == null) {
            return false;
        }
        ClassLoader classLoader = this.lifecycleHelper.getContextLoader();
        if (!(classLoader instanceof ChangeAwareClassLoader)) {
            return false;
        }
        ChangeAwareClassLoader changeAwareClassLoader = (ChangeAwareClassLoader)classLoader;
        return !changeAwareClassLoader.upToDate();
    }

    protected void prepareServlet(RequestCallback requestCallback) throws ServletException, UnavailableException, IOException {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.context.getLogContext() + ": Preparing servlet: " + this.name);
        }
        try {
            ClassLoader classLoader = this.getClassLoader();
            Class<?> clazz = classLoader.loadClass(this.className);
            if (this.runtime != null) {
                this.runtime.incReloadCount();
            }
            this.lifecycleHelper = new StubLifecycleHelper(this, clazz, this.context.getServletClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = this.context.getClasspath();
            String string2 = this.context.getLogContext();
            Throwable throwable = classNotFoundException.getException();
            if (throwable == null) {
                throwable = classNotFoundException;
            }
            Loggable loggable = HTTPLogger.logServletClassNotFoundLoggable((String)string2, (String)this.name, (String)this.className, (String)string, (Throwable)throwable);
            loggable.log();
            throw new ServletException(loggable.getMessage().replace(string, ""));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = this.context.getClasspath();
            String string3 = this.context.getLogContext();
            Loggable loggable = HTTPLogger.logServletClassDefNotFoundLoggable((String)string3, (String)this.name, (String)this.className, (String)string, (Throwable)noClassDefFoundError);
            loggable.log();
            throw new ServletException(loggable.getMessage().replace(string, ""));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = this.context.getClasspath();
            String string4 = this.context.getLogContext();
            Loggable loggable = HTTPLogger.logServletUnsatisfiedLinkLoggable((String)string4, (String)this.name, (String)this.className, (String)string, (Throwable)unsatisfiedLinkError);
            loggable.log();
            throw new ServletException(loggable.getMessage().replace(string, ""));
        }
        catch (VerifyError verifyError) {
            String string = this.context.getLogContext();
            Loggable loggable = HTTPLogger.logServletVerifyErrorLoggable((String)string, (String)this.name, (String)this.className, (Throwable)verifyError);
            loggable.log();
            throw new ServletException(loggable.getMessage());
        }
        catch (ClassFormatError classFormatError) {
            String string = this.context.getLogContext();
            Loggable loggable = HTTPLogger.logServletClassFormatErrorLoggable((String)string, (String)this.name, (String)this.className, (Throwable)classFormatError);
            loggable.log();
            throw new ServletException(loggable.getMessage());
        }
        catch (LinkageError linkageError) {
            String string = this.context.getClasspath();
            String string5 = this.context.getLogContext();
            Loggable loggable = HTTPLogger.logServletLinkageErrorLoggable((String)string5, (String)this.name, (String)this.className, (String)string, (Throwable)linkageError);
            loggable.log();
            throw new ServletException(loggable.getMessage().replace(string, ""));
        }
    }

    protected ClassLoader getClassLoader() {
        return this.context.getServletClassLoader();
    }

    public final ServletContext getServletContext() {
        return this.context;
    }

    public final String getServletName() {
        return this.name;
    }

    Map getInitParametersMap() {
        return this.initParams;
    }

    public final Enumeration getInitParameterNames() {
        if (this.initParams == null) {
            return new EmptyEnumerator();
        }
        return new IteratorEnumerator(this.initParams.keySet().iterator());
    }

    public final String getInitParameter(String string) {
        if (this.initParams == null) {
            return null;
        }
        return (String)this.initParams.get(string);
    }

    public final String toString() {
        return super.toString() + " - " + this.getServletName() + " class: '" + this.className + "'";
    }

    public final boolean isDynamicallyGenerated() {
        return this.dynamicallyGenerated;
    }

    public final StubSecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public StubLifecycleHelper getLifecycleHelper() {
        return this.lifecycleHelper;
    }

    public WebAppServletContext getContext() {
        return this.context;
    }

    static final ServletStubImpl getUnavailableStub(ServletStubImpl servletStubImpl) {
        return new ServletStubImpl(servletStubImpl.getServletName(), servletStubImpl.getClassName(), (WebAppServletContext)servletStubImpl.getServletContext(), null){

            public void execute(ServletRequest servletRequest, ServletResponse servletResponse, FilterChainImpl filterChainImpl) throws ServletException, IOException {
                throw new UnavailableException("Stub had been removed earlier due to UnavailableException with no timeout.");
            }
        };
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.servlet.internal.ServletStubImpl");
        _WLDF$INST_FLD_Servlet_Execute_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_Execute_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ServletStubImpl.java", (String)"weblogic.servlet.internal.ServletStubImpl", (String)"execute", (String)"(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;Lweblogic/servlet/internal/FilterChainImpl;)V", (int)207, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_Execute_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"this", (String)"weblogic.diagnostics.instrumentation.gathering.ServletStubImplRenderer", (boolean)false, (boolean)true), null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"req", (String)"weblogic.diagnostics.instrumentation.gathering.ServletRequestRenderer", (boolean)false, (boolean)true), null, null})}), (boolean)false);
    }
}

