/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.http.FutureResponseModel;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.utils.collections.StackPool;

public final class StubLifecycleHelper {
    private final ServletStubImpl stub;
    private final Class clazz;
    private final boolean isSingleThreadModel;
    private final boolean isFutureResponseServlet;
    private final ClassLoader contextLoader;
    private Servlet theServlet;
    private StackPool servletPool;
    private UnavailableException unavailException;
    private long unavailTime;
    private boolean permUnavailable = false;

    StubLifecycleHelper(ServletStubImpl servletStubImpl, Class clazz, ClassLoader classLoader) throws ServletException {
        this.stub = servletStubImpl;
        this.clazz = clazz;
        this.contextLoader = classLoader;
        this.isSingleThreadModel = SingleThreadModel.class.isAssignableFrom(this.clazz);
        this.isFutureResponseServlet = FutureResponseModel.class.isAssignableFrom(clazz);
        if (this.isSingleThreadModel) {
            int n = this.stub.getContext().getConfigManager().getSingleThreadedServletPoolSize();
            this.servletPool = new StackPool(n);
            for (int i = 0; i < n; ++i) {
                Servlet servlet = this.createOneInstance();
                this.servletPool.add((Object)servlet);
            }
        } else {
            this.theServlet = this.createOneInstance();
        }
    }

    private synchronized Servlet createOneInstance() throws ServletException {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        thread2.setContextClassLoader(this.contextLoader);
        try {
            Servlet servlet = this.stub.getSecurityHelper().createServlet(this.clazz);
            return servlet;
        }
        catch (UnavailableException unavailableException) {
            this.unavailException = unavailableException;
            int n = this.unavailException.getUnavailableSeconds();
            if (n > 0) {
                this.unavailTime = System.currentTimeMillis() + (long)(n * 1000);
            } else {
                this.permUnavailable = true;
            }
            throw unavailableException;
        }
        finally {
            thread2.setContextClassLoader(classLoader);
        }
    }

    public synchronized void makeUnavailable(UnavailableException unavailableException) {
        this.unavailException = unavailableException;
        int n = this.unavailException.getUnavailableSeconds();
        if (n > 0) {
            this.unavailTime = System.currentTimeMillis() + (long)(n * 1000);
        } else {
            this.permUnavailable = true;
        }
    }

    public int getPoolCapacity() {
        if (this.isSingleThreadModel) {
            return this.servletPool.capacity();
        }
        return 0;
    }

    public Servlet getServlet() throws ServletException {
        this.checkIfUnavailable();
        if (this.isSingleThreadModel) {
            Servlet servlet = (Servlet)this.servletPool.remove();
            if (servlet != null) {
                return servlet;
            }
            return this.createOneInstance();
        }
        return this.theServlet;
    }

    private void checkIfUnavailable() throws UnavailableException {
        if (this.unavailException != null) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug(this.stub.getContext().getLogContext() + ": servlet " + this.stub.getServletName() + " is unavaialable", (Exception)((Object)this.unavailException));
            }
            if (this.permUnavailable) {
                HTTPLogger.logPermUnavailable((String)this.stub.getContext().getLogContext(), (String)this.stub.getServletName());
                throw this.unavailException;
            }
            if (this.unavailTime > System.currentTimeMillis()) {
                HTTPLogger.logTimeUnavailable((String)this.stub.getContext().getLogContext(), (String)this.stub.getServletName(), (long)(this.unavailTime - System.currentTimeMillis() / 1000L));
                throw this.unavailException;
            }
            this.unavailException = null;
        }
    }

    public final void returnServlet(Servlet servlet) {
        if (this.isSingleThreadModel) {
            if (this.clazz == servlet.getClass() && this.servletPool.add((Object)servlet)) {
                return;
            }
            this.stub.getSecurityHelper().destroyServlet(servlet);
        }
    }

    public synchronized void destroy() {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("destroyServlet: Destroying all servlets named: '" + this.stub.getServletName() + "'");
        }
        if (this.isSingleThreadModel) {
            while (!this.servletPool.isEmpty()) {
                this.destroyOneInstance((Servlet)this.servletPool.remove());
            }
        } else {
            this.destroyOneInstance(this.theServlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyOneInstance(Servlet servlet) {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        thread2.setContextClassLoader(this.contextLoader);
        try {
            this.stub.getSecurityHelper().destroyServlet(servlet);
        }
        catch (NullPointerException nullPointerException) {
            HTTPLogger.logNPEDuringServletDestroy((String)this.stub.getContext().getLogContext(), (String)this.clazz.getName(), (Throwable)nullPointerException);
        }
        finally {
            thread2.setContextClassLoader(classLoader);
        }
    }

    public boolean isSingleThreadModel() {
        return this.isSingleThreadModel;
    }

    public boolean isFutureResponseServlet() {
        return this.isFutureResponseServlet;
    }

    public ClassLoader getContextLoader() {
        return this.contextLoader;
    }
}

