/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.login.LoginException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.JspStub;
import weblogic.servlet.security.internal.WebAppSecurity;

public final class StubSecurityHelper {
    private final ServletStubImpl stub;
    private PrincipalAuthenticator pa = null;
    private AuthenticatedSubject initAs = null;
    private AuthenticatedSubject destroyAs = null;
    private AuthenticatedSubject runAs = null;
    private String runAsIdentity = null;
    private ConcurrentHashMap securityRoleMap;

    public StubSecurityHelper(ServletStubImpl servletStubImpl) {
        this.stub = servletStubImpl;
    }

    public final void addRoleLink(String string, String string2) {
        if (this.securityRoleMap == null) {
            this.securityRoleMap = new ConcurrentHashMap();
        }
        this.securityRoleMap.put(string, string2);
    }

    public final String getRoleLink(String string) {
        if (this.securityRoleMap == null) {
            return null;
        }
        return (String)this.securityRoleMap.get(string);
    }

    final Iterator getRoleNames() {
        if (this.securityRoleMap == null) {
            return null;
        }
        return this.securityRoleMap.keySet().iterator();
    }

    public Servlet createServlet(Class clazz) throws ServletException {
        ServletInitAction servletInitAction = new ServletInitAction(this.stub, clazz);
        Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)this.getInitAsSubject(), (PrivilegedAction)servletInitAction);
        if (throwable instanceof ServletException) {
            throw (ServletException)throwable;
        }
        if (throwable instanceof Throwable) {
            throw new ServletException(throwable);
        }
        return servletInitAction.getServlet();
    }

    private AuthenticatedSubject getInitAsSubject() {
        if (this.initAs != null) {
            return this.initAs;
        }
        if (this.runAs != null) {
            return this.runAs;
        }
        return SubjectUtils.getAnonymousSubject();
    }

    public void destroyServlet(Servlet servlet) {
        ServletDestroyAction servletDestroyAction = new ServletDestroyAction(servlet, this.stub.getContext());
        Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)this.getDestroyAsSubject(), (PrivilegedAction)servletDestroyAction);
        if (throwable != null) {
            HTTPLogger.logServletFailedOnDestroy((String)this.stub.getContext().getLogContext(), (String)this.stub.getServletName(), (Throwable)throwable);
        }
    }

    private AuthenticatedSubject getDestroyAsSubject() {
        if (this.destroyAs != null) {
            return this.destroyAs;
        }
        if (this.runAs != null) {
            return this.runAs;
        }
        return SubjectUtils.getAnonymousSubject();
    }

    private PrincipalAuthenticator getPrincipalAuthenticator() {
        if (this.pa != null) {
            return this.pa;
        }
        this.pa = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (String)this.stub.getContext().getSecurityRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        return this.pa;
    }

    public Throwable invokeServlet(ServletRequest servletRequest, HttpServletRequest httpServletRequest, ServletRequestImpl servletRequestImpl, ServletResponse servletResponse, HttpServletResponse httpServletResponse, Servlet servlet) throws ServletException {
        ServletServiceAction servletServiceAction = new ServletServiceAction(servletRequest, servletRequestImpl, servletResponse, servlet, this.stub);
        if (this.runAsIdentity != null) {
            AuthenticatedSubject authenticatedSubject;
            try {
                authenticatedSubject = this.getPrincipalAuthenticator().impersonateIdentity(this.runAsIdentity, WebAppSecurity.getContextHandler(httpServletRequest, httpServletResponse));
            }
            catch (LoginException loginException) {
                Loggable loggable = HTTPLogger.logRunAsUserCouldNotBeResolvedLoggable((String)this.runAsIdentity, (String)this.stub.getServletName(), (String)this.stub.getContext().getContextPath(), (Throwable)loginException);
                loggable.log();
                throw new ServletException((Throwable)loginException);
            }
            return (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)servletServiceAction);
        }
        return (Throwable)servletServiceAction.run();
    }

    final String getRunAsIdentity() {
        return this.runAsIdentity;
    }

    final void setRunAsIdentity(String string) throws DeploymentException {
        try {
            this.runAsIdentity = string;
            this.runAs = this.getPrincipalAuthenticator().impersonateIdentity(string);
        }
        catch (LoginException loginException) {
            Loggable loggable = HTTPLogger.logRunAsUserCouldNotBeResolvedLoggable((String)string, (String)this.stub.getServletName(), (String)this.stub.getContext().getContextPath(), (Throwable)loginException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        this.checkDeployUserPrivileges(this.runAs, "run-as");
    }

    final void setInitAsIdentity(String string) throws DeploymentException {
        try {
            this.initAs = this.getPrincipalAuthenticator().impersonateIdentity(string);
        }
        catch (LoginException loginException) {
            Loggable loggable = HTTPLogger.logRunAsUserCouldNotBeResolvedLoggable((String)string, (String)this.stub.getServletName(), (String)this.stub.getContext().getContextPath(), (Throwable)loginException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        this.checkDeployUserPrivileges(this.initAs, "init-as");
    }

    final void setDestroyAsIdentity(String string) throws DeploymentException {
        try {
            this.destroyAs = this.getPrincipalAuthenticator().impersonateIdentity(string);
        }
        catch (LoginException loginException) {
            Loggable loggable = HTTPLogger.logRunAsUserCouldNotBeResolvedLoggable((String)string, (String)this.stub.getServletName(), (String)this.stub.getContext().getContextPath(), (Throwable)loginException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        this.checkDeployUserPrivileges(this.destroyAs, "destroy-as");
    }

    private void checkDeployUserPrivileges(AuthenticatedSubject authenticatedSubject, String string) throws DeploymentException {
        ApplicationContextInternal applicationContextInternal;
        AuthenticatedSubject authenticatedSubject2;
        if (!(!SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject) || (authenticatedSubject2 = (applicationContextInternal = ApplicationAccess.getApplicationAccess().getCurrentApplicationContext()).getDeploymentInitiator()) == null || applicationContextInternal.isStaticDeploymentOperation() && SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject2) || SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject2))) {
            throw new DeploymentException("The " + string + " user : " + authenticatedSubject + " has higher privileges than the deployment " + "user : " + authenticatedSubject2 + ". Hence this deployment user " + "cannot perform the current deployment action. Try the " + "deployment action with admin privileged user.");
        }
    }

    private static final class ServletDestroyAction
    implements PrivilegedAction {
        final Servlet servlet;
        final WebAppServletContext context;

        ServletDestroyAction(Servlet servlet, WebAppServletContext webAppServletContext) {
            this.servlet = servlet;
            this.context = webAppServletContext;
        }

        public Object run() {
            try {
                this.servlet.destroy();
            }
            catch (Throwable throwable) {
                return throwable;
            }
            try {
                this.context.getComponentCreator().notifyPreDestroy(this.servlet);
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    private static final class ServletInitAction
    implements PrivilegedAction {
        private final ServletStubImpl stub;
        private final Class clazz;
        private Servlet servlet = null;

        public ServletInitAction(ServletStubImpl servletStubImpl, Class clazz) {
            this.stub = servletStubImpl;
            this.clazz = clazz;
        }

        public Servlet getServlet() {
            return this.servlet;
        }

        public Object run() {
            try {
                this.servlet = this.stub instanceof JspStub ? (Servlet)this.clazz.newInstance() : this.stub.getContext().getComponentCreator().createServletInstance(this.stub.getClassName());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                HTTPLogger.logInstantiateError((String)this.stub.getContext().getLogContext(), (String)this.stub.getServletName(), (Throwable)noSuchMethodError);
                return new ServletException("Servlet class: '" + this.stub.getClassName() + "' doesn't have a default constructor");
            }
            catch (InstantiationException instantiationException) {
                HTTPLogger.logInstantiateError((String)this.stub.getContext().getLogContext(), (String)this.stub.getServletName(), (Throwable)instantiationException);
                return new ServletException("Servlet class: '" + this.stub.getClassName() + "' couldn't be instantiated");
            }
            catch (IllegalAccessException illegalAccessException) {
                HTTPLogger.logIllegalAccessOnInstantiate((String)this.stub.getContext().getLogContext(), (String)this.stub.getServletName(), (Throwable)illegalAccessException);
                return new ServletException("Servlet class: '" + this.stub.getClassName() + "' couldn't be instantiated");
            }
            catch (ClassCastException classCastException) {
                HTTPLogger.logCastingError((String)this.stub.getContext().getLogContext(), (String)this.stub.getServletName(), (Throwable)classCastException);
                return new ServletException("Servlet class: '" + this.stub.getClassName() + "' does not implement javax.servlet.Servlet");
            }
            catch (Throwable throwable) {
                return throwable;
            }
            try {
                this.servlet.init((ServletConfig)this.stub);
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    private static final class ServletServiceAction
    implements PrivilegedAction {
        private final ServletRequest req;
        private final ServletRequestImpl reqi;
        private final ServletResponse rsp;
        private final Servlet servlet;
        private final ServletStubImpl stub;

        ServletServiceAction(ServletRequest servletRequest, ServletRequestImpl servletRequestImpl, ServletResponse servletResponse, Servlet servlet, ServletStubImpl servletStubImpl) {
            this.req = servletRequest;
            this.reqi = servletRequestImpl;
            this.rsp = servletResponse;
            this.servlet = servlet;
            this.stub = servletStubImpl;
        }

        public Object run() {
            try {
                if (this.stub == this.reqi.getServletStub() && this.stub.isFutureResponseServlet()) {
                    this.reqi.enableFutureResponse();
                }
                this.servlet.service(this.req, this.rsp);
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }
}

