/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.descriptor.DescriptorCache;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAppIOHelper;
import weblogic.utils.collections.ArraySet;

public class TldCacheHelper {
    private static final String IMPLICIT_TLD = "implicit.tld";
    private static final String TLD_CACHE_DIR = ".tld_cache";
    public static final String LISTENER_CLASS = "listener-class";
    public static final String TAG_CLASS = "tag-class";

    public static Map parseTagLibraries(Collection collection, String string, String string2) {
        return TldCacheHelper.parseTagLibraries(collection, new File(string), string2);
    }

    public static Map parseTagLibraries(Collection collection, File file, String string) {
        if (collection == null || collection.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        Set set = null;
        Set set2 = null;
        long l = System.currentTimeMillis();
        File file2 = new File(file, TLD_CACHE_DIR);
        file2.mkdirs();
        for (War.ResourceLocation resourceLocation : collection) {
            if (resourceLocation.getURI().endsWith(IMPLICIT_TLD)) continue;
            TldIOHelper tldIOHelper = new TldIOHelper(resourceLocation);
            try {
                Object object;
                File file3 = new File(file2, resourceLocation.getURI().replace('\\', '/'));
                Map map = (Map)DescriptorCache.getInstance().parseXML(file3, (DescriptorCache.IOHelper)tldIOHelper);
                Collection collection2 = (Collection)map.get(LISTENER_CLASS);
                if (collection2 != null && !collection2.isEmpty()) {
                    if (set == null) {
                        set = new ArraySet();
                    }
                    set.addAll(collection2);
                    if (HTTPDebugLogger.isEnabled()) {
                        object = collection2.iterator();
                        while (object.hasNext()) {
                            HTTPDebugLogger.debug("[TldCacheHelper] Found listener '" + object.next() + "' in tld at " + resourceLocation.getLocation());
                        }
                    }
                }
                if ((object = (Collection)map.get(TAG_CLASS)) == null || object.isEmpty()) continue;
                if (set2 == null) {
                    set2 = new ArraySet();
                }
                set2.addAll(object);
                if (!HTTPDebugLogger.isEnabled()) continue;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    HTTPDebugLogger.debug("[TldCacheHelper] Found tag handler '" + iterator.next() + "' in tld at " + resourceLocation.getLocation());
                }
            }
            catch (XMLStreamException xMLStreamException) {
                if (string == null) continue;
                HTTPLogger.logListenerParseException((String)string, (String)resourceLocation.getLocation(), (Throwable)xMLStreamException);
            }
            catch (IOException iOException) {
                if (string == null) continue;
                HTTPLogger.logListenerParseException((String)string, (String)resourceLocation.getLocation(), (Throwable)iOException);
            }
        }
        HashMap hashMap = new HashMap(2);
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        if (set2 == null) {
            set2 = Collections.EMPTY_SET;
        }
        hashMap.put(LISTENER_CLASS, set);
        hashMap.put(TAG_CLASS, set2);
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("[TldCacheHelper] parseTagLibraries() took : " + (System.currentTimeMillis() - l));
        }
        return hashMap;
    }

    private static class TldIOHelper
    extends WebAppIOHelper {
        TldIOHelper(War.ResourceLocation resourceLocation) {
            super(resourceLocation);
        }

        protected Object parseXMLInternal(XMLStreamReader xMLStreamReader) throws IOException, XMLStreamException {
            ArraySet arraySet = new ArraySet();
            ArraySet arraySet2 = new ArraySet();
            String string = null;
            boolean bl = false;
            boolean bl2 = false;
            int n = xMLStreamReader.next();
            while (n != 8) {
                switch (n) {
                    case 1: {
                        if (TldCacheHelper.LISTENER_CLASS.equals(xMLStreamReader.getLocalName())) {
                            bl = true;
                            break;
                        }
                        if (!TldCacheHelper.TAG_CLASS.equals(xMLStreamReader.getLocalName())) break;
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        if (TldCacheHelper.LISTENER_CLASS.equals(xMLStreamReader.getLocalName())) {
                            bl = false;
                            break;
                        }
                        if (!TldCacheHelper.TAG_CLASS.equals(xMLStreamReader.getLocalName())) break;
                        bl2 = false;
                        break;
                    }
                    case 4: 
                    case 12: {
                        string = xMLStreamReader.getText().trim();
                        if (string.length() == 0) break;
                        if (bl) {
                            arraySet.add(string);
                        }
                        if (!bl2) break;
                        arraySet2.add(string);
                    }
                }
                n = xMLStreamReader.next();
            }
            HashMap<String, ArraySet> hashMap = new HashMap<String, ArraySet>(2);
            hashMap.put(TldCacheHelper.LISTENER_CLASS, arraySet);
            hashMap.put(TldCacheHelper.TAG_CLASS, arraySet2);
            return hashMap;
        }
    }
}

