/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.Locale;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.utils.StringUtils;

final class URLMatchHelper {
    private static final boolean WIN_32 = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    private final String pattern;
    private final ServletStubImpl servletStub;
    private final String servletPath;
    private final String extension;
    private final boolean defaultServlet;
    private final boolean exactPattern;
    private final boolean fileOrJspServlet;
    private final boolean isJspClassServlet;

    URLMatchHelper(String string, ServletStubImpl servletStubImpl) {
        this.pattern = string;
        this.servletStub = servletStubImpl;
        String string2 = this.servletStub.getClassName();
        this.fileOrJspServlet = "weblogic.servlet.FileServlet".equals(string2) || "weblogic.servlet.JSPServlet".equals(string2) || "weblogic.servlet.JavelinJSPServlet".equals(string2) || "weblogic.servlet.JavelinxJSPServlet".equals(string2);
        this.isJspClassServlet = "weblogic.servlet.JSPClassServlet".equals(string2);
        if (this.pattern.startsWith("*.") && this.pattern.length() > 2) {
            this.servletPath = null;
            this.extension = this.pattern.substring(1);
            this.defaultServlet = false;
            this.exactPattern = false;
        } else if (this.pattern.equals("/")) {
            this.servletPath = null;
            this.extension = null;
            this.defaultServlet = true;
            this.exactPattern = true;
        } else if (this.pattern.equals("/*")) {
            this.servletPath = "";
            this.extension = null;
            this.defaultServlet = true;
            this.exactPattern = false;
        } else if (this.pattern.endsWith("/*")) {
            this.servletPath = this.pattern.substring(0, this.pattern.length() - 2);
            this.extension = null;
            this.defaultServlet = false;
            this.exactPattern = false;
        } else {
            this.servletPath = this.pattern;
            this.extension = null;
            this.defaultServlet = false;
            this.exactPattern = true;
        }
    }

    String getPattern() {
        return this.pattern;
    }

    ServletStubImpl getServletStub() {
        return this.servletStub;
    }

    boolean isDefaultServlet() {
        return this.defaultServlet;
    }

    boolean isIndexServlet() {
        return !this.defaultServlet && !this.fileOrJspServlet;
    }

    boolean isFileOrJspServlet() {
        return this.fileOrJspServlet || this.isJspClassServlet;
    }

    String getServletPath(String string) {
        if (this.exactPattern) {
            return string;
        }
        if (this.defaultServlet) {
            return "";
        }
        if (this.extension == null) {
            return this.servletPath;
        }
        int n = WIN_32 ? StringUtils.lastIndexOfIgnoreCase((String)string, (String)this.extension) : string.lastIndexOf(this.extension);
        int n2 = string.indexOf(47, n);
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2);
    }
}

