/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import weblogic.management.runtime.SocketRuntime;
import weblogic.protocol.ServerChannel;
import weblogic.security.service.ContextHandler;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLCipherUtility;
import weblogic.security.utils.SSLSetup;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.MuxableSocketHTTP;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.socket.SocketMuxer;
import weblogic.utils.StringUtils;
import weblogic.utils.collections.SecondChanceCacheMap;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.io.UnsyncByteArrayInputStream;

public final class VirtualConnection {
    private static final String X509_CERTIFICATE = "javax.servlet.request.X509Certificate";
    private static final String CIPHER_SUITE = "javax.servlet.request.cipher_suite";
    private static final String KEY_SIZE = "javax.servlet.request.key_size";
    private static final String SSL_SESSION = "weblogic.servlet.request.sslsession";
    private static final String NETWORK_CHANNEL_HTTP_PORT = "weblogic.servlet.network_channel.port";
    private static final String NETWORK_CHANNEL_HTTPS_PORT = "weblogic.servlet.network_channel.sslport";
    private final ServletRequestImpl request;
    private final MuxableSocketHTTP muxableSocket;
    private final boolean internalDispatch;
    private Socket socket;
    private int socketFD = -1;
    private InetAddress proxyHost;
    private InetAddress peer;
    private String remoteAddr;
    private String remoteHost;
    private int remotePort = -1;
    private byte[] x509ProxyClientCert;
    private boolean certExtracted;
    private final ArrayList perimeterAuthClientCert = new ArrayList(5);
    private final ArrayList perimeterAuthClientCertType = new ArrayList(5);
    private Object origCert = null;
    private boolean certsFromProxy;
    private boolean secure;
    private boolean ssl;

    VirtualConnection(ServletRequestImpl servletRequestImpl, MuxableSocketHTTP muxableSocketHTTP) {
        this.request = servletRequestImpl;
        this.muxableSocket = muxableSocketHTTP;
        boolean bl = this.internalDispatch = this.muxableSocket == null;
        if (!this.internalDispatch) {
            this.initNetworkChannelPorts(this.muxableSocket.getChannel());
            this.socket = this.muxableSocket.getSocket();
        }
    }

    void init() {
        if (!this.internalDispatch && this.muxableSocket.isHttps()) {
            this.initSSLAttributes((SSLSocket)this.getSocket());
        }
    }

    int getLocalPort() {
        if (this.internalDispatch) {
            return 0;
        }
        ServerChannel serverChannel = this.muxableSocket.getChannel();
        return serverChannel.getPublicInetAddress().getPort();
    }

    String getLocalAddr() {
        if (this.internalDispatch) {
            return null;
        }
        ServerChannel serverChannel = this.muxableSocket.getChannel();
        return serverChannel.getPublicInetAddress().getAddress().getHostAddress();
    }

    String getLocalName() {
        if (this.internalDispatch) {
            return null;
        }
        ServerChannel serverChannel = this.muxableSocket.getChannel();
        return serverChannel.getPublicInetAddress().getHostName();
    }

    public int getSocketFD() {
        return this.socketFD;
    }

    public void setSocketFD(int n) {
        this.socketFD = n;
    }

    boolean isSecure() {
        return this.secure;
    }

    public Socket getSocket() {
        return this.muxableSocket.getSocket();
    }

    public SocketRuntime getSocketRuntime() {
        return this.muxableSocket;
    }

    public ServerChannel getChannel() {
        return this.muxableSocket.getChannel();
    }

    public ContextHandler getContextHandler() {
        return this.muxableSocket;
    }

    public ArrayList getPerimeterAuthClientCert() {
        return this.perimeterAuthClientCert;
    }

    public ArrayList getPerimeterAuthClientCertType() {
        return this.perimeterAuthClientCertType;
    }

    public byte[] getX509ProxyClientCert() {
        return this.x509ProxyClientCert;
    }

    void setX509ProxyClientCert(byte[] byArray) {
        this.x509ProxyClientCert = byArray;
    }

    void reset() {
        this.perimeterAuthClientCert.clear();
        this.perimeterAuthClientCertType.clear();
        this.x509ProxyClientCert = null;
        this.certExtracted = false;
        this.proxyHost = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.peer = null;
        this.secure = this.ssl;
        if (this.certsFromProxy) {
            this.certsFromProxy = false;
            this.request.setAttribute(X509_CERTIFICATE, this.origCert);
        }
    }

    private void initNetworkChannelPorts(ServerChannel serverChannel) {
        if (serverChannel.supportsTLS()) {
            this.request.setAttribute(NETWORK_CHANNEL_HTTPS_PORT, new Integer(serverChannel.getPublicPort()));
        } else {
            this.request.setAttribute(NETWORK_CHANNEL_HTTP_PORT, new Integer(serverChannel.getPublicPort()));
        }
    }

    private void initSSLAttributes(SSLSocket sSLSocket) {
        this.secure = true;
        this.ssl = true;
        SSLSession sSLSession = sSLSocket.getSession();
        String string = sSLSession.getCipherSuite();
        this.request.setAttribute(SSL_SESSION, sSLSession);
        this.request.setAttribute(CIPHER_SUITE, string);
        int n = SSLCipherUtility.getKeySize(string);
        if (n >= 0) {
            this.request.setAttribute(KEY_SIZE, new Integer(n));
        }
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            if (certificateArray != null) {
                this.request.setAttribute(X509_CERTIFICATE, SSLCertUtility.toJavaX5092(certificateArray));
            }
        }
        catch (IOException iOException) {
            SSLSetup.info(iOException, "Exception processing certificates: " + iOException.getMessage());
        }
    }

    void initCerts() {
        if (this.request.getContext().getConfigManager().isClientCertProxyEnabled()) {
            this.initProxyClientCert();
        } else {
            this.setX509ProxyClientCert(null);
        }
    }

    private void initProxyClientCert() {
        if (this.certExtracted) {
            return;
        }
        this.certExtracted = true;
        if (this.x509ProxyClientCert != null) {
            try {
                UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.x509ProxyClientCert);
                byte[] byArray = new BASE64Decoder().decodeBuffer((InputStream)unsyncByteArrayInputStream);
                UnsyncByteArrayInputStream unsyncByteArrayInputStream2 = new UnsyncByteArrayInputStream(byArray);
                X509Certificate[] x509CertificateArray = new X509Certificate[1];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                x509CertificateArray[0] = (X509Certificate)certificateFactory.generateCertificate((InputStream)unsyncByteArrayInputStream2);
                this.saveOrigCert();
                this.request.setAttribute(X509_CERTIFICATE, x509CertificateArray);
            }
            catch (Exception exception) {
                HTTPLogger.logIgnoringClientCert((String)"WL-Proxy-Client-Cert", (Throwable)exception);
                this.x509ProxyClientCert = null;
            }
        }
    }

    void processProxyHeader(String string, byte[] byArray) {
        int n = string.length();
        switch (n) {
            case 12: {
                if (!ServletRequestImpl.eq(string, "WL-Proxy-SSL", 12)) break;
                String string2 = StringUtils.getString((byte[])byArray);
                if ("true".equalsIgnoreCase(string2)) {
                    if (this.muxableSocket.getHttpServer().isWeblogicPluginEnabled()) {
                        this.secure = true;
                        break;
                    }
                    this.secure = false;
                    break;
                }
                if (!"false".equalsIgnoreCase(string2)) break;
                this.secure = false;
                break;
            }
            case 18: {
                if (!ServletRequestImpl.eq(string, "WL-Proxy-Client-IP", 18)) break;
                try {
                    this.proxyHost = InetAddress.getByName(StringUtils.getString((byte[])byArray));
                }
                catch (UnknownHostException unknownHostException) {
                    if (!HTTPDebugLogger.isEnabled()) break;
                    HTTPDebugLogger.debug("Failed to process the client header WL-Proxy-Client-IP:" + StringUtils.getString((byte[])byArray), unknownHostException);
                }
                break;
            }
            case 20: {
                if (!ServletRequestImpl.eq(string, "WL-Proxy-Client-Cert", 20)) break;
                this.setX509ProxyClientCert(byArray);
                break;
            }
        }
        if (n > 16 && ServletRequestImpl.eq(string, "WL-Proxy-Client-", 16) && byArray != null && byArray.length > 0) {
            this.getPerimeterAuthClientCertType().add(string.substring(16));
            this.getPerimeterAuthClientCert().add(byArray);
        }
    }

    private void saveOrigCert() {
        this.certsFromProxy = true;
        this.origCert = this.request.getAttribute(X509_CERTIFICATE);
    }

    String getRemoteAddr() {
        if (this.remoteAddr != null) {
            return this.remoteAddr;
        }
        if (this.internalDispatch) {
            return null;
        }
        if (this.muxableSocket.getHttpServer().isWeblogicPluginEnabled()) {
            this.peer = this.proxyHost;
        }
        if (this.peer == null && (this.peer = this.socket.getInetAddress()) == null) {
            return null;
        }
        InetAddressCacheRecord inetAddressCacheRecord = InetAddressCacheRecord.getInstance(this.peer);
        this.remoteAddr = inetAddressCacheRecord.getHostAddress();
        return this.remoteAddr;
    }

    String getRemoteHost() {
        if (this.remoteHost != null) {
            return this.remoteHost;
        }
        this.getRemoteAddr();
        if (this.remoteAddr == null) {
            return "";
        }
        if (this.peer == null) {
            try {
                this.peer = InetAddress.getByName(this.remoteAddr);
            }
            catch (UnknownHostException unknownHostException) {
                return this.getRemoteAddr();
            }
        }
        InetAddressCacheRecord inetAddressCacheRecord = InetAddressCacheRecord.getInstance(this.peer);
        this.remoteHost = inetAddressCacheRecord.getHostName();
        return this.remoteHost;
    }

    public int getRemotePort() {
        if (this.remotePort != -1) {
            return this.remotePort;
        }
        if (this.internalDispatch) {
            return -1;
        }
        if (this.remotePort == -1) {
            this.remotePort = this.socket.getPort();
        }
        return this.remotePort;
    }

    boolean isInternalDispatch() {
        return this.internalDispatch;
    }

    void deliverHasException(IOException iOException) {
        SocketMuxer.getMuxer().deliverHasException(this.muxableSocket.getSocketFilter(), iOException);
    }

    void requeue() {
        this.muxableSocket.requeue();
    }

    void close() {
        SocketMuxer.getMuxer().deliverEndOfStream(this.muxableSocket.getSocketFilter());
    }

    static final class InetAddressCacheRecord {
        private static final SecondChanceCacheMap cache = new SecondChanceCacheMap(317);
        private final InetAddress address;
        private String remoteHost;
        private String remoteIP;

        static InetAddressCacheRecord getInstance(InetAddress inetAddress) {
            InetAddressCacheRecord inetAddressCacheRecord = (InetAddressCacheRecord)cache.get((Object)inetAddress);
            if (inetAddressCacheRecord == null) {
                inetAddressCacheRecord = new InetAddressCacheRecord(inetAddress);
                cache.put((Object)inetAddress, (Object)inetAddressCacheRecord);
            }
            return inetAddressCacheRecord;
        }

        InetAddressCacheRecord(InetAddress inetAddress) {
            this.address = inetAddress;
        }

        String getHostName() {
            if (this.remoteHost == null) {
                this.remoteHost = this.address.getHostName();
            }
            return this.remoteHost;
        }

        String getHostAddress() {
            if (this.remoteIP == null) {
                this.remoteIP = this.address.getHostAddress();
            }
            return this.remoteIP;
        }
    }
}

