/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import weblogic.utils.io.Chunk;

public final class WLOutputStreamWriter
extends Writer {
    private final CharsetEncoder encoder;
    private final OutputStream out;
    private final ByteBuffer bb;
    private int pos = 0;
    private boolean error = false;
    private boolean closed = false;
    private boolean haveLeftoverChar = false;
    private char leftoverChar;
    private CharBuffer lcb;
    private Chunk head;

    public WLOutputStreamWriter(OutputStream outputStream, String string) {
        this(outputStream, Charset.forName(string).newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public WLOutputStreamWriter(OutputStream outputStream) {
        this(outputStream, Charset.defaultCharset().newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    private WLOutputStreamWriter(OutputStream outputStream, CharsetEncoder charsetEncoder) {
        if (outputStream == null) {
            throw new NullPointerException("out is null");
        }
        this.out = outputStream;
        this.encoder = charsetEncoder;
        this.head = Chunk.getChunk();
        this.bb = ByteBuffer.wrap(this.head.buf);
    }

    public String getEncoding() {
        return this.encoder.charset().name();
    }

    public void write(int n) throws IOException {
        if (this.error) {
            return;
        }
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.error) {
            return;
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.write(CharBuffer.wrap(cArray, n, n2));
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.error) {
            return;
        }
        if (string == null || n2 == 0) {
            return;
        }
        int n3 = string.length();
        if (n < 0 || n > n3 || n2 < 0 || n + n2 > n3 || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.write(CharBuffer.wrap(string, n, n2));
    }

    private void write(CharBuffer charBuffer) throws IOException {
        if (this.haveLeftoverChar) {
            this.flushLeftoverChar(charBuffer, false);
        }
        while (charBuffer.hasRemaining()) {
            CoderResult coderResult = this.encoder.encode(charBuffer, this.bb, true);
            if (coderResult.isUnderflow()) {
                if (charBuffer.remaining() != 1) break;
                this.haveLeftoverChar = true;
                this.leftoverChar = charBuffer.get();
                break;
            }
            if (coderResult.isOverflow()) {
                this.writeBytes();
                continue;
            }
            coderResult.throwException();
        }
        this.flushBuffer();
    }

    public void close() throws IOException {
        CoderResult coderResult;
        if (this.closed) {
            return;
        }
        this.flushLeftoverChar(null, true);
        while (!(coderResult = this.encoder.flush(this.bb)).isUnderflow()) {
            if (coderResult.isOverflow()) {
                this.writeBytes();
                continue;
            }
            coderResult.throwException();
        }
        if (this.bb.position() > 0) {
            this.writeBytes();
        }
        this.out.close();
        Chunk.releaseChunks((Chunk)this.head);
        this.head = null;
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.error) {
            return;
        }
        this.out.flush();
    }

    private void writeBytes() throws IOException {
        this.bb.flip();
        int n = this.bb.limit();
        int n2 = this.bb.position();
        int n3 = n2 > n ? 0 : n - n2;
        this.out.write(this.bb.array(), this.bb.arrayOffset() + n2, n3);
        this.bb.clear();
    }

    private void flushLeftoverChar(CharBuffer charBuffer, boolean bl) throws IOException {
        if (!this.haveLeftoverChar && !bl) {
            return;
        }
        if (this.lcb == null) {
            this.lcb = CharBuffer.allocate(2);
        } else {
            this.lcb.clear();
        }
        if (this.haveLeftoverChar) {
            this.lcb.put(this.leftoverChar);
        }
        if (charBuffer != null && charBuffer.hasRemaining()) {
            this.lcb.put(charBuffer.get());
        }
        this.lcb.flip();
        while (this.lcb.hasRemaining() || bl) {
            CoderResult coderResult = this.encoder.encode(this.lcb, this.bb, bl);
            if (coderResult.isUnderflow()) {
                if (!this.lcb.hasRemaining()) break;
                throw new Error();
            }
            if (coderResult.isOverflow()) {
                this.writeBytes();
                continue;
            }
            coderResult.throwException();
        }
        this.haveLeftoverChar = false;
    }

    void flushBuffer() throws IOException {
        if (this.error) {
            return;
        }
        if (this.closed) {
            return;
        }
        if (this.bb.position() > 0) {
            this.writeBytes();
        }
    }
}

