/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.SplitDirectoryInfo;
import weblogic.application.io.Archive;
import weblogic.application.io.ClasspathInfo;
import weblogic.application.io.DescriptorFinder;
import weblogic.application.io.Ear;
import weblogic.application.io.ExplodedJar;
import weblogic.application.io.JarCopyFilter;
import weblogic.application.io.ManifestFinder;
import weblogic.application.library.CachableLibMetadata;
import weblogic.application.library.CachableLibMetadataEntry;
import weblogic.application.library.CachableLibMetadataType;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryMetadataCache;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.utils.CompositeWebAppFinder;
import weblogic.application.utils.PathUtils;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.Kernel;
import weblogic.servlet.internal.ArchivedWar;
import weblogic.servlet.internal.CaseAwareExplodedJar;
import weblogic.servlet.internal.ConsoleExtensionManager;
import weblogic.servlet.internal.DescriptorCacheEntry;
import weblogic.servlet.internal.FaceConfigCacheHelper;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.TldCacheHelper;
import weblogic.servlet.internal.WarLibraryDefinition;
import weblogic.servlet.internal.WarSource;
import weblogic.servlet.internal.WebAnnotationProcessor;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.servlet.utils.ServletMapping;
import weblogic.servlet.utils.annotation.ClassAnnotationDetector;
import weblogic.utils.FileUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.DelegateFinder;
import weblogic.utils.classloaders.DelegateSource;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.classloaders.NullSource;
import weblogic.utils.classloaders.Source;
import weblogic.utils.collections.ArraySet;
import weblogic.utils.collections.SecondChanceCacheMap;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.IteratorEnumerator;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.utils.zip.SafeZipFileInputStream;

public class War {
    private static final String WEB_INF_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final String META_INF_FACES_CONFIG = "META-INF/faces-config.xml";
    private static final String BEA_EXTN_DIR = "/WEB-INF/bea-ext";
    static final String WAR_EXTRACT_ROOT = "war";
    private static final String LIBRARY_EXTRACT_ROOT = "libs";
    private static final String EXTENSION_EXTRACT_ROOT = "beaext";
    private static final String CONSOLE_EXTENSION_EXTRACT_ROOT = "console-ext";
    private static final FileFilter DOT_JAR = FileUtils.makeExtensionFilter((String)".jar");
    private static final FileFilter WEBAPP_EXTN = FileUtils.makeExtensionFilter((String[])new String[]{".jar", ".war"});
    private static final String WEB_INF_LIB = "/WEB-INF/lib";
    private static String WEB_INF_CLASSES = "/WEB-INF/classes";
    private static final boolean DEBUG = false;
    private static final DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"WarExtraction");
    private final Archive archive;
    private CompositeWebAppFinder classfinder = new CompositeWebAppFinder();
    private final String uri;
    private List extensions = new ArrayList();
    private List beaExtensionRoots = new ArrayList();
    private final ServletMapping virtualFinders = War.newServletMapping();
    private List tldURIs;
    private boolean findTldsCalled = false;
    private Map tldInfo;
    private List facesConfigURIs = null;
    private Set<String> matchSet = new HashSet<String>();
    private WebAppConfigManager configManager;
    private File extractDir;
    private boolean isConsoleWar;
    private boolean isConsoleHelpWar;
    public static final ClasspathInfo WAR_CLASSPATH_INFO = new ClasspathInfo(){
        private final String[] WEB_INF_CLASSES = new String[]{"WEB-INF" + File.separator + "classes"};
        private final String[] WEB_INF_LIB = new String[]{"WEB-INF" + File.separator + "lib"};

        public String[] getClasspathURIs() {
            return this.WEB_INF_CLASSES;
        }

        public String[] getJarURIs() {
            return this.WEB_INF_LIB;
        }
    };

    public War(String string, File file, WebAppServletContext webAppServletContext) throws IOException {
        String[] stringArray;
        Object object;
        boolean bl;
        ApplicationContextInternal applicationContextInternal = webAppServletContext.getApplicationContext();
        this.isConsoleWar = "console".equals(webAppServletContext.getWebAppModule().getId());
        this.isConsoleHelpWar = "consolehelp".equals(webAppServletContext.getWebAppModule().getId());
        if (!this.isConsoleHelpWar) {
            this.isConsoleHelpWar = "consolehelp.war".equals(webAppServletContext.getWebAppModule().getId());
        }
        this.uri = webAppServletContext.getWebAppModule().getId();
        this.configManager = webAppServletContext.getConfigManager();
        Ear ear = applicationContextInternal.getEar();
        this.extractDir = file;
        File file2 = new File(file, WAR_EXTRACT_ROOT);
        file2.mkdirs();
        File[] fileArray = null;
        boolean bl2 = bl = this.isConsoleWar && webAppServletContext.isInternalApp();
        if (ear == null) {
            object = new File(applicationContextInternal.getStagingPath());
            if (!((File)object).exists()) {
                throw new FileNotFoundException("Unable to find war for uri " + this.uri + " at path " + ((File)object).getAbsolutePath());
            }
            fileArray = new File[]{object};
            this.archive = War.makeExplodedJar(this.uri, file2, fileArray, bl);
        } else {
            fileArray = ear.getModuleRoots(string);
            if (fileArray.length == 0) {
                throw new FileNotFoundException("Unable to find war with uri " + this.uri + " in ear at " + applicationContextInternal.getStagingPath());
            }
            this.archive = War.makeExplodedJar(this.uri, file2, fileArray, bl);
        }
        object = applicationContextInternal.getSplitDirectoryInfo();
        if (object != null && (stringArray = ((SplitDirectoryInfo)object).getWebAppClasses(string)) != null && stringArray.length > 0) {
            ClasspathClassFinder2 classpathClassFinder2 = new ClasspathClassFinder2(StringUtils.join((String[])stringArray, (String)File.pathSeparator));
            this.classfinder.addFinder((ClassFinder)classpathClassFinder2);
            this.classfinder.addFinder(new SplitWebInfoClassesDescriptorFinder(this.uri, (ClassFinder)classpathClassFinder2));
        }
        this.init(fileArray, file);
    }

    public War(String string, File file, VirtualJarFile virtualJarFile) throws IOException {
        this(string, file, virtualJarFile, false);
    }

    private War(String string, File file, VirtualJarFile virtualJarFile, boolean bl) throws IOException {
        this.uri = string;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Creating War uri: " + string + " extractDir :" + file + " VJFDir: " + virtualJarFile.getDirectory());
        }
        this.extractDir = file;
        File file2 = new File(file, WAR_EXTRACT_ROOT);
        file2.mkdirs();
        File[] fileArray = virtualJarFile.getRootFiles();
        this.archive = War.makeExplodedJar(string, file2, fileArray, bl);
        this.init(fileArray, file);
    }

    public War(String string) {
        this.uri = string;
        this.archive = new NoOpArchive();
        this.virtualFinders.put("/", new ResourceFinder(this.getURI() + "#", this.classfinder, this.configManager));
    }

    private void init(File[] fileArray, File file) throws IOException {
        this.classfinder.addFinder(this.archive.getClassFinder());
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i] == null) continue;
            this.classfinder.addFinder(new ManifestFinder.ClassPathFinder(fileArray[i]));
        }
        this.processExtensions(file);
        this.virtualFinders.put("/", new ResourceFinder(this.getURI() + "#", this.classfinder, this.configManager));
    }

    public List getBeaExtensionRoots() {
        return this.beaExtensionRoots;
    }

    boolean hasExtensions() {
        return !this.beaExtensionRoots.isEmpty();
    }

    public ClassFinder getClassFinder() {
        return this.classfinder;
    }

    public void remove() {
        if (this.extensions.size() > 0) {
            for (WarExtension warExtension : this.extensions) {
                warExtension.remove();
            }
            this.extensions.clear();
        }
        if (this.beaExtensionRoots.size() > 0) {
            this.beaExtensionRoots.clear();
        }
        this.archive.remove();
    }

    public String getURI() {
        return this.uri;
    }

    private List getWebTLDLocations() {
        if (!this.findTldsCalled) {
            ResourceFinder resourceFinder = ((ResourceFinder)this.getResourceFinder("")).getWebResourceFinder();
            ArrayList arrayList = new ArrayList();
            War.findTlds(resourceFinder, arrayList, this.classfinder.getWebappFinder());
            this.tldURIs = arrayList;
            this.findTldsCalled = true;
        }
        return this.tldURIs;
    }

    private List getWebFacesLocations(String string) {
        if (this.facesConfigURIs == null) {
            ResourceFinder resourceFinder = ((ResourceFinder)this.getResourceFinder("")).getWebResourceFinder();
            this.facesConfigURIs = War.findFacesConfigs(string, resourceFinder, this.classfinder.getWebappFinder());
        }
        return this.facesConfigURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addLibrary(Library library, File file) throws IOException {
        File file2 = War.computeExtractDir(file, PathUtils.generateTempPath(null, library.getName(), library.getSpecificationVersion() + library.getImplementationVersion()), LIBRARY_EXTRACT_ROOT);
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)library.getLocation());
            War war = library instanceof WarLibraryDefinition && ((WarLibraryDefinition)library).isArchived() ? new War(this.getURI(), file2, virtualJarFile, true) : new War(this.getURI(), file2, virtualJarFile);
            final String string = library.getName();
            LibraryFinder libraryFinder = new LibraryFinder(war.getClassFinder(), library);
            this.extensions.add(new WarExtension((ClassFinder)libraryFinder, war, library){
                private Map tldInfo = null;
                final /* synthetic */ ClassFinder val$libFinder;
                final /* synthetic */ War val$lib;
                final /* synthetic */ Library val$library;
                {
                    this.val$libFinder = classFinder;
                    this.val$lib = war2;
                    this.val$library = library;
                }

                public String getName() {
                    return string;
                }

                public ClassFinder getClassFinder() throws IOException {
                    return this.val$libFinder;
                }

                public void remove() {
                    this.val$lib.remove();
                }

                public Collection getTagListeners(boolean bl) {
                    return bl ? this.getAnnotatedTagListeners() : this.getTagListeners();
                }

                public Collection getTagHandlers(boolean bl) {
                    return bl ? this.getAnnotatedTagHandlers() : this.getTagHandlers();
                }

                private Set getTagListeners() {
                    if (this.tldInfo == null) {
                        this.getTldInfo();
                    }
                    return (Set)this.tldInfo.get("listener-class");
                }

                private Set getTagHandlers() {
                    if (this.tldInfo == null) {
                        this.getTldInfo();
                    }
                    return (Set)this.tldInfo.get("tag-class");
                }

                private Collection getAnnotatedTagListeners() {
                    CachableLibMetadataEntry cachableLibMetadataEntry = ((CachableLibMetadata)((Object)this.val$library)).getCachableEntry(CachableLibMetadataType.TAG_LISTENERS);
                    try {
                        return (Collection)LibraryMetadataCache.getInstance().lookupCachedObject(cachableLibMetadataEntry);
                    }
                    catch (LibraryProcessingException libraryProcessingException) {
                        return Collections.EMPTY_SET;
                    }
                }

                private Collection getAnnotatedTagHandlers() {
                    CachableLibMetadataEntry cachableLibMetadataEntry = ((CachableLibMetadata)((Object)this.val$library)).getCachableEntry(CachableLibMetadataType.TAG_HANDLERS);
                    try {
                        return (Collection)LibraryMetadataCache.getInstance().lookupCachedObject(cachableLibMetadataEntry);
                    }
                    catch (LibraryProcessingException libraryProcessingException) {
                        return Collections.EMPTY_SET;
                    }
                }

                private DescriptorCacheEntry.DescriptorCachableObject getTldCachedObject() throws LibraryProcessingException {
                    CachableLibMetadataEntry cachableLibMetadataEntry = ((CachableLibMetadata)((Object)this.val$library)).getCachableEntry(CachableLibMetadataType.TLD);
                    return (DescriptorCacheEntry.DescriptorCachableObject)LibraryMetadataCache.getInstance().lookupCachedObject(cachableLibMetadataEntry);
                }

                private void getTldInfo() {
                    if (!(this.val$library instanceof CachableLibMetadata)) {
                        this.tldInfo = Collections.EMPTY_MAP;
                    }
                    if (this.tldInfo == null) {
                        try {
                            DescriptorCacheEntry.DescriptorCachableObject descriptorCachableObject = this.getTldCachedObject();
                            this.tldInfo = TldCacheHelper.parseTagLibraries((Collection)descriptorCachableObject.getResourceLocation(), descriptorCachableObject.getCacheBaseDir(), string);
                        }
                        catch (LibraryProcessingException libraryProcessingException) {
                            // empty catch block
                        }
                    }
                }

                private DescriptorCacheEntry.DescriptorCachableObject getFacesConfigCachedObject() throws LibraryProcessingException {
                    CachableLibMetadataEntry cachableLibMetadataEntry = ((CachableLibMetadata)((Object)this.val$library)).getCachableEntry(CachableLibMetadataType.FACE_BEANS);
                    return (DescriptorCacheEntry.DescriptorCachableObject)LibraryMetadataCache.getInstance().lookupCachedObject(cachableLibMetadataEntry);
                }

                public Set getFacesManagedBeans() {
                    if (!(this.val$library instanceof CachableLibMetadata)) {
                        return Collections.EMPTY_SET;
                    }
                    Set set = null;
                    try {
                        DescriptorCacheEntry.DescriptorCachableObject descriptorCachableObject = this.getFacesConfigCachedObject();
                        set = FaceConfigCacheHelper.parseFacesConfigs((Collection)descriptorCachableObject.getResourceLocation(), descriptorCachableObject.getCacheBaseDir(), string);
                    }
                    catch (LibraryProcessingException libraryProcessingException) {
                        // empty catch block
                    }
                    return set == null ? Collections.EMPTY_SET : set;
                }

                public List getAnnotatedClasses() {
                    if (!(this.val$library instanceof CachableLibMetadata)) {
                        return Collections.EMPTY_LIST;
                    }
                    List list = null;
                    try {
                        CachableLibMetadataEntry cachableLibMetadataEntry = ((CachableLibMetadata)((Object)this.val$library)).getCachableEntry(CachableLibMetadataType.ANNOTATED_CLASSES);
                        list = (List)LibraryMetadataCache.getInstance().lookupCachedObject(cachableLibMetadataEntry);
                    }
                    catch (LibraryProcessingException libraryProcessingException) {
                        // empty catch block
                    }
                    return list == null ? Collections.EMPTY_LIST : list;
                }
            });
            this.classfinder.addLibraryFinder((ClassFinder)libraryFinder);
            Object var9_8 = null;
            if (virtualJarFile == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (virtualJarFile == null) throw throwable;
            try {
                virtualJarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            virtualJarFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void addVirtualDirectory(String string, String string2) {
        DescriptorFinder descriptorFinder = new DescriptorFinder(this.getURI(), (ClassFinder)new ClasspathClassFinder2(string));
        MultiClassFinder multiClassFinder = new MultiClassFinder((ClassFinder)descriptorFinder);
        multiClassFinder.addFinder((ClassFinder)this.classfinder);
        this.virtualFinders.put(string2, new ResourceFinder(this.getURI() + "#", (ClassFinder)multiClassFinder, this.configManager));
    }

    public ClassFinder getResourceFinder(String string) {
        string = HttpParsing.ensureStartingSlash((String)string);
        return (ClassFinder)this.virtualFinders.get(string);
    }

    WarSource getResourceAsSource(String string, boolean bl) {
        ResourceFinder resourceFinder = (ResourceFinder)this.getResourceFinder(string);
        return bl ? resourceFinder.getSource(string, bl) : (WarSource)resourceFinder.getSource(string);
    }

    void getResourcePaths(String string, Set set) {
        Enumeration enumeration = this.getResourceFinder(string).getSources(string);
        while (enumeration.hasMoreElements()) {
            Source source = (Source)enumeration.nextElement();
            WarSource warSource = new WarSource(source);
            WarSource[] warSourceArray = warSource.listSources();
            if (warSourceArray == null) continue;
            for (int i = 0; i < warSourceArray.length; ++i) {
                String string2 = string + warSourceArray[i].getName();
                if (warSourceArray[i].isDirectory()) {
                    string2 = string2 + "/";
                }
                set.add(string2);
            }
        }
    }

    synchronized void addClassPath(String string) {
        this.classfinder.addFinder((ClassFinder)new ClasspathClassFinder2(string));
    }

    public void closeAllFinders() {
        this.findTldsCalled = false;
        Object[] objectArray = this.virtualFinders.values();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ClassFinder)objectArray[i]).close();
        }
        if (this.classfinder != null) {
            this.classfinder.close();
        }
    }

    void populateJarMap(Map map) {
        ClassFinder classFinder = this.getResourceFinder("/");
        Enumeration enumeration = classFinder.getSources("/WEB-INF/lib/");
        while (enumeration.hasMoreElements()) {
            File[] fileArray;
            File file;
            Source source = (Source)enumeration.nextElement();
            URL uRL = source.getURL();
            String string = uRL.getProtocol();
            if (!"file".equals(string) || !(file = new File(uRL.getPath())).isDirectory() || !file.exists() || (fileArray = file.listFiles(DOT_JAR)) == null) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getName();
                map.put(string2, fileArray[i].getAbsolutePath());
            }
        }
    }

    public static void findTlds(ClassFinder classFinder, List list, ClassFinder classFinder2) {
        File file;
        Object object;
        Object object2;
        String string;
        Enumeration enumeration = classFinder.getSources("/WEB-INF/");
        while (enumeration.hasMoreElements()) {
            string = (Source)enumeration.nextElement();
            object2 = string.getURL();
            object = ((URL)object2).getProtocol();
            if (!"file".equals(object) || !(file = new File(((URL)object2).getPath())).isDirectory()) continue;
            War.findTLDs(file, "/WEB-INF", list);
        }
        string = classFinder2.getClassPath();
        object2 = War.getWebInfLibJarFiles(string, true);
        object = object2.iterator();
        while (object.hasNext()) {
            file = (File)object.next();
            long l = 0L;
            if (debugLogger.isDebugEnabled()) {
                l = System.currentTimeMillis();
            }
            War.findJarTLD(file, list);
            if (!debugLogger.isDebugEnabled()) continue;
            debugLogger.debug("**** Processing WEB-INF/lib jar -> :" + file.getName() + " Elapsed: " + (System.currentTimeMillis() - l));
        }
    }

    public static List findFacesConfigs(String string, ClassFinder classFinder, ClassFinder classFinder2) {
        ArrayList<ResourceLocation> arrayList = null;
        List list = War.findMetaInfFacesConfigs(classFinder2);
        arrayList = War.addAllIfNotEmpty(arrayList, (Collection)list);
        List list2 = War.findFacesConfigFiles(string, classFinder);
        arrayList = War.addAllIfNotEmpty(arrayList, (Collection)list2);
        ResourceLocation resourceLocation = War.findDefaultFacesConfig(classFinder);
        if (resourceLocation != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<ResourceLocation>();
            }
            arrayList.add(resourceLocation);
        }
        return arrayList == null ? Collections.EMPTY_LIST : arrayList;
    }

    private static void findTLDs(File file, String string, List list) {
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                War.findTLDs(file2, string + '/' + stringArray[i], list);
                continue;
            }
            if (!file2.isFile() || !stringArray[i].endsWith(".tld")) continue;
            list.add(new ResourceLocation(file2, string + '/' + stringArray[i], 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void findJarTLD(File file, List list) {
        JarFile jarFile = null;
        jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (!string.endsWith(".tld")) continue;
            list.add(new JarResourceLocation(file, string, 1));
        }
        Object var7_7 = null;
        if (jarFile == null) return;
        try {
            jarFile.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Object var7_8 = null;
                if (jarFile == null) return;
                try {
                    jarFile.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static List findMetaInfFacesConfigs(ClassFinder classFinder) {
        ArrayList<JarResourceLocation> arrayList = null;
        List list = War.getWebInfLibJarFiles(classFinder.getClassPath(), false);
        for (File file : list) {
            JarFile jarFile;
            block11: {
                jarFile = null;
                jarFile = new JarFile(file);
                JarEntry jarEntry = jarFile.getJarEntry(META_INF_FACES_CONFIG);
                if (jarEntry == null) break block11;
                if (arrayList == null) {
                    arrayList = new ArrayList<JarResourceLocation>();
                }
                arrayList.add(new JarResourceLocation(file, META_INF_FACES_CONFIG, 2));
            }
            Object var8_8 = null;
            if (jarFile == null) continue;
            try {
                jarFile.close();
            }
            catch (IOException iOException2) {}
            continue;
            {
                catch (IOException iOException) {
                    var8_8 = null;
                    if (jarFile == null) continue;
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var8_8 = null;
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    private static List findFacesConfigFiles(String string, ClassFinder classFinder) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        String[] stringArray = string.split(",");
        ArrayList<ResourceLocation> arrayList = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Source source;
            if (WEB_INF_FACES_CONFIG.equals(stringArray[i])) continue;
            if (!stringArray[i].startsWith("/")) {
                stringArray[i] = "/" + stringArray[i];
            }
            if ((source = classFinder.getSource(stringArray[i])) == null) continue;
            URL uRL = source.getURL();
            String string2 = uRL.getProtocol();
            String string3 = uRL.getFile();
            if (!"file".equals(string2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ResourceLocation>();
            }
            arrayList.add(new ResourceLocation(new File(string3), stringArray[i], 2));
        }
        return arrayList;
    }

    private static ResourceLocation findDefaultFacesConfig(ClassFinder classFinder) {
        Source source = classFinder.getSource(WEB_INF_FACES_CONFIG);
        if (source == null) {
            return null;
        }
        URL uRL = source.getURL();
        String string = uRL.getProtocol();
        if (!"file".equals(string)) {
            return null;
        }
        String string2 = uRL.getFile();
        return new ResourceLocation(new File(string2), WEB_INF_FACES_CONFIG, 2);
    }

    private static List getWebInfLibJarFiles(String string, boolean bl) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        String[] stringArray = string.split(File.pathSeparator);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".jar") || bl && stringArray[i].endsWith("_wl_cls_gen.jar")) continue;
            File file = new File(stringArray[i]);
            if (!stringArray[i].replace(File.separatorChar, '/').endsWith("WEB-INF/lib/" + file.getName())) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private void processExtensions(File file) throws IOException {
        Source source;
        Object object;
        if (this.isConsoleWar || this.isConsoleHelpWar) {
            long l = 0L;
            long l2 = 0L;
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("**** processExtensions, finding console extensions");
                l = System.currentTimeMillis();
            }
            object = ConsoleExtensionManager.getInstance();
            ConsoleExtensionManager.ExtensionDef[] extensionDefArray = ((ConsoleExtensionManager)object).findExtensions();
            if (debugLogger.isDebugEnabled()) {
                l2 = System.currentTimeMillis();
            }
            if (extensionDefArray.length > 0) {
                for (int i = 0; i < extensionDefArray.length; ++i) {
                    ConsoleExtensionManager.ExtensionDef extensionDef = extensionDefArray[i];
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("**** processExtensions, found extension: " + extensionDef);
                    }
                    if (!((ConsoleExtensionManager)object).shouldIncludeExtension(this.uri, extensionDef)) continue;
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("**** processExtensions, archive will be loaded");
                    }
                    File file2 = extensionDef.getFile();
                    File file3 = War.computeExtractDir(file, file2, CONSOLE_EXTENSION_EXTRACT_ROOT);
                    final ArchivedWar archivedWar = new ArchivedWar(this.uri, file3, file2, WAR_CLASSPATH_INFO);
                    final String string = file2.getName();
                    this.extensions.add(new WarExtension(){

                        public String getName() {
                            return string;
                        }

                        public ClassFinder getClassFinder() throws IOException {
                            return archivedWar.getClassFinder();
                        }

                        public Collection getTagListeners(boolean bl) {
                            return Collections.EMPTY_SET;
                        }

                        public Collection getTagHandlers(boolean bl) {
                            return Collections.EMPTY_SET;
                        }

                        public List getAnnotatedClasses() {
                            return Collections.EMPTY_LIST;
                        }

                        public Set getFacesManagedBeans() {
                            return Collections.EMPTY_SET;
                        }

                        public void remove() {
                            archivedWar.remove();
                        }
                    });
                    this.beaExtensionRoots.addAll(Arrays.asList(archivedWar.getDirs()));
                }
            } else if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("**** processExtensions, No console extensions configured");
            }
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("**** processExtensions, console extension execution time(ms):" + (l2 - l));
            }
            ((ConsoleExtensionManager)object).release();
        }
        Enumeration enumeration = this.classfinder.getSources(this.uri + "#" + BEA_EXTN_DIR);
        while (enumeration.hasMoreElements()) {
            source = (Source)enumeration.nextElement();
            URL uRL = source.getURL();
            if (!"file".equals(uRL.getProtocol())) {
                throw new AssertionError((Object)("Unknown protocol " + uRL.getProtocol()));
            }
            Object object2 = uRL.getPath();
            object = new File((String)object2);
            if (!((File)object).isDirectory()) continue;
            this.processExtensionsDir((File)object, EXTENSION_EXTRACT_ROOT, file);
        }
        if (this.extensions.size() > 0) {
            source = new MultiClassFinder();
            for (Object object2 : this.extensions) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Prepending extension: " + object2.getName());
                }
                source.addFinder(object2.getClassFinder());
            }
            this.classfinder.addFinderFirst((ClassFinder)source);
        }
    }

    private void processExtensionsDir(File file, String string, File file2) throws IOException {
        File[] fileArray = file.listFiles(WEBAPP_EXTN);
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file3 = War.computeExtractDir(file2, fileArray[i], string);
            final ArchivedWar archivedWar = new ArchivedWar(this.uri, file3, fileArray[i], WAR_CLASSPATH_INFO);
            final String string2 = fileArray[i].getName();
            this.extensions.add(new WarExtension(){

                public String getName() {
                    return string2;
                }

                public ClassFinder getClassFinder() throws IOException {
                    return archivedWar.getClassFinder();
                }

                public Collection getTagListeners(boolean bl) {
                    return Collections.EMPTY_SET;
                }

                public Collection getTagHandlers(boolean bl) {
                    return Collections.EMPTY_SET;
                }

                public List getAnnotatedClasses() {
                    return Collections.EMPTY_LIST;
                }

                public Set getFacesManagedBeans() {
                    return Collections.EMPTY_SET;
                }

                public void remove() {
                    archivedWar.remove();
                }
            });
            this.beaExtensionRoots.addAll(Arrays.asList(archivedWar.getDirs()));
        }
    }

    private Map getWebTldInfo() {
        if (this.tldInfo == null) {
            List list = this.getWebTLDLocations();
            this.tldInfo = TldCacheHelper.parseTagLibraries((Collection)list, this.extractDir, this.uri);
        }
        return this.tldInfo;
    }

    public Set getTagClasses(boolean bl, String string) {
        Set set = null;
        Map map = this.getWebTldInfo();
        ClassFinder classFinder = this.classfinder.getWebappFinder();
        Collection collection = War.getWebTagClasses(classFinder, map, bl, string);
        set = War.addAllIfNotEmpty(set, collection);
        Set set2 = this.getLibTagClasses(bl, string);
        return (set = War.addAllIfNotEmpty(set, (Collection)set2)) == null ? Collections.EMPTY_SET : set;
    }

    public static Collection getWebTagClasses(ClassFinder classFinder, Map map, boolean bl, String string) {
        Collection collection = null;
        Collection collection2 = (Collection)map.get(string);
        if (bl) {
            if (collection2 != null && !collection2.isEmpty()) {
                for (Object e : collection2) {
                    String string2 = (String)e;
                    if (!ClassAnnotationDetector.isClassHasAnnotation(classFinder, string2)) continue;
                    if (collection == null) {
                        collection = new ArraySet();
                    }
                    collection.add(string2);
                }
            }
        } else {
            collection = collection2;
        }
        return collection;
    }

    public Set getLibTagClasses(boolean bl, String string) {
        Set set = null;
        for (WarExtension warExtension : this.extensions) {
            Collection collection = null;
            if (string.equals("listener-class")) {
                collection = warExtension.getTagListeners(bl);
            } else if (string.equals("tag-class")) {
                collection = warExtension.getTagHandlers(bl);
            }
            set = War.addAllIfNotEmpty(set, collection);
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getFacesManagedBeans(String string, File file) {
        List list = this.getWebFacesLocations(string);
        Set set = null;
        Set set2 = FaceConfigCacheHelper.parseFacesConfigs((Collection)list, file, this.uri);
        set = War.addAllIfNotEmpty(set, (Collection)set2);
        Set set3 = this.getLibManagedBeans();
        return (set = War.addAllIfNotEmpty(set, (Collection)set3)) == null ? Collections.EMPTY_SET : set;
    }

    public Set getLibManagedBeans() {
        Set set = null;
        for (WarExtension warExtension : this.extensions) {
            Set set2 = warExtension.getFacesManagedBeans();
            set = War.addAllIfNotEmpty(set, (Collection)set2);
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public List getAnnotatedClasses(WebAnnotationProcessor webAnnotationProcessor) {
        List list = null;
        ClassFinder classFinder = this.classfinder.getWebappFinder();
        List list2 = webAnnotationProcessor.getAnnotatedClasses(classFinder);
        list = War.addAllIfNotEmpty(list, (Collection)list2);
        for (WarExtension warExtension : this.extensions) {
            List list3 = warExtension.getAnnotatedClasses();
            list = War.addAllIfNotEmpty(list, (Collection)list3);
        }
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public static Set addAllIfNotEmpty(Set set, Collection collection) {
        Set set2 = set;
        if (collection != null && !collection.isEmpty()) {
            if (set2 == null) {
                set2 = new ArraySet();
            }
            set2.addAll(collection);
        }
        return set2;
    }

    public static List addAllIfNotEmpty(List arrayList, Collection collection) {
        ArrayList arrayList2 = arrayList;
        if (collection != null && !collection.isEmpty()) {
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
            }
            arrayList2.addAll(collection);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExplodedJar makeExplodedJar(String string, File file, File[] fileArray, boolean bl) throws IOException {
        block3: {
            long l = 0L;
            try {
                if (fileArray.length != 1 || fileArray[0].isDirectory()) break block3;
                ArchivedWar archivedWar = new ArchivedWar(string, file, fileArray[0], WAR_CLASSPATH_INFO);
                Object var8_7 = null;
                return archivedWar;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
        CaseAwareExplodedJar caseAwareExplodedJar = new CaseAwareExplodedJar(string, file, fileArray, WAR_CLASSPATH_INFO, bl ? JarCopyFilter.NOCOPY_FILTER : JarCopyFilter.DEFAULT_FILTER);
        Object var8_8 = null;
        return caseAwareExplodedJar;
    }

    private static ServletMapping newServletMapping() {
        if (!Kernel.isServer()) {
            return new ServletMapping();
        }
        return new ServletMapping(WebAppConfigManager.isCaseInsensitive(), WebAppSecurity.getEnforceStrictURLPattern());
    }

    private static File computeExtractDir(File file, File file2, String string) {
        String string2 = file2.getName();
        if (string2.lastIndexOf(46) > 0) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        return War.computeExtractDir(file, string2, string);
    }

    private static File computeExtractDir(File file, String string, String string2) {
        File file2 = new File(file, string2 + File.separator + string);
        return file2;
    }

    public void setVirtualMappingPaths(List list) {
        for (String string : list) {
            if (string.endsWith(File.separator)) {
                this.matchSet.add(string.substring(0, string.length() - 1));
                continue;
            }
            this.matchSet.add(string);
        }
    }

    public boolean isKnownVirtualMappingUri(String string) {
        if (this.matchSet.isEmpty() || string == null) {
            return false;
        }
        string = FileUtils.normalize((String)string);
        while (string.length() > 0) {
            boolean bl = this.matchSet.contains(string);
            if (bl) {
                return true;
            }
            int n = string.lastIndexOf(File.separatorChar);
            if (n > 0) {
                string = string.substring(0, n);
                continue;
            }
            string = "";
        }
        return false;
    }

    private static class SplitWebInfoClassesDescriptorFinder
    extends DescriptorFinder {
        private String prefix;
        private ClassFinder delegate;

        public SplitWebInfoClassesDescriptorFinder(String string, ClassFinder classFinder) throws IOException {
            super(string, classFinder);
            this.prefix = string + "#" + WEB_INF_CLASSES;
            this.delegate = classFinder;
        }

        public Source getSource(String string) {
            if (string != null && string.startsWith(this.prefix)) {
                return this.delegate.getSource(this.removePrefix(string));
            }
            return null;
        }

        public Enumeration getSources(String string) {
            if (string != null && string.startsWith(this.prefix)) {
                return this.delegate.getSources(this.removePrefix(string));
            }
            return new EmptyEnumerator();
        }

        private String removePrefix(String string) {
            return string.substring(this.prefix.length(), string.length());
        }
    }

    private static class LibraryFinder
    extends DelegateFinder {
        private final boolean fromArchive;

        public LibraryFinder(ClassFinder classFinder, Library library) {
            super(classFinder);
            boolean bl = false;
            if (library instanceof WarLibraryDefinition) {
                bl = ((WarLibraryDefinition)library).isArchived();
            }
            this.fromArchive = bl;
        }

        public Source getSource(String string) {
            Source source = super.getSource(string);
            if (source == null) {
                return null;
            }
            return new LibrarySource(source, this.fromArchive);
        }

        public Enumeration getSources(String string) {
            Enumeration enumeration = super.getSources(string);
            ArrayList<LibrarySource> arrayList = null;
            if (enumeration != null) {
                arrayList = new ArrayList<LibrarySource>();
                while (enumeration.hasMoreElements()) {
                    Source source = (Source)enumeration.nextElement();
                    arrayList.add(new LibrarySource(source, this.fromArchive));
                }
            }
            if (arrayList == null) {
                return new EmptyEnumerator();
            }
            return new IteratorEnumerator(arrayList.iterator());
        }
    }

    public static class LibrarySource
    extends DelegateSource {
        private boolean fromArchive;

        public LibrarySource(Source source, boolean bl) {
            super(source);
            this.fromArchive = bl;
        }

        public boolean isFromArchive() {
            return this.fromArchive;
        }
    }

    static final class JarResourceLocation
    extends ResourceLocation {
        private String fragment;

        JarResourceLocation(File file, String string, int n) {
            super(file, file.getName() + '/' + string, n);
            this.fragment = string;
        }

        InputStream getInputStream() {
            block9: {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(this.location);
                    JarEntry jarEntry = (JarEntry)jarFile.getEntry(this.fragment);
                    if (jarEntry != null) {
                        return new SafeZipFileInputStream((ZipFile)jarFile, (ZipEntry)jarEntry);
                    }
                }
                catch (IOException iOException) {
                    if (HTTPDebugLogger.isEnabled()) {
                        if (this.type == 1) {
                            HTTPDebugLogger.debug("[War] Unable to find tld at location: " + this.getLocation());
                        } else if (this.type == 2) {
                            HTTPDebugLogger.debug("[War] Unable to find faces config file at location: " + this.getLocation());
                        }
                    }
                    if (jarFile == null) break block9;
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        String getLocation() {
            return this.location.getAbsolutePath() + "!" + (this.fragment.endsWith("/") ? this.fragment : "/" + this.fragment);
        }
    }

    static class ResourceLocation
    implements Serializable {
        static final int TYPE_TLD = 1;
        static final int TYPE_FACES_CONFIG = 2;
        protected final int type;
        protected final File location;
        private final String uri;

        ResourceLocation(File file, String string, int n) {
            this.location = file;
            this.uri = string;
            this.type = n;
        }

        InputStream getInputStream() throws IOException {
            return new FileInputStream(this.location);
        }

        String getLocation() {
            return this.location.getAbsolutePath();
        }

        String getURI() {
            return this.uri;
        }

        int getType() {
            return this.type;
        }
    }

    static final class ResourceFinder
    implements ClassFinder {
        private static final NullSource NULL = new NullSource();
        private final SecondChanceCacheMap cache = new SecondChanceCacheMap(317);
        private ClassFinder delegate;
        private ResourceFinder webappResourceFinder;
        private String prefix;
        private String classpath;
        private WebAppConfigManager configManager;

        ResourceFinder(String string, ClassFinder classFinder) {
            this(string, classFinder, null);
        }

        ResourceFinder(String string, ClassFinder classFinder, WebAppConfigManager webAppConfigManager) {
            this.prefix = string;
            this.delegate = classFinder;
            this.configManager = webAppConfigManager;
        }

        public ResourceFinder getWebResourceFinder() {
            if (this.delegate instanceof CompositeWebAppFinder) {
                if (this.webappResourceFinder == null) {
                    this.webappResourceFinder = new ResourceFinder(this.prefix, ((CompositeWebAppFinder)this.delegate).getWebappFinder(), this.configManager);
                }
                return this.webappResourceFinder;
            }
            return this;
        }

        public Source getSource(String string) {
            WarSource warSource = (WarSource)this.cache.get((Object)(this.prefix + string));
            int n = -1;
            if (this.configManager != null) {
                n = this.configManager.getResourceReloadCheckSecs() * 1000;
            }
            if (warSource == null || n >= 0 && System.currentTimeMillis() - (long)n > warSource.getLastChecked()) {
                warSource = this.getSource(string, true);
            }
            if (warSource.delegate == NULL) {
                return null;
            }
            return warSource;
        }

        private WarSource getSource(String string, boolean bl) {
            WarSource warSource = null;
            if (bl) {
                Source source = this.delegate.getSource(this.prefix + string);
                if (source == null) {
                    source = NULL;
                }
                warSource = new WarSource(source);
                this.cache.put((Object)(this.prefix + string), (Object)warSource);
            }
            return warSource;
        }

        public Enumeration getSources(String string) {
            Enumeration enumeration = this.delegate.getSources(this.prefix + string);
            ArrayList<WarSource> arrayList = null;
            if (enumeration != null) {
                arrayList = new ArrayList<WarSource>();
                while (enumeration.hasMoreElements()) {
                    arrayList.add(new WarSource((Source)enumeration.nextElement()));
                }
            }
            if (arrayList == null) {
                return new EmptyEnumerator();
            }
            return new IteratorEnumerator(arrayList.iterator());
        }

        public Source getClassSource(String string) {
            return this.delegate.getClassSource(string);
        }

        public String getClassPath() {
            if (this.classpath != null) {
                return this.classpath;
            }
            String string = null;
            Enumeration enumeration = this.delegate.getSources(this.prefix + "/");
            while (enumeration.hasMoreElements()) {
                Source source = (Source)enumeration.nextElement();
                URL uRL = source.getURL();
                if (uRL == null) continue;
                if (string == null) {
                    string = uRL.getPath() + File.pathSeparator;
                    continue;
                }
                string = string + uRL.getPath() + File.pathSeparator;
            }
            this.classpath = string;
            return this.classpath;
        }

        public ClassFinder getManifestFinder() {
            return this.delegate.getManifestFinder();
        }

        public Enumeration entries() {
            return this.delegate.entries();
        }

        public void clearCache(String string) {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            this.cache.remove((Object)(this.prefix + string));
        }

        public void close() {
            this.classpath = null;
            this.delegate.close();
        }
    }

    private static class NoOpArchive
    extends Archive {
        private NoOpArchive() {
        }

        public ClassFinder getClassFinder() throws IOException {
            return NullClassFinder.NULL_FINDER;
        }

        public void remove() {
        }
    }

    static interface WarExtension {
        public String getName();

        public ClassFinder getClassFinder() throws IOException;

        public Collection getTagListeners(boolean var1);

        public Collection getTagHandlers(boolean var1);

        public List getAnnotatedClasses();

        public Set getFacesManagedBeans();

        public void remove();
    }
}

