/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import weblogic.application.ComponentMBeanFactory;
import weblogic.application.Deployment;
import weblogic.application.DeploymentFactory;
import weblogic.application.internal.BaseComponentMBeanFactory;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.servlet.internal.WarDeployment;
import weblogic.servlet.utils.WarUtils;

public final class WarDeploymentFactory
extends BaseComponentMBeanFactory
implements DeploymentFactory,
ComponentMBeanFactory {
    public Deployment createDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        try {
            return WarUtils.isWar(file) ? new WarDeployment(appDeploymentMBean, file) : null;
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException);
        }
    }

    public Deployment createDeployment(SystemResourceMBean systemResourceMBean, File file) throws DeploymentException {
        return null;
    }

    public ComponentMBean[] findOrCreateComponentMBeans(ApplicationMBean applicationMBean, File file, AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        try {
            if (!WarUtils.isWar(file)) {
                return null;
            }
            String string = file.getName();
            String string2 = this.removeExtension(string);
            if (appDeploymentMBean != null) {
                string2 = this.getCompatibilityName(string2, appDeploymentMBean);
            }
            ComponentMBeanFactory.MBeanFactory mBeanFactory = WarUtils.isWebServices(file) ? WEB_SERVICE_COMP : WEB_COMP;
            ComponentMBean componentMBean = this.findOrCreateComponentMBean(mBeanFactory, applicationMBean, string2, string);
            return new ComponentMBean[]{componentMBean};
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException);
        }
    }
}

