/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import weblogic.application.Type;
import weblogic.application.io.ExplodedJar;
import weblogic.application.io.JarCopyFilter;
import weblogic.application.library.ApplicationLibrary;
import weblogic.application.library.CachableLibMetadataEntry;
import weblogic.application.library.CachableLibMetadataType;
import weblogic.application.library.IllegalSpecVersionTypeException;
import weblogic.application.library.J2EELibraryReference;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryConstants;
import weblogic.application.library.LibraryContext;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryMetadataCache;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.library.LibraryReference;
import weblogic.application.library.LibraryReferenceFactory;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.WebBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.AnnotatedClassesCacheEntry;
import weblogic.servlet.internal.AnnotatedTagHandlersCacheEntry;
import weblogic.servlet.internal.AnnotatedTagListenersCacheEntry;
import weblogic.servlet.internal.DescriptorCacheEntry;
import weblogic.servlet.internal.FaceConfigCacheEntry;
import weblogic.servlet.internal.TldCacheEntry;
import weblogic.servlet.internal.TldCacheHelper;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAnnotationProcessor;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.servlet.utils.WarUtils;
import weblogic.servlet.utils.annotation.ClassAnnotationDetector;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.collections.ArraySet;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class WarLibraryDefinition
extends LibraryDefinition
implements Library,
ApplicationLibrary {
    private LibraryReference[] libraryRefs = null;
    private final File extractDir;
    private final boolean archived;
    private Map cacheEntries;
    private static String singletonAutoRefLibName = null;
    private final String ctxRootFromLocation;
    private ExplodedJar jar;
    private String jsfConfigFiles = null;
    private boolean isReferenceJSFLib = false;
    private Map tldInfo = null;
    private boolean isAnnotationEnabled = false;

    public WarLibraryDefinition(LibraryData libraryData, File file) {
        super(libraryData, Type.WAR);
        this.extractDir = file;
        this.ctxRootFromLocation = this.getLocation().getName();
        this.archived = !this.getLocation().isDirectory();
        this.cacheEntries = new HashMap();
        this.cacheEntries.put(CachableLibMetadataType.ANNOTATED_CLASSES, new AnnotatedClassesCacheEntry(this));
        this.cacheEntries.put(CachableLibMetadataType.TLD, new TldCacheEntry(this));
        this.cacheEntries.put(CachableLibMetadataType.TAG_HANDLERS, new AnnotatedTagHandlersCacheEntry(this));
        this.cacheEntries.put(CachableLibMetadataType.TAG_LISTENERS, new AnnotatedTagListenersCacheEntry(this));
        this.cacheEntries.put(CachableLibMetadataType.FACE_BEANS, new FaceConfigCacheEntry(this));
    }

    public Collection getAnnotatedTagListeners() throws LibraryProcessingException {
        return this.getAnnotatedTagClasses("listener-class");
    }

    public Collection getAnnotatedTagHandlers() throws LibraryProcessingException {
        return this.getAnnotatedTagClasses("tag-class");
    }

    public boolean isArchived() {
        return this.archived;
    }

    public File getLibTempDir() {
        return this.extractDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getTldLocations() throws LibraryProcessingException {
        ArrayList arrayList;
        War.ResourceFinder resourceFinder;
        block6: {
            ClassFinder classFinder = null;
            resourceFinder = null;
            arrayList = new ArrayList();
            try {
                try {
                    classFinder = this.getClassFinder();
                    resourceFinder = new War.ResourceFinder("wld#", classFinder);
                    War.findTlds(resourceFinder, arrayList, classFinder);
                }
                catch (Exception exception) {
                    throw new LibraryProcessingException(exception);
                }
                Object var6_4 = null;
                if (classFinder == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (classFinder != null) {
                    classFinder.close();
                }
                if (resourceFinder == null) throw throwable;
                resourceFinder.close();
                throw throwable;
            }
            classFinder.close();
        }
        if (resourceFinder == null) return arrayList;
        resourceFinder.close();
        return arrayList;
    }

    public List getFacesConfigLocations() throws LibraryProcessingException {
        List list;
        War.ResourceFinder resourceFinder;
        block7: {
            if (!this.isReferenceJSFLib) {
                return Collections.EMPTY_LIST;
            }
            ClassFinder classFinder = null;
            resourceFinder = null;
            try {
                classFinder = this.getClassFinder();
                resourceFinder = new War.ResourceFinder("wld#", classFinder);
                list = War.findFacesConfigs(this.jsfConfigFiles, resourceFinder, classFinder);
                Object var5_5 = null;
                if (classFinder == null) break block7;
            }
            catch (Exception exception) {
                try {
                    throw new LibraryProcessingException(exception);
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var5_6 = null;
                        if (classFinder != null) {
                            classFinder.close();
                        }
                        if (resourceFinder == null) break block8;
                        resourceFinder.close();
                    }
                    throw throwable;
                }
            }
            classFinder.close();
        }
        if (resourceFinder != null) {
            resourceFinder.close();
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getAnnotatedClasses() throws LibraryProcessingException {
        if (!this.isAnnotationEnabled) {
            return Collections.EMPTY_LIST;
        }
        List list = null;
        ClassFinder classFinder = null;
        try {
            try {
                classFinder = this.getClassFinder();
                String string = "weblogic.servlet.internal.WebAnnotationProcessorImpl";
                WebAnnotationProcessor webAnnotationProcessor = (WebAnnotationProcessor)Class.forName(string).newInstance();
                list = webAnnotationProcessor.getAnnotatedClasses(classFinder);
            }
            catch (Exception exception) {
                throw new LibraryProcessingException(exception);
            }
            Object var6_6 = null;
            if (classFinder == null) return list;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (classFinder == null) throw throwable;
            classFinder.close();
            throw throwable;
        }
        classFinder.close();
        return list;
    }

    private ClassFinder getClassFinder() throws IOException {
        if (this.archived) {
            return this.jar.getClassFinder();
        }
        ExplodedJar explodedJar = new ExplodedJar("wld", this.extractDir, new File[]{this.getLocation()}, War.WAR_CLASSPATH_INFO, JarCopyFilter.NOCOPY_FILTER);
        return explodedJar.getClassFinder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws LibraryProcessingException {
        block13: {
            LibraryConstants.AutoReferrer[] autoReferrerArray = this.getAutoRef();
            if (autoReferrerArray.length > 0) {
                for (LibraryConstants.AutoReferrer autoReferrer : autoReferrerArray) {
                    if (autoReferrer == LibraryConstants.AutoReferrer.WebApp) continue;
                    throw new LibraryProcessingException("Unsupported Auto-Ref value: " + (Object)((Object)autoReferrer));
                }
                if (singletonAutoRefLibName == null) {
                    singletonAutoRefLibName = this.getName();
                } else if (!singletonAutoRefLibName.equals(this.getName())) {
                    throw new LibraryProcessingException("Only one web auto reference library allowed. " + singletonAutoRefLibName + " is already deployed as an auto reference library");
                }
            }
            if (this.jar == null && this.archived) {
                try {
                    try {
                        this.jar = new ExplodedJar("wld", this.extractDir, this.getLocation(), War.WAR_CLASSPATH_INFO);
                        this.setLocation(this.extractDir);
                    }
                    catch (IOException iOException) {
                        throw new LibraryProcessingException(iOException);
                    }
                    Object var7_7 = null;
                    if (this.jar == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (this.jar == null) throw throwable;
                    try {
                        this.jar.getClassFinder().close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                this.jar.getClassFinder().close();
            }
        }
        this.initDescriptors();
        LibraryMetadataCache.getInstance().initLibraryCache(this);
    }

    public void importLibrary(J2EELibraryReference j2EELibraryReference, LibraryContext libraryContext, MultiClassFinder multiClassFinder) throws LibraryProcessingException {
        String string = j2EELibraryReference.getContextRoot() == null ? this.ctxRootFromLocation : j2EELibraryReference.getContextRoot();
        this.addWebModule(libraryContext, this.getLocation().getName(), string);
        try {
            libraryContext.registerLink(this.getLocation());
        }
        catch (IOException iOException) {
            throw new LibraryProcessingException(iOException);
        }
    }

    public LibraryReference[] getLibraryReferences() {
        return this.libraryRefs;
    }

    public void cleanup() throws LibraryProcessingException {
        LibraryConstants.AutoReferrer[] autoReferrerArray = this.getAutoRef();
        if (autoReferrerArray.length > 0 && singletonAutoRefLibName != null && singletonAutoRefLibName.equals(this.getName())) {
            singletonAutoRefLibName = null;
        }
    }

    public void remove() throws LibraryProcessingException {
        if (this.jar != null) {
            this.jar.remove();
            this.jar = null;
        }
        LibraryMetadataCache.getInstance().clearLibraryCache(this);
        this.cacheEntries.clear();
    }

    public CachableLibMetadataEntry[] findAllCachableEntry() {
        return this.cacheEntries.values().toArray(new CachableLibMetadataEntry[this.cacheEntries.size()]);
    }

    public CachableLibMetadataEntry getCachableEntry(CachableLibMetadataType cachableLibMetadataType) {
        return (CachableLibMetadataEntry)this.cacheEntries.get(cachableLibMetadataType);
    }

    private void addWebModule(LibraryContext libraryContext, String string, String string2) throws LibraryProcessingException {
        ApplicationBean applicationBean = libraryContext.getApplicationDD();
        WebBean webBean = applicationBean.createModule().createWeb();
        webBean.setWebUri(string);
        webBean.setContextRoot(string2);
        LibraryLoggingUtils.updateDescriptor(libraryContext.getApplicationDescriptor(), applicationBean);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initDescriptors() throws LibraryProcessingException {
        VirtualJarFile virtualJarFile = null;
        try {
            try {
                virtualJarFile = VirtualJarFactory.createVirtualJar((File)this.getLocation());
                WebAppDescriptor webAppDescriptor = new WebAppDescriptor(virtualJarFile);
                WebAppBean webAppBean = webAppDescriptor.getWebAppBean();
                WeblogicWebAppBean weblogicWebAppBean = webAppDescriptor.getWeblogicWebAppBean();
                this.isAnnotationEnabled = WarUtils.isAnnotationEnabled(webAppBean);
                this.jsfConfigFiles = WarUtils.getFacesConfigFiles(webAppBean);
                this.isReferenceJSFLib = WarUtils.isJsfApplication(webAppBean, weblogicWebAppBean);
                if (weblogicWebAppBean != null) {
                    this.libraryRefs = LibraryReferenceFactory.getWebLibReference(weblogicWebAppBean.getLibraryRefs());
                }
            }
            catch (IOException iOException) {
                throw new LibraryProcessingException(iOException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new LibraryProcessingException(xMLStreamException);
            }
            catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
                throw new LibraryProcessingException(HTTPLogger.logIllegalWebLibSpecVersionRefLoggable((String)this.getLocation().getName(), (String)illegalSpecVersionTypeException.getSpecVersion()).getMessage());
            }
            Object var6_8 = null;
            if (virtualJarFile == null) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (virtualJarFile == null) throw throwable;
            try {
                virtualJarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        virtualJarFile.close();
        return;
    }

    private Map getTldInfo() throws LibraryProcessingException {
        if (this.tldInfo == null) {
            CachableLibMetadataEntry cachableLibMetadataEntry = this.getCachableEntry(CachableLibMetadataType.TLD);
            DescriptorCacheEntry.DescriptorCachableObject descriptorCachableObject = (DescriptorCacheEntry.DescriptorCachableObject)LibraryMetadataCache.getInstance().lookupCachedObject(cachableLibMetadataEntry);
            this.tldInfo = TldCacheHelper.parseTagLibraries((Collection)descriptorCachableObject.getResourceLocation(), descriptorCachableObject.getCacheBaseDir(), this.getName());
        }
        return this.tldInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection getAnnotatedTagClasses(String string) throws LibraryProcessingException {
        Map map;
        ClassFinder classFinder;
        Set set;
        block8: {
            if (!this.isAnnotationEnabled) {
                return Collections.EMPTY_SET;
            }
            set = Collections.EMPTY_SET;
            classFinder = null;
            classFinder = this.getClassFinder();
            map = this.getTldInfo();
            if (map != Collections.EMPTY_MAP) break block8;
            Set set2 = Collections.EMPTY_SET;
            Object var9_8 = null;
            if (classFinder == null) return set2;
            classFinder.close();
            return set2;
        }
        try {
            try {
                Collection collection = (Collection)map.get(string);
                for (Object e : collection) {
                    if (!ClassAnnotationDetector.isClassHasAnnotation(classFinder, (String)e)) continue;
                    if (set == Collections.EMPTY_SET) {
                        set = new ArraySet();
                    }
                    set.add(e);
                }
                Object var9_9 = null;
                if (classFinder == null) return set;
            }
            catch (IOException iOException) {
                throw new LibraryProcessingException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (classFinder == null) throw throwable;
            classFinder.close();
            throw throwable;
        }
        classFinder.close();
        return set;
    }

    static class Noop
    extends WarLibraryDefinition {
        Noop(LibraryData libraryData, File file) {
            super(libraryData, file);
        }

        public void importLibrary(J2EELibraryReference j2EELibraryReference, LibraryContext libraryContext, MultiClassFinder multiClassFinder) {
        }
    }
}

