/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryFactory;
import weblogic.application.library.LibraryProcessingException;
import weblogic.servlet.internal.WarLibraryDefinition;
import weblogic.servlet.utils.WarUtils;

public final class WarLibraryFactory
implements LibraryFactory {
    public LibraryDefinition createLibrary(LibraryData libraryData, File file) throws LibraryProcessingException {
        try {
            if (WarUtils.isWar(libraryData.getLocation())) {
                return new WarLibraryDefinition(libraryData, file);
            }
        }
        catch (IOException iOException) {
            throw new LibraryProcessingException(iOException);
        }
        return null;
    }

    public static class Noop
    implements LibraryFactory {
        public LibraryDefinition createLibrary(LibraryData libraryData, File file) throws LibraryProcessingException {
            try {
                if (WarUtils.isWar(libraryData.getLocation())) {
                    return new WarLibraryDefinition.Noop(libraryData, file);
                }
            }
            catch (IOException iOException) {
                throw new LibraryProcessingException(iOException);
            }
            return null;
        }
    }
}

