/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.servlet.internal.MDSSource;
import weblogic.servlet.internal.ResponseHeaders;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.classloaders.FileSource;
import weblogic.utils.classloaders.NullSource;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.URLSource;
import weblogic.utils.classloaders.ZipSource;

public class WarSource
implements Source {
    final Source delegate;
    private final long length;
    private final boolean isDirectory;
    private final long lastChecked = System.currentTimeMillis();
    private final long lastModified;
    private final String lastModifiedString;
    private final boolean fromArchive;
    private final boolean fromLibrary;
    private String contentType;
    private String fileName = null;

    public WarSource(Source source) {
        boolean bl = false;
        boolean bl2 = false;
        if (source instanceof War.LibrarySource) {
            War.LibrarySource librarySource = (War.LibrarySource)source;
            bl = librarySource.isFromArchive();
            source = librarySource.getSource();
            bl2 = true;
        }
        this.delegate = source;
        this.fromArchive = bl;
        this.fromLibrary = bl2;
        this.length = source.length();
        this.lastModified = source.lastModified();
        this.lastModifiedString = ResponseHeaders.getDateString(this.lastModified);
        this.isDirectory = WarSource.isDirectory(source);
    }

    public Source getDelegateSource() {
        return this.delegate;
    }

    public long getLastChecked() {
        return this.lastChecked;
    }

    public byte[] getBytes() throws IOException {
        return this.delegate.getBytes();
    }

    public long length() {
        return this.length;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public URL getCodeSourceURL() {
        return this.delegate.getCodeSourceURL();
    }

    public String getLastModifiedAsString() {
        return this.lastModifiedString;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        if (this.delegate instanceof FileSource) {
            return true;
        }
        if (this.delegate instanceof ZipSource) {
            return false;
        }
        if (this.delegate instanceof WarSource) {
            return ((WarSource)this.delegate).isFile();
        }
        if (this.delegate instanceof URLSource) {
            return true;
        }
        if (this.delegate instanceof MDSSource) {
            return false;
        }
        throw new UnsupportedOperationException("Can't isFile on: '" + this.delegate + "'");
    }

    public String getFileName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        if (this.delegate instanceof FileSource) {
            this.fileName = ((FileSource)this.delegate).getFile().getAbsolutePath();
        } else if (this.delegate instanceof ZipSource || this.delegate instanceof URLSource) {
            this.fileName = this.delegate.getURL().getFile();
        } else if (this.delegate instanceof MDSSource) {
            this.fileName = ((MDSSource)this.delegate).getProviderURI();
        } else if (this.delegate instanceof WarSource) {
            this.fileName = ((WarSource)this.delegate).getFileName();
        } else {
            throw new UnsupportedOperationException("Can't getFileName on: '" + this.delegate + "'");
        }
        return this.fileName;
    }

    public boolean isFromArchive() {
        return this.fromArchive;
    }

    public boolean isFromLibrary() {
        return this.fromLibrary;
    }

    public String getContentType(WebAppServletContext webAppServletContext) {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = webAppServletContext.getMimeType(this.getName());
        return this.contentType;
    }

    public String getName() {
        if (this.delegate instanceof FileSource) {
            return ((FileSource)this.delegate).getFile().getName();
        }
        if (this.delegate instanceof ZipSource) {
            String string = ((ZipSource)this.delegate).getEntry().getName();
            return this.getNameFromPath(string);
        }
        if (this.delegate instanceof MDSSource) {
            String string = ((MDSSource)this.delegate).getProviderURI();
            return this.getNameFromPath(string);
        }
        if (this.delegate instanceof WarSource) {
            return ((WarSource)this.delegate).getName();
        }
        if (this.delegate instanceof URLSource) {
            return ((URLSource)this.delegate).getURL().getFile();
        }
        throw new UnsupportedOperationException("Can't getName on: '" + this.delegate + "'");
    }

    private String getNameFromPath(String string) {
        int n;
        if (string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf("/")) != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public WarSource[] listSources() {
        if (this.delegate instanceof FileSource) {
            return WarSource.getFileSourceListing((FileSource)this.delegate);
        }
        if (this.delegate instanceof ZipSource) {
            return WarSource.getZipSourceListing((ZipSource)this.delegate);
        }
        if (this.delegate instanceof WarSource) {
            return ((WarSource)this.delegate).listSources();
        }
        if (this.delegate instanceof MDSSource) {
            return null;
        }
        if (this.delegate instanceof URLSource) {
            return null;
        }
        throw new UnsupportedOperationException("Can't getDirectoryListing on: " + this.delegate + "'");
    }

    private static WarSource[] getFileSourceListing(FileSource fileSource) {
        if (!fileSource.getFile().isDirectory()) {
            return null;
        }
        File[] fileArray = fileSource.getFile().listFiles();
        WarSource[] warSourceArray = new WarSource[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            warSourceArray[i] = new WarSource((Source)new FileSource(fileArray[i]));
        }
        return warSourceArray;
    }

    private static WarSource[] getZipSourceListing(ZipSource zipSource) {
        String string = zipSource.getEntry().getName();
        if ("/".equals(string)) {
            string = "";
        }
        ArrayList<WarSource> arrayList = new ArrayList<WarSource>();
        Enumeration<? extends ZipEntry> enumeration = zipSource.getFile().entries();
        while (enumeration.hasMoreElements()) {
            int n;
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (string2.equals(string) || !string2.startsWith(string) || (n = string2.indexOf("/", string.length())) > 0 && n < string2.length() - 1) continue;
            arrayList.add(new WarSource((Source)new ZipSource(zipSource.getFile(), zipEntry)));
        }
        return arrayList.toArray(new WarSource[arrayList.size()]);
    }

    private static boolean isDirectory(Source source) {
        if (source == null) {
            return false;
        }
        if (source instanceof FileSource) {
            return ((FileSource)source).getFile().isDirectory();
        }
        if (source instanceof ZipSource) {
            ZipSource zipSource = (ZipSource)source;
            if (zipSource.getEntry().isDirectory()) {
                return true;
            }
            ZipFile zipFile = zipSource.getFile();
            ZipEntry zipEntry = zipFile.getEntry(zipSource.getEntry().toString() + '/');
            return zipEntry != null;
        }
        if (source instanceof WarSource) {
            return ((WarSource)source).isDirectory();
        }
        if (source instanceof NullSource || source instanceof URLSource || source instanceof MDSSource) {
            return false;
        }
        throw new UnsupportedOperationException("Can't isDirectory on: '" + source + "'");
    }
}

