/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.annotation.security.DeclareRoles;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.apache.openjpa.lib.meta.ClassAnnotationMetaDataFilter;
import weblogic.application.utils.ClassFinderMetaDataEnumaration;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.dd.xml.J2eeAnnotationProcessor;
import weblogic.j2ee.descriptor.FilterBean;
import weblogic.j2ee.descriptor.J2eeClientEnvironmentBean;
import weblogic.j2ee.descriptor.ListenerBean;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.RunAsBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.ServletMappingBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.servlet.annotation.WLFilter;
import weblogic.servlet.annotation.WLInitParam;
import weblogic.servlet.annotation.WLServlet;
import weblogic.servlet.internal.WebAnnotationProcessor;
import weblogic.servlet.internal.WebAppHelper;
import weblogic.servlet.internal.WebComponentContributor;
import weblogic.servlet.utils.WarUtils;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class WebAnnotationProcessorImpl
extends J2eeAnnotationProcessor
implements WebAnnotationProcessor {
    private static final Class[] COMMON_ANNOTATION_CLASSES = new Class[]{WLServlet.class, WLFilter.class, WebService.class, WebServiceProvider.class};
    private ClassAnnotationMetaDataFilter annotationFilter = this.getAnnotationDataFilter();
    private JSFManagedBeanAnnotation jsfAnnotations;

    public WebAppBean processAnnotationsOnClone(GenericClassLoader genericClassLoader, WebAppBean webAppBean, WebAppHelper webAppHelper) throws ClassNotFoundException, ErrorCollectionException {
        if (!WarUtils.isAnnotationEnabled(webAppBean)) {
            return webAppBean;
        }
        Descriptor descriptor = (Descriptor)((DescriptorBean)webAppBean).getDescriptor().clone();
        WebAppBean webAppBean2 = (WebAppBean)descriptor.getRootBean();
        this.processAnnotations(genericClassLoader, webAppBean2, webAppHelper);
        return webAppBean2;
    }

    public void processAnnotations(GenericClassLoader genericClassLoader, WebAppBean webAppBean, WebAppHelper webAppHelper) throws ClassNotFoundException, ErrorCollectionException {
        if (!WarUtils.isAnnotationEnabled(webAppBean)) {
            return;
        }
        long l = System.currentTimeMillis();
        WebAnnotationProcessorImpl.dbg("Processing annotations... ");
        HashSet<String> hashSet = new HashSet<String>();
        if (webAppHelper != null) {
            for (Object e : webAppHelper.getAnnotatedClasses(this)) {
                Class clazz = genericClassLoader.loadClass((String)e);
                if (clazz.isAnnotationPresent(WLServlet.class)) {
                    this.processWLServletAnnotation(clazz, webAppBean);
                    continue;
                }
                if (clazz.isAnnotationPresent(WLFilter.class)) {
                    this.processWLFilterAnnotation(clazz, webAppBean);
                    continue;
                }
                if (clazz.isAnnotationPresent(WebService.class) || clazz.isAnnotationPresent(WebServiceProvider.class)) {
                    WebAnnotationProcessorImpl.dbg("Processing @WebService annotation on " + clazz);
                    if (clazz.isInterface()) continue;
                    WebAnnotationProcessorImpl.mergeWebAppWebService(clazz, webAppBean);
                    continue;
                }
                if (!this.jsfAnnotations.isAnnotedWithManagedBean(clazz)) continue;
                hashSet.add(clazz.getName());
            }
        }
        WebAnnotationProcessorImpl.dbg("Processing J2EE annotations ..");
        this.processJ2eeAnnotations((ClassLoader)genericClassLoader, webAppBean);
        WebAnnotationProcessorImpl.dbg("Processing tag-class annotations ..");
        if (webAppHelper != null) {
            for (Object e : webAppHelper.getTagHandlers(true)) {
                this.processJ2eeAnnotations(genericClassLoader.loadClass((String)e), (J2eeClientEnvironmentBean)webAppBean);
            }
        }
        WebAnnotationProcessorImpl.dbg("Processing listener-class annotations ..");
        if (webAppHelper != null) {
            for (Object e : webAppHelper.getTagListeners(true)) {
                this.processJ2eeAnnotations(genericClassLoader.loadClass((String)e), (J2eeClientEnvironmentBean)webAppBean);
            }
        }
        WebAnnotationProcessorImpl.dbg("Processing managed-bean-class annotations ..");
        if (webAppHelper != null) {
            for (Object e : webAppHelper.getManagedBeanClasses(hashSet)) {
                this.processJ2eeAnnotations(genericClassLoader.loadClass((String)e), (J2eeClientEnvironmentBean)webAppBean);
            }
        }
        WebAnnotationProcessorImpl.dbg("Annotation processing took " + (System.currentTimeMillis() - l) + " ms");
    }

    public List getAnnotatedClasses(ClassFinder classFinder) {
        ArrayList arrayList = null;
        ClassFinderMetaDataEnumaration classFinderMetaDataEnumaration = new ClassFinderMetaDataEnumaration(classFinder, this.annotationFilter);
        while (classFinderMetaDataEnumaration.hasMoreElements()) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(classFinderMetaDataEnumaration.nextElement());
        }
        return arrayList == null ? Collections.EMPTY_LIST : arrayList;
    }

    public static void mergeWebAppWebService(Class clazz, WebAppBean webAppBean) {
        ServletMappingBean[] servletMappingBeanArray;
        ServletMappingBean servletMappingBean;
        ServletBean servletBean = null;
        for (ServletBean servletBean2 : servletMappingBean = webAppBean.getServlets()) {
            if (!clazz.getName().equals(servletBean2.getServletClass())) continue;
            servletBean = servletBean2;
            break;
        }
        if (servletBean == null) {
            servletBean = webAppBean.createServlet();
            servletBean.setServletName(clazz.getName());
            servletBean.setServletClass(clazz.getName());
            servletBean.setLoadOnStartup("1");
        }
        ServletMappingBean servletMappingBean2 = null;
        for (ServletMappingBean servletMappingBean3 : servletMappingBeanArray = webAppBean.getServletMappings()) {
            if (!servletBean.getServletName().equals(servletMappingBean3.getServletName())) continue;
            servletMappingBean2 = servletMappingBean3;
            break;
        }
        if (servletMappingBean2 == null) {
            servletMappingBean2 = webAppBean.createServletMapping();
            servletMappingBean2.setServletName(servletBean.getServletName());
            servletMappingBean2.setUrlPatterns(new String[]{WebAnnotationProcessorImpl.getWebServiceName(clazz)});
        }
    }

    private static String getWebServiceName(Class clazz) {
        String string = null;
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webService != null) {
            string = webService.serviceName();
        } else {
            WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
            if (webServiceProvider != null) {
                string = webServiceProvider.serviceName();
            }
        }
        if (string == null || string.trim().equals("")) {
            string = clazz.getSimpleName() + "Service";
        }
        return string;
    }

    public void processJ2eeAnnotations(ClassLoader classLoader, WebAppBean webAppBean) throws ClassNotFoundException, ErrorCollectionException {
        if (!WarUtils.isAnnotationEnabled(webAppBean)) {
            return;
        }
        this.processServlets(webAppBean, classLoader);
        this.processFilters(webAppBean, classLoader);
        this.processListeners(webAppBean, classLoader);
        this.validate(classLoader, (DescriptorBean)webAppBean, false);
        this.throwProcessingErrors();
    }

    private void processServlets(WebAppBean webAppBean, ClassLoader classLoader) throws ClassNotFoundException {
        ServletBean[] servletBeanArray = webAppBean.getServlets();
        if (servletBeanArray == null || servletBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < servletBeanArray.length; ++i) {
            if (servletBeanArray[i].getServletClass() == null) continue;
            Class<?> clazz = classLoader.loadClass(servletBeanArray[i].getServletClass());
            this.processJ2eeAnnotations(clazz, (J2eeClientEnvironmentBean)webAppBean);
            this.processRunAs(clazz, (DescriptorBean)servletBeanArray[i]);
            this.processDeclareRoles(clazz, servletBeanArray[i], webAppBean);
        }
    }

    private void processFilters(WebAppBean webAppBean, ClassLoader classLoader) throws ClassNotFoundException {
        FilterBean[] filterBeanArray = webAppBean.getFilters();
        if (filterBeanArray == null || filterBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < filterBeanArray.length; ++i) {
            Class<?> clazz = classLoader.loadClass(filterBeanArray[i].getFilterClass());
            this.processJ2eeAnnotations(clazz, (J2eeClientEnvironmentBean)webAppBean);
        }
    }

    private void processListeners(WebAppBean webAppBean, ClassLoader classLoader) throws ClassNotFoundException {
        ListenerBean[] listenerBeanArray = webAppBean.getListeners();
        if (listenerBeanArray == null || listenerBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < listenerBeanArray.length; ++i) {
            Class<?> clazz = classLoader.loadClass(listenerBeanArray[i].getListenerClass());
            this.processJ2eeAnnotations(clazz, (J2eeClientEnvironmentBean)webAppBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWeblogicWebAnnotations(VirtualJarFile virtualJarFile, ClassLoader classLoader, WebAppBean webAppBean) {
        File[] fileArray = virtualJarFile.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].exists()) continue;
            VirtualJarFile virtualJarFile2 = null;
            try {
                virtualJarFile2 = VirtualJarFactory.createVirtualJar((File)fileArray[i]);
                Iterator iterator = virtualJarFile2.getEntries("/WEB-INF/classes/");
                while (iterator.hasNext()) {
                    ZipEntry zipEntry = (ZipEntry)iterator.next();
                    String string = zipEntry.getName();
                    if (!string.endsWith(".class")) continue;
                    string = string.substring(16);
                    string = string.replace('/', '.');
                    Class<?> clazz = classLoader.loadClass(string = string.substring(0, string.length() - 6));
                    if (clazz.isAnnotationPresent(WLServlet.class)) {
                        this.processWLServletAnnotation(clazz, webAppBean);
                        continue;
                    }
                    if (!clazz.isAnnotationPresent(WLFilter.class)) continue;
                    this.processWLFilterAnnotation(clazz, webAppBean);
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            finally {
                if (virtualJarFile2 != null) {
                    try {
                        virtualJarFile2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void processWLFilterAnnotation(Class clazz, WebAppBean webAppBean) {
        ParamValueBean paramValueBean;
        WLFilter wLFilter = clazz.getAnnotation(WLFilter.class);
        String string = WebAnnotationProcessorImpl.getName(wLFilter.name(), clazz);
        WebAnnotationProcessorImpl.dbg("Processing @WLFilter annotation on " + clazz);
        FilterBean filterBean = webAppBean.lookupFilter(string);
        if (filterBean == null) {
            filterBean = webAppBean.createFilter(string);
        }
        if (!filterBean.isFilterClassSet()) {
            filterBean.setFilterClass(clazz.getName());
        }
        WLInitParam[] wLInitParamArray = wLFilter.initParams();
        for (int i = 0; wLInitParamArray != null && i < wLInitParamArray.length; ++i) {
            paramValueBean = filterBean.lookupInitParam(wLInitParamArray[i].name());
            if (paramValueBean == null) {
                paramValueBean = filterBean.createInitParam(wLInitParamArray[i].name());
            }
            if (paramValueBean.isParamValueSet()) continue;
            paramValueBean.setParamValue(wLInitParamArray[i].value());
        }
        String[] stringArray = wLFilter.mapping();
        if (stringArray != null && stringArray.length > 0) {
            paramValueBean = webAppBean.createFilterMapping();
            paramValueBean.setFilterName(string);
            paramValueBean.setUrlPatterns(stringArray);
        }
    }

    private void processWLServletAnnotation(Class clazz, WebAppBean webAppBean) {
        RunAsBean runAsBean;
        String string;
        WLServlet wLServlet = clazz.getAnnotation(WLServlet.class);
        String string2 = WebAnnotationProcessorImpl.getName(wLServlet.name(), clazz);
        ServletBean servletBean = webAppBean.lookupServlet(string2);
        if (servletBean == null) {
            servletBean = webAppBean.createServlet(string2);
        }
        WebAnnotationProcessorImpl.dbg("Processing @WLServlet annotation on " + clazz);
        if (!servletBean.isServletClassSet()) {
            servletBean.setServletClass(clazz.getName());
        }
        if (!servletBean.isLoadOnStartupSet() && wLServlet.loadOnStartup() != -1) {
            servletBean.setLoadOnStartup(Integer.toString(wLServlet.loadOnStartup()));
        }
        if ((string = wLServlet.runAs()).length() > 0 && !servletBean.isRunAsSet()) {
            runAsBean = servletBean.createRunAs();
            runAsBean.setRoleName(string);
        }
        runAsBean = wLServlet.initParams();
        for (int i = 0; runAsBean != null && i < ((RunAsBean)runAsBean).length; ++i) {
            ParamValueBean paramValueBean = servletBean.lookupInitParam(runAsBean[i].name());
            if (paramValueBean == null) {
                paramValueBean = servletBean.createInitParam(runAsBean[i].name());
            }
            if (paramValueBean.isParamValueSet()) continue;
            paramValueBean.setParamValue(runAsBean[i].value());
        }
        String[] stringArray = wLServlet.mapping();
        if (stringArray != null && stringArray.length > 0) {
            this.addUrlPatterns(webAppBean, string2, stringArray);
        }
    }

    private static String getName(String string, Class clazz) {
        if (string == null || string.length() == 0) {
            string = clazz.getSimpleName();
        }
        return string;
    }

    private void addUrlPatterns(WebAppBean webAppBean, String string, String[] stringArray) {
        ServletMappingBean servletMappingBean = null;
        ServletMappingBean[] servletMappingBeanArray = webAppBean.getServletMappings();
        if (servletMappingBeanArray != null) {
            for (int i = 0; i < servletMappingBeanArray.length && servletMappingBean == null; ++i) {
                if ((servletMappingBeanArray[i].getServletName() == null || !servletMappingBeanArray[i].getServletName().equals(string)) && (servletMappingBeanArray[i].getServletName() != null || string != null)) continue;
                servletMappingBean = servletMappingBeanArray[i];
            }
        }
        if (servletMappingBean == null) {
            servletMappingBean = webAppBean.createServletMapping();
            servletMappingBean.setServletName(string);
        }
        if (servletMappingBean.getUrlPatterns() == null) {
            servletMappingBean.setUrlPatterns(stringArray);
        } else {
            List<String> list = Arrays.asList(servletMappingBean.getUrlPatterns());
            for (int i = 0; i < stringArray.length; ++i) {
                if (list.contains(stringArray[i])) continue;
                servletMappingBean.addUrlPattern(stringArray[i]);
            }
        }
    }

    private static void dbg(String string) {
        WebComponentContributor.dbg(string);
    }

    protected void perhapsDeclareRunAs(DescriptorBean descriptorBean, String string) {
        ServletBean servletBean = (ServletBean)descriptorBean;
        if (servletBean.getRunAs() == null) {
            RunAsBean runAsBean = servletBean.createRunAs();
            runAsBean.setRoleName(string);
        }
    }

    private void processDeclareRoles(Class clazz, ServletBean servletBean, WebAppBean webAppBean) {
        if (clazz.isAnnotationPresent(DeclareRoles.class)) {
            DeclareRoles declareRoles = clazz.getAnnotation(DeclareRoles.class);
            this.perhapsDeclareRoles(webAppBean, declareRoles.value());
        }
    }

    private void perhapsDeclareRoles(WebAppBean webAppBean, String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (SecurityRoleBean securityRoleBean : webAppBean.getSecurityRoles()) {
            hashSet.add(securityRoleBean.getRoleName());
        }
        for (String string : stringArray) {
            if (hashSet.contains(string)) continue;
            SecurityRoleBean securityRoleBean = webAppBean.createSecurityRole();
            securityRoleBean.setRoleName(string);
        }
    }

    private ClassAnnotationMetaDataFilter getAnnotationDataFilter() {
        Class<? extends Annotation> clazz;
        if (this.jsfAnnotations == null) {
            this.jsfAnnotations = JSFManagedBeanAnnotation.create(Thread.currentThread().getContextClassLoader());
        }
        if ((clazz = this.jsfAnnotations.getManagedBeanAnnotation()) == null) {
            return new ClassAnnotationMetaDataFilter(COMMON_ANNOTATION_CLASSES);
        }
        int n = COMMON_ANNOTATION_CLASSES.length + 1;
        Class[] classArray = new Class[n];
        System.arraycopy(COMMON_ANNOTATION_CLASSES, 0, classArray, 0, COMMON_ANNOTATION_CLASSES.length);
        classArray[n - 1] = this.jsfAnnotations.getManagedBeanAnnotation();
        return new ClassAnnotationMetaDataFilter(classArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSFManagedBeanAnnotation {
        public static final String MANAGEDBEAN = "javax.faces.bean.ManagedBean";
        private Class<? extends Annotation> managedBean = null;

        public static JSFManagedBeanAnnotation create(ClassLoader classLoader) {
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(MANAGEDBEAN);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new JSFManagedBeanAnnotation(clazz);
        }

        private JSFManagedBeanAnnotation(Class clazz) {
            this.managedBean = clazz;
        }

        public Class<? extends Annotation> getManagedBeanAnnotation() {
            return this.managedBean;
        }

        public boolean isAnnotedWithManagedBean(Class clazz) {
            return this.managedBean != null && clazz.isAnnotationPresent(this.managedBean);
        }
    }
}

