/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import weblogic.application.ApplicationContextInternal;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.MimeMappingBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.CharsetMappingBean;
import weblogic.j2ee.descriptor.wl.CharsetParamsBean;
import weblogic.j2ee.descriptor.wl.ContainerDescriptorBean;
import weblogic.j2ee.descriptor.wl.InputCharsetBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.management.DomainDir;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.configuration.WebAppContainerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.security.RealmMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.CharsetMap;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.LocaleEncodingMap;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebComponentBeanUpdateListener;
import weblogic.utils.StringUtils;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.http.HttpConstants;
import weblogic.utils.http.HttpParsing;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class WebAppConfigManager {
    private static final String WL_USE_VM_ENCODING = "webapp.encoding.usevmdefault";
    private static final String WL_DEFAULT_ENCODING = "webapp.encoding.default";
    private static final boolean WIN_32 = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final ServerMBean servermbean = ManagementService.getRuntimeAccess(KERNEL_ID).getServer();
    private static final ClusterMBean clustermbean = servermbean.getCluster();
    private static final WebAppContainerMBean webAppContainer = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().getWebAppContainer();
    private static final int DEFAULT_RESOURCE_RELOAD_CHECK_SECONDS = WebAppConfigManager.getDefaultReloadSecs();
    private static final int DEFAULT_SERVLET_RELOAD_CHECK_SECONDS = WebAppConfigManager.getDefaultReloadSecs();
    private final WebAppServletContext context;
    private final ConcurrentHashMap mimeMapping = new ConcurrentHashMap();
    private WebAppComponentMBean compMBean = null;
    private boolean checkAuthOnForwardEnabled;
    private boolean filterDispatchedRequestsEnabled = true;
    private boolean preferWebInfClasses;
    private boolean clientCertProxyEnabled;
    private boolean redirectWithAbsoluteURLEnabled = true;
    private boolean encodingEnabled;
    private int singleThreadedServletPoolSize = 5;
    private String authRealmName = "WebLogic Server";
    private String defaultMimeType;
    private String defaultEncoding = "ISO-8859-1";
    private String dispatchPolicy = "weblogic.kernel.Default";
    private WorkManager workManager;
    private boolean reloginEnabled;
    private boolean allowAllRoles;
    private boolean nativeIOEnabled;
    private boolean rtexprvalueJspParamName;
    private boolean isJSPCompilerBackwardsCompatible;
    private static final boolean caseInsensitive = SecurityServiceManager.areWebAppFilesCaseInsensitive() && WIN_32;
    private final HashMap inputEncodingMap = new HashMap();
    private CharsetMap charsetMap;
    private LocaleEncodingMap localeEncodingMap = new LocaleEncodingMap();
    private int defaultServletReloadCheckSecs;
    private int servletReloadCheckSecs;
    private int resourceReloadCheckSecs;
    private boolean servletReloadCheckSecsSet = false;
    private boolean optimisticSerialization;
    private boolean retainOriginalURL;
    private boolean servletAuthFromURL;
    private boolean indexDirectoryEnabled = false;
    private boolean indexDirectoryEnabledSet = false;
    private String indexDirectorySortBy = "NAME";
    private boolean showArchivedRealPathEnabledSet = false;
    private boolean showArchivedRealPathEnabled = false;
    private boolean accessLoggingDisabled = false;
    private boolean accessLoggingDisabledSet = false;
    private boolean preferForwardQueryStringSet = false;
    private boolean preferForwardQueryString = false;
    private long minimumNativeFileSize = 4096L;
    private String tempDir = null;
    private boolean disableImplicitServletMappings = false;
    private boolean requireAdminTraffic = false;
    private final BeanUpdateListener containerBeanListener;

    WebAppConfigManager(WebAppServletContext webAppServletContext) {
        this.context = webAppServletContext;
        this.defaultServletReloadCheckSecs = DEFAULT_SERVLET_RELOAD_CHECK_SECONDS;
        this.servletReloadCheckSecs = DEFAULT_SERVLET_RELOAD_CHECK_SECONDS;
        this.resourceReloadCheckSecs = DEFAULT_RESOURCE_RELOAD_CHECK_SECONDS;
        this.containerBeanListener = this.createBeanUpdateListener();
    }

    BeanUpdateListener getBeanUpdateListener() {
        return this.containerBeanListener;
    }

    void init() {
        HttpServer httpServer = this.context.getServer();
        this.initMimeMapping();
        this.initEncoding(this.context.getApplicationContext());
        this.initCharsetMap(httpServer.getMBean().getCharsets());
        this.initPluginSecurity();
        this.initSwitches();
        this.initWorkManager();
        this.initAccessLoggingDiasbled();
    }

    private void initSwitches() {
        this.reloginEnabled = webAppContainer.isReloginEnabled();
        this.allowAllRoles = webAppContainer.isAllowAllRoles();
        this.filterDispatchedRequestsEnabled = webAppContainer.isSet("FilterDispatchedRequestsEnabled") ? webAppContainer.isFilterDispatchedRequestsEnabled() : this.isOldDescriptor();
        this.optimisticSerialization = Boolean.getBoolean("weblogic.servlet.optimisticSerialization") || webAppContainer.isOptimisticSerialization();
        this.retainOriginalURL = webAppContainer.isRetainOriginalURL();
        this.servletAuthFromURL = webAppContainer.isServletAuthenticationFormURL();
        this.rtexprvalueJspParamName = webAppContainer.isRtexprvalueJspParamName();
        this.isJSPCompilerBackwardsCompatible = webAppContainer.isJSPCompilerBackwardsCompatible();
    }

    boolean isOldDescriptor() {
        WebAppModule webAppModule = this.context.getWebAppModule();
        if (webAppModule == null) {
            return false;
        }
        WebAppBean webAppBean = webAppModule.getWebAppBean();
        if (webAppBean == null) {
            return false;
        }
        String string = webAppBean.getVersion();
        if (string == null) {
            return true;
        }
        try {
            float f = Float.parseFloat(string);
            return (double)f < 2.4;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private void initPluginSecurity() {
        this.clientCertProxyEnabled = webAppContainer.isClientCertProxyEnabled();
        if (clustermbean != null && clustermbean.isSet("ClientCertProxyEnabled")) {
            this.clientCertProxyEnabled = clustermbean.isClientCertProxyEnabled();
        }
        if (servermbean.isSet("ClientCertProxyEnabled")) {
            this.clientCertProxyEnabled = servermbean.isClientCertProxyEnabled();
        }
    }

    private void initEncoding(ApplicationContextInternal applicationContextInternal) {
        String string = null;
        string = "true".equalsIgnoreCase(applicationContextInternal.getApplicationParameter(WL_USE_VM_ENCODING)) ? System.getProperty("file.encoding") : applicationContextInternal.getApplicationParameter(WL_DEFAULT_ENCODING);
        if (string == null) {
            return;
        }
        if (!Charset.isSupported(string)) {
            HTTPLogger.logUnsupportedEncoding((String)this.context.getLogContext(), (String)string, (Throwable)new UnsupportedEncodingException("Unsupported encoding " + string));
            return;
        }
        this.defaultEncoding = string;
        this.encodingEnabled = true;
    }

    private void initCharsetMap(Map map) {
        this.charsetMap = new CharsetMap(map);
    }

    private void initAccessLoggingDiasbled() {
        this.accessLoggingDisabled = this.context.isInternalApp();
    }

    void addInputEncoding(String string, String string2) {
        string = StringUtils.endsWith((String)(string = HttpParsing.ensureStartingSlash((String)string)), (char)'*') ? string.substring(0, string.length() - 1) : string;
        string = StringUtils.endsWith((String)string, (char)'/') ? string.substring(0, string.length() - 1) : string;
        this.inputEncodingMap.put(string, string2);
    }

    void registerMBean(WebAppComponentMBean webAppComponentMBean) {
        this.compMBean = webAppComponentMBean;
        this.singleThreadedServletPoolSize = webAppComponentMBean.getSingleThreadedServletPoolSize();
        this.preferWebInfClasses = webAppComponentMBean.isPreferWebInfClasses();
        if (webAppComponentMBean.isSessionURLRewritingEnabledSet()) {
            this.context.getSessionContext().getConfigMgr().setUrlRewritingEnabled(webAppComponentMBean.isSessionURLRewritingEnabled());
        }
        this.authRealmName = webAppComponentMBean.getAuthRealmName();
    }

    void registerContainerDescriptors(WeblogicWebAppBean weblogicWebAppBean) {
        if (weblogicWebAppBean == null) {
            return;
        }
        ContainerDescriptorBean containerDescriptorBean = (ContainerDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getContainerDescriptors(), "ContainerDescriptor");
        this.checkAuthOnForwardEnabled = containerDescriptorBean.getCheckAuthOnForward() != null;
        this.redirectWithAbsoluteURLEnabled = containerDescriptorBean.isRedirectWithAbsoluteUrl();
        this.nativeIOEnabled = containerDescriptorBean.isNativeIOEnabled();
        DescriptorBean descriptorBean = (DescriptorBean)containerDescriptorBean;
        if (descriptorBean.isSet("FilterDispatchedRequestsEnabled")) {
            this.filterDispatchedRequestsEnabled = containerDescriptorBean.isFilterDispatchedRequestsEnabled();
        }
        if (descriptorBean.isSet("PreferWebInfClasses")) {
            this.preferWebInfClasses = containerDescriptorBean.isPreferWebInfClasses();
        }
        if (descriptorBean.isSet("SingleThreadedServletPoolSize")) {
            this.singleThreadedServletPoolSize = containerDescriptorBean.getSingleThreadedServletPoolSize();
        }
        if (descriptorBean.isSet("ClientCertProxyEnabled")) {
            this.clientCertProxyEnabled = containerDescriptorBean.isClientCertProxyEnabled();
        }
        if (descriptorBean.isSet("ReloginEnabled")) {
            this.reloginEnabled = containerDescriptorBean.isReloginEnabled();
        }
        if (descriptorBean.isSet("AllowAllRoles")) {
            this.allowAllRoles = containerDescriptorBean.isAllowAllRoles();
        }
        if (descriptorBean.isSet("OptimisticSerialization")) {
            this.optimisticSerialization = containerDescriptorBean.isOptimisticSerialization();
        }
        if (descriptorBean.isSet("RetainOriginalURL")) {
            this.retainOriginalURL = containerDescriptorBean.isRetainOriginalURL();
        }
        if (containerDescriptorBean.getDefaultMimeType() != null && !containerDescriptorBean.getDefaultMimeType().equals("")) {
            this.defaultMimeType = containerDescriptorBean.getDefaultMimeType();
        }
        if (containerDescriptorBean.isServletReloadCheckSecsSet()) {
            this.servletReloadCheckSecsSet = true;
            this.servletReloadCheckSecs = containerDescriptorBean.getServletReloadCheckSecs();
        }
        this.resourceReloadCheckSecs = containerDescriptorBean.getResourceReloadCheckSecs();
        if (containerDescriptorBean.isIndexDirectoryEnabledSet()) {
            this.indexDirectoryEnabledSet = true;
            this.indexDirectoryEnabled = containerDescriptorBean.isIndexDirectoryEnabled();
        }
        this.indexDirectorySortBy = containerDescriptorBean.getIndexDirectorySortBy();
        if (containerDescriptorBean.isShowArchivedRealPathEnabledSet()) {
            this.showArchivedRealPathEnabledSet = true;
            this.showArchivedRealPathEnabled = containerDescriptorBean.isShowArchivedRealPathEnabled();
        }
        if (containerDescriptorBean.isAccessLoggingDisabledSet()) {
            this.accessLoggingDisabledSet = true;
            this.accessLoggingDisabled = containerDescriptorBean.isAccessLoggingDisabled();
        }
        if (containerDescriptorBean.isPreferForwardQueryStringSet()) {
            this.preferForwardQueryStringSet = true;
            this.preferForwardQueryString = containerDescriptorBean.isPreferForwardQueryString();
        }
        this.minimumNativeFileSize = containerDescriptorBean.getMinimumNativeFileSize();
        this.tempDir = containerDescriptorBean.getTempDir();
        this.disableImplicitServletMappings = containerDescriptorBean.isDisableImplicitServletMappings();
        this.requireAdminTraffic = containerDescriptorBean.isRequireAdminTraffic();
    }

    void registerCharsetParams(WeblogicWebAppBean weblogicWebAppBean) {
        CharsetParamsBean charsetParamsBean = (CharsetParamsBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getCharsetParams(), "CharsetParams");
        if (charsetParamsBean != null) {
            CharsetMappingBean[] charsetMappingBeanArray;
            Object object;
            InputCharsetBean[] inputCharsetBeanArray = charsetParamsBean.getInputCharsets();
            if (inputCharsetBeanArray != null) {
                for (int i = 0; i < inputCharsetBeanArray.length; ++i) {
                    object = inputCharsetBeanArray[i].getResourcePath();
                    String string = inputCharsetBeanArray[i].getJavaCharsetName();
                    if (object == null || string == null) continue;
                    this.addInputEncoding((String)object, string);
                }
            }
            if ((charsetMappingBeanArray = charsetParamsBean.getCharsetMappings()) != null) {
                object = this.getCharsetMap();
                for (int i = 0; i < charsetMappingBeanArray.length; ++i) {
                    ((CharsetMap)object).addMapping(charsetMappingBeanArray[i]);
                }
            }
        }
    }

    public CharsetMap getCharsetMap() {
        return this.charsetMap;
    }

    public LocaleEncodingMap getLocaleEncodingMap() {
        return this.localeEncodingMap;
    }

    HashMap getInputEncodings() {
        return this.inputEncodingMap;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean useDefaultEncoding() {
        return this.encodingEnabled;
    }

    public boolean isRedirectWithAbsoluteURLEnabled() {
        return this.redirectWithAbsoluteURLEnabled;
    }

    public boolean isShowArchivedRealPathEnabled() {
        if (this.showArchivedRealPathEnabledSet) {
            return this.showArchivedRealPathEnabled;
        }
        if (webAppContainer != null) {
            return webAppContainer.isShowArchivedRealPathEnabled();
        }
        return false;
    }

    public boolean isCheckAuthOnForwardEnabled() {
        return this.checkAuthOnForwardEnabled;
    }

    public boolean isIndexDirectoryEnabled() {
        if (this.indexDirectoryEnabledSet) {
            return this.indexDirectoryEnabled;
        }
        if (this.compMBean != null) {
            return this.compMBean.isIndexDirectoryEnabled();
        }
        return false;
    }

    public String getIndexDirectorySortBy() {
        return this.indexDirectorySortBy;
    }

    public static boolean isCaseInsensitive() {
        return caseInsensitive;
    }

    public boolean isReloginEnabled() {
        return this.reloginEnabled;
    }

    public boolean isAllowAllRoles() {
        return this.allowAllRoles;
    }

    public boolean isNativeIOEnabled() {
        return this.nativeIOEnabled;
    }

    boolean isOptimisticSerialization() {
        return this.optimisticSerialization;
    }

    public boolean isRetainOriginalURL() {
        return this.retainOriginalURL;
    }

    public boolean isServletAuthFromURL() {
        return this.servletAuthFromURL;
    }

    boolean isRtexprvalueJspParamName() {
        return this.rtexprvalueJspParamName;
    }

    boolean isJSPCompilerBackwardsCompatible() {
        return this.isJSPCompilerBackwardsCompatible;
    }

    public boolean isAccessLoggingDisabled() {
        return this.accessLoggingDisabled;
    }

    public long getMinimumNativeFileSize() {
        return this.minimumNativeFileSize;
    }

    public boolean isPreferForwardQueryString() {
        return this.preferForwardQueryString;
    }

    boolean isRequireAdminTraffic() {
        return this.requireAdminTraffic;
    }

    public boolean isFilterDispatchedRequestsEnabled() {
        return this.filterDispatchedRequestsEnabled;
    }

    public int getServletReloadCheckSecs() {
        WebAppModule webAppModule = this.context.getWebAppModule();
        if (webAppModule != null && !webAppModule.isServletReloadAllowed()) {
            return -1;
        }
        if (this.servletReloadCheckSecsSet) {
            return this.servletReloadCheckSecs;
        }
        if (webAppContainer.isServletReloadCheckSecsSet()) {
            return webAppContainer.getServletReloadCheckSecs();
        }
        return this.defaultServletReloadCheckSecs;
    }

    public int getResourceReloadCheckSecs() {
        if (this.context.getJSPManager().isPageCheckSecondsSet()) {
            return this.context.getJSPManager().getPageCheckSeconds();
        }
        return this.resourceReloadCheckSecs;
    }

    void setServletReloadCheckSecs(int n) {
        this.defaultServletReloadCheckSecs = n;
    }

    public int getSingleThreadedServletPoolSize() {
        return this.singleThreadedServletPoolSize;
    }

    void setSingleThreadedServletPoolSize(int n) {
        this.singleThreadedServletPoolSize = n;
    }

    String getTempDir() {
        return this.tempDir;
    }

    boolean getPreferWebInfClasses() {
        return this.preferWebInfClasses;
    }

    void setPreferWebInfClasses(boolean bl) {
        this.preferWebInfClasses = bl;
    }

    String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public String getAuthRealmName() {
        return this.authRealmName;
    }

    void setAuthRealmName(String string) {
        this.authRealmName = string;
    }

    public boolean isClientCertProxyEnabled() {
        return this.clientCertProxyEnabled;
    }

    void setClientCertProxyEnabled(boolean bl) {
        this.clientCertProxyEnabled = bl;
    }

    public String getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    private void initWorkManager() {
        this.workManager = WorkManagerFactory.getInstance().find("weblogic.kernel.Default", this.context.getApplicationId(), null);
    }

    WorkManager getWorkManager() {
        return this.workManager;
    }

    void setDispatchPolicy(String string) {
        this.dispatchPolicy = string == null ? "weblogic.kernel.Default" : string;
        this.workManager = WorkManagerFactory.getInstance().find(this.dispatchPolicy, this.context.getApplicationId(), this.context.getId());
    }

    boolean isImplicitServletMappingDisabled() {
        return this.disableImplicitServletMappings;
    }

    private void initMimeMapping() {
        WebAppModule webAppModule;
        String string;
        MimeMappingBean[] mimeMappingBeanArray;
        Map map;
        for (int i = 0; i < HttpConstants.DEFAULT_MIME_MAPPINGS.length; ++i) {
            this.addMimeMapping(HttpConstants.DEFAULT_MIME_MAPPINGS[i][0], HttpConstants.DEFAULT_MIME_MAPPINGS[i][1]);
        }
        if (webAppContainer.getMimeMappingFile() != null) {
            String string2 = webAppContainer.getMimeMappingFile();
            string2 = string2.replace('\\', File.separatorChar);
            if (!WebAppServletContext.isAbsoluteFilePath(string2 = string2.replace('/', File.separatorChar))) {
                string2 = DomainDir.getRootDir() + File.separatorChar + string2;
            }
            this.addMimeMappings(new File(string2));
        }
        if (this.compMBean != null && (map = this.compMBean.getMimeTypes()) != null) {
            mimeMappingBeanArray = map.keySet().iterator();
            while (mimeMappingBeanArray.hasNext()) {
                String string3 = (String)mimeMappingBeanArray.next();
                string = (String)map.get(string3);
                this.addMimeMapping(string3, string);
            }
        }
        if ((webAppModule = this.context.getWebAppModule()) != null && webAppModule.getWebAppBean() != null && (mimeMappingBeanArray = webAppModule.getWebAppBean().getMimeMappings()) != null) {
            for (int i = 0; i < mimeMappingBeanArray.length; ++i) {
                string = mimeMappingBeanArray[i];
                this.addMimeMapping(string.getExtension(), string.getMimeType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addMimeMappings(File file) {
        block14: {
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (string == null || string.length() <= 0) continue;
                this.addMimeMapping(string, string2);
            }
            Object var8_8 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block14;
            }
            catch (IOException iOException) {}
            break block14;
            {
                catch (IOException iOException) {
                    if (HTTPDebugLogger.isEnabled()) {
                        HTTPDebugLogger.debug("Failed to load mime-mappings from domain", iOException);
                    }
                    Object var8_9 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    void addMimeMapping(String string, String string2) {
        string = string.trim().toLowerCase();
        if (string2 == null) {
            this.mimeMapping.remove((Object)string);
            return;
        }
        if ((string2 = string2.trim()).length() == 0) {
            this.mimeMapping.remove((Object)string);
            return;
        }
        this.mimeMapping.put((Object)string, (Object)string2);
    }

    String getMimeType(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n != -1 ? string.substring(n + 1).toLowerCase() : string;
        String string3 = (String)this.mimeMapping.get((Object)string2);
        if (string3 == null) {
            return this.getDefaultMimeType();
        }
        return string3;
    }

    static File getConsoleExtensionDirectory() {
        File file;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
        String string = domainMBean.getConsoleExtensionDirectory();
        if (string != null && (file = new File(domainMBean.getRootDirectory(), string)).isDirectory()) {
            return file;
        }
        return null;
    }

    public static String getRealmAuthMethods() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
        RealmMBean realmMBean = domainMBean.getSecurityConfiguration().getDefaultRealm();
        if (realmMBean != null) {
            return realmMBean.getAuthMethods();
        }
        return null;
    }

    static File getDocrootFile(String string, WebAppServletContext webAppServletContext) throws IOException {
        if (string == null) {
            if (webAppServletContext.getLogContext() != null) {
                HTTPLogger.logNullDocumentRoot((String)webAppServletContext.getLogContext());
            }
            throw new IOException("Document root is null.");
        }
        string = string.replace('/', File.separatorChar);
        File file = new File(string);
        String string2 = string;
        if (!file.isAbsolute() && !file.exists()) {
            ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getCluster();
            if (clusterMBean != null) {
                string2 = string2 + clusterMBean.getName();
            }
            if (string2 == null) {
                string2 = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getName();
            }
            string2 = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getRootDirectory() + File.separator + string2 + File.separator + string;
            file = new File(string2);
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug(webAppServletContext.getLogContext() + ": document root doesn't exist for " + webAppServletContext.getLogContext() + " looking under relative path: " + file.getAbsolutePath());
            }
        }
        if (!file.exists()) {
            if (webAppServletContext.getLogContext() != null) {
                HTTPLogger.logNoDocRoot((String)webAppServletContext.getLogContext(), (String)string2);
            }
            throw new IOException("document root (" + string2 + ") does not exist.");
        }
        return file;
    }

    private static int getDefaultReloadSecs() {
        return HttpServer.isProductionModeEnabled() ? -1 : 1;
    }

    private BeanUpdateListener createBeanUpdateListener() {
        return new WebComponentBeanUpdateListener(){

            protected void handlePropertyRemove(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
                String string = propertyUpdate.getPropertyName();
                if ("ServletReloadCheckSecs".equals(string)) {
                    WebAppConfigManager.this.servletReloadCheckSecs = DEFAULT_SERVLET_RELOAD_CHECK_SECONDS;
                    WebAppConfigManager.this.servletReloadCheckSecsSet = false;
                } else if ("ResourceReloadCheckSecs".equals(string)) {
                    WebAppConfigManager.this.resourceReloadCheckSecs = DEFAULT_RESOURCE_RELOAD_CHECK_SECONDS;
                } else if ("IndexDirectoryEnabled".equals(string)) {
                    WebAppConfigManager.this.indexDirectoryEnabledSet = false;
                    WebAppConfigManager.this.indexDirectoryEnabled = false;
                } else if ("IndexDirectorySortBy".equals(string)) {
                    WebAppConfigManager.this.indexDirectorySortBy = "NAME";
                } else if ("ShowArchivedRealPathEnabled".equals(string)) {
                    WebAppConfigManager.this.showArchivedRealPathEnabledSet = false;
                    WebAppConfigManager.this.showArchivedRealPathEnabled = false;
                } else if ("MinimumNativeFileSize".equals(string)) {
                    WebAppConfigManager.this.minimumNativeFileSize = 4096L;
                } else if ("TempDir".equals(string)) {
                    WebAppConfigManager.this.tempDir = null;
                } else if ("DisableImplicitServletMappings".equals(string)) {
                    WebAppConfigManager.this.disableImplicitServletMappings = false;
                } else if ("RequireAdminTraffic".equals(string)) {
                    WebAppConfigManager.this.requireAdminTraffic = false;
                } else if ("AccessLoggingDisabled".equals(string)) {
                    WebAppConfigManager.this.accessLoggingDisabledSet = false;
                    WebAppConfigManager.this.accessLoggingDisabled = WebAppConfigManager.this.context.isInternalApp();
                }
            }

            protected void handlePropertyChange(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) {
                ContainerDescriptorBean containerDescriptorBean = (ContainerDescriptorBean)descriptorBean;
                String string = propertyUpdate.getPropertyName();
                if ("ServletReloadCheckSecs".equals(string)) {
                    WebAppConfigManager.this.servletReloadCheckSecs = containerDescriptorBean.getServletReloadCheckSecs();
                    WebAppConfigManager.this.servletReloadCheckSecsSet = true;
                } else if ("ResourceReloadCheckSecs".equals(string)) {
                    WebAppConfigManager.this.resourceReloadCheckSecs = containerDescriptorBean.getResourceReloadCheckSecs();
                } else if ("IndexDirectoryEnabled".equals(string)) {
                    WebAppConfigManager.this.indexDirectoryEnabledSet = true;
                    WebAppConfigManager.this.indexDirectoryEnabled = containerDescriptorBean.isIndexDirectoryEnabled();
                } else if ("IndexDirectorySortBy".equals(string)) {
                    WebAppConfigManager.this.indexDirectorySortBy = containerDescriptorBean.getIndexDirectorySortBy();
                } else if ("ShowArchivedRealPathEnabled".equals(string)) {
                    WebAppConfigManager.this.showArchivedRealPathEnabledSet = true;
                    WebAppConfigManager.this.showArchivedRealPathEnabled = containerDescriptorBean.isShowArchivedRealPathEnabled();
                } else if ("MinimumNativeFileSize".equals(string)) {
                    WebAppConfigManager.this.minimumNativeFileSize = containerDescriptorBean.getMinimumNativeFileSize();
                } else if ("TempDir".equals(string)) {
                    WebAppConfigManager.this.tempDir = containerDescriptorBean.getTempDir();
                } else if ("DisableImplicitServletMappings".equals(string)) {
                    WebAppConfigManager.this.disableImplicitServletMappings = containerDescriptorBean.isDisableImplicitServletMappings();
                } else if ("RequireAdminTraffic".equals(string)) {
                    WebAppConfigManager.this.requireAdminTraffic = containerDescriptorBean.isRequireAdminTraffic();
                } else if ("AccessLoggingDisabled".equals(string)) {
                    WebAppConfigManager.this.accessLoggingDisabledSet = true;
                    WebAppConfigManager.this.accessLoggingDisabled = containerDescriptorBean.isAccessLoggingDisabled();
                }
            }

            protected void prepareBeanAdd(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) throws BeanUpdateRejectedException {
                if (!(descriptorBean instanceof ContainerDescriptorBean)) {
                    return;
                }
                WeblogicWebAppBean weblogicWebAppBean = WebAppConfigManager.this.context.getWebAppModule().getWlWebAppBean();
                ContainerDescriptorBean containerDescriptorBean = (ContainerDescriptorBean)descriptorBean;
                ContainerDescriptorBean containerDescriptorBean2 = (ContainerDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getContainerDescriptors(), "ContainerDescriptor");
                ArrayList<String> arrayList = new ArrayList<String>();
                1.computeChange("check-auth-on-forward", containerDescriptorBean.getCheckAuthOnForward(), containerDescriptorBean2.getCheckAuthOnForward(), arrayList);
                1.computeChange("filter-dispatched-requests-enabled", containerDescriptorBean.isFilterDispatchedRequestsEnabled(), containerDescriptorBean2.isFilterDispatchedRequestsEnabled(), arrayList);
                1.computeChange("redirect-content-type", containerDescriptorBean.getRedirectContentType(), containerDescriptorBean2.getRedirectContentType(), arrayList);
                1.computeChange("redirect-content", containerDescriptorBean.getRedirectContent(), containerDescriptorBean2.getRedirectContent(), arrayList);
                1.computeChange("redirect-with-absolute-url", containerDescriptorBean.isRedirectWithAbsoluteUrl(), containerDescriptorBean2.isRedirectWithAbsoluteUrl(), arrayList);
                1.computeChange("single-threaded-servlet-pool-size", containerDescriptorBean.getSingleThreadedServletPoolSize(), containerDescriptorBean2.getSingleThreadedServletPoolSize(), arrayList);
                1.computeChange("save-sessions-enabled", containerDescriptorBean.isSaveSessionsEnabled(), containerDescriptorBean2.isSaveSessionsEnabled(), arrayList);
                1.computeChange("prefer-web-inf-classes", containerDescriptorBean.isPreferWebInfClasses(), containerDescriptorBean2.isPreferWebInfClasses(), arrayList);
                1.computeChange("default-mime-type", containerDescriptorBean.getDefaultMimeType(), containerDescriptorBean2.getDefaultMimeType(), arrayList);
                1.computeChange("relogin-enabled", containerDescriptorBean.isReloginEnabled(), containerDescriptorBean2.isReloginEnabled(), arrayList);
                1.computeChange("allow-all-roles", containerDescriptorBean.isAllowAllRoles(), containerDescriptorBean2.isAllowAllRoles(), arrayList);
                1.computeChange("client-cert-proxy-enabled", containerDescriptorBean.isClientCertProxyEnabled(), containerDescriptorBean2.isClientCertProxyEnabled(), arrayList);
                1.computeChange("native-io-enabled", containerDescriptorBean.isNativeIOEnabled(), containerDescriptorBean2.isNativeIOEnabled(), arrayList);
                1.computeChange("disable-implicit-servlet-mappings", containerDescriptorBean.isDisableImplicitServletMappings(), containerDescriptorBean2.isDisableImplicitServletMappings(), arrayList);
                1.computeChange("temp-dir", containerDescriptorBean.getTempDir(), containerDescriptorBean2.getTempDir(), arrayList);
                1.computeChange("optimistic-serialization", containerDescriptorBean.isOptimisticSerialization(), containerDescriptorBean2.isOptimisticSerialization(), arrayList);
                1.computeChange("retain-original-url", containerDescriptorBean.isRetainOriginalURL(), containerDescriptorBean2.isRetainOriginalURL(), arrayList);
                if (!arrayList.isEmpty()) {
                    throw new BeanUpdateRejectedException("Non-Dynamic property in \"container-descriptor\" is/are specified in deployment plan: '" + 1.getChangedPropertyNames(arrayList) + "'");
                }
            }

            protected void handleBeanAdd(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) {
                if (!(descriptorBean instanceof ContainerDescriptorBean) || propertyUpdate == null || !"ContainerDescriptors".equals(propertyUpdate.getPropertyName())) {
                    return;
                }
                ContainerDescriptorBean containerDescriptorBean = (ContainerDescriptorBean)descriptorBean;
                ((DescriptorBean)containerDescriptorBean).addBeanUpdateListener((BeanUpdateListener)this);
                if (containerDescriptorBean.isServletReloadCheckSecsSet()) {
                    WebAppConfigManager.this.servletReloadCheckSecs = containerDescriptorBean.getServletReloadCheckSecs();
                    WebAppConfigManager.this.servletReloadCheckSecsSet = true;
                }
                WebAppConfigManager.this.resourceReloadCheckSecs = containerDescriptorBean.getResourceReloadCheckSecs();
                if (containerDescriptorBean.isIndexDirectoryEnabledSet()) {
                    WebAppConfigManager.this.indexDirectoryEnabledSet = true;
                    WebAppConfigManager.this.indexDirectoryEnabled = containerDescriptorBean.isIndexDirectoryEnabled();
                }
                WebAppConfigManager.this.indexDirectorySortBy = containerDescriptorBean.getIndexDirectorySortBy();
                if (containerDescriptorBean.isShowArchivedRealPathEnabledSet()) {
                    WebAppConfigManager.this.showArchivedRealPathEnabledSet = true;
                    WebAppConfigManager.this.showArchivedRealPathEnabled = containerDescriptorBean.isShowArchivedRealPathEnabled();
                }
                WebAppConfigManager.this.minimumNativeFileSize = containerDescriptorBean.getMinimumNativeFileSize();
                WebAppConfigManager.this.tempDir = containerDescriptorBean.getTempDir();
                WebAppConfigManager.this.disableImplicitServletMappings = containerDescriptorBean.isDisableImplicitServletMappings();
                WebAppConfigManager.this.requireAdminTraffic = containerDescriptorBean.isRequireAdminTraffic();
                if (containerDescriptorBean.isAccessLoggingDisabledSet()) {
                    WebAppConfigManager.this.accessLoggingDisabledSet = true;
                    WebAppConfigManager.this.accessLoggingDisabled = containerDescriptorBean.isAccessLoggingDisabled();
                }
            }

            protected void handleBeanRemove(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
                if (propertyUpdate == null || !"ContainerDescriptors".equals(propertyUpdate.getPropertyName()) || !(propertyUpdate.getRemovedObject() instanceof ContainerDescriptorBean)) {
                    return;
                }
                ContainerDescriptorBean containerDescriptorBean = (ContainerDescriptorBean)propertyUpdate.getRemovedObject();
                ((DescriptorBean)containerDescriptorBean).removeBeanUpdateListener((BeanUpdateListener)this);
                WebAppConfigManager.this.servletReloadCheckSecs = DEFAULT_SERVLET_RELOAD_CHECK_SECONDS;
                WebAppConfigManager.this.servletReloadCheckSecsSet = false;
                WebAppConfigManager.this.resourceReloadCheckSecs = DEFAULT_RESOURCE_RELOAD_CHECK_SECONDS;
                WebAppConfigManager.this.indexDirectoryEnabledSet = false;
                WebAppConfigManager.this.indexDirectoryEnabled = false;
                WebAppConfigManager.this.indexDirectorySortBy = "NAME";
                WebAppConfigManager.this.showArchivedRealPathEnabledSet = false;
                WebAppConfigManager.this.showArchivedRealPathEnabled = false;
                WebAppConfigManager.this.minimumNativeFileSize = 4096L;
                WebAppConfigManager.this.tempDir = null;
                WebAppConfigManager.this.disableImplicitServletMappings = false;
                WebAppConfigManager.this.requireAdminTraffic = false;
                WebAppConfigManager.this.accessLoggingDisabledSet = false;
                WebAppConfigManager.this.accessLoggingDisabled = WebAppConfigManager.this.context.isInternalApp();
            }
        };
    }
}

