/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.CachingDescriptorLoader2;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.internal.WebAppInternalParser;
import weblogic.servlet.internal.WebAppReader2;
import weblogic.servlet.internal.WlsWebAppReader2;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.DirectoryClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class WebAppDescriptor
implements WebAppInternalParser {
    private static final String STANDARD_DD = "WEB-INF/web.xml";
    private static final String WEBLOGIC_DD = "WEB-INF/weblogic.xml";
    private MyWebAppDescriptor webAppDescriptor;
    private MyWlsWebAppDescriptor wlsWebAppDescriptor;
    private boolean hasWebDescriptorFile = true;
    private boolean validateSchema = true;

    public WebAppDescriptor(File file, File file2, File file3, DeploymentPlanBean deploymentPlanBean, String string) {
        this.webAppDescriptor = new MyWebAppDescriptor(file, file3, deploymentPlanBean, string);
        this.wlsWebAppDescriptor = new MyWlsWebAppDescriptor(file2, file3, deploymentPlanBean, string);
    }

    public WebAppDescriptor(File file, VirtualJarFile virtualJarFile, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
        this.webAppDescriptor = new MyWebAppDescriptor(file, file2, deploymentPlanBean, string);
        this.wlsWebAppDescriptor = new MyWlsWebAppDescriptor(virtualJarFile, file2, deploymentPlanBean, string);
    }

    public WebAppDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.webAppDescriptor = new MyWebAppDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
        this.wlsWebAppDescriptor = new MyWlsWebAppDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
    }

    public WebAppDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
        this.webAppDescriptor = new MyWebAppDescriptor(descriptorManager, genericClassLoader);
        this.wlsWebAppDescriptor = new MyWlsWebAppDescriptor(descriptorManager, genericClassLoader);
    }

    public WebAppDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.webAppDescriptor = new MyWebAppDescriptor(virtualJarFile, file, deploymentPlanBean, string);
        this.wlsWebAppDescriptor = new MyWlsWebAppDescriptor(virtualJarFile, file, deploymentPlanBean, string);
    }

    public WebAppDescriptor(File file) {
        this(file, (File)null, null, null, null);
    }

    public WebAppDescriptor(VirtualJarFile virtualJarFile) {
        this(virtualJarFile, null, null, null);
    }

    public void setValidateSchema(boolean bl) {
        this.validateSchema = bl;
    }

    public void writeDescriptors(File file) throws IOException, XMLStreamException {
        DescriptorManager descriptorManager = new DescriptorManager();
        File file2 = null;
        DescriptorBean descriptorBean = (DescriptorBean)this.getWebAppBean();
        if (descriptorBean != null) {
            file2 = new File(file, this.webAppDescriptor.getDocumentURI());
            DescriptorUtils.writeDescriptor(descriptorManager, descriptorBean, file2);
        }
        if ((descriptorBean = (DescriptorBean)this.getWeblogicWebAppBean()) != null) {
            file2 = new File(file, this.wlsWebAppDescriptor.getDocumentURI());
            DescriptorUtils.writeDescriptor(descriptorManager, descriptorBean, file2);
        }
    }

    public WebAppBean getWebAppBean() throws IOException, XMLStreamException {
        WebAppBean webAppBean;
        if (!this.validateSchema) {
            this.webAppDescriptor.setValidate(this.validateSchema);
        }
        if ((webAppBean = (WebAppBean)this.webAppDescriptor.loadDescriptorBean()) == null) {
            this.hasWebDescriptorFile = false;
            webAppBean = this.createWebAppBean();
            this.webAppDescriptor.updateDescriptorWithBean((DescriptorBean)webAppBean);
        }
        return webAppBean;
    }

    public boolean hasWebDescriptorFile() {
        return this.hasWebDescriptorFile;
    }

    public WeblogicWebAppBean getWeblogicWebAppBean() throws IOException, XMLStreamException {
        if (this.wlsWebAppDescriptor == null) {
            return null;
        }
        if (!this.validateSchema) {
            this.wlsWebAppDescriptor.setValidate(this.validateSchema);
        }
        return (WeblogicWebAppBean)this.wlsWebAppDescriptor.loadDescriptorBean();
    }

    public DescriptorBean mergeLibaryDescriptors(Source[] sourceArray, String string) throws IOException, XMLStreamException {
        if (string == null) {
            return null;
        }
        if (string.equals(STANDARD_DD)) {
            return this.webAppDescriptor.mergeDescriptors(sourceArray);
        }
        if (string.equals(WEBLOGIC_DD)) {
            return this.wlsWebAppDescriptor.mergeDescriptors(sourceArray);
        }
        return null;
    }

    public AbstractDescriptorLoader2 getWebAppDescriptorLoader() {
        return this.webAppDescriptor;
    }

    public AbstractDescriptorLoader2 getWlsWebAppDescriptorLoader() {
        return this.wlsWebAppDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            WebAppDescriptor.usage();
        }
        try {
            boolean bl = false;
            String string = stringArray[0];
            File file = new File(string);
            if (file.getName().endsWith(".war")) {
                JarFile jarFile = new JarFile(string);
                VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
                System.out.println("\n\n... getting WebAppBean:");
                WebAppDescriptor webAppDescriptor = new WebAppDescriptor(virtualJarFile, null, null, null);
                WebAppBean webAppBean = webAppDescriptor.getWebAppBean();
                ((DescriptorBean)webAppBean).getDescriptor().toXML((OutputStream)System.out);
                if (webAppDescriptor.getWeblogicWebAppBean() != null) {
                    System.out.println("\n\n... getting WeblogicWebAppBean:");
                    ((DescriptorBean)webAppDescriptor.getWeblogicWebAppBean()).getDescriptor().toXML((OutputStream)System.out);
                }
            } else {
                if (file.getPath().startsWith("edit")) {
                    bl = true;
                }
                if (file.getPath().endsWith("web.xml")) {
                    System.out.println("\n\n... getting WebAppBean: editable = " + bl);
                    WebAppDescriptor webAppDescriptor = bl ? new WebAppDescriptor((DescriptorManager)new EditableDescriptorManager(), new GenericClassLoader((ClassFinder)new DirectoryClassFinder(new File(".")))) : new WebAppDescriptor(file, (File)null, null, null, null);
                    ((DescriptorBean)webAppDescriptor.getWebAppBean()).getDescriptor().toXML((OutputStream)System.out);
                    System.out.println("\n\n\nDescriptor is editable = " + ((DescriptorBean)webAppDescriptor.getWebAppBean()).getDescriptor().isEditable());
                } else {
                    if (file.getPath().startsWith("edit")) {
                        bl = true;
                    }
                    if (file.getPath().endsWith("weblogic.xml")) {
                        File file2;
                        System.out.println("\n\n... getting WeblogicWebAppBean:");
                        WebAppDescriptor webAppDescriptor = bl ? new WebAppDescriptor((DescriptorManager)new EditableDescriptorManager(), new GenericClassLoader((ClassFinder)new DirectoryClassFinder(new File(".")))) : new WebAppDescriptor(null, file, null, null, null);
                        System.out.println("" + webAppDescriptor.getWeblogicWebAppBean());
                        ((DescriptorBean)webAppDescriptor.getWeblogicWebAppBean()).getDescriptor().toXML((OutputStream)System.out);
                        System.out.println("\n\n\nDescriptor is editable = " + ((DescriptorBean)webAppDescriptor.getWeblogicWebAppBean()).getDescriptor().isEditable());
                        if (stringArray.length > 1 && (file2 = new File(stringArray[1])).getPath().endsWith("plan.xml")) {
                            System.out.println("\n\n... plan:");
                            DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file2);
                            DeploymentPlanBean deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
                            ((DescriptorBean)deploymentPlanBean).getDescriptor().toXML((OutputStream)System.out);
                            if (stringArray.length > 2) {
                                WebAppDescriptor webAppDescriptor2 = new WebAppDescriptor(null, file, new File(deploymentPlanBean.getConfigRoot()), deploymentPlanBean, stringArray[2]);
                                System.out.println("\n\n... plan merged with WeblogicApplicationBean:");
                                ((DescriptorBean)webAppDescriptor2.getWeblogicWebAppBean()).getDescriptor().toXML((OutputStream)System.out);
                            } else {
                                System.out.println("\n\nNO MODULE NAME\n\nusage: java weblogic.servlet.internal.WebAppDescriptor weblogic.xml plan.xml module-name");
                            }
                        }
                    } else {
                        System.out.println("\n\n... neither web nor weblogic xml specified");
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.out.println(exception.getMessage());
            System.out.println(exception.getCause());
            exception.printStackTrace();
        }
    }

    private WebAppBean createWebAppBean() {
        WebAppBean webAppBean = (WebAppBean)new DescriptorManager().createDescriptorRoot(WebAppBean.class).getRootBean();
        webAppBean.setVersion("2.5");
        return webAppBean;
    }

    private static void usage() {
        System.err.println("usage: java weblogic.servlet.internal.WebAppDescriptor <descriptor file name>");
        System.err.println("\n\n example:\n java weblogic.servlet.internal.WebAppDescriptor war or altDD file name ");
        System.err.println("\n\n example:\n java weblogic.servlet.internal.WebAppDescriptor war or altDD file name ");
        System.exit(0);
    }

    public static class MyWlsWebAppDescriptor
    extends CachingDescriptorLoader2 {
        public MyWlsWebAppDescriptor(File file) {
            this(file, null, null, null);
        }

        public MyWlsWebAppDescriptor(VirtualJarFile virtualJarFile) {
            this(virtualJarFile, null, null, null);
        }

        public MyWlsWebAppDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            this(descriptorManager, genericClassLoader, null, null, null);
        }

        public MyWlsWebAppDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            super(file, file2, deploymentPlanBean, string, WebAppDescriptor.WEBLOGIC_DD);
        }

        public MyWlsWebAppDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, WebAppDescriptor.WEBLOGIC_DD);
        }

        public MyWlsWebAppDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(virtualJarFile, file, deploymentPlanBean, string, WebAppDescriptor.WEBLOGIC_DD);
        }

        public MyWlsWebAppDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(virtualJarFile, file, deploymentPlanBean, string, WebAppDescriptor.WEBLOGIC_DD);
        }

        public MyWlsWebAppDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, WebAppDescriptor.WEBLOGIC_DD);
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new WlsWebAppReader2(inputStream, this);
        }

        void setValidate(boolean bl) {
            super.setValidateSchema(bl);
        }
    }

    public static class MyWebAppDescriptor
    extends CachingDescriptorLoader2 {
        public MyWebAppDescriptor(File file) {
            this(file, null, null, null);
        }

        public MyWebAppDescriptor(VirtualJarFile virtualJarFile) {
            this(virtualJarFile, null, null, null);
        }

        public MyWebAppDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            this(descriptorManager, genericClassLoader, null, null, null);
        }

        public MyWebAppDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            super(file, file2, deploymentPlanBean, string, WebAppDescriptor.STANDARD_DD);
        }

        public MyWebAppDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, WebAppDescriptor.STANDARD_DD);
        }

        public MyWebAppDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(virtualJarFile, file, deploymentPlanBean, string, WebAppDescriptor.STANDARD_DD);
        }

        public MyWebAppDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(virtualJarFile, file, deploymentPlanBean, string, WebAppDescriptor.STANDARD_DD);
        }

        public MyWebAppDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, WebAppDescriptor.STANDARD_DD);
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new WebAppReader2(inputStream, this);
        }

        void setValidate(boolean bl) {
            super.setValidateSchema(bl);
        }
    }
}

