/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.descriptor.DescriptorCache;
import weblogic.servlet.internal.War;

abstract class WebAppIOHelper
implements DescriptorCache.IOHelper {
    protected final War.ResourceLocation resLocation;

    WebAppIOHelper(War.ResourceLocation resourceLocation) {
        this.resLocation = resourceLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object parseXML(InputStream inputStream) throws IOException, XMLStreamException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(WebAppIOHelper.class.getClassLoader());
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(inputStream);
            Object object = this.parseXMLInternal(xMLStreamReader);
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            return object;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
    }

    protected abstract Object parseXMLInternal(XMLStreamReader var1) throws IOException, XMLStreamException;

    public InputStream openInputStream() throws IOException {
        return this.resLocation.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readCachedBean(File file) throws IOException {
        Object object;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ObjectInputStream(new FileInputStream(file));
                object = objectInputStream.readObject();
                Object var5_5 = null;
                if (objectInputStream == null) return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (IOException)new IOException(classNotFoundException.getMessage()).initCause(classNotFoundException);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (objectInputStream == null) throw throwable;
            try {
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return object;
        }
        objectInputStream.close();
        return object;
    }

    public boolean useCaching() {
        return true;
    }
}

