/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import com.bea.wls.redef.ClassRedefinerFactory;
import com.bea.wls.redef.RedefiningClassLoader;
import com.bea.wls.redef.runtime.ClassRedefinitionRuntimeImpl;
import com.bea.wls.redef.runtime.ClassRedefinitionRuntimeMBean;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javax.management.InvalidAttributeValueException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationFileManager;
import weblogic.application.ConcurrentModule;
import weblogic.application.MergedDescriptorModule;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.ModuleLocationInfo;
import weblogic.application.ParentModule;
import weblogic.application.UpdateListener;
import weblogic.application.internal.BaseJ2EEModule;
import weblogic.application.io.DescriptorFinder;
import weblogic.application.utils.AppFileOverrideUtils;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.CompositeWebAppFinder;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.TargetUtils;
import weblogic.cacheprovider.coherence.CoherenceClusterManager;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deployment.AbstractPersistenceUnitRegistry;
import weblogic.deployment.EnvironmentException;
import weblogic.deployment.ModulePersistenceUnitRegistry;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.deployment.PersistenceUnitRegistryInitializer;
import weblogic.deployment.PersistenceUnitRegistryProvider;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.CoherenceClusterRefBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.FastSwapBean;
import weblogic.j2ee.descriptor.wl.JspDescriptorBean;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.kodo.monitoring.KodoPersistenceUnitParent;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.management.runtime.WorkManagerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.Jdk6;
import weblogic.servlet.internal.OnDemandManager;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.servlet.internal.WebAppInternalParser;
import weblogic.servlet.internal.WebAppParser;
import weblogic.servlet.internal.WebAppRuntimeMBeanImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;
import weblogic.servlet.internal.dd.glassfish.GlassFishWebAppParser;
import weblogic.servlet.internal.session.GracefulShutdownHelper;
import weblogic.utils.Debug;
import weblogic.utils.FileUtils;
import weblogic.utils.NestedException;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StringUtils;
import weblogic.utils.application.WarDetector;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ChangeAwareClassLoader;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.work.ShutdownCallback;
import weblogic.work.WorkManagerRuntimeMBeanImpl;
import weblogic.work.WorkManagerService;

public class WebAppModule
extends BaseJ2EEModule
implements Module,
ModuleLocationInfo,
ParentModule,
UpdateListener,
MergedDescriptorModule,
PersistenceUnitRegistryProvider,
ConcurrentModule {
    public static final String WEB_INF = "WEB-INF";
    public static final String WEB_XML_PATH = "WEB-INF/web.xml";
    public static final String WEBLOGIC_XML_PATH = "WEB-INF/weblogic.xml";
    public static final String APP_XML = "META-INF/application.xml";
    public static final String META_INF = "META-INF";
    public static final String PERSISTENCE_XML_PATH = "META-INF/persistence.xml";
    public static final String PERSISTENCE_CONFIGURATION_XML_PATH = "META-INF/persistence-configuration.xml";
    public static final String ROUTING_HANDLER_INIT_PARAM_NAME = "RoutingHandlerClassName";
    public static final String WSEE_SOAP_ROUTING_HANDLER_CLASS_NAME = "weblogic.wsee.jaxws.cluster.proxy.SOAPRoutingHandler";
    public static final String WSEE_PROXY_HTTP = "weblogic-wsee-proxy-channel-http";
    public static final String WSEE_PROXY_HTTPS = "weblogic-wsee-proxy-channel-https";
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugWebAppModule");
    private static final AppClassLoaderManager appClassLoaderManager = AppClassLoaderManager.getAppClassLoaderManager();
    private final String moduleURI;
    private final Map allContexts = new HashMap();
    private final String contextRootFromAppDD;
    private final ArrayList tmpDirs = new ArrayList();
    private final ArrayList archives = new ArrayList();
    private WebAppComponentMBean mbean;
    private WebAppBean webappBean;
    private WeblogicWebAppBean wlWebAppBean;
    private AppDeploymentMBean dmb;
    private ApplicationFileManager appFileManager;
    private ApplicationContextInternal appCtx;
    private File altDDFile;
    private WebAppInternalParser webAppParser;
    private GenericClassLoader parentClassLoader;
    private GenericClassLoader webClassLoader;
    private MultiClassFinder finder;
    private VirtualJarFile virtualJarFile;
    private boolean createdClassLoader;
    private boolean isSuspended = false;
    private boolean allowServletReload = true;
    private boolean webappsDestroyed = false;
    private boolean hasWebDescriptorFile = true;
    private ModuleException alreadyRegisteredException = null;
    private PersistenceUnitRegistry persistenceUnitRegistry;
    private PersistenceUnitRegistry proposedPersistenceUnitRegistry;
    private static Set redefinableWebApps = WebAppModule.initRedefinableWebApps();
    private int fastSwapRefreshInterval;
    private boolean registerFastSwapFilter;

    public WebAppModule(String string, String string2) {
        this.moduleURI = string;
        string2 = EarUtils.fixAppContextRoot(string2);
        if (string2 != null) {
            string2 = WarDetector.instance.stem(string2);
        }
        this.contextRootFromAppDD = string2;
    }

    private void initClassFinder() throws ModuleException {
        this.finder = new MultiClassFinder();
        ClassFinder classFinder = AppFileOverrideUtils.getFinderIfRequired(this.appCtx.getAppDeploymentMBean(), this.moduleURI);
        if (classFinder != null) {
            this.finder.addFinder(classFinder);
        }
    }

    private void initClassLoader() {
        this.webClassLoader = new ChangeAwareClassLoader((ClassFinder)this.finder, false, (ClassLoader)this.parentClassLoader);
        this.webClassLoader.setAnnotation(new Annotation(this.appCtx.getAppDeploymentMBean().getApplicationIdentifier(), this.normalizeId(this.getId(), this.moduleURI)));
    }

    private GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration, boolean bl) throws ModuleException {
        this.appCtx = (ApplicationContextInternal)applicationContext;
        this.parentClassLoader = genericClassLoader;
        registration.addUpdateListener(this);
        this.createdClassLoader = bl;
        this.initClassFinder();
        if (bl) {
            this.initClassLoader();
        } else {
            this.webClassLoader = genericClassLoader;
            this.webClassLoader.addClassFinder((ClassFinder)this.finder);
        }
        this.initJNDIContext();
        this.appFileManager = this.appCtx.getApplicationFileManager();
        return this.webClassLoader;
    }

    private void initMBeans() throws ModuleException {
        this.dmb = this.appCtx.getAppDeploymentMBean();
        ComponentMBean componentMBean = this.findComponentMBeanInternal(this.appCtx, this.moduleURI, WebAppComponentMBean.class);
        if (componentMBean instanceof WebAppComponentMBean) {
            this.mbean = (WebAppComponentMBean)componentMBean;
        }
    }

    public TargetMBean[] getTargets() {
        return this.dmb.getTargets();
    }

    private void initJNDIContext() throws ModuleException {
        Context context = this.appCtx.getEnvContext();
        try {
            context.lookup("/webapp");
        }
        catch (NameNotFoundException nameNotFoundException) {
            try {
                context.createSubcontext("webapp");
            }
            catch (NamingException namingException) {
                throw new ModuleException(namingException);
            }
        }
        catch (NamingException namingException) {
            throw new ModuleException(namingException);
        }
    }

    public String getDescriptorURI() {
        return WEB_INF;
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.init(applicationContext, genericClassLoader, registration, false);
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        return this.init(applicationContext, genericClassLoader, registration, true);
    }

    public String getModuleURI() {
        return this.moduleURI;
    }

    public String getId() {
        return this.contextRootFromAppDD != null ? this.contextRootFromAppDD : this.moduleURI;
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_WAR;
    }

    public GenericClassLoader getClassLoader() {
        return this.webClassLoader;
    }

    public String getContextRoot() {
        return this.contextRootFromAppDD;
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        int n = this.allContexts.size();
        ComponentRuntimeMBean[] componentRuntimeMBeanArray = new ComponentRuntimeMBean[n];
        Iterator iterator = this.allContexts.values().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            WebAppServletContext webAppServletContext = (WebAppServletContext)iterator.next();
            componentRuntimeMBeanArray[n2] = webAppServletContext.getRuntimeMBean();
            ++n2;
        }
        return componentRuntimeMBeanArray;
    }

    public DescriptorBean[] getDescriptors() {
        if (this.webappBean != null && this.wlWebAppBean != null) {
            return new DescriptorBean[]{(DescriptorBean)this.webappBean, (DescriptorBean)this.wlWebAppBean};
        }
        if (this.webappBean != null) {
            return new DescriptorBean[]{(DescriptorBean)this.webappBean};
        }
        if (this.wlWebAppBean != null) {
            return new DescriptorBean[]{(DescriptorBean)this.wlWebAppBean};
        }
        return new DescriptorBean[0];
    }

    public void prepare() throws ModuleException {
        this.alreadyRegisteredException = null;
        this.allContexts.clear();
        this.webappsDestroyed = false;
        this.initPersistenceUnitRegistry();
        this.initMBeans();
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug(HTTPLogger.logPreparingLoggable((String)this.getAppDisplayName(), (String)this.getId()).getMessage());
        }
        this.allowServletReload = this.webClassLoader instanceof ChangeAwareClassLoader;
        this.loadDescriptor();
        this.loadFastSwapClassloader();
        boolean bl = false;
        try {
            try {
                if (this.wlWebAppBean != null && this.appCtx != null) {
                    this.appCtx.getWorkManagerCollection().populate(this.getId(), this.wlWebAppBean);
                }
                if (this.isDeployedLocally()) {
                    this.registerWebApp(WebService.defaultHttpServer());
                }
                this.deployOnVirtualHosts();
                this.addWorkManagerRuntimes(this.appCtx.getWorkManagerCollection().getWorkManagers(this.getId()));
                this.initPersistenceMBean();
                this.setupCoherenceCaches();
                bl = true;
            }
            catch (DeploymentException deploymentException) {
                throw new ModuleException(deploymentException.getMessage(), (Throwable)((Object)deploymentException));
            }
            catch (ManagementException managementException) {
                throw new ModuleException(managementException.getMessage(), managementException);
            }
            catch (EnvironmentException environmentException) {
                throw new ModuleException((Throwable)((Object)environmentException));
            }
            Object var4_2 = null;
            if (!bl) {
                this.closeVirtualJarFile();
                this.destroyContexts();
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!bl) {
                this.closeVirtualJarFile();
                this.destroyContexts();
            }
            throw throwable;
        }
    }

    private void initPersistenceUnitRegistry() throws ModuleException {
        PersistenceUnitRegistryInitializer persistenceUnitRegistryInitializer = PersistenceUnitRegistryInitializer.getInstance(this.appCtx);
        persistenceUnitRegistryInitializer.setupPersistenceUnitRegistries();
    }

    protected void initPersistenceMBean() throws EnvironmentException {
        AbstractPersistenceUnitRegistry abstractPersistenceUnitRegistry = (AbstractPersistenceUnitRegistry)this.getPersistenceUnitRegistry();
        ComponentRuntimeMBean[] componentRuntimeMBeanArray = this.getComponentRuntimeMBeans();
        for (int i = 0; i < componentRuntimeMBeanArray.length; ++i) {
            if (!(componentRuntimeMBeanArray[i] instanceof KodoPersistenceUnitParent)) continue;
            abstractPersistenceUnitRegistry.setParentRuntimeMBean((KodoPersistenceUnitParent)((Object)componentRuntimeMBeanArray[i]));
        }
    }

    public void activate() throws IllegalStateException, ModuleException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug(HTTPLogger.logActivatingLoggable((String)this.getAppDisplayName(), (String)this.getId()).getMessage());
        }
        if (this.webappsDestroyed || this.alreadyRegisteredException != null) {
            this.prepare();
        }
        if (this.alreadyRegisteredException != null) {
            this.unprepare();
            throw this.alreadyRegisteredException;
        }
        this.activateContexts();
        this.registerBeanUpdateListeners();
        this.reconfigPersistenceUnits();
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug(HTTPLogger.logReadyLoggable((String)this.getAppDisplayName(), (String)this.getId()).getMessage());
        }
    }

    private void reconfigPersistenceUnits() throws ModuleException {
        PersistenceUnitRegistry persistenceUnitRegistry = this.getPersistenceUnitRegistry();
        if (persistenceUnitRegistry == null) {
            return;
        }
        Collection collection = persistenceUnitRegistry.getPersistenceUnitNames();
        for (String string : collection) {
            PersistenceUnitInfoImpl persistenceUnitInfoImpl = persistenceUnitRegistry.getPersistenceUnit(string);
            try {
                persistenceUnitInfoImpl.activate(this.appCtx.getEnvContext());
            }
            catch (EnvironmentException environmentException) {
                throw new ModuleException("Error activating JPA deployment:", (Throwable)((Object)environmentException));
            }
        }
    }

    public void start() throws ModuleException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug(HTTPLogger.logStartingLoggable((String)this.getAppDisplayName(), (String)this.getId()).getMessage());
        }
        this.startContexts();
        if (this.dmb != null && this.dmb.getOnDemandContextPaths() != null && this.dmb.getOnDemandContextPaths().length > 0) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("WebAppModule.activate: " + this.toString() + " unregister context paths ");
            }
            OnDemandManager onDemandManager = WebService.defaultHttpServer().getOnDemandManager();
            onDemandManager.unregisterOnDemandContextPaths(this.dmb.getOnDemandContextPaths());
        }
    }

    public void deactivate() throws IllegalStateException, ModuleException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug(HTTPLogger.logDeactivatingLoggable((String)this.getAppDisplayName(), (String)this.getId()).getMessage());
        }
        this.releaseCoherenceCaches();
        this.stopContexts();
        this.unregisterBeanUpdateListeners();
        this.destroyContexts();
        if (this.allowServletReload) {
            this.initClassFinder();
            this.initClassLoader();
            appClassLoaderManager.addModuleLoader(this.webClassLoader, this.getId());
        }
    }

    public void unprepare() throws IllegalStateException, ModuleException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug(HTTPLogger.logRollingBackLoggable((String)this.getAppDisplayName(), (String)this.getId()).getMessage());
        }
        this.releaseCoherenceCaches();
        this.destroyContexts();
        if (this.appCtx != null) {
            this.appCtx.getWorkManagerCollection().removeModuleEntries(this.getId());
        }
        if (this.finder != null) {
            this.finder.close();
        }
        this.closeVirtualJarFile();
        this.closePersistenceUnitRegistry();
        Jdk6.clearCache((ClassLoader)this.webClassLoader);
        this.cleanGeneratedJspClasses();
    }

    public void remove() throws ModuleException, IllegalStateException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug(HTTPLogger.logRemovingLoggable((String)this.getAppDisplayName(), (String)this.moduleURI).getMessage());
        }
        if (this.appCtx != null) {
            this.appCtx.getWorkManagerCollection().removeModuleEntries(this.getId());
        }
        if (this.archives != null && this.archives.size() > 0) {
            for (War war : this.archives) {
                war.remove();
            }
            this.archives.clear();
        }
        this.cleanupTempDirs();
        this.removeSavedSessionState();
        this.allContexts.clear();
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        if (this.createdClassLoader) {
            if (this.webClassLoader != null) {
                this.webClassLoader.close();
            }
            this.createdClassLoader = false;
        }
        this.finder = null;
        this.webClassLoader = null;
        registration.removeUpdateListener(this);
        this.closeVirtualJarFile();
    }

    public boolean acceptURI(String string) {
        if (string.endsWith(".class") || string.endsWith(".jar")) {
            return false;
        }
        if (this.appCtx.isEar()) {
            boolean bl = this.acceptModuleUri(this.appCtx, this.moduleURI, string);
            if (!bl) {
                String string2 = this.appCtx.getStagingPath();
                String string3 = string2 + "/" + string;
                for (WebAppServletContext webAppServletContext : this.allContexts.values()) {
                    War war = webAppServletContext.getWarInstance();
                    if (!war.isKnownVirtualMappingUri(string3)) continue;
                    return true;
                }
            }
            return bl;
        }
        return this.acceptModuleUri(this.appCtx, this.moduleURI, string);
    }

    public void adminToProduction() {
        this.setSuspended(false);
    }

    public void forceProductionToAdmin() throws ModuleException {
        this.setSuspended(true);
        GracefulShutdownHelper.notifyGracefulProductionToAdmin(this.appCtx.getApplicationId(), this);
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws ModuleException {
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getServerRuntime();
        if (serverRuntimeMBean.getStateVal() == 4 || serverRuntimeMBean.getStateVal() == 7 || this.isSuspended()) {
            return;
        }
        boolean bl = ApplicationVersionUtils.getIgnoreSessionsAppCtxParam(this.appCtx);
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("WebAppModule.gracefulProductionToAdmin: " + this.toString() + " received for " + this.moduleURI + ", ignoreSessions=" + bl);
        }
        ShutdownCallback shutdownCallback = adminModeCompletionBarrier.registerWMShutdown();
        GracefulShutdownHelper.waitForPendingSessions(this.appCtx.getApplicationId(), this, bl);
        this.setSuspended(true);
        shutdownCallback.completed();
    }

    public void prepareUpdate(String string) throws ModuleException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("WebAppModule: " + this.toString() + " received prepareUpdate for " + string);
        }
        String string2 = this.unmangle(this.appCtx, this.moduleURI, string);
        this.checkForDescriptorUpdate(string2);
        for (WebAppServletContext webAppServletContext : this.allContexts.values()) {
            webAppServletContext.precompileJspsOnUpdate(string2);
        }
    }

    public void activateUpdate(String string) throws ModuleException {
    }

    public void rollbackUpdate(String string) {
    }

    public String toString() {
        return "WebAppModule(" + this.getAppDisplayName() + ":" + this.getId() + ")";
    }

    boolean isServletReloadAllowed() {
        return this.allowServletReload;
    }

    public synchronized boolean isSuspended() {
        return this.isSuspended;
    }

    public synchronized void setSuspended(boolean bl) {
        this.isSuspended = bl;
    }

    private void registerBeanUpdateListeners() {
        if (this.wlWebAppBean == null) {
            return;
        }
        for (WebAppServletContext webAppServletContext : this.allContexts.values()) {
            DescriptorBean descriptorBean;
            BeanUpdateListener beanUpdateListener = webAppServletContext.getSessionContext().getConfigMgr().getBeanUpdateListener();
            ((DescriptorBean)this.wlWebAppBean).addBeanUpdateListener(beanUpdateListener);
            if (this.wlWebAppBean.getSessionDescriptors() != null && this.wlWebAppBean.getSessionDescriptors().length > 0) {
                descriptorBean = (DescriptorBean)this.wlWebAppBean.getSessionDescriptors()[0];
                descriptorBean.addBeanUpdateListener(beanUpdateListener);
            }
            beanUpdateListener = webAppServletContext.getJSPManager().getBeanUpdateListener();
            ((DescriptorBean)this.wlWebAppBean).addBeanUpdateListener(beanUpdateListener);
            if (this.wlWebAppBean.getJspDescriptors() != null && this.wlWebAppBean.getJspDescriptors().length > 0) {
                descriptorBean = (DescriptorBean)this.wlWebAppBean.getJspDescriptors()[0];
                descriptorBean.addBeanUpdateListener(beanUpdateListener);
            }
            beanUpdateListener = webAppServletContext.getConfigManager().getBeanUpdateListener();
            ((DescriptorBean)this.wlWebAppBean).addBeanUpdateListener(beanUpdateListener);
            if (this.wlWebAppBean.getContainerDescriptors() == null || this.wlWebAppBean.getContainerDescriptors().length <= 0) continue;
            descriptorBean = (DescriptorBean)this.wlWebAppBean.getContainerDescriptors()[0];
            descriptorBean.addBeanUpdateListener(beanUpdateListener);
        }
    }

    private void unregisterBeanUpdateListeners() {
        if (this.wlWebAppBean == null) {
            return;
        }
        for (WebAppServletContext webAppServletContext : this.allContexts.values()) {
            DescriptorBean descriptorBean;
            BeanUpdateListener beanUpdateListener = webAppServletContext.getSessionContext().getConfigMgr().getBeanUpdateListener();
            ((DescriptorBean)this.wlWebAppBean).removeBeanUpdateListener(beanUpdateListener);
            if (this.wlWebAppBean.getSessionDescriptors() != null && this.wlWebAppBean.getSessionDescriptors().length > 0) {
                descriptorBean = (DescriptorBean)this.wlWebAppBean.getSessionDescriptors()[0];
                descriptorBean.removeBeanUpdateListener(beanUpdateListener);
            }
            beanUpdateListener = webAppServletContext.getJSPManager().getBeanUpdateListener();
            ((DescriptorBean)this.wlWebAppBean).removeBeanUpdateListener(beanUpdateListener);
            if (this.wlWebAppBean.getJspDescriptors() != null && this.wlWebAppBean.getJspDescriptors().length > 0) {
                descriptorBean = (DescriptorBean)this.wlWebAppBean.getJspDescriptors()[0];
                descriptorBean.removeBeanUpdateListener(beanUpdateListener);
            }
            beanUpdateListener = webAppServletContext.getConfigManager().getBeanUpdateListener();
            ((DescriptorBean)this.wlWebAppBean).removeBeanUpdateListener(beanUpdateListener);
            if (this.wlWebAppBean.getContainerDescriptors() == null || this.wlWebAppBean.getContainerDescriptors().length <= 0) continue;
            descriptorBean = (DescriptorBean)this.wlWebAppBean.getContainerDescriptors()[0];
            descriptorBean.removeBeanUpdateListener(beanUpdateListener);
        }
    }

    private void cleanupTempDirs() {
        if (this.tmpDirs == null || this.tmpDirs.size() < 1) {
            return;
        }
        File file = null;
        for (File file2 : this.tmpDirs) {
            FileUtils.remove((File)file2);
            if (file != null) continue;
            file = file2.getParentFile();
        }
        this.tmpDirs.clear();
        if (file != null) {
            FileUtils.remove(file);
        }
    }

    private void deployOnVirtualHosts() throws ModuleException {
        VirtualHostMBean[] virtualHostMBeanArray = this.resolveWebServers();
        if (virtualHostMBeanArray == null) {
            return;
        }
        for (int i = 0; i < virtualHostMBeanArray.length; ++i) {
            HttpServer httpServer = WebService.getHttpServer(virtualHostMBeanArray[i].getName());
            if (httpServer == null || httpServer == WebService.defaultHttpServer()) continue;
            this.registerWebApp(httpServer);
        }
    }

    private void registerWebApp(HttpServer httpServer) throws ModuleException {
        String string = this.initAndValidateContextPath(httpServer);
        if (this.alreadyRegisteredException != null) {
            return;
        }
        this.allContexts.put(httpServer, httpServer.loadWebApp(this.mbean, this.appCtx, this, string));
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("registered " + string + " with " + httpServer);
        }
        this.checkWseeRoutingHandler();
    }

    private boolean checkWseeRoutingHandler() throws ModuleException {
        ServerMBean[] serverMBeanArray;
        if (!this.isWseeClusterRoutingHandlerConfigured()) {
            return true;
        }
        DomainMBean domainMBean = this.getDomain();
        for (ServerMBean serverMBean : serverMBeanArray = domainMBean.getServers()) {
            NetworkAccessPointMBean[] networkAccessPointMBeanArray;
            for (NetworkAccessPointMBean networkAccessPointMBean : networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints()) {
                String string = networkAccessPointMBean.getName();
                if (!string.equals(WSEE_PROXY_HTTP) && !string.equals(WSEE_PROXY_HTTPS)) continue;
                return true;
            }
        }
        throw new ModuleException("If a deployed (Cluster) Servlet has an  <init-param> with <param-name> = RoutingHandlerClassName and <param-value> = weblogic.wsee.jaxws.cluster.proxy.SOAPRoutingHandler in its <web.xml> file, Then the cluster domain must contain at least one <server> that is configured with a <network-access-point> named either 'weblogic-wsee-proxy-channel-http' or 'weblogic-wsee-proxy-channel-https'.  But neither has been found.  This is a deployment Error.");
    }

    private boolean isWseeClusterRoutingHandlerConfigured() {
        ServletBean[] servletBeanArray;
        WebAppBean webAppBean = this.getWebAppBean();
        for (ServletBean servletBean : servletBeanArray = this.getWebAppBean().getServlets()) {
            ParamValueBean paramValueBean = servletBean.lookupInitParam(ROUTING_HANDLER_INIT_PARAM_NAME);
            if (paramValueBean == null || !paramValueBean.getParamValue().equals(WSEE_SOAP_ROUTING_HANDLER_CLASS_NAME)) continue;
            return true;
        }
        return false;
    }

    private DomainMBean getDomain() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(WebAppModule.getKernelId());
        return runtimeAccess.getDomain();
    }

    private void removeSavedSessionState() {
        for (HttpServer httpServer : this.allContexts.keySet()) {
            httpServer.getServletContextManager().removeSavedSessionState(((WebAppServletContext)this.allContexts.get(httpServer)).getContextPath());
        }
    }

    private void checkForDescriptorUpdate(String string) throws ModuleException {
        if (WEB_XML_PATH.equals(string) || WEBLOGIC_XML_PATH.equals(string)) {
            this.prepareUpdateWebAppBean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareUpdateWebAppBean() throws ModuleException {
        Loggable loggable;
        WeblogicWebAppBean weblogicWebAppBean;
        WebAppBean webAppBean;
        block15: {
            try {
                this.virtualJarFile = this.createVirtualJarFile();
            }
            catch (IOException iOException) {
                throw new ModuleException(iOException.getMessage(), iOException);
            }
            WebAppParser webAppParser = this.getWebAppParser(this.virtualJarFile, this.appCtx.findDeploymentPlan());
            if (webAppParser == null) {
                this.closeVirtualJarFile();
                return;
            }
            webAppBean = null;
            weblogicWebAppBean = null;
            try {
                try {
                    webAppBean = webAppParser.getWebAppBean();
                    weblogicWebAppBean = webAppParser.getWeblogicWebAppBean();
                }
                catch (IOException iOException) {
                    loggable = HTTPLogger.logErrorReadingWebAppLoggable((String)this.toString(), (String)this.getWarPath(), (Throwable)iOException);
                    loggable.log();
                    this.createModuleException(loggable.getMessage(), iOException);
                    Object var7_6 = null;
                    this.closeVirtualJarFile();
                    break block15;
                }
                catch (Exception exception) {
                    loggable = HTTPLogger.logLoadErrorLoggable((String)this.toString(), (String)this.getWarPath(), (Throwable)exception);
                    loggable.log();
                    this.createModuleException(loggable.getMessage(), exception);
                    Object var7_7 = null;
                    this.closeVirtualJarFile();
                }
                Object var7_5 = null;
                this.closeVirtualJarFile();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.closeVirtualJarFile();
                throw throwable;
            }
        }
        try {
            Descriptor descriptor = null;
            loggable = null;
            if (webAppBean != null && this.webappBean != null) {
                descriptor = ((DescriptorBean)this.webappBean).getDescriptor();
                descriptor.prepareUpdate(((DescriptorBean)webAppBean).getDescriptor());
            }
            if (weblogicWebAppBean != null && this.wlWebAppBean != null) {
                loggable = ((DescriptorBean)this.wlWebAppBean).getDescriptor();
                loggable.prepareUpdate(((DescriptorBean)weblogicWebAppBean).getDescriptor());
            }
            if (descriptor != null) {
                descriptor.activateUpdate();
            }
            if (loggable != null) {
                loggable.activateUpdate();
            }
        }
        catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
            throw new ModuleException(descriptorUpdateRejectedException);
        }
        catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
            throw new ModuleException(descriptorUpdateFailedException);
        }
    }

    private String initAndValidateContextPath(HttpServer httpServer) throws ModuleException {
        Object object;
        String string = null;
        if ("console".equals(this.getId())) {
            string = HttpParsing.ensureStartingSlash((String)ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getDomain().getConsoleContextPath());
        } else {
            string = this.contextRootFromAppDD;
            if (this.wlWebAppBean != null) {
                Object object2 = object = this.wlWebAppBean.getContextRoots().length > 0 ? this.wlWebAppBean.getContextRoots()[0] : null;
                if (string == null || this.isSynthesizedApplicationXml()) {
                    string = object;
                } else if (this.wlWebAppBean.getContextRoots().length > 0) {
                    HTTPLogger.logIgnoringWeblogicXMLContextRoot((String)this.getAppDisplayName(), (String)this.getId(), (String)string, (String)object);
                }
            }
            if (string == null) {
                string = WarDetector.instance.stem(this.moduleURI);
            }
        }
        string = this.fixupContextPath(string);
        string = this.substituteAppName(string);
        if (httpServer.getMBean().getDefaultWebAppContextRoot() != null && httpServer.getMBean().getDefaultWebAppContextRoot().equals(string)) {
            string = "";
        }
        if ((object = httpServer.getServletContextManager().getContextForContextPath(string, this.dmb.getVersionIdentifier())) != null) {
            this.alreadyRegisteredException = ((WebAppServletContext)object).getWebAppModule() != null ? new ModuleException("Context path '" + string + "' is already in use by the module: " + ((WebAppServletContext)object).getWebAppModule().getModuleName() + " application: " + ((WebAppServletContext)object).getWebAppModule().getAppDisplayName()) : new ModuleException("Context path '" + string + "' is already in use by the module: " + ((WebAppServletContext)object).getName());
        }
        try {
            if (this.mbean != null) {
                this.mbean.setContextPath(string);
            }
        }
        catch (DistributedManagementException distributedManagementException) {
            HTTPLogger.logFailedToSetContextPath((String)this.getAppDisplayName(), (String)this.getId(), (String)string, (Throwable)distributedManagementException);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            HTTPLogger.logFailedToSetContextPath((String)this.getAppDisplayName(), (String)this.getId(), (String)string, (Throwable)invalidAttributeValueException);
        }
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Context Path = " + string);
        }
        if (this.appCtx.getApplicationDD() != null) {
            EarUtils.handleUnsetContextRoot(this.moduleURI, string, this.appCtx.getApplicationDD(), this.wlWebAppBean);
        }
        return string;
    }

    /*
     * Loose catch block
     */
    private boolean isSynthesizedApplicationXml() throws ModuleException {
        boolean bl;
        VirtualJarFile virtualJarFile;
        block11: {
            block9: {
                boolean bl2;
                block10: {
                    virtualJarFile = null;
                    if (this.appCtx != null && this.appCtx.getApplicationFileManager() != null) break block9;
                    bl2 = true;
                    Object var4_5 = null;
                    if (virtualJarFile == null) break block10;
                    try {
                        virtualJarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            virtualJarFile = this.appCtx.getApplicationFileManager().getVirtualJarFile();
            bl = virtualJarFile.getEntry(APP_XML) == null;
            Object var4_6 = null;
            if (virtualJarFile == null) break block11;
            try {
                virtualJarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
        catch (IOException iOException) {
            try {
                throw new ModuleException(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                block12: {
                    Object var4_7 = null;
                    if (virtualJarFile == null) break block12;
                    try {
                        virtualJarFile.close();
                    }
                    catch (IOException iOException2) {}
                }
                throw throwable;
            }
        }
    }

    private String fixupContextPath(String string) {
        if (string.equals("/") || string.equals("")) {
            return "";
        }
        if (string.startsWith("/")) {
            return string;
        }
        return "/" + string;
    }

    private String substituteAppName(String string) {
        if (string.indexOf("${APPNAME}") == -1) {
            return string;
        }
        return StringUtils.replaceGlobal((String)string, (String)"${APPNAME}", (String)ApplicationVersionUtils.getApplicationName(this.appCtx.getApplicationId()));
    }

    protected WebAppParser getWebAppParser(VirtualJarFile virtualJarFile, DeploymentPlanBean deploymentPlanBean) throws ModuleException {
        this.altDDFile = this.resolveAltDD(this.appCtx, this.moduleURI);
        File file = null;
        if (this.dmb.getPlanDir() != null) {
            file = new File(this.dmb.getLocalPlanDir());
        }
        WebAppDescriptor webAppDescriptor = null;
        webAppDescriptor = this.altDDFile != null ? new WebAppDescriptor(this.altDDFile, virtualJarFile, file, deploymentPlanBean, this.moduleURI) : new WebAppDescriptor(virtualJarFile, file, deploymentPlanBean, this.moduleURI);
        if (this.appCtx != null && this.appCtx.getAppDeploymentMBean().isInternalApp() && ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getDomain().isInternalAppsDeployOnDemandEnabled()) {
            webAppDescriptor.setValidateSchema(false);
        }
        return webAppDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDescriptor() throws ModuleException {
        block13: {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug(HTTPLogger.logLoadingDescriptorsLoggable((String)this.getAppDisplayName(), (String)this.getId()).getMessage());
            }
            try {
                block12: {
                    try {
                        this.virtualJarFile = this.createVirtualJarFile();
                        try {
                            WebAppParser webAppParser = this.getWebAppParser(this.virtualJarFile, this.dmb.getDeploymentPlanDescriptor());
                            this.webappBean = webAppParser.getWebAppBean();
                            this.wlWebAppBean = webAppParser.getWeblogicWebAppBean();
                            if (this.wlWebAppBean == null) {
                                this.wlWebAppBean = GlassFishWebAppParser.getParser(this.virtualJarFile).getWeblogicWebAppBean();
                            }
                            if (webAppParser instanceof WebAppInternalParser) {
                                this.webAppParser = (WebAppInternalParser)webAppParser;
                                this.hasWebDescriptorFile = this.webAppParser.hasWebDescriptorFile();
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (IOException iOException) {
                            throw new ModuleException(iOException.getMessage(), iOException);
                        }
                        if (this.webappBean != null) break block12;
                        this.webappBean = (WebAppBean)new DescriptorManager().createDescriptorRoot(WebAppBean.class).getRootBean();
                        this.webappBean.setVersion("2.5");
                        this.hasWebDescriptorFile = false;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Loggable loggable = HTTPLogger.logUnableToFindWebAppLoggable((String)this.toString(), (String)this.getWarPath(), (Throwable)fileNotFoundException);
                        loggable.log();
                        this.createModuleException(loggable.getMessage(), fileNotFoundException);
                        Object var4_8 = null;
                        this.closeVirtualJarFile();
                        break block13;
                    }
                    catch (IOException iOException) {
                        Loggable loggable = HTTPLogger.logErrorReadingWebAppLoggable((String)this.toString(), (String)this.getWarPath(), (Throwable)iOException);
                        loggable.log();
                        this.createModuleException(loggable.getMessage(), iOException);
                        Object var4_9 = null;
                        this.closeVirtualJarFile();
                        break block13;
                    }
                    catch (Exception exception) {
                        Loggable loggable = HTTPLogger.logLoadErrorLoggable((String)this.toString(), (String)this.getWarPath(), (Throwable)exception);
                        loggable.log();
                        this.createModuleException(loggable.getMessage(), exception);
                        Object var4_10 = null;
                        this.closeVirtualJarFile();
                    }
                }
                Object var4_7 = null;
                this.closeVirtualJarFile();
            }
            catch (Throwable throwable) {
                Object var4_11 = null;
                this.closeVirtualJarFile();
                throw throwable;
            }
        }
    }

    private VirtualJarFile createVirtualJarFile() throws ModuleException, IOException {
        String string = this.getWarPath();
        if (!new File(string).isDirectory() && WarDetector.instance.suffixed(string)) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug(HTTPLogger.logLoadingFromWARLoggable((String)this.toString(), (String)this.getModuleName(), (String)string).getMessage());
            }
            return VirtualJarFactory.createVirtualJar((JarFile)new JarFile(string));
        }
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug(HTTPLogger.logLoadingFromDirLoggable((String)this.toString(), (String)this.toString(), (String)string).getMessage());
        }
        return this.appFileManager.getVirtualJarFile(this.moduleURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeVirtualJarFile() {
        if (this.virtualJarFile != null) {
            try {
                try {
                    this.virtualJarFile.close();
                }
                catch (IOException iOException) {
                    if (DEBUG.isDebugEnabled()) {
                        DEBUG.debug(iOException.getMessage(), (Throwable)iOException);
                    }
                    Object var3_2 = null;
                    this.virtualJarFile = null;
                }
                Object var3_1 = null;
                this.virtualJarFile = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.virtualJarFile = null;
                throw throwable;
            }
        }
    }

    protected boolean isDeployedLocally() {
        AppDeploymentMBean appDeploymentMBean = null;
        if (this.appCtx.getProposedDomain() != null) {
            appDeploymentMBean = this.appCtx.getProposedDomain().lookupAppDeployment(this.appCtx.getApplicationId());
        }
        TargetMBean[] targetMBeanArray = TargetUtils.findModuleTargets(appDeploymentMBean, this.appCtx.getBasicDeploymentMBean(), this.appCtx, this.getId());
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] instanceof VirtualHostMBean || TargetUtils.findLocalServerTarget(new TargetMBean[]{targetMBeanArray[i]}) == null) continue;
            return true;
        }
        return false;
    }

    private VirtualHostMBean[] resolveWebServers() {
        TargetMBean[] targetMBeanArray;
        AppDeploymentMBean appDeploymentMBean = null;
        if (this.appCtx.getProposedDomain() != null) {
            appDeploymentMBean = this.appCtx.getProposedDomain().lookupAppDeployment(this.appCtx.getApplicationId());
        }
        if ((targetMBeanArray = TargetUtils.findModuleTargets(appDeploymentMBean, this.appCtx.getBasicDeploymentMBean(), this.getId())) == null || targetMBeanArray.length == 0) {
            return new VirtualHostMBean[0];
        }
        ArrayList<VirtualHostMBean> arrayList = new ArrayList<VirtualHostMBean>();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            VirtualHostMBean virtualHostMBean;
            if (!(targetMBeanArray[i] instanceof VirtualHostMBean) || !TargetUtils.isDeployedLocally((virtualHostMBean = (VirtualHostMBean)targetMBeanArray[i]).getTargets())) continue;
            arrayList.add(virtualHostMBean);
        }
        return arrayList.toArray(new VirtualHostMBean[arrayList.size()]);
    }

    private void addWorkManagerRuntimes(List list) throws ManagementException {
        Iterator iterator = this.allContexts.values().iterator();
        J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = this.appCtx.getRuntime();
        while (iterator.hasNext()) {
            WebAppServletContext webAppServletContext = (WebAppServletContext)iterator.next();
            WebAppRuntimeMBeanImpl webAppRuntimeMBeanImpl = webAppServletContext.getRuntimeMBean();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                WorkManagerRuntimeMBean workManagerRuntimeMBean = WorkManagerRuntimeMBeanImpl.getWorkManagerRuntime(((WorkManagerService)iterator2.next()).getDelegate(), j2EEApplicationRuntimeMBeanImpl, webAppRuntimeMBeanImpl);
                if (workManagerRuntimeMBean == null) continue;
                webAppRuntimeMBeanImpl.addWorkManagerRuntime(workManagerRuntimeMBean);
            }
        }
    }

    private void activateContexts() throws ModuleException {
        for (WebAppServletContext webAppServletContext : this.allContexts.values()) {
            try {
                webAppServletContext.activate();
            }
            catch (DeploymentException deploymentException) {
                throw new ModuleException(deploymentException.getMessage(), (Throwable)((Object)deploymentException));
            }
            catch (Throwable throwable) {
                throw new ModuleException(throwable.getMessage(), throwable);
            }
        }
    }

    private void startContexts() throws ModuleException {
        for (WebAppServletContext webAppServletContext : this.allContexts.values()) {
            try {
                webAppServletContext.start();
            }
            catch (DeploymentException deploymentException) {
                throw new ModuleException(deploymentException.getMessage(), (Throwable)((Object)deploymentException));
            }
            catch (Throwable throwable) {
                throw new ModuleException(throwable.getMessage(), throwable);
            }
        }
    }

    private void stopContexts() {
        for (WebAppServletContext webAppServletContext : this.allContexts.values()) {
            webAppServletContext.stop();
        }
    }

    private void destroyContexts() {
        if (this.webappsDestroyed) {
            return;
        }
        this.webappsDestroyed = true;
        this.tmpDirs.clear();
        this.archives.clear();
        for (HttpServer httpServer : this.allContexts.keySet()) {
            WebAppServletContext webAppServletContext = (WebAppServletContext)this.allContexts.get(httpServer);
            httpServer.unloadWebApp(webAppServletContext, this.dmb.getVersionIdentifier());
            this.tmpDirs.add(webAppServletContext.getRootTempDir());
            this.archives.add(webAppServletContext.getWarInstance());
        }
    }

    public String getWarPath() throws ModuleException {
        Debug.assertion((this.appFileManager != null ? 1 : 0) != 0);
        Debug.assertion((this.appFileManager.getSourcePath(this.moduleURI) != null ? 1 : 0) != 0);
        return this.appFileManager.getSourcePath(this.moduleURI).getAbsolutePath();
    }

    public WebAppBean getWebAppBean() {
        return this.webappBean;
    }

    void setWebAppBean(WebAppBean webAppBean) {
        this.webappBean = webAppBean;
    }

    boolean hasWebDescriptorFile() {
        return this.hasWebDescriptorFile;
    }

    public WeblogicWebAppBean getWlWebAppBean() {
        return this.wlWebAppBean;
    }

    void setClassFinder(ClassFinder classFinder) {
        if (!(classFinder instanceof MultiClassFinder)) {
            classFinder = new MultiClassFinder(classFinder);
        }
        this.finder = (MultiClassFinder)classFinder;
        this.webClassLoader.addClassFinder((ClassFinder)this.finder);
    }

    ClassLoader getWebClassLoader(boolean bl) {
        if (bl && this.webClassLoader != null) {
            try {
                Jdk6.clearCache((ClassLoader)this.webClassLoader);
                GenericClassLoader genericClassLoader = this.webClassLoader;
                Annotation annotation = genericClassLoader.getAnnotation();
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("reloading servlet classloader for " + this.toString());
                }
                this.webClassLoader = new ChangeAwareClassLoader((ClassFinder)this.finder, false, genericClassLoader.getParent());
                this.webClassLoader.setAnnotation(annotation);
                appClassLoaderManager.addModuleLoader(this.webClassLoader, this.getId());
            }
            catch (IllegalStateException illegalStateException) {
                HTTPLogger.logFailedToBounceClassLoader((String)this.getAppDisplayName(), (String)this.getId(), (Throwable)illegalStateException);
            }
        }
        return this.webClassLoader;
    }

    private String getModuleName() {
        return this.getId();
    }

    public String getName() {
        return this.getId();
    }

    private void createModuleException(String string, Exception exception) throws ModuleException {
        String string2 = string + PlatformConstants.EOL + (exception instanceof NestedException ? exception.toString() : exception.getMessage());
        throw new ModuleException(string2, exception);
    }

    public String getAppDisplayName() {
        return ApplicationVersionUtils.getDisplayName(this.dmb);
    }

    public WebAppServletContext getServletContextForServer(HttpServer httpServer) {
        return (WebAppServletContext)this.allContexts.get(httpServer);
    }

    public Iterator getAllContexts() {
        return this.allContexts.values().iterator();
    }

    private String normalizeId(String string, String string2) {
        if (string == null || string.trim().equals("") || string.equals("/")) {
            return string2;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    void mergeLibraryDescriptors(Source[] sourceArray, String string) throws IOException, Exception {
        if (string == null || this.webAppParser == null) {
            return;
        }
        if (string.equalsIgnoreCase(WEB_XML_PATH)) {
            this.webappBean = (WebAppBean)this.webAppParser.mergeLibaryDescriptors(sourceArray, string);
            if (HTTPDebugLogger.isEnabled()) {
                this.dump((DescriptorBean)this.webappBean);
            }
        } else if (string.equalsIgnoreCase(WEBLOGIC_XML_PATH)) {
            this.wlWebAppBean = (WeblogicWebAppBean)this.webAppParser.mergeLibaryDescriptors(sourceArray, string);
            if (HTTPDebugLogger.isEnabled()) {
                this.dump((DescriptorBean)this.wlWebAppBean);
            }
        }
    }

    private static Set initRedefinableWebApps() {
        String string = System.getProperty("weblogic.class.redef.webapps");
        if (string == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string.split(",")));
        return hashSet;
    }

    private void dump(DescriptorBean descriptorBean) {
        try {
            System.out.println("dumping merged descriptor for " + this.moduleURI);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new DescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)byteArrayOutputStream);
            new DescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)System.out);
            String string = byteArrayOutputStream.toString();
            HTTPLogger.logDebug((String)("dumping merged descriptor for " + this.moduleURI));
            HTTPLogger.logDebug((String)string);
        }
        catch (Exception exception) {
            System.out.println("unable to dump merged descriptor for " + this.moduleURI + exception.getMessage());
        }
    }

    public PersistenceUnitRegistry getPersistenceUnitRegistry() {
        return this.persistenceUnitRegistry;
    }

    private void cleanGeneratedJspClasses() {
        if (this.tmpDirs == null || this.tmpDirs.size() < 1) {
            return;
        }
        String string = this.getPackagePrefix();
        for (File file : this.tmpDirs) {
            FileUtils.remove((File)new File(file, string));
        }
    }

    private String getPackagePrefix() {
        if (this.wlWebAppBean == null) {
            return "jsp_servlet";
        }
        JspDescriptorBean[] jspDescriptorBeanArray = this.wlWebAppBean.getJspDescriptors();
        if (jspDescriptorBeanArray == null || jspDescriptorBeanArray.length == 0) {
            return "jsp_servlet";
        }
        String string = jspDescriptorBeanArray[0].getPackagePrefix();
        if (string == null) {
            return "jsp_servlet";
        }
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public Map getDescriptorMappings() {
        if (this.wlWebAppBean == null) {
            return null;
        }
        LibraryRefBean[] libraryRefBeanArray = this.wlWebAppBean.getLibraryRefs();
        if (libraryRefBeanArray == null || libraryRefBeanArray.length == 0) {
            return null;
        }
        HashMap<String, DescriptorBean> hashMap = new HashMap<String, DescriptorBean>(2);
        hashMap.put("/WEB-INF/web.xml", (DescriptorBean)this.webappBean);
        if (this.wlWebAppBean != null) {
            hashMap.put("/WEB-INF/weblogic.xml", (DescriptorBean)this.wlWebAppBean);
        }
        return hashMap;
    }

    public void handleMergedFinder(ClassFinder classFinder) {
        Iterator iterator = this.getAllContexts();
        while (iterator.hasNext()) {
            WebAppServletContext webAppServletContext = (WebAppServletContext)iterator.next();
            War war = webAppServletContext.getWarInstance();
            ClassFinder classFinder2 = war.getClassFinder();
            if (!(classFinder2 instanceof CompositeWebAppFinder)) continue;
            CompositeWebAppFinder compositeWebAppFinder = (CompositeWebAppFinder)classFinder2;
            DescriptorFinder descriptorFinder = new DescriptorFinder(war.getURI(), classFinder);
            compositeWebAppFinder.addFinderFirst(descriptorFinder);
            compositeWebAppFinder.addFinderFirst(classFinder);
        }
    }

    public void loadFastSwapClassloader() throws ModuleException {
        if (!this.createdClassLoader) {
            return;
        }
        if (HttpServer.isProductionModeEnabled()) {
            return;
        }
        boolean bl = redefinableWebApps.contains(this.getId());
        FastSwapBean fastSwapBean = null;
        if (this.wlWebAppBean != null && this.wlWebAppBean.getContainerDescriptors() != null) {
            fastSwapBean = this.wlWebAppBean.getFastSwap();
        }
        if (fastSwapBean == null && this.appCtx.getWLApplicationDD() != null) {
            fastSwapBean = this.appCtx.getWLApplicationDD().getFastSwap();
        }
        if (fastSwapBean != null && fastSwapBean.isEnabled()) {
            bl = true;
            this.registerFastSwapFilter = true;
            this.fastSwapRefreshInterval = fastSwapBean.getRefreshInterval();
        }
        if (bl) {
            try {
                this.webClassLoader = ClassRedefinerFactory.makeClassLoader((ClassFinder)this.webClassLoader.getClassFinder(), (ClassLoader)this.webClassLoader.getParent());
                this.webClassLoader.setAnnotation(new Annotation(this.appCtx.getAppDeploymentMBean().getApplicationIdentifier(), this.normalizeId(this.getId(), this.moduleURI)));
            }
            catch (Exception exception) {
                throw new ModuleException("Cannot initailize ClassRedefinerFactory", exception);
            }
            appClassLoaderManager.addModuleLoader(this.webClassLoader, this.getId());
            try {
                RedefiningClassLoader redefiningClassLoader = (RedefiningClassLoader)this.webClassLoader;
                J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = this.appCtx.getRuntime();
                ClassRedefinitionRuntimeImpl classRedefinitionRuntimeImpl = (ClassRedefinitionRuntimeImpl)j2EEApplicationRuntimeMBeanImpl.getClassRedefinitionRuntime();
                if (classRedefinitionRuntimeImpl != null) {
                    classRedefinitionRuntimeImpl.registerClassLoader(redefiningClassLoader);
                } else {
                    redefiningClassLoader.getRedefinitionRuntime().setRedefinitionTaskLimit(fastSwapBean.getRedefinitionTaskLimit());
                    classRedefinitionRuntimeImpl = new ClassRedefinitionRuntimeImpl((RuntimeMBean)j2EEApplicationRuntimeMBeanImpl, this.webClassLoader);
                    j2EEApplicationRuntimeMBeanImpl.setClassRedefinitionRuntime((ClassRedefinitionRuntimeMBean)classRedefinitionRuntimeImpl);
                }
            }
            catch (ManagementException managementException) {
                throw new ModuleException(managementException.getMessage(), managementException);
            }
            catch (ClassCastException classCastException) {
                throw new ModuleException(classCastException.getMessage(), classCastException);
            }
        }
    }

    public int getFastSwapRefreshInterval() {
        return this.fastSwapRefreshInterval;
    }

    public boolean getRegisterFastSwapFilter() {
        return this.registerFastSwapFilter;
    }

    protected void setupPersistenceUnitRegistry() throws EnvironmentException, MalformedURLException {
        if (this.persistenceUnitRegistry == null) {
            this.persistenceUnitRegistry = new ModulePersistenceUnitRegistry(this.webClassLoader, this.appCtx, this, true);
        }
    }

    private void closePersistenceUnitRegistry() {
        if (this.persistenceUnitRegistry != null) {
            this.persistenceUnitRegistry.close();
            this.persistenceUnitRegistry = null;
        }
    }

    void reloadPersistenceUnitRegistry() throws EnvironmentException, MalformedURLException {
        this.closePersistenceUnitRegistry();
        this.setupPersistenceUnitRegistry();
    }

    public PersistenceUnitRegistry getProposedPersistenceUnitRegistry() {
        return this.proposedPersistenceUnitRegistry;
    }

    public void setProposedPersistenceUnitRegistry(PersistenceUnitRegistry persistenceUnitRegistry) {
        this.proposedPersistenceUnitRegistry = persistenceUnitRegistry;
    }

    public boolean isParallelEnabled() {
        return true;
    }

    private void setupCoherenceCaches() throws DeploymentException {
        try {
            GenericClassLoader genericClassLoader = this.webClassLoader;
            CoherenceClusterManager coherenceClusterManager = CoherenceClusterManager.getInstance();
            boolean bl = coherenceClusterManager.isCoherenceAvailable((ClassLoader)genericClassLoader);
            CoherenceClusterRefBean coherenceClusterRefBean = this.getCoherenceClusterRefBean();
            String string = null;
            if (coherenceClusterRefBean != null) {
                string = coherenceClusterRefBean.getCoherenceClusterName();
                if (!bl) {
                    throw new ModuleException("Missing Coherence jar or WebLogic Coherence Integration jar");
                }
            }
            if (bl) {
                ComponentRuntimeMBean[] componentRuntimeMBeanArray = this.getComponentRuntimeMBeans();
                List<ComponentRuntimeMBean> list = Arrays.asList(componentRuntimeMBeanArray);
                WebAppComponentRuntimeMBean[] webAppComponentRuntimeMBeanArray = new WebAppComponentRuntimeMBean[list.size()];
                list.toArray(webAppComponentRuntimeMBeanArray);
                coherenceClusterManager.registerWebAppComponentRuntimeMBean((ClassLoader)genericClassLoader, webAppComponentRuntimeMBeanArray);
                coherenceClusterManager.configureClusterService((ClassLoader)genericClassLoader, string);
                coherenceClusterManager.addCacheConfiguration((ClassLoader)genericClassLoader);
            }
        }
        catch (ModuleException moduleException) {
            throw moduleException;
        }
        catch (Exception exception) {
            throw new ModuleException(exception.getMessage(), exception);
        }
    }

    private CoherenceClusterRefBean getCoherenceClusterRefBean() {
        if (this.wlWebAppBean != null) {
            return this.wlWebAppBean.getCoherenceClusterRef();
        }
        return null;
    }

    private void releaseCoherenceCaches() {
        if (this.webappsDestroyed) {
            return;
        }
        try {
            GenericClassLoader genericClassLoader = this.webClassLoader;
            CoherenceClusterManager coherenceClusterManager = CoherenceClusterManager.getInstance();
            if (coherenceClusterManager.isCoherenceAvailable((ClassLoader)genericClassLoader)) {
                coherenceClusterManager.releaseCacheConfiguration((ClassLoader)genericClassLoader);
                coherenceClusterManager.shutdownClusterService((ClassLoader)genericClassLoader);
                ComponentRuntimeMBean[] componentRuntimeMBeanArray = this.getComponentRuntimeMBeans();
                List<ComponentRuntimeMBean> list = Arrays.asList(componentRuntimeMBeanArray);
                WebAppComponentRuntimeMBean[] webAppComponentRuntimeMBeanArray = new WebAppComponentRuntimeMBean[list.size()];
                list.toArray(webAppComponentRuntimeMBeanArray);
                coherenceClusterManager.unRegisterWebAppComponentRuntimeMBean((ClassLoader)genericClassLoader, webAppComponentRuntimeMBeanArray);
            }
        }
        catch (Exception exception) {
            HTTPLogger.logError((String)this.toString(), (String)("Failed to cleanly shutdown Coherence: " + exception));
        }
    }

    static AuthenticatedSubject getKernelId() {
        return KernelIdHolder.kernelId;
    }

    private static class KernelIdHolder {
        static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

        private KernelIdHolder() {
        }
    }
}

