/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.ReaderEvent2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.OldDescriptorCompatibility;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;

public class WebAppReader2
extends VersionMunger {
    private static boolean enableReordering = Boolean.getBoolean("weblogic.servlet.descriptor.enableReordering");
    private boolean requiresLeadingForwardSlash = false;
    private boolean inEjbRef = false;
    private boolean inEjbLink = false;
    private ArrayList taglibs = new ArrayList();
    private ReaderEvent2 jspConfig = null;

    public WebAppReader2(InputStream inputStream, AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
        super(inputStream, abstractDescriptorLoader2, "weblogic.j2ee.descriptor.WebAppBeanImpl$SchemaHelper2", !enableReordering);
    }

    public String getDtdNamespaceURI() {
        return "http://java.sun.com/xml/ns/javaee";
    }

    public String getNamespaceURI() {
        String string = super.getNamespaceURI();
        if (string == null || string == "") {
            return this.getDtdNamespaceURI();
        }
        return string;
    }

    protected VersionMunger.Continuation onStartElement(String string) {
        this.requiresLeadingForwardSlash = this.requiresLeadingForwardSlash(this.getLocalName());
        if ("taglib".equals(string)) {
            this.getTaglibs().add(this.currentEvent);
        }
        if ("ejb-ref".equals(string)) {
            this.inEjbRef = true;
        }
        if ("ejb-link".equals(string)) {
            this.inEjbLink = true;
        }
        if (this.inEjbRef && "run-as".equals(string)) {
            return this.SKIP;
        }
        return CONTINUE;
    }

    protected VersionMunger.Continuation onCharacters(String string) {
        if (this.inEjbLink) {
            this.replaceSlashWithPeriod(this.inEjbLink);
        }
        return CONTINUE;
    }

    protected VersionMunger.Continuation onEndElement(String string) {
        this.requiresLeadingForwardSlash = false;
        if ("ejb-ref".equals(string)) {
            this.inEjbRef = false;
        }
        if ("ejb-link".equals(string)) {
            this.inEjbLink = false;
        }
        if (this.getTaglibs().size() > 0 && "web-app".equals(string)) {
            if (this.debug) {
                System.out.println("taglibs = " + this.getTaglibs());
            }
            System.out.flush();
            ReaderEvent2 readerEvent2 = this.lastEvent;
            SchemaHelper schemaHelper = readerEvent2.getSchemaHelper();
            if (this.debug) {
                System.out.println("lastEvent = " + this.lastEvent + ", parentSchemaHelper = " + schemaHelper);
            }
            this.jspConfig = new ReaderEvent2(1, "jsp-config", readerEvent2, readerEvent2.getLocation());
            int n = schemaHelper.getPropertyIndex(this.jspConfig.getElementName());
            SchemaHelper schemaHelper2 = schemaHelper.getSchemaHelper(n);
            this.jspConfig.setSchemaHelper(schemaHelper2);
            for (int i = 0; i < this.getTaglibs().size(); ++i) {
                ReaderEvent2 readerEvent22 = (ReaderEvent2)this.getTaglibs().get(i);
                readerEvent22.getParent().getChildren().remove(readerEvent22);
                this.jspConfig.adopt(readerEvent22, schemaHelper2);
            }
            readerEvent2.adopt(this.jspConfig, schemaHelper);
            this.getTaglibs().clear();
        }
        return CONTINUE;
    }

    protected VersionMunger.Continuation onEndDocument() {
        this.orderChildren();
        return CONTINUE;
    }

    private boolean requiresLeadingForwardSlash(String string) {
        return "location".equals(string);
    }

    public String getText() {
        String string;
        if (this.debug) {
            System.out.println("** WebAppReader.getText()");
        }
        String string2 = super.getText();
        if (!this.hasDTD()) {
            return string2;
        }
        if (string2 != null && (string = OldDescriptorCompatibility.canonicalize(this.currentEvent.getElementName(), string2)) != null) {
            if (this.debug) {
                System.out.println("txt = " + string2 + ", replaced = " + string);
            }
            this.currentEvent.getReaderEventInfo().setCharacters(string.toCharArray());
            return string;
        }
        if (string2.charAt(0) != '/' && this.requiresLeadingForwardSlash) {
            string2 = "/" + string2;
            if (this.debug) {
                System.out.println("txt, replaced = " + string2 + " for " + this.currentEvent.getElementName());
            }
            this.currentEvent.getReaderEventInfo().setCharacters(string2.toCharArray());
        }
        return string2;
    }

    public char[] getTextCharacters() {
        if (this.debug) {
            System.out.println("** WebAppReader2.getTextCharacters()");
        }
        char[] cArray = super.getTextCharacters();
        if (!this.hasDTD()) {
            return cArray;
        }
        if (cArray != null) {
            String string = OldDescriptorCompatibility.canonicalize(this.currentEvent.getElementName(), new String(cArray));
            if (string != null) {
                System.arraycopy(string.toCharArray(), 0, cArray, 0, string.length());
                if (this.debug) {
                    System.out.println("chars = " + new String(cArray) + ", replaced = " + string);
                }
                this.currentEvent.getReaderEventInfo().setCharacters(cArray);
            }
            if (cArray[0] != '/' && this.requiresLeadingForwardSlash) {
                char[] cArray2 = new char[cArray.length + 1];
                System.arraycopy(cArray, 0, cArray2, 1, cArray.length);
                cArray2[0] = 47;
                cArray = cArray2;
                if (this.debug) {
                    System.out.println("txt, replaced = " + new String(cArray) + " for " + this.currentEvent.getElementName());
                }
                this.currentEvent.getReaderEventInfo().setCharacters(cArray);
            }
        }
        return cArray;
    }

    public String getElementText() throws XMLStreamException {
        String string;
        if (this.debug) {
            System.out.println("** WebAppReader2.getElementText()");
        }
        String string2 = super.getElementText();
        if (!this.hasDTD()) {
            return string2;
        }
        if (string2 != null && (string = OldDescriptorCompatibility.canonicalize(this.currentEvent.getElementName(), string2)) != null) {
            if (this.debug) {
                System.out.println("txt = " + string2 + ", replaced = " + string);
            }
            return string;
        }
        return string2;
    }

    private ArrayList getTaglibs() {
        if (this.taglibs == null) {
            this.taglibs = new ArrayList();
        }
        return this.taglibs;
    }

    protected String getLatestSchemaVersion() {
        return "2.5";
    }

    protected boolean isOldSchema() {
        String string = this.getNamespaceURI();
        if (string != null && string.indexOf("j2ee") != -1) {
            this.isOldSchema = true;
            this.versionInfo = "2.4";
            return this.isOldSchema;
        }
        return false;
    }

    protected void transformOldSchema() {
        if (this.currentEvent.getElementName().equals("web-app")) {
            int n = this.currentEvent.getReaderEventInfo().getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string = this.currentEvent.getReaderEventInfo().getAttributeLocalName(i);
                String string2 = this.currentEvent.getReaderEventInfo().getAttributeValue(i);
                if (!string2.equals("2.4")) continue;
                this.versionInfo = string2;
                this.currentEvent.getReaderEventInfo().setAttributeValue("2.5", i);
            }
            this.transformNamespace("http://java.sun.com/xml/ns/javaee", this.currentEvent, "http://java.sun.com/xml/ns/j2ee");
        }
        this.tranformedNamespace = "http://java.sun.com/xml/ns/javaee";
    }

    public static void main(String[] stringArray) throws Exception {
        AbstractDescriptorLoader2 abstractDescriptorLoader2;
        String string;
        if (stringArray.length == 0) {
            WebAppReader2.usage();
            System.exit(-1);
        }
        String string2 = stringArray[0];
        String string3 = stringArray.length > 1 && stringArray[1].endsWith("plan.xml") ? stringArray[1] : null;
        File file = new File(string2);
        Object var4_4 = null;
        File file2 = new File(".");
        DeploymentPlanBean deploymentPlanBean = null;
        String string4 = string = stringArray.length > 2 ? stringArray[2] : null;
        if (string3 != null) {
            if (string == null) {
                WebAppReader2.usage();
                System.exit(-1);
            }
            abstractDescriptorLoader2 = new AbstractDescriptorLoader2(new File(string3), string3){};
            deploymentPlanBean = (DeploymentPlanBean)abstractDescriptorLoader2.loadDescriptorBean();
        }
        abstractDescriptorLoader2 = new AbstractDescriptorLoader2(file, file2, deploymentPlanBean, string, string2){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                System.out.println("call it...");
                return new WebAppReader2(inputStream, this);
            }
        };
        System.out.println("stamp out version munger for: " + string2);
        System.out.flush();
        DescriptorBean descriptorBean = abstractDescriptorLoader2.loadDescriptorBean();
        Descriptor descriptor = descriptorBean.getDescriptor();
        descriptor.toXML((OutputStream)System.out);
    }

    private static void usage() {
        System.out.print("java weblogic.servlet.internal.WebAppReader2 <dd-filename> || <dd-filename> <plan-filename> <module-name>");
    }
}

