/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.ComponentRuntimeMBeanImpl;
import weblogic.j2ee.descriptor.wl.LoggingBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.kodo.monitoring.KodoPersistenceUnitParent;
import weblogic.logging.j2ee.LoggingBeanAdapter;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.logging.LogRuntime;
import weblogic.management.runtime.CoherenceClusterRuntimeMBean;
import weblogic.management.runtime.KodoPersistenceUnitRuntimeMBean;
import weblogic.management.runtime.LibraryRuntimeMBean;
import weblogic.management.runtime.LogRuntimeMBean;
import weblogic.management.runtime.PageFlowsRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.ServletRuntimeMBean;
import weblogic.management.runtime.ServletSessionRuntimeMBean;
import weblogic.management.runtime.SpringRuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.management.runtime.WebPubSubRuntimeMBean;
import weblogic.management.runtime.WseeClientConfigurationRuntimeMBean;
import weblogic.management.runtime.WseeClientRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.servlet.ReferencedAttribute;
import weblogic.servlet.internal.PageFlowsRuntimeMBeanImpl;
import weblogic.servlet.internal.ServletRuntimeMBeanImpl;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.ServletSessionRuntimeMBeanImpl;
import weblogic.servlet.internal.session.SessionContext;

public class WebAppRuntimeMBeanImpl
extends ComponentRuntimeMBeanImpl
implements WebAppComponentRuntimeMBean,
ReferencedAttribute,
KodoPersistenceUnitParent {
    private static final long serialVersionUID = -1274209977754857686L;
    private WebAppServletContext context;
    private LogRuntime logRuntime;
    private PageFlowsRuntimeMBean pageFlowsRuntimeMBean;
    private LibraryRuntimeMBean[] libraryRuntimes;
    private Map m_runtimePersistenUnit = new HashMap();
    private WebPubSubRuntimeMBean webPubSubRuntimeMBean;
    private String applicationIdentifier;
    private CoherenceClusterRuntimeMBean coherenceClusterRuntimeMBean;
    private int state = 0;
    private SpringRuntimeMBean springRuntimeMBean;
    private final HashSet<WseeClientRuntimeMBean> wseeClientRuntimes = new HashSet();
    private final HashSet<WseeV2RuntimeMBean> wseeV2Runtimes = new HashSet();
    private final Set<WseeClientConfigurationRuntimeMBean> wseeClientConfigurationRuntimes = new HashSet<WseeClientConfigurationRuntimeMBean>();

    public WebAppRuntimeMBeanImpl(String string, String string2, WebAppServletContext webAppServletContext, RuntimeMBean runtimeMBean, String string3) throws ManagementException {
        super(string, string2, runtimeMBean, true, webAppServletContext.getMBean());
        LoggingBeanAdapter loggingBeanAdapter;
        this.context = webAppServletContext;
        this.applicationIdentifier = string3;
        if (this.context != null && this.context.getServletContextLogger() != null && (loggingBeanAdapter = this.context.getServletContextLogger().getLogAdapter()) != null) {
            this.logRuntime = new LogRuntime(loggingBeanAdapter, this);
        }
        this.pageFlowsRuntimeMBean = new PageFlowsRuntimeMBeanImpl(webAppServletContext.getServer().getServerName(), webAppServletContext.getServer().getName(), webAppServletContext.getContextPath(), webAppServletContext.getName(), this);
    }

    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public String getComponentName() {
        return this.context.getName();
    }

    public String getContextRoot() {
        return this.context.getContextPath();
    }

    public String getModuleURI() {
        WebAppModule webAppModule = this.context.getWebAppModule();
        if (webAppModule == null) {
            return null;
        }
        return webAppModule.getModuleURI();
    }

    public String getStatus() {
        return this.context.isStarted() ? "DEPLOYED" : "UNDEPLOYED";
    }

    public String getSourceInfo() {
        String string = this.context.getURI();
        return string == null ? "" : string;
    }

    public ServletRuntimeMBean[] getServlets() {
        return this.context.getServletRuntimeMBeans();
    }

    public int getOpenSessionsCurrentCount() {
        SessionContext sessionContext = this.context.getSessionContext();
        if (sessionContext == null) {
            return 0;
        }
        return sessionContext.getCurrOpenSessionsCount();
    }

    public int getOpenSessionsHighCount() {
        SessionContext sessionContext = this.context.getSessionContext();
        if (sessionContext == null) {
            return 0;
        }
        return sessionContext.getMaxOpenSessionsCount();
    }

    public int getSessionsOpenedTotalCount() {
        SessionContext sessionContext = this.context.getSessionContext();
        if (sessionContext == null) {
            return 0;
        }
        return sessionContext.getTotalOpenSessionsCount();
    }

    public Set getAllServletSessions() {
        return this.context.getSessionContext().getAllServletSessions();
    }

    public ServletSessionRuntimeMBean[] getServletSessions() {
        return this.context.getSessionContext().getServletSessionRuntimeMBeans();
    }

    public String[] getServletSessionsMonitoringIds() {
        return this.context.getSessionContext().getServletSessionsMonitoringIds();
    }

    public void invalidateServletSession(String string) throws IllegalStateException {
        this.context.getSessionContext().invalidateServletSession(string);
    }

    public long getSessionLastAccessedTime(String string) throws IllegalStateException {
        return this.context.getSessionContext().getSessionLastAccessedTime(string);
    }

    public long getSessionMaxInactiveInterval(String string) throws IllegalStateException {
        return this.context.getSessionContext().getSessionMaxInactiveInterval(string);
    }

    public String getMonitoringId(String string) throws IllegalStateException {
        return this.context.getSessionContext().getMonitoringId(string);
    }

    public ServletSessionRuntimeMBean getServletSession(String string) {
        return this.context.getSessionContext().getServletSessionRuntimeMBean(string);
    }

    public int getSessionTimeoutSecs() {
        return this.context.getSessionContext().getConfigMgr().getSessionTimeoutSecs();
    }

    public int getSessionInvalidationIntervalSecs() {
        return this.context.getSessionContext().getConfigMgr().getInvalidationIntervalSecs();
    }

    public int getSessionIDLength() {
        return this.context.getSessionContext().getConfigMgr().getIDLength();
    }

    public int getSessionCookieMaxAgeSecs() {
        return this.context.getSessionContext().getConfigMgr().getCookieMaxAgeSecs();
    }

    public String getSessionCookieComment() {
        return this.context.getSessionContext().getConfigMgr().getCookieComment();
    }

    public String getSessionCookieName() {
        return this.context.getSessionContext().getConfigMgr().getCookieName();
    }

    public String getSessionCookieDomain() {
        return this.context.getSessionContext().getConfigMgr().getCookieDomain();
    }

    public String getSessionCookiePath() {
        return this.context.getSessionContext().getConfigMgr().getCookiePath();
    }

    public boolean isIndexDirectoryEnabled() {
        return this.context.getConfigManager().isIndexDirectoryEnabled();
    }

    public boolean isFilterDispatchedRequestsEnabled() {
        return this.context.getConfigManager().isFilterDispatchedRequestsEnabled();
    }

    public int getServletReloadCheckSecs() {
        return this.context.getConfigManager().getServletReloadCheckSecs();
    }

    public int getSingleThreadedServletPoolSize() {
        return this.context.getConfigManager().getSingleThreadedServletPoolSize();
    }

    public boolean isSessionMonitoringEnabled() {
        return this.context.getSessionContext().getConfigMgr().isMonitoringEnabled();
    }

    public boolean isJSPKeepGenerated() {
        return "true".equalsIgnoreCase(this.get(this.context.getJSPManager().getJspConfigArgs(), "keepgenerated"));
    }

    public boolean isJSPVerbose() {
        return "true".equalsIgnoreCase(this.get(this.context.getJSPManager().getJspConfigArgs(), "verbose"));
    }

    public boolean isJSPDebug() {
        return "true".equalsIgnoreCase(this.get(this.context.getJSPManager().getJspConfigArgs(), "debug"));
    }

    public long getJSPPageCheckSecs() {
        String string = this.get(this.context.getJSPManager().getJspConfigArgs(), "pageCheckSeconds");
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1L;
    }

    public String getJSPCompileCommand() {
        return this.get(this.context.getJSPManager().getJspConfigArgs(), "compileCommand");
    }

    public String getLogFilename() {
        WebAppModule webAppModule = this.context.getWebAppModule();
        if (webAppModule == null) {
            return null;
        }
        WeblogicWebAppBean weblogicWebAppBean = webAppModule.getWlWebAppBean();
        if (weblogicWebAppBean == null) {
            return null;
        }
        LoggingBean loggingBean = (LoggingBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getLoggings(), "Logging");
        if (loggingBean == null) {
            return null;
        }
        return loggingBean.getLogFilename();
    }

    private String get(Map map, String string) {
        return this.trim((String)map.get(string));
    }

    private String trim(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string;
    }

    public void deleteInvalidSessions() {
        SessionContext sessionContext = this.context.getSessionContext();
        sessionContext.deleteInvalidSessions();
    }

    public int getDeploymentState() {
        return this.state;
    }

    public void setDeploymentState(int n) {
        this.state = n;
    }

    public static void dumpRuntime(PrintStream printStream, WebAppRuntimeMBeanImpl webAppRuntimeMBeanImpl) {
        WebAppRuntimeMBeanImpl.println(printStream, "========== DUMP ==============");
        WebAppRuntimeMBeanImpl.println(printStream, "STATUS: " + webAppRuntimeMBeanImpl.getStatus());
        WebAppRuntimeMBeanImpl.println(printStream, "SOURCE INFO: " + webAppRuntimeMBeanImpl.getSourceInfo());
        ServletRuntimeMBean[] servletRuntimeMBeanArray = webAppRuntimeMBeanImpl.getServlets();
        if (servletRuntimeMBeanArray == null) {
            WebAppRuntimeMBeanImpl.println(printStream, "SERVLETS IS NULL");
        } else if (servletRuntimeMBeanArray.length == 0) {
            WebAppRuntimeMBeanImpl.println(printStream, "SERVLETS IS EMPTY");
        } else {
            WebAppRuntimeMBeanImpl.println(printStream, "SERVLETS:");
            for (int i = 0; i < servletRuntimeMBeanArray.length; ++i) {
                ServletRuntimeMBeanImpl.dumpServlet(printStream, servletRuntimeMBeanArray[i]);
            }
        }
        WebAppRuntimeMBeanImpl.println(printStream, "OPEN SESSIONS: " + webAppRuntimeMBeanImpl.getOpenSessionsCurrentCount());
        WebAppRuntimeMBeanImpl.println(printStream, "OpenSessionsHighCount: " + webAppRuntimeMBeanImpl.getOpenSessionsHighCount());
        WebAppRuntimeMBeanImpl.println(printStream, "SessionsOpenedTotalCount: " + webAppRuntimeMBeanImpl.getSessionsOpenedTotalCount());
        ServletSessionRuntimeMBean[] servletSessionRuntimeMBeanArray = webAppRuntimeMBeanImpl.getServletSessions();
        if (servletSessionRuntimeMBeanArray == null) {
            WebAppRuntimeMBeanImpl.println(printStream, "SESSIONS IS NULL");
        } else if (servletSessionRuntimeMBeanArray.length == 0) {
            WebAppRuntimeMBeanImpl.println(printStream, "SESSIONS IS EMPTY");
        } else {
            WebAppRuntimeMBeanImpl.println(printStream, "SESSIONS:");
            for (int i = 0; i < servletSessionRuntimeMBeanArray.length; ++i) {
                ServletSessionRuntimeMBeanImpl.dumpSession(printStream, servletSessionRuntimeMBeanArray[i]);
            }
        }
    }

    private static void println(PrintStream printStream, String string) {
        printStream.println(string + "<br>");
    }

    public void registerServlet(String string, String string2, String[] stringArray, Map map, int n) throws DeploymentException {
        this.context.registerServlet(string, string2, stringArray, map, n);
    }

    public void registerFilter(String string, String string2, String[] stringArray, String[] stringArray2, Map map, String[] stringArray3) throws DeploymentException {
        this.context.registerFilter(string, string2, stringArray, stringArray2, map, stringArray3);
    }

    public LogRuntimeMBean getLogRuntime() {
        return this.logRuntime;
    }

    public PageFlowsRuntimeMBean getPageFlows() {
        return this.pageFlowsRuntimeMBean;
    }

    public LibraryRuntimeMBean[] getLibraryRuntimes() {
        return this.libraryRuntimes;
    }

    public void setLibraryRuntimes(LibraryRuntimeMBean[] libraryRuntimeMBeanArray) {
        this.libraryRuntimes = libraryRuntimeMBeanArray;
    }

    public void setSpringRuntimeMBean(SpringRuntimeMBean springRuntimeMBean) {
        this.springRuntimeMBean = springRuntimeMBean;
    }

    public SpringRuntimeMBean getSpringRuntimeMBean() {
        return this.springRuntimeMBean;
    }

    public void addKodoPersistenceUnit(KodoPersistenceUnitRuntimeMBean kodoPersistenceUnitRuntimeMBean) {
        this.m_runtimePersistenUnit.put(kodoPersistenceUnitRuntimeMBean.getPersistenceUnitName(), kodoPersistenceUnitRuntimeMBean);
    }

    public KodoPersistenceUnitRuntimeMBean[] getKodoPersistenceUnitRuntimes() {
        KodoPersistenceUnitRuntimeMBean[] kodoPersistenceUnitRuntimeMBeanArray = new KodoPersistenceUnitRuntimeMBean[this.m_runtimePersistenUnit.size()];
        kodoPersistenceUnitRuntimeMBeanArray = this.m_runtimePersistenUnit.values().toArray(kodoPersistenceUnitRuntimeMBeanArray);
        return kodoPersistenceUnitRuntimeMBeanArray;
    }

    public KodoPersistenceUnitRuntimeMBean getKodoPersistenceUnitRuntime(String string) {
        return (KodoPersistenceUnitRuntimeMBean)this.m_runtimePersistenUnit.get(string);
    }

    public WebPubSubRuntimeMBean getWebPubSubRuntime() {
        return this.webPubSubRuntimeMBean;
    }

    public void setWebPubSubRuntime(WebPubSubRuntimeMBean webPubSubRuntimeMBean) {
        this.webPubSubRuntimeMBean = webPubSubRuntimeMBean;
    }

    public CoherenceClusterRuntimeMBean getCoherenceClusterRuntime() {
        return this.coherenceClusterRuntimeMBean;
    }

    public void setCoherenceClusterRuntime(CoherenceClusterRuntimeMBean coherenceClusterRuntimeMBean) {
        this.coherenceClusterRuntimeMBean = coherenceClusterRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeClientRuntimeMBean[] getWseeClientRuntimes() {
        HashSet<WseeClientRuntimeMBean> hashSet = this.wseeClientRuntimes;
        synchronized (hashSet) {
            int n = this.wseeClientRuntimes.size();
            return this.wseeClientRuntimes.toArray(new WseeClientRuntimeMBean[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeClientRuntimeMBean lookupWseeClientRuntime(String string) {
        WseeClientRuntimeMBean wseeClientRuntimeMBean = null;
        HashSet<WseeClientRuntimeMBean> hashSet = this.wseeClientRuntimes;
        synchronized (hashSet) {
            for (WseeClientRuntimeMBean wseeClientRuntimeMBean2 : this.wseeClientRuntimes) {
                if (!wseeClientRuntimeMBean2.getName().equals(string)) continue;
                wseeClientRuntimeMBean = wseeClientRuntimeMBean2;
                break;
            }
        }
        return wseeClientRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWseeClientRuntime(WseeClientRuntimeMBean wseeClientRuntimeMBean) {
        HashSet<WseeClientRuntimeMBean> hashSet = this.wseeClientRuntimes;
        synchronized (hashSet) {
            this.wseeClientRuntimes.add(wseeClientRuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWseeClientRuntime(WseeClientRuntimeMBean wseeClientRuntimeMBean) {
        HashSet<WseeClientRuntimeMBean> hashSet = this.wseeClientRuntimes;
        synchronized (hashSet) {
            this.wseeClientRuntimes.remove(wseeClientRuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeV2RuntimeMBean[] getWseeV2Runtimes() {
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            int n = this.wseeV2Runtimes.size();
            return this.wseeV2Runtimes.toArray(new WseeV2RuntimeMBean[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeV2RuntimeMBean lookupWseeV2Runtime(String string) {
        WseeV2RuntimeMBean wseeV2RuntimeMBean = null;
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            for (WseeV2RuntimeMBean wseeV2RuntimeMBean2 : this.wseeV2Runtimes) {
                if (!wseeV2RuntimeMBean2.getName().equals(string)) continue;
                wseeV2RuntimeMBean = wseeV2RuntimeMBean2;
                break;
            }
        }
        return wseeV2RuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWseeV2Runtime(WseeV2RuntimeMBean wseeV2RuntimeMBean) {
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            this.wseeV2Runtimes.add(wseeV2RuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWseeV2Runtime(WseeV2RuntimeMBean wseeV2RuntimeMBean) {
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            this.wseeV2Runtimes.remove(wseeV2RuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeClientConfigurationRuntimeMBean[] getWseeClientConfigurationRuntimes() {
        Set<WseeClientConfigurationRuntimeMBean> set = this.wseeClientConfigurationRuntimes;
        synchronized (set) {
            return this.wseeClientConfigurationRuntimes.toArray(new WseeClientConfigurationRuntimeMBean[this.wseeClientConfigurationRuntimes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeClientConfigurationRuntimeMBean lookupWseeClientConfigurationRuntime(String string) {
        WseeClientConfigurationRuntimeMBean wseeClientConfigurationRuntimeMBean = null;
        Set<WseeClientConfigurationRuntimeMBean> set = this.wseeClientConfigurationRuntimes;
        synchronized (set) {
            for (WseeClientConfigurationRuntimeMBean wseeClientConfigurationRuntimeMBean2 : this.wseeClientConfigurationRuntimes) {
                if (!wseeClientConfigurationRuntimeMBean2.getName().equals(string)) continue;
                wseeClientConfigurationRuntimeMBean = wseeClientConfigurationRuntimeMBean2;
                break;
            }
        }
        return wseeClientConfigurationRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWseeClientConfigurationRuntime(WseeClientConfigurationRuntimeMBean wseeClientConfigurationRuntimeMBean) {
        Set<WseeClientConfigurationRuntimeMBean> set = this.wseeClientConfigurationRuntimes;
        synchronized (set) {
            this.wseeClientConfigurationRuntimes.add(wseeClientConfigurationRuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWseeClientConfigurationRuntime(WseeClientConfigurationRuntimeMBean wseeClientConfigurationRuntimeMBean) {
        Set<WseeClientConfigurationRuntimeMBean> set = this.wseeClientConfigurationRuntimes;
        synchronized (set) {
            this.wseeClientConfigurationRuntimes.remove(wseeClientConfigurationRuntimeMBean);
        }
    }
}

