/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspApplicationContext;
import oracle.jsp.provider.JspResourceProvider;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationFileManager;
import weblogic.application.ModuleException;
import weblogic.application.Type;
import weblogic.application.library.IllegalSpecVersionTypeException;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryConstants;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryReference;
import weblogic.application.library.LibraryReferenceFactory;
import weblogic.application.library.LibraryReferencer;
import weblogic.application.utils.AppFileOverrideUtils;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.PathUtils;
import weblogic.deployment.EnvironmentBuilder;
import weblogic.deployment.EnvironmentException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.health.HealthMonitorService;
import weblogic.j2ee.descriptor.JspConfigBean;
import weblogic.j2ee.descriptor.LoginConfigBean;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.ServletMappingBean;
import weblogic.j2ee.descriptor.WelcomeFileListBean;
import weblogic.j2ee.descriptor.wl.ContainerDescriptorBean;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.j2ee.descriptor.wl.LoggingBean;
import weblogic.j2ee.descriptor.wl.ServletDescriptorBean;
import weblogic.j2ee.descriptor.wl.SessionDescriptorBean;
import weblogic.j2ee.descriptor.wl.VirtualDirectoryMappingBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.jndi.factories.java.javaURLContextFactory;
import weblogic.logging.Loggable;
import weblogic.logging.j2ee.ServletContextLogger;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.ServletRuntimeMBean;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.AsyncInitServlet;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.JSPServlet;
import weblogic.servlet.WebLogicServletContext;
import weblogic.servlet.internal.AttributesMap;
import weblogic.servlet.internal.CompEnv;
import weblogic.servlet.internal.ContextVersionManager;
import weblogic.servlet.internal.ErrorManager;
import weblogic.servlet.internal.EventsManager;
import weblogic.servlet.internal.FilterChainImpl;
import weblogic.servlet.internal.FilterManager;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.JSPManager;
import weblogic.servlet.internal.MDSClassFinder;
import weblogic.servlet.internal.RequestCallback;
import weblogic.servlet.internal.RequestDispatcherImpl;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.StubSecurityHelper;
import weblogic.servlet.internal.URLMatchHelper;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WarSource;
import weblogic.servlet.internal.WebAnnotationProcessor;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppHelper;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppRuntimeMBeanImpl;
import weblogic.servlet.internal.WebAppShutdownService;
import weblogic.servlet.internal.WebComponentContributor;
import weblogic.servlet.internal.WebComponentCreator;
import weblogic.servlet.internal.WebService;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.internal.session.SharedSessionData;
import weblogic.servlet.jsp.JspApplicationContextImpl;
import weblogic.servlet.jsp.JspFactoryImpl;
import weblogic.servlet.jsp.JspFileNotFoundException;
import weblogic.servlet.jsp.JspStub;
import weblogic.servlet.jsp.StaleChecker;
import weblogic.servlet.jsp.TagFileClassLoader;
import weblogic.servlet.jsp.TagFileHelper;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.servlet.security.internal.ServletSecurityManager;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.servlet.utils.BeanELResolverCachePurger;
import weblogic.servlet.utils.FastSwapFilter;
import weblogic.servlet.utils.ServletMapping;
import weblogic.servlet.utils.URLMapping;
import weblogic.servlet.utils.URLMappingFactory;
import weblogic.servlet.utils.WarUtils;
import weblogic.spring.monitoring.instrumentation.SpringInstrumentationUtils;
import weblogic.utils.Debug;
import weblogic.utils.NestedRuntimeException;
import weblogic.utils.StringUtils;
import weblogic.utils.application.WarDetector;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ChangeAwareClassLoader;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.IteratorEnumerator;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.io.FilenameEncoder;
import weblogic.utils.jars.JarFileUtils;
import weblogic.version;
import weblogic.work.WorkManagerFactory;

public final class WebAppServletContext
implements ServletContext,
StaleChecker,
WebLogicServletContext {
    private static final boolean WIN_32;
    private static final boolean NO_VERSION_CHECK;
    private static final char FSC;
    private static final Map NON_BLOCKING_DISPATCH;
    private static final Map DIRECT_DISPATCH;
    private static final String TEMPDIR_ATTRIBUTE = "javax.servlet.context.tempdir";
    private static final String WL_HTTPD = "weblogic.httpd.";
    private static final String WL_RELOADCHECKSECS = "servlet.reloadCheckSecs";
    private static final String WL_CLASSPATH = "servlet.classpath";
    private static final String WL_PROXYCLIENTCERT = "clientCertProxy";
    private static final String WL_DEFAULTSERVLET = "defaultServlet";
    private static final String WL_INPUTCHARSET = "inputCharset";
    private static final String STANDARD_DD = "WEB-INF/web.xml";
    private static final String WEBLOGIC_DD = "WEB-INF/weblogic.xml";
    private static final String JSF_RI_DI_SPI = "com.sun.faces.injectionProvider";
    private static final String JSF_RI_SUNJSFJS = "com.sun.faces.sunJsfJs";
    private static final String WL_JSF_RI_DI_IMPL = "com.bea.faces.WeblogicInjectionProvider";
    private static final String WL_RP_COMPAT_SWITCH = "webapp.getrealpath.accept_context_path";
    public static final String WEBFLOW_RESOURCE = "webflow_resource";
    public static final DebugLogger DEBUG_URL_RES;
    private static Method wldfDyeInjectionMethod;
    private static int maxConcurrentRequestsAllowed;
    private static boolean mergeDescriptors;
    private static boolean doNotSendContinueHeader;
    private final WebAppModule module;
    private final HttpServer httpServer;
    private ContextVersionManager contextManager;
    private ClassLoader classLoader;
    private final TagFileHelper tagFileHelper = new TagFileHelper(this);
    private final WebAppComponentMBean compMBean;
    private final ApplicationContextInternal appCtx;
    private WebAppRuntimeMBeanImpl runtime;
    private final CompEnv compEnv;
    private final String contextName;
    private String contextPath;
    private final String versionId;
    private final String fullCtxName;
    private boolean adminMode = false;
    private final String logContext;
    private String displayName;
    private String docroot = null;
    private final AttributesMap attributes = new AttributesMap("servlet-context");
    private final Map initParams = new HashMap();
    private final EventsManager eventsManager = new EventsManager(this);
    private final SessionContext sessionContext;
    private final ServletSecurityManager securityManager;
    private final WebAppConfigManager configManager = new WebAppConfigManager(this);
    private final WebAppHelper helper;
    private final JSPManager jspManager = new JSPManager(this);
    private final ErrorManager errorManager = new ErrorManager(this);
    private final FilterManager filterManager = new FilterManager(this);
    private boolean defaultContext;
    private final boolean programmaticallyDeployed;
    private final boolean internalUtilitiesWebApp;
    private final boolean internalUtilitiesWebSvcs;
    private final boolean internalApp;
    private final boolean internalSAMLApp;
    private final boolean onDemandDisplayRefresh;
    private boolean started = false;
    private boolean isArchived = false;
    private boolean acceptContextPathInGetRealPath = false;
    private final ConcurrentHashMap servletStubs = new ConcurrentHashMap();
    private URLMapping servletMapping = new ServletMapping(WebAppConfigManager.isCaseInsensitive(), WebAppSecurity.getEnforceStrictURLPattern());
    private String[] indexFiles;
    private final TreeMap servletLoadSequences = new TreeMap();
    private boolean startedServletLoadSequences = false;
    private URLMatchHelper defaultURLMatchHelper = null;
    private String defaultServletName = null;
    private Object webservicesDD;
    private final ServletContextLogger servletContextLogger;
    private final boolean loggingEnabled;
    private War war;
    private File rootTempDir;
    private String tempPath;
    private HashMap jarFiles;
    private LibraryManager libraryManager = null;
    private boolean asyncInitsStillRunning = false;
    private final List asyncInitServlets = new ArrayList();
    private WebComponentCreator componentCreator;
    private JspResourceProvider jspResourceProvider;
    private MDSClassFinder mdsFinder;
    private JspApplicationContextImpl jacImpl = null;
    private Object reloadServletClassLoaderLock = new Object();
    private boolean isJsfApplication = false;
    static final long serialVersionUID = -7328668877117740921L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_Context_Handle_Throwable_Around_High;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    private WebAppServletContext(HttpServer httpServer, ApplicationContextInternal applicationContextInternal, WebAppComponentMBean webAppComponentMBean, WebAppModule webAppModule, String string, String string2, String string3, ClassLoader classLoader, boolean bl) throws DeploymentException {
        this.httpServer = httpServer;
        this.appCtx = applicationContextInternal;
        if (applicationContextInternal != null && applicationContextInternal.getAppDeploymentMBean() != null) {
            this.versionId = applicationContextInternal.getAppDeploymentMBean().getVersionIdentifier();
            this.onDemandDisplayRefresh = applicationContextInternal.getAppDeploymentMBean().isOnDemandDisplayRefresh();
        } else {
            this.versionId = null;
            this.onDemandDisplayRefresh = false;
        }
        this.contextName = string2;
        this.fullCtxName = this.versionId == null ? string2 : string2 + "#" + this.versionId;
        this.programmaticallyDeployed = bl;
        this.setContextPath(string3);
        this.compMBean = webAppComponentMBean;
        this.module = webAppModule;
        JspFactoryImpl.init();
        this.jacImpl = new JspApplicationContextImpl(this);
        this.internalUtilitiesWebApp = this.contextPath.equals(WebService.getInternalWebAppContextPath());
        this.internalUtilitiesWebSvcs = this.contextPath.equals("/_async");
        if (webAppComponentMBean != null) {
            this.attributes.put("weblogic.servlet.WebAppComponentMBean", webAppComponentMBean);
            this.internalApp = this.internalUtilitiesWebApp || webAppComponentMBean.getApplication().isInternalApp();
        } else {
            this.internalApp = this.internalUtilitiesWebApp;
        }
        this.internalSAMLApp = this.contextPath.equals("/samlits_ba") || this.contextPath.equals("/samlits_cc") || this.contextPath.equals("/samlacs") || this.contextPath.equals("/samlars") || this.contextPath.equals("/saml2");
        this.initSwitches();
        this.setDocroot(this.getRoot(string));
        this.processWebAppLibraries(this.getRootTempDir());
        if (mergeDescriptors) {
            this.mergeLibraryDescriptors();
        }
        if (webAppModule != null) {
            try {
                if (WarUtils.configureFCL(webAppModule.getWlWebAppBean(), applicationContextInternal.getAppClassLoader(), !applicationContextInternal.isEar())) {
                    HTTPLogger.logFilteringConfigurationIgnored((String)applicationContextInternal.getApplicationId(), (String)webAppModule.getModuleURI());
                }
            }
            catch (Exception exception) {
                throw new DeploymentException(exception.getMessage());
            }
            this.isJsfApplication = WarUtils.isJsfApplication(webAppModule.getWebAppBean(), webAppModule.getWlWebAppBean());
        }
        if (this.isJsfApplication) {
            this.initParams.put(JSF_RI_DI_SPI, WL_JSF_RI_DI_IMPL);
        }
        this.configManager.init();
        this.loadInitParams();
        this.helper = new ServletContextWebAppHelper();
        this.securityManager = new ServletSecurityManager(this);
        if (classLoader != null) {
            this.classLoader = classLoader;
        } else {
            this.initClassLoader(false);
        }
        this.processAnnotations(false);
        this.registerInternalServlets();
        this.sessionContext = this.initSessionContext();
        this.registerDefaultServlet();
        this.initFromMBean();
        this.servletContextLogger = this.initLogger();
        this.loggingEnabled = this.servletContextLogger != null;
        this.logContext = this.toString();
        this.compEnv = new CompEnv(this);
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Initialized servlet context: " + this.getLogContext());
        }
    }

    WebAppServletContext(HttpServer httpServer, ApplicationContextInternal applicationContextInternal, String string) throws DeploymentException {
        this(httpServer, applicationContextInternal, null, null, null, string, string, null, true);
        this.activate();
        this.start();
    }

    WebAppServletContext(HttpServer httpServer, ApplicationContextInternal applicationContextInternal, String string, ClassLoader classLoader) throws DeploymentException {
        this(httpServer, applicationContextInternal, null, null, null, string, string, classLoader, true);
        this.activate();
        this.start();
    }

    WebAppServletContext(HttpServer httpServer, ApplicationContextInternal applicationContextInternal, WebAppComponentMBean webAppComponentMBean, WebAppModule webAppModule, String string) throws DeploymentException, ModuleException {
        this(httpServer, applicationContextInternal, webAppComponentMBean, webAppModule, webAppModule.getWarPath(), ApplicationVersionUtils.getNonVersionedName(webAppModule.getName()), string, null, false);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string, this);
    }

    public Enumeration getAttributeNames() {
        if (this.attributes.isEmpty()) {
            return new EmptyEnumerator();
        }
        return new IteratorEnumerator(this.attributes.keys());
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        Object object2 = this.attributes.put(string, object, this);
        this.eventsManager.notifyContextAttributeChange(string, object, object2);
    }

    public void removeAttribute(String string) {
        Object object = this.attributes.remove(string);
        this.eventsManager.notifyContextAttributeChange(string, null, object);
    }

    public ServletContext getContext(String string) {
        if (string == null) {
            return null;
        }
        string = HttpParsing.ensureStartingSlash((String)string);
        ContextVersionManager contextVersionManager = this.httpServer.getServletContextManager().lookupVersionManager(string);
        if (contextVersionManager == null) {
            return null;
        }
        return contextVersionManager.getCurrentOrActiveContext(this.isAdminMode());
    }

    public String getInitParameter(String string) {
        return (String)this.initParams.get(string);
    }

    public void setInitParameter(String string, String string2) {
        this.initParams.put(string, string2);
    }

    public Enumeration getInitParameterNames() {
        if (this.initParams.isEmpty()) {
            return new EmptyEnumerator();
        }
        return new IteratorEnumerator(this.initParams.keySet().iterator());
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public String getMimeType(String string) {
        return this.configManager.getMimeType(string);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return this.getRequestDispatcher(string, -1);
    }

    RequestDispatcher getRequestDispatcher(String string, int n) {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            return null;
        }
        String string2 = null;
        int n2 = string.indexOf(63);
        if (n2 > 0 && n2 <= string.length() - 1) {
            string2 = string.substring(n2 + 1);
            if ("".equals(string2)) {
                string2 = null;
            }
            string = string.substring(0, n2);
        }
        if ((string = FilenameEncoder.resolveRelativeURIPath((String)string, (boolean)true)) == null) {
            return null;
        }
        return new RequestDispatcherImpl(string, string2, this, n);
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        return this.getNamedDispatcher(string, -1);
    }

    public RequestDispatcher getNamedDispatcher(String string, int n) {
        if (string == null) {
            return null;
        }
        ServletStubImpl servletStubImpl = (ServletStubImpl)this.servletStubs.get((Object)string);
        if (servletStubImpl == null) {
            return null;
        }
        return new RequestDispatcherImpl(servletStubImpl, this, n);
    }

    public String getRealPath(String string) {
        Object object;
        if (this.docroot == null) {
            HTTPLogger.logNullDocRoot((String)this.getLogContext(), (String)"getRealPath()");
            return null;
        }
        if (string == null) {
            return null;
        }
        String string2 = string.replace('/', FSC);
        if (this.isArchived) {
            if (this.configManager.isShowArchivedRealPathEnabled()) {
                try {
                    File file = new File(this.getRootTempDir(), "war");
                    file = FilenameEncoder.getSafeFile((String)file.getPath(), (String)string2);
                    return file.getCanonicalPath();
                }
                catch (FilenameEncoder.UnsafeFilenameException unsafeFilenameException) {
                    HTTPLogger.logUnsafePath((String)this.getLogContext(), (String)"getRealPath()", (String)string, (Throwable)unsafeFilenameException);
                    return null;
                }
                catch (IOException iOException) {
                    HTTPLogger.logUnsafePath((String)this.getLogContext(), (String)"getRealPath()", (String)string, (Throwable)iOException);
                    return null;
                }
            }
            return null;
        }
        if (this.acceptContextPathInGetRealPath && !this.isDefaultContext() && string2.startsWith((String)(object = FSC + this.contextName))) {
            string2 = string2.substring(((String)object).length());
        }
        try {
            object = this.appCtx.getApplicationFileManager();
            File[] fileArray = ((ApplicationFileManager)object).getVirtualJarFile(this.getURI()).getRootFiles();
            if (fileArray.length == 0) {
                throw new AssertionError((Object)"Could not determine the docroot in getRealPath");
            }
            File file = null;
            for (int i = 0; i < fileArray.length && !(file = FilenameEncoder.getSafeFile((String)fileArray[i].getPath(), (String)string2)).exists(); ++i) {
            }
            return file.getCanonicalPath();
        }
        catch (FilenameEncoder.UnsafeFilenameException unsafeFilenameException) {
            HTTPLogger.logUnsafePath((String)this.getLogContext(), (String)"getRealPath()", (String)string, (Throwable)unsafeFilenameException);
            return null;
        }
        catch (IOException iOException) {
            HTTPLogger.logUnsafePath((String)this.getLogContext(), (String)"getRealPath()", (String)string, (Throwable)iOException);
            return null;
        }
    }

    public URL getResource(String string) throws MalformedURLException {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + " getResource() invoked for : " + string);
        }
        if (string == null || string.length() < 1 || string.charAt(0) != '/') {
            throw new MalformedURLException("The path for getResource() must begin with a '/'");
        }
        WarSource warSource = this.getResourceAsSource(string);
        return warSource == null ? null : warSource.getURL();
    }

    public URL[] getResources(String string) throws MalformedURLException {
        if (string == null || string.length() < 1 || string.charAt(0) != '/') {
            throw new MalformedURLException("The path for getResources() must begin with a '/'");
        }
        ClassFinder classFinder = this.war.getResourceFinder(string);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Enumeration enumeration = classFinder.getSources(string);
        while (enumeration.hasMoreElements()) {
            arrayList.add(((Source)enumeration.nextElement()).getURL());
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public InputStream getResourceAsStream(String string) {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + " getResourceAsStream() invoked for : " + string);
        }
        WarSource warSource = this.getResourceAsSource(string);
        try {
            return warSource == null ? null : warSource.getInputStream();
        }
        catch (IOException iOException) {
            HTTPLogger.logUnableToGetStream((String)this.getLogContext(), (String)string, (Throwable)iOException);
            return null;
        }
    }

    public String getServerInfo() {
        return HttpServer.SERVER_INFO;
    }

    public HttpServer getServer() {
        return this.httpServer;
    }

    public void log(String string, Throwable throwable) {
        if (!this.loggingEnabled) {
            return;
        }
        this.servletContextLogger.log(string, throwable);
    }

    public void logError(String string) {
        if (!this.loggingEnabled) {
            return;
        }
        this.servletContextLogger.logError(string);
    }

    public void log(String string) {
        if (!this.loggingEnabled) {
            return;
        }
        this.servletContextLogger.log(string);
    }

    public Set getResourcePaths(String string) {
        if (string == null) {
            return null;
        }
        string = HttpParsing.ensureEndingSlash((String)string);
        HashSet hashSet = new HashSet();
        this.war.getResourcePaths(string, hashSet);
        return hashSet.isEmpty() ? null : hashSet;
    }

    public String getServletContextName() {
        return this.displayName;
    }

    public Enumeration getServletNames() {
        return new IteratorEnumerator(this.servletStubs.keySet().iterator());
    }

    public Servlet getServlet(String string) {
        return null;
    }

    public Enumeration getServlets() {
        return new EmptyEnumerator();
    }

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public ContextVersionManager getContextManager() {
        if (this.contextManager == null || this.contextManager.isOld()) {
            this.contextManager = this.httpServer.getServletContextManager().lookupVersionManagerForContextPath(this.getContextPath());
        }
        return this.contextManager;
    }

    public void addSession(String string) {
        ContextVersionManager contextVersionManager = this.getContextManager();
        if (contextVersionManager != null) {
            contextVersionManager.putContextForSession(string, this);
        }
    }

    public void removeSession(String string) {
        ContextVersionManager contextVersionManager = this.getContextManager();
        if (contextVersionManager != null) {
            contextVersionManager.removeContextForSession(string);
        }
    }

    public void enteringContext(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl, HttpSession httpSession) {
        if (!(httpSession instanceof SharedSessionData)) {
            this.sessionContext.enter(servletRequestImpl, servletResponseImpl, httpSession);
        }
    }

    public void exitingContext(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl, HttpSession httpSession) {
        if (!(httpSession instanceof SharedSessionData)) {
            this.sessionContext.exit(servletRequestImpl, servletResponseImpl, httpSession);
        }
    }

    ServletContextLogger getServletContextLogger() {
        return this.servletContextLogger;
    }

    private ServletContextLogger initLogger() {
        if (this.programmaticallyDeployed || this.module == null || this.module.getWlWebAppBean() == null || this.module.getWlWebAppBean().getLoggings().length == 0) {
            return new ServletContextLogger("ServletContext-" + this.getContextPath(), null);
        }
        LoggingBean loggingBean = this.module.getWlWebAppBean().getLoggings()[0];
        if (loggingBean.isLoggingEnabled()) {
            return new ServletContextLogger("ServletContext-" + this.getContextPath(), loggingBean);
        }
        return null;
    }

    private void loadInitParams() {
        ParamValueBean[] paramValueBeanArray;
        if (this.module != null && this.module.getWebAppBean() != null && (paramValueBeanArray = this.module.getWebAppBean().getContextParams()) != null) {
            for (int i = 0; i < paramValueBeanArray.length; ++i) {
                this.addInitParameter(paramValueBeanArray[i].getParamName(), paramValueBeanArray[i].getParamValue());
            }
        }
    }

    private void initFromMBean() {
        this.acceptContextPathInGetRealPath = this.httpServer.getMBean().isAcceptContextPathInGetRealPath();
        if (this.compMBean != null) {
            this.configManager.registerMBean(this.compMBean);
            this.setDefaultServlet(this.compMBean.getDefaultServlet());
        }
    }

    private void setDefaultServlet(String string) {
        ServletStubImpl servletStubImpl;
        if (string == null) {
            return;
        }
        if (this.servletStubs != null && (servletStubImpl = (ServletStubImpl)this.servletStubs.get((Object)string)) != null) {
            this.defaultURLMatchHelper = new URLMatchHelper("/", servletStubImpl);
        }
        this.defaultServletName = string;
    }

    private String getRoot(String string) throws DeploymentException {
        Debug.assertion((string != null ? 1 : 0) != 0);
        File file = new File(string);
        if (!file.isDirectory() && WarDetector.instance.suffixed(string)) {
            this.isArchived = true;
            return file.getPath();
        }
        return string.replace('/', FSC);
    }

    private void registerDefaultServlet() {
        this.registerServlet("FileServlet", "/", "weblogic.servlet.FileServlet", new HashMap());
    }

    private void registerInternalServlets() throws DeploymentException {
        if (!this.programmaticallyDeployed) {
            this.registerWebServicesServlet();
        }
    }

    private void registerWebServicesServlet() throws DeploymentException {
        String string;
        if (this.configManager.isImplicitServletMappingDisabled()) {
            return;
        }
        try {
            this.getServletClassLoader().loadClass("weblogic.webservice.server.servlet.WebServiceServlet");
            string = "weblogic.webservice.server.servlet.WebServiceServlet";
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = "weblogic.webservice.server.servlet.DummyServlet";
        }
        this.registerServletDefinition("WebServiceServlet", string, null, false);
        this.registerServletLoadSequence("WebServiceServlet", 0);
    }

    void prepare(RuntimeMBean runtimeMBean) throws DeploymentException {
        AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getServer();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.httpServer.getName());
        stringBuffer.append("_").append(this.getContextPath());
        stringBuffer.append(this.getVersionId() == null ? "" : "_" + this.getVersionId());
        try {
            this.runtime = new WebAppRuntimeMBeanImpl(stringBuffer.toString(), this.contextPath, this, runtimeMBean, appDeploymentMBean.getApplicationIdentifier());
        }
        catch (ManagementException managementException) {
            throw new DeploymentException(managementException);
        }
        if (this.libraryManager != null && !this.libraryManager.hasUnresolvedReferences()) {
            this.runtime.setLibraryRuntimes(this.libraryManager.getReferencedLibraryRuntimes());
            this.libraryManager.getReferencer().setReferencerRuntime(this.runtime);
        }
        if (this.module != null && this.module.getRegisterFastSwapFilter()) {
            FastSwapFilter.registerFastSwapFilter(this);
        }
        this.prepareFromDescriptors();
        this.initResourceProvider();
        this.attributes.put("weblogic.servlet.WebAppComponentRuntimeMBean", this.runtime);
        this.initContextListeners();
        for (ServletStubImpl servletStubImpl : this.servletStubs.values()) {
            try {
                servletStubImpl.initRuntime();
            }
            catch (ManagementException managementException) {
                throw new DeploymentException(managementException);
            }
        }
        this.getSecurityManager().getWebAppSecurity().start();
    }

    private SessionContext initSessionContext() throws DeploymentException {
        WeblogicWebAppBean weblogicWebAppBean;
        SessionDescriptorBean sessionDescriptorBean = null;
        WeblogicApplicationBean weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        if (weblogicApplicationBean != null && weblogicApplicationBean.isSet("SessionDescriptor")) {
            sessionDescriptorBean = weblogicApplicationBean.getSessionDescriptor();
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug(this.getLogContext() + ": shared session context enabled");
            }
        }
        if (sessionDescriptorBean == null && this.module != null && (weblogicWebAppBean = this.module.getWlWebAppBean()) != null) {
            sessionDescriptorBean = (SessionDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getSessionDescriptors(), "SessionDescriptor");
        }
        return SessionContext.getInstance(this, sessionDescriptorBean);
    }

    private void initSwitches() {
        String string = this.appCtx.getApplicationParameter(WL_RP_COMPAT_SWITCH);
        if (string != null && string.equalsIgnoreCase("true")) {
            this.acceptContextPathInGetRealPath = true;
        }
    }

    private void prepareFromDescriptors() throws DeploymentException {
        if (this.module == null || this.module.getWebAppBean() == null) {
            return;
        }
        String[] stringArray = this.module.getWebAppBean().getDisplayNames();
        if (stringArray != null && stringArray.length > 0) {
            this.displayName = stringArray[0];
        }
        this.configManager.registerContainerDescriptors(this.module.getWlWebAppBean());
        this.getSecurityManager().getWebAppSecurity().registerSecurityRoles(this.module);
        this.jspManager.registerJspDescriptor(this.module.getWebAppBean(), this.module.getWlWebAppBean());
        this.filterManager.registerServletFilters(this.module.getWebAppBean());
        this.registerURLMatchMapper();
        this.registerServlets();
        this.registerWelcomeFiles();
        this.getSecurityManager().getWebAppSecurity().registerSecurityConstraints(this.module.getWebAppBean().getSecurityConstraints());
        this.registerLoginConfig();
        this.jspManager.registerTagLibs(this.module.getWebAppBean().getJspConfigs());
        this.configManager.getLocaleEncodingMap().registerLocaleEncodingMap(this.module.getWebAppBean().getLocaleEncodingMappingLists());
        if (System.getSecurityManager() != null) {
            this.jspManager.registerSecurityPermissionSpec(this.module.getWlWebAppBean());
        }
        if (this.module.getWlWebAppBean() != null) {
            this.registerVirtualDirectoryMappings();
            this.registerAuthFilter();
            this.registerContainerDescriptorsWithSessionContext();
            this.configManager.registerCharsetParams(this.module.getWlWebAppBean());
            if (this.jspManager.isJspPrecompileEnabled()) {
                this.jspManager.precompileJSPs();
            }
        }
    }

    private void activateFromDescriptors() throws DeploymentException {
        if (this.module == null || this.module.getWebAppBean() == null) {
            return;
        }
        this.errorManager.registerErrorPages(this.module.getWebAppBean());
        WeblogicWebAppBean weblogicWebAppBean = this.module.getWlWebAppBean();
        if (weblogicWebAppBean != null) {
            this.configManager.setDispatchPolicy(weblogicWebAppBean.getWlDispatchPolicies().length > 0 ? weblogicWebAppBean.getWlDispatchPolicies()[0] : null);
        }
    }

    private void registerLoginConfig() throws DeploymentException {
        String string;
        LoginConfigBean[] loginConfigBeanArray = this.module.getWebAppBean().getLoginConfigs();
        if (loginConfigBeanArray == null || loginConfigBeanArray.length < 1) {
            return;
        }
        if (loginConfigBeanArray.length > 1) {
            Loggable loggable = HTTPLogger.logMultipleOccurrencesNotAllowedLoggable((String)"<login-config>", (String)"web.xml");
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        try {
            this.getSecurityManager().setLoginConfig(loginConfigBeanArray[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Loggable loggable = HTTPLogger.logInvalidAuthMethodLoggable((String)this.getLogContext(), (String)illegalArgumentException.getMessage());
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        WebAppSecurity webAppSecurity = this.getSecurityManager().getWebAppSecurity();
        if (webAppSecurity != null && "FORM".equals(webAppSecurity.getAuthMethod())) {
            if (webAppSecurity.getLoginPage() == null || webAppSecurity.getLoginPage().length() < 1) {
                Loggable loggable = HTTPLogger.logLoginOrErrorPageMissingLoggable((String)this.getLogContext(), (String)"form-login-page");
                loggable.log();
                throw new DeploymentException(loggable.getMessage());
            }
            if (webAppSecurity.getErrorPage() == null || webAppSecurity.getErrorPage().length() < 1) {
                Loggable loggable = HTTPLogger.logLoginOrErrorPageMissingLoggable((String)this.getLogContext(), (String)"form-error-page");
                loggable.log();
                throw new DeploymentException(loggable.getMessage());
            }
        }
        if ((string = loginConfigBeanArray[0].getRealmName()) != null) {
            this.configManager.setAuthRealmName(string);
            this.securityManager.setAuthRealmName(string);
        }
    }

    private void processAnnotations(boolean bl) throws DeploymentException {
        WebAnnotationProcessor webAnnotationProcessor = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getServletClassLoader());
        try {
            Object object;
            Object object2;
            String string = "weblogic.servlet.internal.WebAnnotationProcessorImpl";
            webAnnotationProcessor = (WebAnnotationProcessor)Class.forName(string).newInstance();
            if (bl) {
                object2 = webAnnotationProcessor.processAnnotationsOnClone((GenericClassLoader)this.getServletClassLoader(), this.getWebAppModule().getWebAppBean(), this.helper);
                if (HTTPDebugLogger.isEnabled()) {
                    System.out.println("------------------------------------------");
                    DescriptorUtils.writeAsXML((DescriptorBean)this.getWebAppModule().getWebAppBean());
                    System.out.println("------------------------------------------");
                    DescriptorUtils.writeAsXML((DescriptorBean)object2);
                    System.out.println("------------------------------------------");
                }
                if ((object = ((DescriptorBean)this.getWebAppModule().getWebAppBean()).getDescriptor().computeDiff(((DescriptorBean)object2).getDescriptor())).size() > 0) {
                    HTTPLogger.logAnnotationsChanged((String)this.getDocroot());
                }
            } else {
                webAnnotationProcessor.processAnnotations((GenericClassLoader)this.getServletClassLoader(), this.getWebAppModule().getWebAppBean(), this.helper);
            }
            object2 = null;
            if (this.getWebAppModule().getWlWebAppBean() != null && this.getWebAppModule().getWlWebAppBean().getComponentFactoryClassName().length > 0) {
                object2 = this.getWebAppModule().getWlWebAppBean().getComponentFactoryClassName()[0];
            }
            if (object2 == null && this.appCtx != null && this.appCtx.getWLApplicationDD() != null) {
                object2 = this.appCtx.getWLApplicationDD().getComponentFactoryClassName();
            }
            object = new PitchforkContext((String)object2);
            this.componentCreator = new WebComponentContributor((PitchforkContext)object);
            this.componentCreator.initialize(this);
        }
        catch (Exception exception) {
            Loggable loggable = HTTPLogger.logAnnotationProcessingFailedLoggable((String)this.getDocroot(), (String)exception.getMessage(), (Throwable)exception);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public WebComponentCreator getComponentCreator() {
        return this.componentCreator;
    }

    private void registerAuthFilter() {
        String string;
        WeblogicWebAppBean weblogicWebAppBean = this.module.getWlWebAppBean();
        String string2 = string = weblogicWebAppBean.getAuthFilters().length > 0 ? weblogicWebAppBean.getAuthFilters()[0] : null;
        if (string != null) {
            this.getSecurityManager().getWebAppSecurity().setAuthFilter(string);
        }
    }

    private void registerVirtualDirectoryMappings() {
        VirtualDirectoryMappingBean[] virtualDirectoryMappingBeanArray = this.module.getWlWebAppBean().getVirtualDirectoryMappings();
        if (virtualDirectoryMappingBeanArray == null || virtualDirectoryMappingBeanArray.length < 1) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < virtualDirectoryMappingBeanArray.length; ++i) {
            Object object;
            String string;
            block9: {
                string = virtualDirectoryMappingBeanArray[i].getLocalPath();
                if (string == null || string.length() < 1) continue;
                if (!WebAppServletContext.isAbsoluteFilePath(string)) {
                    object = new File(this.getDocroot() + FSC + string);
                    if (HTTPDebugLogger.isEnabled()) {
                        HTTPDebugLogger.debug(this.getLogContext() + ":The localPath is :" + string);
                        HTTPDebugLogger.debug(this.getLogContext() + ":docRoot is :" + this.getDocroot());
                    }
                    if (((File)object).exists()) {
                        try {
                            string = ((File)object).getCanonicalPath();
                            arrayList.add(string);
                            break block9;
                        }
                        catch (IOException iOException) {
                            HTTPLogger.logInvalidVirtualDirectoryPath((String)this.getLogContext(), (String)string, (String)this.getDocroot(), (Throwable)iOException);
                            continue;
                        }
                    }
                    if (HTTPDebugLogger.isEnabled()) {
                        HTTPDebugLogger.debug(this.getLogContext() + ": local path is relative to the rootDir." + " It is :" + new File(string));
                    }
                }
            }
            if ((object = virtualDirectoryMappingBeanArray[i].getUrlPatterns()) == null || ((String[])object).length < 1) continue;
            for (int j = 0; j < ((String[])object).length; ++j) {
                if (object[j] == null) continue;
                String string2 = WebAppSecurity.fixupURLPattern((String)object[j]);
                this.war.addVirtualDirectory(string, string2);
            }
        }
        this.war.setVirtualMappingPaths(arrayList);
    }

    private void registerWelcomeFiles() {
        String[] stringArray;
        int n;
        WelcomeFileListBean[] welcomeFileListBeanArray = this.module.getWebAppBean().getWelcomeFileLists();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (welcomeFileListBeanArray != null && welcomeFileListBeanArray.length > 0) {
            for (n = 0; n < welcomeFileListBeanArray.length; ++n) {
                String[] stringArray2 = welcomeFileListBeanArray[n].getWelcomeFiles();
                if (stringArray2 == null) continue;
                for (int i = 0; i < stringArray2.length; ++i) {
                    arrayList.add(stringArray2[i]);
                }
            }
        } else if (this.compMBean != null && (stringArray = this.compMBean.getIndexFiles()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        this.indexFiles = arrayList.toArray(new String[arrayList.size()]);
        if (this.indexFiles != null) {
            for (n = 0; n < this.indexFiles.length; ++n) {
                if (this.indexFiles[n].length() <= 0 || this.indexFiles[n].charAt(0) != '/') continue;
                this.indexFiles[n] = this.indexFiles[n].substring(1);
            }
        }
    }

    private void registerServlets() throws DeploymentException {
        ServletMappingBean[] servletMappingBeanArray;
        ServletBean[] servletBeanArray = this.module.getWebAppBean().getServlets();
        if (servletBeanArray != null) {
            this.registerServlets(servletBeanArray);
        }
        if ((servletMappingBeanArray = this.module.getWebAppBean().getServletMappings()) != null) {
            this.registerServletMapping(servletMappingBeanArray);
        }
    }

    private void registerServlets(ServletBean[] servletBeanArray) throws DeploymentException {
        ServletDescriptorBean[] servletDescriptorBeanArray;
        HashMap<String, ServletDescriptorBean> hashMap = new HashMap<String, ServletDescriptorBean>();
        if (this.module.getWlWebAppBean() != null && (servletDescriptorBeanArray = this.module.getWlWebAppBean().getServletDescriptors()) != null && servletDescriptorBeanArray.length > 0) {
            for (int i = 0; i < servletDescriptorBeanArray.length; ++i) {
                hashMap.put(servletDescriptorBeanArray[i].getServletName(), servletDescriptorBeanArray[i]);
            }
        }
        for (int i = 0; i < servletBeanArray.length; ++i) {
            String string;
            String string2;
            Object object;
            ServletBean servletBean = servletBeanArray[i];
            ParamValueBean[] paramValueBeanArray = servletBean.getInitParams();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            if (paramValueBeanArray != null) {
                for (int j = 0; j < paramValueBeanArray.length; ++j) {
                    object = paramValueBeanArray[j];
                    hashMap2.put(object.getParamName(), object.getParamValue());
                }
            }
            if ((string2 = servletBean.getServletClass()) != null) {
                object = this.registerServletDefinition(servletBean.getServletName(), string2, hashMap2, false);
            } else {
                object = this.jspManager.registerJSPServletDefinition(servletBean, hashMap2);
                this.getSecurityManager().getWebAppSecurity().registerRoleRefs((ServletStubImpl)object);
            }
            this.getSecurityManager().getWebAppSecurity().registerSecurityRoleRef((ServletStubImpl)object, servletBean.getSecurityRoleRefs());
            ServletDescriptorBean servletDescriptorBean = (ServletDescriptorBean)hashMap.get(servletBean.getServletName());
            if (servletDescriptorBean != null) {
                if (servletDescriptorBean.getDispatchPolicy() != null) {
                    ((ServletStubImpl)object).setDispatchPolicy(servletDescriptorBean.getDispatchPolicy());
                }
                ((ServletStubImpl)object).getSecurityHelper().setInitAsIdentity(servletDescriptorBean.getInitAsPrincipalName());
                ((ServletStubImpl)object).getSecurityHelper().setDestroyAsIdentity(servletDescriptorBean.getDestroyAsPrincipalName());
            }
            if (servletBean.getRunAs() != null && (string = servletBean.getRunAs().getRoleName()) != null) {
                ((ServletStubImpl)object).getSecurityHelper().setRunAsIdentity(this.getSecurityManager().getWebAppSecurity().getRunAsPrincipalName(servletDescriptorBean, string));
            }
            int n = -1;
            try {
                n = Integer.parseInt(servletBean.getLoadOnStartup());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.registerServletLoadSequence(servletBean.getServletName(), n);
        }
    }

    private void registerServletMapping(ServletMappingBean[] servletMappingBeanArray) throws DeploymentException {
        JspConfigBean[] jspConfigBeanArray = this.module.getWebAppBean().getJspConfigs();
        Set set = JSPManager.getJspConfigPatterns(jspConfigBeanArray);
        for (int i = 0; i < servletMappingBeanArray.length; ++i) {
            Object object;
            ServletMappingBean servletMappingBean = servletMappingBeanArray[i];
            if (servletMappingBean == null) continue;
            String string = servletMappingBean.getServletName();
            ServletStubImpl servletStubImpl = (ServletStubImpl)this.servletStubs.get((Object)string);
            String[] stringArray = servletMappingBean.getUrlPatterns();
            Debug.assertion((stringArray != null && stringArray.length > 0 ? 1 : 0) != 0, (String)"web-app schema requires atleast one url-pattern");
            if (servletStubImpl == null) {
                object = HTTPLogger.logServletNotFoundForPatternLoggable((String)string, (String)StringUtils.join((String[])stringArray, (String)", "));
                object.log();
                if (!this.configManager.isOldDescriptor()) {
                    throw new DeploymentException(object.getMessage());
                }
                return;
            }
            object = null;
            if (servletStubImpl != null) {
                object = servletStubImpl.getClassName();
            }
            boolean bl = "weblogic.servlet.proxy.HttpClusterServlet".equals(object) || "weblogic.servlet.proxy.HttpProxyServlet".equals(object);
            boolean bl2 = "weblogic.servlet.JSPServlet".equals(object) || "weblogic.servlet.JSPClassServlet".equals(object);
            boolean bl3 = "oracle.jsp.runtimev2.JspServlet".equals(object);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j] != null && stringArray[j].equals("*.jsp") && !bl && !bl3) {
                    HTTPLogger.logFoundStarJspUrlPattern((String)string);
                }
                if (set != null && set.contains(stringArray[j]) && !bl2 && !bl && !bl3) continue;
                this.registerServletMap(string, stringArray[j], servletStubImpl);
            }
        }
    }

    public String getUrlMatchMap() {
        WeblogicWebAppBean weblogicWebAppBean = this.module.getWlWebAppBean();
        if (weblogicWebAppBean == null) {
            return null;
        }
        return weblogicWebAppBean.getUrlMatchMaps().length > 0 ? weblogicWebAppBean.getUrlMatchMaps()[0] : null;
    }

    private void registerURLMatchMapper() {
        String string = this.getUrlMatchMap();
        if (string == null) {
            return;
        }
        URLMapping uRLMapping = URLMappingFactory.createCustomURLMapping(string, this.getServletClassLoader(), WebAppConfigManager.isCaseInsensitive());
        if (uRLMapping == null) {
            return;
        }
        Object[] objectArray = this.servletMapping.values();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                URLMatchHelper uRLMatchHelper = (URLMatchHelper)objectArray[i];
                if (uRLMatchHelper == null) continue;
                uRLMapping.put(uRLMatchHelper.getPattern(), uRLMatchHelper);
            }
        }
        this.servletMapping = uRLMapping;
    }

    private void registerContainerDescriptorsWithSessionContext() {
        WeblogicWebAppBean weblogicWebAppBean = this.module.getWlWebAppBean();
        ContainerDescriptorBean containerDescriptorBean = (ContainerDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getContainerDescriptors(), "ContainerDescriptor");
        if (containerDescriptorBean.isSaveSessionsEnabled()) {
            this.sessionContext.getConfigMgr().setSaveSessionsOnRedeployEnabled(true);
        }
    }

    public void registerFilter(String string, String string2, String[] stringArray, String[] stringArray2, Map map) throws DeploymentException {
        this.filterManager.registerFilter(string, string2, stringArray, stringArray2, map);
    }

    public void registerFilter(String string, String string2, String[] stringArray, String[] stringArray2, Map map, String[] stringArray3) throws DeploymentException {
        this.filterManager.registerFilter(string, string2, stringArray, stringArray2, map, stringArray3);
    }

    public boolean isFilterRegistered(String string) {
        return this.filterManager.isFilterRegistered(string);
    }

    public void registerListener(String string) throws DeploymentException {
        this.eventsManager.registerEventListener(string);
    }

    public boolean isListenerRegistered(String string) {
        return this.eventsManager.isListenerRegistered(string);
    }

    public void registerServlet(String string, String string2, String[] stringArray, Map map, int n) throws DeploymentException {
        ServletStubImpl servletStubImpl = this.registerServletDefinition(string, string2, map, false);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.registerServletMap(string, stringArray[i], servletStubImpl);
            }
        }
        this.registerServletLoadSequence(string, n);
    }

    public boolean isServletRegistered(String string) {
        Object[] objectArray = this.servletMapping.values();
        if (objectArray == null || objectArray.length < 1) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            URLMatchHelper uRLMatchHelper = (URLMatchHelper)objectArray[i];
            if (!uRLMatchHelper.getPattern().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void bindResourceRef(String string, String string2, String string3, String string4, boolean bl, String string5) throws DeploymentException {
        if (!this.isStarted()) {
            throw new DeploymentException("ResourceRef can be NOT bound when the application is NOT started :'" + string + "'");
        }
        this.compEnv.bindResourceRef(string, string2, string3, string4, bl, string5);
    }

    public void bindEjbRef(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws DeploymentException {
        if (!this.isStarted()) {
            throw new DeploymentException("EjbRef can be NOT bound when the application is NOT started :'" + string + "'");
        }
        this.compEnv.bindEjbRef(string, string2, string3, string4, string5, string6, string7, false);
    }

    public void bindEjbLocalRef(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws DeploymentException {
        if (!this.isStarted()) {
            throw new DeploymentException("EjbLocalRef can NOT be bound when the application is NOT started :'" + string + "'");
        }
        this.compEnv.bindEjbRef(string, string2, string3, string4, string5, string6, string7, true);
    }

    public boolean isResourceBound(String string) {
        return this.compEnv.isResourceBound(string);
    }

    public void setJspParam(String string, String string2) throws DeploymentException {
        this.jspManager.setJspParam(string, string2);
    }

    void registerServlet(String string, String string2, String string3, Map map) {
        this.registerServlet(string, string2, string3, map, false);
    }

    private void registerServlet(String string, String string2, String string3, Map map, boolean bl) {
        ServletStubImpl servletStubImpl = (ServletStubImpl)this.servletStubs.get((Object)string);
        if (servletStubImpl == null) {
            servletStubImpl = this.registerServletDefinition(string, string3, map, bl);
        }
        this.registerServletMap(string, string2, servletStubImpl);
    }

    private ServletStubImpl registerServletDefinition(String string, String string2, Map map, boolean bl) {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + ": registering servlet : " + string2 + string + " initArgs: " + (map != null ? map.toString() : ""));
        }
        try {
            ServletStubImpl servletStubImpl = new ServletStubImpl(string, string2, this, map);
            if (this.runtime != null) {
                servletStubImpl.initRuntime();
            }
            servletStubImpl.setInternalServlet(bl);
            this.registerServletStub(string, servletStubImpl);
            this.getSecurityManager().getWebAppSecurity().registerRoleRefs(servletStubImpl);
            return servletStubImpl;
        }
        catch (ManagementException managementException) {
            HTTPLogger.logErrorCreatingServletStub((String)this.getLogContext(), (String)string, (String)string2, (Object)map, (Throwable)managementException);
            return null;
        }
    }

    public synchronized void registerServletMap(String string, String string2) {
        ServletStubImpl servletStubImpl = (ServletStubImpl)this.servletStubs.get((Object)string);
        this.registerServletMap(string, string2, servletStubImpl);
    }

    synchronized void registerServletMap(String string, String string2, ServletStubImpl servletStubImpl) {
        if (string2 == null || string2.length() == 0) {
            Loggable loggable = HTTPLogger.logServletNameIsNullLoggable((String)this.toString(), (String)string2);
            throw new IllegalArgumentException(loggable.getMessage());
        }
        boolean bl = string2.equals("/");
        if ((string2 = WebAppSecurity.fixupURLPattern(string2)).equals("/")) {
            this.defaultURLMatchHelper = new URLMatchHelper(bl ? "/" : "/*", servletStubImpl);
            return;
        }
        if (this.defaultServletName != null && string.equals(this.defaultServletName)) {
            this.defaultURLMatchHelper = new URLMatchHelper("/", servletStubImpl);
        }
        URLMapping uRLMapping = (URLMapping)this.servletMapping.clone();
        URLMatchHelper uRLMatchHelper = new URLMatchHelper(string2, servletStubImpl);
        uRLMapping.put(string2, uRLMatchHelper);
        this.servletMapping = uRLMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void registerServletLoadSequence(String string, int n) throws DeploymentException {
        if (n < 0) {
            return;
        }
        if (this.started || this.startedServletLoadSequences) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = this.pushEnvironment(thread2);
            try {
                this.preloadServlet(string);
            }
            finally {
                WebAppServletContext.popEnvironment(thread2, classLoader);
            }
            return;
        }
        Integer n2 = new Integer(n);
        Object v = this.servletLoadSequences.get(n2);
        if (v == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.servletLoadSequences.put(n2, arrayList);
        } else {
            ArrayList arrayList = (ArrayList)v;
            arrayList.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initContextListeners() throws DeploymentException {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = this.pushEnvironment(thread2);
        try {
            this.eventsManager.registerPreparePhaseListeners();
            this.eventsManager.notifyContextPreparedEvent();
        }
        finally {
            WebAppServletContext.popEnvironment(thread2, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void preloadResources() throws DeploymentException {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = this.pushEnvironment(thread2);
        try {
            this.eventsManager.registerEventListeners();
            this.eventsManager.notifyContextCreatedEvent();
            this.jacImpl.setContextStarted(true);
            this.filterManager.preloadFilters();
            this.loadServletsOnStartup();
        }
        finally {
            WebAppServletContext.popEnvironment(thread2, classLoader);
        }
        if (this.asyncInitServlets.isEmpty()) {
            this.asyncInitsStillRunning = false;
        } else {
            this.asyncInitsStillRunning = true;
            WorkManagerFactory.getInstance().getDefault().schedule((Runnable)new AsyncInitRequest(this.asyncInitServlets));
        }
    }

    public static final Throwable getRootCause(ServletException servletException) {
        Throwable throwable;
        for (int i = 0; servletException.getRootCause() instanceof ServletException && i < 10 && servletException != (throwable = servletException.getRootCause()); ++i) {
            servletException = (ServletException)throwable;
        }
        if (servletException.getRootCause() == null) {
            return servletException;
        }
        return servletException.getRootCause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadServletsOnStartup() throws DeploymentException {
        this.startedServletLoadSequences = true;
        try {
            Collection collection = this.servletLoadSequences.tailMap(new Integer(0)).values();
            for (ArrayList arrayList : collection) {
                for (String string : arrayList) {
                    this.preloadServlet(string);
                }
            }
        }
        finally {
            this.startedServletLoadSequences = false;
        }
    }

    private void preloadServlet(String string) throws DeploymentException {
        ServletStubImpl servletStubImpl = (ServletStubImpl)this.servletStubs.get((Object)string);
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + ": loading servlet on startup: " + string);
        }
        try {
            String string2 = null;
            if (servletStubImpl instanceof JspStub) {
                string2 = ((JspStub)servletStubImpl).getFilePath();
            }
            ContextRequestCallback contextRequestCallback = new ContextRequestCallback(this, string2);
            servletStubImpl.prepareServlet(contextRequestCallback);
        }
        catch (ServletException servletException) {
            Throwable throwable = WebAppServletContext.getRootCause(servletException);
            Loggable loggable = HTTPLogger.logServletFailedToPreloadOnStartupLoggable((String)string, (String)this.contextName, (Throwable)throwable);
            loggable.log();
            if (!(throwable instanceof UnavailableException)) {
                throw new DeploymentException(loggable.getMessage(), throwable);
            }
        }
        catch (Exception exception) {
            Loggable loggable = HTTPLogger.logServletFailedToPreloadOnStartupLoggable((String)string, (String)this.contextName, (Throwable)exception);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), exception);
        }
    }

    public void addAsyncInitServlet(AsyncInitServlet asyncInitServlet) {
        this.asyncInitServlets.add(asyncInitServlet);
    }

    public void addMimeMapping(String string, String string2) {
        this.configManager.addMimeMapping(string, string2);
    }

    public boolean isSSLRequired(String string, String string2) {
        string = HttpParsing.ensureStartingSlash((String)string);
        return this.getSecurityManager().getWebAppSecurity().isSSLRequired(string, string2);
    }

    public ServletStubImpl getServletStub(String string) {
        ServletStubImpl servletStubImpl = null;
        URLMatchHelper uRLMatchHelper = (URLMatchHelper)this.servletMapping.get(string);
        if (uRLMatchHelper != null) {
            servletStubImpl = uRLMatchHelper.getServletStub();
        }
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + ": servlet " + (servletStubImpl == null ? "not found" : "found") + " for the url-pattern: " + string);
        }
        return servletStubImpl;
    }

    synchronized void removeServletStub(ServletStubImpl servletStubImpl, boolean bl) {
        ServletStubImpl servletStubImpl2;
        String string = servletStubImpl.getServletName();
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + ": removing servlet stub with name: " + string);
        }
        if ((servletStubImpl2 = (ServletStubImpl)this.servletStubs.get((Object)string)) != servletStubImpl) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug(this.getLogContext() + ": the stub is different, not destroying it");
            }
            return;
        }
        this.servletStubs.remove((Object)string);
        servletStubImpl.destroy();
        URLMapping uRLMapping = (URLMapping)this.servletMapping.clone();
        Object[] objectArray = uRLMapping.values();
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            URLMatchHelper uRLMatchHelper = (URLMatchHelper)objectArray[i];
            if (!string.equals(uRLMatchHelper.getServletStub().getServletName())) continue;
            if (bl) {
                uRLMapping.put(uRLMatchHelper.getPattern(), new URLMatchHelper(uRLMatchHelper.getPattern(), ServletStubImpl.getUnavailableStub(servletStubImpl)));
                continue;
            }
            uRLMapping.remove(uRLMatchHelper.getPattern());
        }
        this.servletMapping = uRLMapping;
    }

    void registerServletStub(String string, ServletStubImpl servletStubImpl) {
        ServletStubImpl servletStubImpl2 = (ServletStubImpl)this.servletStubs.put((Object)string, (Object)servletStubImpl);
        if (servletStubImpl2 != null) {
            servletStubImpl2.destroy();
        }
    }

    public boolean webflowCheckAccess(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        boolean bl;
        string = HttpParsing.ensureStartingSlash((String)string);
        servletRequestImpl.setAttribute(WEBFLOW_RESOURCE, string);
        try {
            bl = this.securityManager.checkAccess(servletRequestImpl, servletResponseImpl, false);
        }
        catch (ServletException servletException) {
            return false;
        }
        catch (SocketException socketException) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPLogger.logException((String)this.getLogContext(), (Throwable)socketException);
            }
            bl = false;
        }
        catch (IOException iOException) {
            HTTPLogger.logIOException((String)this.getLogContext(), (Throwable)iOException);
            bl = false;
        }
        servletRequestImpl.removeAttribute(WEBFLOW_RESOURCE);
        return bl;
    }

    private String prependContextPath(String string) {
        string = HttpParsing.ensureStartingSlash((String)string);
        if (!this.isDefaultContext()) {
            string = this.getContextPath() + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) throws IOException {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + ": invoking servlet for : " + (Object)((Object)servletRequestImpl));
        }
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = this.pushEnvironment(thread2);
        try {
            if (StringUtils.indexOfIgnoreCase((String)servletRequestImpl.getRelativeUri(), (String)"/WEB-INF") == 0 || StringUtils.indexOfIgnoreCase((String)servletRequestImpl.getRelativeUri(), (String)"/META-INF") == 0) {
                servletResponseImpl.sendError(404);
                return;
            }
            if (servletRequestImpl.getSendRedirect()) {
                servletResponseImpl.sendRedirect(servletResponseImpl.encodeRedirectURL(servletRequestImpl.getRedirectURI()));
                return;
            }
            if (!this.isStarted()) {
                servletResponseImpl.sendError(503);
                return;
            }
            if (servletResponseImpl.getStatus() != 200) {
                servletResponseImpl.sendError(servletResponseImpl.getStatus());
                return;
            }
            ServletStubImpl servletStubImpl = servletRequestImpl.getServletStub();
            if (servletStubImpl == null) {
                servletResponseImpl.sendError(404);
                return;
            }
            if (this.isSuspended()) {
                Loggable loggable = HTTPLogger.logServerSuspendedLoggable((String)this.toString(), (String)ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getServer().getName());
                throw new UnavailableException(loggable.getMessage());
            }
            if (!this.checkPermissionOnPort(servletRequestImpl, servletResponseImpl)) {
                return;
            }
            if (this.asyncInitsStillRunning) {
                servletResponseImpl.sendError(503);
                return;
            }
            this.securedExecute(servletRequestImpl, servletResponseImpl, true);
        }
        catch (JspFileNotFoundException jspFileNotFoundException) {
            servletResponseImpl.sendError(404);
        }
        catch (Throwable throwable) {
            this.handleThrowableFromInvocation(throwable, servletRequestImpl, servletResponseImpl);
        }
        finally {
            WebAppServletContext.popEnvironment(thread2, classLoader);
        }
    }

    private void handleOOME(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError || throwable.getCause() instanceof OutOfMemoryError) {
            HealthMonitorService.panic(throwable);
        }
    }

    public void securedExecute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws Throwable {
        Object object;
        if (!this.securityManager.checkAccess(httpServletRequest, httpServletResponse, bl)) {
            return;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (this.isSuspending() && httpSession == null) {
            Loggable loggable = HTTPLogger.logServerSuspendedLoggable((String)this.toString(), (String)ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getServer().getName());
            throw new UnavailableException(loggable.getMessage());
        }
        if (httpSession != null) {
            int n = ((SessionInternal)httpSession).getConcurrentRequestCount();
            if (maxConcurrentRequestsAllowed != -1 && n > maxConcurrentRequestsAllowed) {
                this.logError("Rejecting request since concurrent requests allowable limit exceeded :" + maxConcurrentRequestsAllowed);
                httpServletResponse.sendError(500);
                return;
            }
        }
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        if (!doNotSendContinueHeader && servletRequestImpl.getInputHelper().getRequestParser().isProtocolVersion_1_1() && this.getSecurityManager().getWebAppSecurity().getAuthMethod() != null && !this.getSecurityManager().getWebAppSecurity().isFormAuth() && !servletRequestImpl.getConnection().isInternalDispatch() && "100-continue".equalsIgnoreCase((String)(object = servletRequestImpl.getRequestHeaders().getExpect()))) {
            servletRequestImpl.send100ContinueResponse();
        }
        if ((object = SecurityModule.getCurrentUser(this.getServer(), httpServletRequest)) == null) {
            object = SubjectUtils.getAnonymousSubject();
        } else {
            servletRequestImpl.getHttpAccountingInfo().setRemoteUser(SubjectUtils.getUsername((AuthenticatedSubject)object));
        }
        ServletInvocationAction servletInvocationAction = new ServletInvocationAction(httpServletRequest, httpServletResponse, servletRequestImpl.getServletStub());
        Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)object, (PrivilegedAction)servletInvocationAction);
        if (throwable != null) {
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleThrowableFromInvocation(Throwable throwable, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) throws IOException {
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block24: {
            block23: {
                bl = _WLDF$INST_FLD_Servlet_Context_Handle_Throwable_Around_High.isEnabledAndNotDyeFiltered();
                diagnosticActionArray = null;
                diagnosticActionStateArray = null;
                Object var11_7 = null;
                if (bl) {
                    Object[] objectArray = null;
                    if (_WLDF$INST_FLD_Servlet_Context_Handle_Throwable_Around_High.isArgumentsCaptureNeeded()) {
                        objectArray = new Object[]{this, throwable, servletRequestImpl, servletResponseImpl};
                    }
                    DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                    DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_Context_Handle_Throwable_Around_High;
                    diagnosticActionArray = delegatingMonitor.getActions();
                    diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                    InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                }
                try {
                    Throwable throwable2;
                    block26: {
                        block29: {
                            Throwable throwable3;
                            block28: {
                                block27: {
                                    block25: {
                                        if (this.isSuspended()) {
                                            servletResponseImpl.sendError(503);
                                            Object var9_11 = null;
                                            if (!bl) return;
                                            break block23;
                                        }
                                        throwable2 = throwable;
                                        if (!(throwable instanceof ServletException)) break block25;
                                        throwable = WebAppServletContext.getRootCause((ServletException)throwable);
                                        this.handleOOME(throwable);
                                        if (this.isSuspending() && throwable instanceof UnavailableException) {
                                            if (HTTPDebugLogger.isEnabled()) {
                                                HTTPLogger.logRootCause((String)WebAppServletContext.addUpRequestInfo(this.httpServer, servletRequestImpl, this.getLogContext()), (Throwable)throwable);
                                            }
                                        } else if (throwable instanceof SocketException) {
                                            if (HTTPDebugLogger.isEnabled()) {
                                                HTTPLogger.logRootCause((String)this.getLogContext(), (Throwable)throwable);
                                            }
                                        } else if (throwable instanceof IOException) {
                                            HTTPLogger.logRootCause((String)WebAppServletContext.addUpRequestInfo(this.httpServer, servletRequestImpl, this.getLogContext()), (Throwable)throwable);
                                        } else {
                                            HTTPLogger.logRootCause((String)WebAppServletContext.addUpRequestInfo(this.httpServer, servletRequestImpl, this.getLogContext()), (Throwable)throwable);
                                        }
                                        servletRequestImpl.setAttribute("javax.servlet.error.exception", (throwable3 = ((ServletException)throwable2).getRootCause()) == null ? throwable2 : throwable3);
                                        break block26;
                                    }
                                    if (!(throwable instanceof SocketException)) break block27;
                                    if (HTTPDebugLogger.isEnabled()) {
                                        HTTPLogger.logException((String)this.getLogContext(), (Throwable)throwable);
                                    }
                                    break block26;
                                }
                                if (!(throwable instanceof IOException)) break block28;
                                HTTPLogger.logIOException((String)this.getLogContext(), (Throwable)throwable);
                                break block26;
                            }
                            if (!(throwable instanceof NestedRuntimeException)) break block29;
                            throwable3 = ((NestedRuntimeException)throwable).getNestedException();
                            if (throwable3 instanceof SocketException) {
                                if (HTTPDebugLogger.isEnabled()) {
                                    HTTPLogger.logException((String)this.getLogContext(), (Throwable)throwable);
                                }
                                break block26;
                            } else if (throwable3 instanceof IOException) {
                                HTTPLogger.logIOException((String)this.getLogContext(), (Throwable)throwable);
                            }
                            break block26;
                        }
                        if (!"Internal Servlet Session Process Error Found!".equals(throwable.getMessage())) {
                            HTTPLogger.logException((String)this.getLogContext(), (Throwable)throwable);
                        }
                    }
                    if (servletResponseImpl.isCommitted()) break block24;
                    try {
                        this.errorManager.handleException(servletRequestImpl, servletResponseImpl, throwable2);
                        break block24;
                    }
                    catch (SocketException socketException) {
                        if (HTTPDebugLogger.isEnabled()) {
                            throw socketException;
                        }
                        break block24;
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                }
                catch (Throwable throwable4) {
                    Object var9_13 = null;
                    if (!bl) throw throwable4;
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Context_Handle_Throwable_Around_High, diagnosticActionArray, diagnosticActionStateArray);
                    throw throwable4;
                }
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Context_Handle_Throwable_Around_High, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
            return;
        }
        Object var9_12 = null;
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Context_Handle_Throwable_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    private boolean checkPermissionOnPort(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) throws IOException {
        if (!servletRequestImpl.getConnection().isInternalDispatch()) {
            ServerChannel serverChannel = servletRequestImpl.getServerChannel();
            ServerChannel serverChannel2 = ServerChannelManager.findLocalServerChannel((Protocol)ProtocolHandlerAdmin.PROTOCOL_ADMIN);
            if (serverChannel2 != null) {
                if (ChannelHelper.isAdminChannel((ServerChannel)serverChannel)) {
                    if (!(this.isInternalApp() || this.isAdminMode() || this.configManager.isRequireAdminTraffic())) {
                        servletResponseImpl.sendError(403, "Operation is not allowed on an administration channel");
                        return false;
                    }
                } else if (!(this.internalUtilitiesWebApp || !this.isInternalApp() && !this.configManager.isRequireAdminTraffic() || this.internalUtilitiesWebSvcs || this.isInternalSAMLApp() || servletRequestImpl.getServletStub().isClasspathServlet())) {
                    servletResponseImpl.sendError(403, "Console/Management requests or requests with &lt;require-admin-traffic&gt; specified to 'true' can only be made through an administration channel");
                    HTTPLogger.logInternalAppWrongPort((String)serverChannel.getPublicAddress(), (int)serverChannel.getPublicPort(), (String)serverChannel.getChannelName(), (String)serverChannel2.getPublicAddress(), (int)serverChannel2.getPublicPort(), (String)serverChannel2.getChannelName(), (String)this.getContextPath());
                    return false;
                }
            }
        }
        return true;
    }

    static boolean isAbsoluteURL(String string) {
        String[] stringArray = StringUtils.split((String)string, (char)':');
        if (stringArray[0] == null || stringArray[1] == null) {
            return false;
        }
        return stringArray[0].equals("mailto") || stringArray[1].startsWith("//");
    }

    static boolean isAbsoluteFilePath(String string) {
        if (WIN_32 && string.length() > 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            return true;
        }
        return string.length() > 0 && string.charAt(0) == FSC;
    }

    ServletStubImpl resolveDirectRequest(ServletRequestImpl servletRequestImpl) {
        String string = servletRequestImpl.getRelativeUri();
        URLMatchHelper uRLMatchHelper = this.resolveRequest(string);
        if (uRLMatchHelper.isDefaultServlet()) {
            servletRequestImpl.setCheckIndexFile(true);
        }
        servletRequestImpl.setServletPathAndPathInfo(string, uRLMatchHelper.getServletPath(string));
        ServletStubImpl servletStubImpl = uRLMatchHelper.getServletStub();
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("Servlet resource: " + servletStubImpl + " is mapped to request: " + servletRequestImpl.toStringSimple());
        }
        return servletStubImpl;
    }

    ServletStubImpl resolveForwardedRequest(ServletRequestImpl servletRequestImpl, ServletRequest servletRequest) {
        ServletStubImpl servletStubImpl;
        String string = servletRequestImpl.getRelativeUri();
        URLMatchHelper uRLMatchHelper = this.resolveRequest(string);
        if (uRLMatchHelper.isDefaultServlet() && (servletStubImpl = this.getIndexServletStub(string, servletRequestImpl, servletRequest)) != null) {
            return servletStubImpl;
        }
        servletRequestImpl.setServletPathAndPathInfo(string, uRLMatchHelper.getServletPath(string));
        return uRLMatchHelper.getServletStub();
    }

    ServletStubImpl resolveIncludedRequest(ServletRequestImpl servletRequestImpl, ServletRequest servletRequest) {
        String string = (String)servletRequest.getAttribute("javax.servlet.include.request_uri");
        if (string != null && !this.isDefaultContext() && string.startsWith(servletRequestImpl.getContext().getContextPath())) {
            string = string.substring(servletRequestImpl.getContext().getContextPath().length());
        }
        URLMatchHelper uRLMatchHelper = this.resolveRequest(string);
        this.setIncludeServletPath(string, servletRequest, uRLMatchHelper.getServletPath(string));
        return uRLMatchHelper.getServletStub();
    }

    private void setIncludeServletPath(String string, ServletRequest servletRequest, String string2) {
        String string3 = ServletRequestImpl.computePathInfo(string, string2);
        servletRequest.setAttribute("javax.servlet.include.servlet_path", (Object)string2);
        servletRequest.setAttribute("javax.servlet.include.path_info", (Object)string3);
    }

    ServletStubImpl getIndexServletStub(String string, ServletRequestImpl servletRequestImpl, ServletRequest servletRequest) {
        String string2 = this.findIndexFile(string);
        if (string2 == null) {
            return null;
        }
        if (this.isDefaultContext() && string.length() == 0 || StringUtils.endsWith((String)string, (char)'/')) {
            servletRequestImpl.initFromRequestURI(this.prependContextPath(string2));
            ServletStubImpl servletStubImpl = this.resolveDirectRequest(servletRequestImpl);
            if (servletStubImpl.getClassName().equals("weblogic.servlet.proxy.HttpProxyServlet") || servletStubImpl.getClassName().equals("weblogic.servlet.proxy.HttpClusterServlet")) {
                servletRequestImpl.initFromRequestURI(this.prependContextPath(string));
                servletStubImpl = this.resolveDirectRequest(servletRequestImpl);
            }
            return servletStubImpl;
        }
        String string3 = servletRequestImpl.getRequestURI();
        int n = string3.indexOf(59);
        StringBuffer stringBuffer = new StringBuffer();
        if (n != -1) {
            stringBuffer.append(HttpParsing.ensureEndingSlash((String)string3.substring(0, n)));
            stringBuffer.append(string3.substring(n));
        } else {
            stringBuffer.append(HttpParsing.ensureEndingSlash((String)string3));
        }
        String string4 = servletRequestImpl.getQueryString();
        if (string4 != null) {
            stringBuffer.append('?').append(string4);
        }
        if (DEBUG_URL_RES.isDebugEnabled()) {
            DEBUG_URL_RES.debug(this.getLogContext() + ": redirecting " + (Object)((Object)servletRequestImpl) + " to :" + stringBuffer.toString());
        }
        servletRequestImpl.setRedirectURI(stringBuffer.toString());
        return null;
    }

    WebAppHelper getHelper() {
        return this.helper;
    }

    private URLMatchHelper resolveRequest(String string) {
        int n;
        URLMatchHelper uRLMatchHelper;
        if (DEBUG_URL_RES.isDebugEnabled()) {
            DEBUG_URL_RES.debug(this.getLogContext() + ": resolving request with relUri: " + string);
        }
        if ((uRLMatchHelper = (URLMatchHelper)this.servletMapping.get(string)) == null && (n = !WebAppConfigManager.isCaseInsensitive() ? string.indexOf(".jws/") : StringUtils.indexOfIgnoreCase((String)string, (String)".jws/")) != -1) {
            String string2 = string.substring(0, n + 4);
            uRLMatchHelper = (URLMatchHelper)this.servletMapping.get(string2);
        }
        if (uRLMatchHelper == null) {
            uRLMatchHelper = this.defaultURLMatchHelper;
        }
        return uRLMatchHelper;
    }

    private String findIndexFile(String string) {
        String[] stringArray = this.indexFiles;
        if (stringArray == null) {
            return null;
        }
        WarSource warSource = this.getResourceAsSource(string = HttpParsing.ensureEndingSlash((String)string));
        if (warSource == null) {
            return null;
        }
        if (warSource.isDirectory()) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = string + stringArray[i];
                WarSource warSource2 = this.getResourceAsSource(string2);
                if (warSource2 != null) {
                    return string2;
                }
                URLMatchHelper uRLMatchHelper = (URLMatchHelper)this.servletMapping.get(string2);
                if (uRLMatchHelper == null || !uRLMatchHelper.isIndexServlet()) continue;
                return string2;
            }
        }
        return null;
    }

    public String getClasspath() {
        return this.war.getClassFinder().getClassPath();
    }

    public String getFullClasspath() {
        TagFileClassLoader tagFileClassLoader = this.getTagFileHelper().getTagFileClassLoader();
        String string = tagFileClassLoader.getClassPath();
        return FilenameEncoder.cleanClasspath((String)string);
    }

    public String getLogContext() {
        if (this.logContext == null) {
            return this.toString();
        }
        return this.logContext;
    }

    public WebAppModule getWebAppModule() {
        return this.module;
    }

    String getModuleName() {
        if (this.compMBean == null) {
            return "webapp";
        }
        return this.compMBean.getName();
    }

    public String getAppName() {
        if (this.appCtx == null) {
            return "";
        }
        AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
        return appDeploymentMBean == null ? "" : appDeploymentMBean.getApplicationName();
    }

    public String getAppDisplayName() {
        if (this.appCtx == null) {
            return "";
        }
        AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
        return appDeploymentMBean == null ? null : ApplicationVersionUtils.getDisplayName(appDeploymentMBean);
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public String getURI() {
        return this.module == null ? null : this.module.getModuleURI();
    }

    public String getId() {
        return this.module == null ? this.contextName : this.module.getId();
    }

    public JspResourceProvider getJspResourceProvider() {
        return this.jspResourceProvider;
    }

    private void setDocroot(String string) throws DeploymentException {
        this.initializeTempDir();
        File file = this.getRootTempDir();
        this.processDocroot(string, file);
    }

    private void mergeLibraryDescriptors() throws DeploymentException {
        if (this.module == null) {
            return;
        }
        if (this.module.getWlWebAppBean() == null && this.libraryManager.getAutoReferencedLibraries().length == 0) {
            return;
        }
        try {
            this.mergeLibraryDescriptors(STANDARD_DD);
            this.mergeLibraryDescriptors(WEBLOGIC_DD);
        }
        catch (Exception exception) {
            Loggable loggable = HTTPLogger.logLibraryDescriptorMergeFailedLoggable((String)this.getDocroot(), (String)exception.getMessage(), (Throwable)exception);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), exception);
        }
    }

    private void mergeLibraryDescriptors(String string) throws IOException, Exception {
        Source[] sourceArray;
        boolean bl = STANDARD_DD.equals(string);
        Enumeration enumeration = this.getResourceFinder("/").getSources("/" + string);
        ArrayList<Source> arrayList = Collections.list(enumeration);
        if (arrayList.size() == 0) {
            return;
        }
        if (arrayList.size() == 1 && bl && this.module.hasWebDescriptorFile()) {
            return;
        }
        if (!this.war.hasExtensions() && (bl && this.module.hasWebDescriptorFile() || !bl)) {
            arrayList.remove(0);
        }
        if ((sourceArray = arrayList.toArray(new Source[0])).length >= 1) {
            this.module.mergeLibraryDescriptors(sourceArray, string);
        }
    }

    private void processWebAppLibraries(File file) throws DeploymentException {
        if (this.module == null) {
            return;
        }
        LibraryRefBean[] libraryRefBeanArray = this.module.getWlWebAppBean() == null ? new LibraryRefBean[]{} : this.module.getWlWebAppBean().getLibraryRefs();
        LibraryReference[] libraryReferenceArray = null;
        try {
            libraryReferenceArray = LibraryReferenceFactory.getWebLibReference(libraryRefBeanArray);
        }
        catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
            throw new DeploymentException(HTTPLogger.logIllegalWebLibSpecVersionRefLoggable((String)this.getLogContext(), (String)illegalSpecVersionTypeException.getSpecVersion()).getMessage());
        }
        this.libraryManager = new LibraryManager(new LibraryReferencer(this.getURI(), this.runtime, "Unresolved Webapp Library references for \"" + this.getLogContext() + "\", " + "defined in weblogic.xml"), libraryReferenceArray);
        this.appCtx.addLibraryManager(this.getId(), this.libraryManager);
        if (this.libraryManager.hasUnresolvedReferences()) {
            throw new DeploymentException("Error: " + this.libraryManager.getUnresolvedReferencesError());
        }
        Library[] libraryArray = this.libraryManager.getReferencedLibraries();
        try {
            for (int i = 0; i < libraryArray.length; ++i) {
                this.war.addLibrary(libraryArray[i], file);
            }
            if (!this.isInternalApp() && !this.isInternalSAMLApp()) {
                this.libraryManager.lookupAndAddAutoReferences(Type.WAR, LibraryConstants.AutoReferrer.WebApp);
                Library[] libraryArray2 = this.libraryManager.getAutoReferencedLibraries();
                for (int i = 0; i < libraryArray2.length; ++i) {
                    this.war.addLibrary(libraryArray2[i], file);
                }
            }
        }
        catch (IOException iOException) {
            Loggable loggable = HTTPLogger.logErrorSettingDocumentRootLoggable((String)this.toString(), (String)this.getDocroot(), (Throwable)iOException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), iOException);
        }
        this.libraryManager.addReferences();
    }

    private void processDocroot(String string, File file) throws DeploymentException {
        try {
            File file2 = WebAppConfigManager.getDocrootFile(string, this);
            this.docroot = file2.getCanonicalPath();
            if (DEBUG_URL_RES.isDebugEnabled()) {
                DEBUG_URL_RES.debug(this.getLogContext() + ": Creating a War() object for '" + this.getURI() + "' ");
            }
            try {
                this.war = new War(this.getURI(), file, this);
            }
            catch (JarFileUtils.PathLengthException pathLengthException) {
                Loggable loggable = HTTPLogger.logExtractionPathTooLongLoggable((String)this.toString(), (String)string, (Throwable)pathLengthException);
                loggable.log();
                throw new DeploymentException(loggable.getMessage(), pathLengthException);
            }
            this.jarFiles = new HashMap();
            this.war.populateJarMap(this.jarFiles);
        }
        catch (IOException iOException) {
            Loggable loggable = HTTPLogger.logErrorSettingDocumentRootLoggable((String)this.toString(), (String)string, (Throwable)iOException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), iOException);
        }
    }

    public File getRootTempDir() {
        return this.rootTempDir;
    }

    public String getTempPath() {
        if (this.tempPath == null) {
            String string = ApplicationVersionUtils.replaceDelimiter(this.getApplicationId(), '_');
            String string2 = ApplicationVersionUtils.replaceDelimiter(this.getName(), '_');
            this.tempPath = PathUtils.generateTempPath(this.getServer().getName(), string, string2);
        }
        return this.tempPath;
    }

    private void initializeTempDir() {
        this.rootTempDir = PathUtils.getAppTempDir(this.getTempPath());
        if (!this.rootTempDir.exists() && !this.rootTempDir.mkdirs()) {
            HTTPLogger.logUnableToMakeDirectory((String)this.getLogContext(), (String)this.rootTempDir.getAbsolutePath());
        }
        File file = null;
        String string = this.configManager.getTempDir();
        file = string == null ? new File(this.rootTempDir, "public") : (WebAppServletContext.isAbsoluteFilePath(string) ? new File(string) : new File(this.rootTempDir, string));
        if (!file.exists() && !file.mkdirs()) {
            HTTPLogger.logUnableToMakeDirectory((String)this.getLogContext(), (String)file.getAbsolutePath());
        }
        this.setAttribute(TEMPDIR_ATTRIBUTE, file);
    }

    public String getDocroot() {
        return this.docroot;
    }

    private void setContextPath(String string) {
        boolean bl = this.defaultContext = string.equals("/") || string.equals("");
        if (this.defaultContext) {
            this.contextPath = "";
        } else {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (string.length() > 2 && string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.contextPath = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void precompileJspsOnUpdate(String string) {
        ((War.ResourceFinder)this.getResourceFinder(this.docroot)).clearCache(string);
        if (this.getJSPManager().createJspConfig().getPageCheckSecs() != -1L) {
            return;
        }
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = this.pushEnvironment(thread2);
        try {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            String string2 = JSPServlet.uri2classname(this.getJSPManager().getJspcPkgPrefix(), string);
            for (ServletStubImpl servletStubImpl : this.servletStubs.values()) {
                JspStub jspStub;
                if (!(servletStubImpl instanceof JspStub) || !(jspStub = (JspStub)servletStubImpl).getClassName().equals(string2)) continue;
                try {
                    ContextRequestCallback contextRequestCallback = new ContextRequestCallback(this, string);
                    jspStub.reloadJSPOnUpdate(contextRequestCallback);
                    break;
                }
                catch (Exception exception) {
                    Loggable loggable = HTTPLogger.logFailureInCompilingJSPLoggable((String)this.getAppName(), (String)this.getModuleName(), (String)string, (Throwable)exception);
                    loggable.log();
                }
            }
        }
        finally {
            WebAppServletContext.popEnvironment(thread2, classLoader);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getName() {
        return this.contextName;
    }

    public String getFullCtxName() {
        return this.fullCtxName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public boolean isAdminMode() {
        return this.adminMode;
    }

    public void setAdminMode(boolean bl) {
        this.adminMode = bl;
    }

    public ApplicationContextInternal getApplicationContext() {
        return this.appCtx;
    }

    public String getApplicationName() {
        String string = this.appCtx.getApplicationId();
        if (string != null) {
            return ApplicationVersionUtils.getApplicationName(string);
        }
        return this.getName();
    }

    public String getApplicationId() {
        String string = this.appCtx.getApplicationId();
        if (string != null) {
            return string;
        }
        return this.getName();
    }

    public String getSecurityRealmName() {
        String string = null;
        if (this.appCtx != null) {
            string = this.appCtx.getApplicationSecurityRealmName();
        }
        if (string == null) {
            return "weblogicDEFAULT";
        }
        return string;
    }

    public Map getJarFiles() {
        return this.jarFiles;
    }

    public War getWarInstance() {
        return this.war;
    }

    public WebAppComponentMBean getMBean() {
        return this.compMBean;
    }

    public WebAppRuntimeMBeanImpl getRuntimeMBean() {
        return this.runtime;
    }

    public synchronized ServletRuntimeMBean[] getServletRuntimeMBeans() {
        ArrayList<ServletRuntimeMBean> arrayList = new ArrayList<ServletRuntimeMBean>();
        for (ServletStubImpl servletStubImpl : this.servletStubs.values()) {
            if (servletStubImpl.getRuntimeMBean() == null) continue;
            arrayList.add(servletStubImpl.getRuntimeMBean());
        }
        return arrayList.toArray(new ServletRuntimeMBean[arrayList.size()]);
    }

    private void initClassLoader(boolean bl) throws DeploymentException {
        Annotation annotation;
        AppDeploymentMBean appDeploymentMBean;
        if (bl && this.classLoader != null) {
            BeanELResolverCachePurger.purgeCache(this.classLoader);
        }
        if (this.module != null) {
            this.module.setClassFinder(this.war.getClassFinder());
            this.classLoader = this.module.getWebClassLoader(bl);
        } else {
            this.classLoader = new GenericClassLoader(this.war.getClassFinder());
            if (this.appCtx != null && this.appCtx.getAppDeploymentMBean() != null) {
                appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
                annotation = new Annotation(appDeploymentMBean.getApplicationIdentifier(), this.getName());
                ((GenericClassLoader)this.classLoader).setAnnotation(annotation);
            }
        }
        if (this.classLoader instanceof ChangeAwareClassLoader) {
            ContainerDescriptorBean containerDescriptorBean;
            appDeploymentMBean = (ChangeAwareClassLoader)this.classLoader;
            appDeploymentMBean.setChildFirst(this.configManager.getPreferWebInfClasses());
            if (this.module != null && (annotation = this.module.getWlWebAppBean()) != null && (containerDescriptorBean = (ContainerDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(annotation, annotation.getContainerDescriptors(), "ContainerDescriptor")) != null && containerDescriptorBean.isPreferWebInfClasses()) {
                this.configManager.setPreferWebInfClasses(true);
                appDeploymentMBean.setChildFirst(this.configManager.getPreferWebInfClasses());
                if (this.appCtx != null && this.appCtx.getAppDeploymentMBean() != null) {
                    try {
                        ClassFinder classFinder = AppFileOverrideUtils.getFinderIfRequired(this.appCtx.getAppDeploymentMBean(), this.appCtx.isEar() ? this.getURI() : null);
                        if (classFinder != null) {
                            appDeploymentMBean.addClassFinderFirst(classFinder);
                        }
                    }
                    catch (ModuleException moduleException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.module != null) {
            try {
                if (bl && this.classLoader != null) {
                    this.module.reloadPersistenceUnitRegistry();
                } else {
                    this.module.setupPersistenceUnitRegistry();
                }
            }
            catch (EnvironmentException environmentException) {
                throw new DeploymentException((Throwable)((Object)environmentException));
            }
            catch (MalformedURLException malformedURLException) {
                throw new DeploymentException(malformedURLException);
            }
        }
        this.tagFileHelper.initClassLoader(this.war.getClassFinder(), this.classLoader);
        if (this.classLoader instanceof GenericClassLoader) {
            SpringInstrumentationUtils.addSpringInstrumentor((GenericClassLoader)((GenericClassLoader)this.classLoader));
        }
    }

    public final ClassLoader getServletClassLoader() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoader reloadServletClassLoader() {
        Object object = this.reloadServletClassLoaderLock;
        synchronized (object) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != this.getServletClassLoader()) {
                return this.classLoader;
            }
            this.eventsManager.notifyContextDestroyedEvent();
            this.attributes.remove(JSF_RI_SUNJSFJS);
            this.jacImpl = new JspApplicationContextImpl(this);
            try {
                this.initClassLoader(true);
            }
            catch (DeploymentException deploymentException) {
                HTTPLogger.logFailedToBounceClassLoader((String)this.getAppDisplayName(), (String)this.getId(), (Throwable)((Object)deploymentException));
            }
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                this.removeTransientAttributes(classLoader);
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.getServletClassLoader());
            }
            try {
                this.processAnnotations(true);
            }
            catch (DeploymentException deploymentException) {
                HTTPLogger.logAnnotationProcessingFailed((String)this.getDocroot(), (String)deploymentException.getMessage(), (Throwable)((Object)deploymentException));
            }
            try {
                this.eventsManager.registerEventListeners();
                this.eventsManager.notifyContextCreatedEvent();
            }
            catch (DeploymentException deploymentException) {
                // empty catch block
            }
            this.jacImpl.setContextStarted(true);
            return this.classLoader;
        }
    }

    public final TagFileHelper getTagFileHelper() {
        return this.tagFileHelper;
    }

    public synchronized void addClassPath(String string) {
        this.war.addClassPath(string);
    }

    public Context getEnvironmentContext() {
        return this.compEnv.getEnvironmentContext();
    }

    public ServletSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    void activate() throws DeploymentException {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + ": activating ...");
        }
        this.activateFromDescriptors();
        this.compEnv.prepare();
        this.compEnv.activate();
        this.sessionContext.initialize(this);
    }

    void start() throws DeploymentException {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + ": starting ...");
        }
        this.preloadResources();
        this.sessionContext.startTimers();
        this.started = true;
    }

    void stop() {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + ": stopping ...");
        }
        this.started = false;
        this.compEnv.cleanup();
    }

    public boolean isStarted() {
        return this.started;
    }

    private boolean isSuspending() {
        return WebAppShutdownService.isSuspending() && !this.isInternalApp();
    }

    private boolean isSuspended() {
        return WebAppShutdownService.isSuspended() && !this.isInternalApp();
    }

    private boolean isServerShutDown() {
        return WebAppShutdownService.isSuspending() || WebAppShutdownService.isSuspended();
    }

    public boolean isInternalApp() {
        return this.internalApp;
    }

    public boolean isInternalSAMLApp() {
        return this.internalSAMLApp;
    }

    public boolean isOnDemandDisplayRefresh() {
        return this.onDemandDisplayRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.isInternalApp() && !this.isServerShutDown()) {
            return;
        }
        this.started = false;
        this.asyncInitsStillRunning = false;
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = this.pushEnvironment(thread2);
        try {
            this.getSessionContext().destroy(this.isServerShutDown());
            this.destroyServlets();
            this.filterManager.destroyFilters();
            this.eventsManager.notifyContextDestroyedEvent();
            BeanELResolverCachePurger.purgeCache(this.classLoader);
        }
        finally {
            WebAppServletContext.popEnvironment(thread2, classLoader);
        }
        try {
            if (this.runtime != null) {
                if (this.libraryManager != null) {
                    this.libraryManager.removeReferences();
                    this.appCtx.removeLibraryManager(this.getId(), this.libraryManager);
                    this.libraryManager = null;
                }
                this.removeAttribute("weblogic.servlet.WebAppComponentRuntimeMBean");
                this.runtime.unregister();
                this.runtime = null;
            }
        }
        catch (ManagementException managementException) {
            HTTPLogger.logErrorUnregisteringWebAppRuntime((ObjectName)this.runtime.getObjectName(), (Throwable)managementException);
        }
        this.war.closeAllFinders();
        this.getSecurityManager().getWebAppSecurity().unregister();
        this.compEnv.destroy();
        this.jspManager.destroy();
        this.tagFileHelper.close();
        this.classLoader = null;
        this.contextManager = null;
    }

    private void destroyServlets() {
        Object object;
        Collection collection = this.servletLoadSequences.tailMap(new Integer(0)).values();
        Object[] objectArray = collection.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            object = (ArrayList)objectArray[i];
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ServletStubImpl servletStubImpl = (ServletStubImpl)this.servletStubs.remove((Object)string);
                if (servletStubImpl == null) continue;
                servletStubImpl.destroy();
            }
        }
        if (!this.servletStubs.isEmpty()) {
            Iterator iterator = this.servletStubs.values().iterator();
            while (iterator.hasNext()) {
                object = (ServletStubImpl)iterator.next();
                iterator.remove();
                ((ServletStubImpl)object).destroy();
            }
        }
        this.servletStubs.clear();
    }

    private void addInitParameter(String string, String string2) {
        this.initParams.put(string, string2);
        if (!string.startsWith(WL_HTTPD)) {
            return;
        }
        String string3 = string.substring(WL_HTTPD.length());
        if (WL_DEFAULTSERVLET.equalsIgnoreCase(string3)) {
            HTTPLogger.logDeprecatedContextParamDefaultServlet();
            this.setDefaultServlet(string2);
        } else if (WL_PROXYCLIENTCERT.equalsIgnoreCase(string3)) {
            HTTPLogger.logDeprecatedContextParam((String)string, (String)"client-cert-proxy-enabled");
            if (string2.equalsIgnoreCase("true")) {
                this.configManager.setClientCertProxyEnabled(true);
            }
        } else if (WL_CLASSPATH.equalsIgnoreCase(string3)) {
            HTTPLogger.logDeprecatedContextParamClasspath();
            this.addClassPath(string2);
        } else if (WL_RELOADCHECKSECS.equalsIgnoreCase(string3)) {
            HTTPLogger.logDeprecatedContextParam((String)string, (String)"servlet-reload-check-secs");
            try {
                this.configManager.setServletReloadCheckSecs(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                HTTPLogger.logReloadCheckSecondsError((String)this.getLogContext(), (String)WL_HTTPD, (String)WL_RELOADCHECKSECS, (Throwable)numberFormatException);
            }
        } else if (WL_INPUTCHARSET.regionMatches(true, 0, string3, 0, 12)) {
            HTTPLogger.logDeprecatedContextParam((String)string, (String)"charset-params");
            this.configManager.addInputEncoding(string3.substring(13), string2);
        }
    }

    public boolean isResourceStale(String string, long l, String string2, String string3) {
        Object object;
        if (HTTPDebugLogger.isEnabled()) {
            object = HTTPLogger.logCompareVersionLoggable((String)this.getLogContext(), (String)string2, (String)version.getReleaseBuildVersion());
            HTTPDebugLogger.debug(object.getMessage());
        }
        if (!NO_VERSION_CHECK && !version.getReleaseBuildVersion().equals(string2)) {
            HTTPLogger.logServerVersionMismatchForJSPisStale((String)this.getLogContext(), (String)string, (String)string2, (String)version.getReleaseBuildVersion());
            return true;
        }
        if (this.jspManager.getPageCheckSeconds() < 0) {
            return false;
        }
        if (this.jspManager.getResourceProviderClass() != null) {
            if (this.jspResourceProvider == null) {
                return true;
            }
            try {
                return l < this.jspResourceProvider.getLastModified(string);
            }
            catch (Exception exception) {
                return true;
            }
        }
        object = this.getResourceAsSource(string, true);
        if (object == null) {
            return true;
        }
        if (!(((WarSource)object).isFromArchive() || !((WarSource)object).isFromLibrary() && this.isArchived)) {
            if (!this.jspManager.isStrictStaleCheck()) {
                return l != ((WarSource)object).lastModified() + 2000L;
            }
            return l < ((WarSource)object).lastModified();
        }
        if (WebAppServletContext.isResourceTimeStale((Source)object, l, string3)) {
            HTTPLogger.logJSPisStale((String)this.getLogContext(), (String)string);
            return true;
        }
        return false;
    }

    public static boolean isResourceTimeStale(Source source, long l, String string) {
        String string2;
        if (source == null) {
            return true;
        }
        long l2 = source.lastModified();
        if (string != null && !string.equals(string2 = TimeZone.getDefault().getID())) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone(string));
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone(string2));
            gregorianCalendar.setTime(new Date(l2));
            gregorianCalendar2.setTime(new Date(l2));
            long l3 = gregorianCalendar.get(15) + gregorianCalendar.get(16);
            long l4 = gregorianCalendar2.get(15) + gregorianCalendar2.get(16);
            l2 -= l3 - l4;
        }
        return l < l2;
    }

    public ClassFinder getResourceFinder(String string) {
        return this.war.getResourceFinder(string);
    }

    public WarSource getResourceAsSource(String string) {
        return this.getResourceAsSource(string, false);
    }

    private WarSource getResourceAsSource(String string, boolean bl) {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(this.getLogContext() + " getResourceAsSource() invoked for : " + string);
        }
        WarSource warSource = this.war.getResourceAsSource(string, bl);
        if ((HTTPDebugLogger.isEnabled() || DEBUG_URL_RES.isDebugEnabled()) && warSource == null) {
            DEBUG_URL_RES.debug(this.getLogContext() + ": getResourceAsSource() couldn't find source for : " + string);
        }
        return warSource;
    }

    public WarSource getResourceAsSourceWithMDS(String string) {
        if (this.mdsFinder != null) {
            Source source = this.mdsFinder.getSource(string);
            if (source == null) {
                if (HTTPDebugLogger.isEnabled() || DEBUG_URL_RES.isDebugEnabled()) {
                    DEBUG_URL_RES.debug(this.getLogContext() + ": getResourceAsSourceWithMDS() couldn't find source for : " + string);
                }
                return null;
            }
            return new WarSource(source);
        }
        return this.getResourceAsSource(string);
    }

    void setDefaultContext() {
        ContextVersionManager contextVersionManager = this.getContextManager();
        if (contextVersionManager != null) {
            contextVersionManager.setDefaultContext();
        }
        this.setContextPath("");
    }

    boolean isDefaultContext() {
        return this.defaultContext;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ServletContext@");
        stringBuffer.append(super.hashCode()).append("[").append("app:").append(this.getAppName()).append(" module:").append(this.getName()).append(" path:").append(this.getContextPath());
        if (this.module != null && this.module.getWebAppBean() != null) {
            stringBuffer.append(" spec-version:").append(this.module.getWebAppBean().getVersion());
        }
        if (this.getVersionId() != null) {
            stringBuffer.append(" version:").append(this.getVersionId());
        }
        return stringBuffer.append("]").toString();
    }

    public final ClassLoader pushEnvironment(Thread thread2) {
        Context context = this.getEnvironmentContext();
        javaURLContextFactory.pushContext(context);
        ClassLoader classLoader = thread2.getContextClassLoader();
        thread2.setContextClassLoader(this.getServletClassLoader());
        return classLoader;
    }

    public static final void popEnvironment(Thread thread2, ClassLoader classLoader) {
        javaURLContextFactory.popContext();
        thread2.setContextClassLoader(classLoader);
    }

    public Object getWebservicesDD() {
        return this.webservicesDD;
    }

    public void setWebservicesDD(Object object) {
        this.webservicesDD = object;
    }

    public void swapServlet(String string, String string2, Map hashMap) throws ServletException {
        ServletStubImpl servletStubImpl = (ServletStubImpl)this.servletStubs.get((Object)string);
        if (servletStubImpl != null) {
            Map map;
            this.servletStubs.remove((Object)string);
            servletStubImpl.destroy();
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            if ((map = servletStubImpl.getInitParametersMap()) != null) {
                hashMap.putAll(map);
            }
        } else {
            throw new ServletException("There is no sevlet \"" + string + "\"" + " defined for web service.");
        }
        ServletStubImpl servletStubImpl2 = this.registerServletDefinition(string, string2, hashMap, false);
        this.swapServletStubs(servletStubImpl, servletStubImpl2);
    }

    private void swapServletStubs(ServletStubImpl servletStubImpl, ServletStubImpl servletStubImpl2) throws ServletException {
        Object object;
        Object[] objectArray;
        if (this.defaultURLMatchHelper != null && this.defaultURLMatchHelper.getServletStub() == servletStubImpl) {
            this.defaultURLMatchHelper = new URLMatchHelper(this.defaultURLMatchHelper.getPattern(), servletStubImpl2);
        }
        if ((objectArray = this.servletMapping.values()) == null || objectArray.length < 1) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            object = (URLMatchHelper)objectArray[i];
            if (((URLMatchHelper)object).getServletStub() != servletStubImpl) continue;
            this.servletMapping.put(((URLMatchHelper)object).getPattern(), new URLMatchHelper(((URLMatchHelper)object).getPattern(), servletStubImpl2));
        }
        StubSecurityHelper stubSecurityHelper = servletStubImpl.getSecurityHelper();
        object = servletStubImpl2.getSecurityHelper();
        try {
            ((StubSecurityHelper)object).setRunAsIdentity(stubSecurityHelper.getRunAsIdentity());
        }
        catch (DeploymentException deploymentException) {
            throw new ServletException((Throwable)((Object)deploymentException));
        }
        Iterator iterator = stubSecurityHelper.getRoleNames();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ((StubSecurityHelper)object).addRoleLink(string, stubSecurityHelper.getRoleLink(string));
            }
        }
    }

    private void initResourceProvider() throws DeploymentException {
        String string = this.jspManager.getResourceProviderClass();
        if (string != null) {
            try {
                Class<?> clazz = this.classLoader.loadClass(string);
                this.jspResourceProvider = (JspResourceProvider)clazz.newInstance();
                this.jspResourceProvider.init(null, this.getContextPath(), "/", (ServletContext)this, null, null);
                this.mdsFinder = new MDSClassFinder(this.jspResourceProvider);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new DeploymentException("Couldn't load jsp resource provider class: " + string);
            }
            catch (InstantiationException instantiationException) {
                throw new DeploymentException("Couldn't instantiate jsp resource provider class: " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DeploymentException("Couldn't instantiate jsp resource provider class: " + string);
            }
        }
    }

    URLMapping getServletMapping() {
        return this.servletMapping;
    }

    public EventsManager getEventsManager() {
        return this.eventsManager;
    }

    public WebAppConfigManager getConfigManager() {
        return this.configManager;
    }

    public JSPManager getJSPManager() {
        return this.jspManager;
    }

    public ErrorManager getErrorManager() {
        return this.errorManager;
    }

    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    public void dump(PrintStream printStream) {
        WebAppServletContext.println(printStream, "==================== Internal Context Information ==================");
        WebAppServletContext.println(printStream, "contextName: " + this.getName());
        WebAppServletContext.println(printStream, "contextPath: " + this.getContextPath());
        WebAppServletContext.println(printStream, "classpath: " + this.getClasspath());
        WebAppServletContext.println(printStream, "defaultServletName: " + this.defaultServletName);
        WebAppServletContext.println(printStream, "indexFiles: " + this.indexFiles);
        WebAppServletContext.println(printStream, "docroot: " + this.docroot);
        WebAppServletContext.println(printStream, "isArchived: " + this.isArchived);
        WebAppServletContext.println(printStream, "reloadCheckSeconds: " + this.configManager.getServletReloadCheckSecs());
        WebAppServletContext.println(printStream, "classLoader: " + this.getServletClassLoader());
        WebAppServletContext.println(printStream, "environmentCtx: " + this.getEnvironmentContext());
        WebAppServletContext.println(printStream, "statusErrors: " + this.errorManager.getStatusErrors());
        WebAppServletContext.println(printStream, "attributes: " + this.attributes);
        WebAppServletContext.println(printStream, "taglibs: " + this.jspManager.getTagLibs());
        WebAppServletContext.println(printStream, "defaultMimeType: " + this.configManager.getDefaultMimeType());
        WebAppServletContext.println(printStream, "initParams: " + this.initParams);
        WebAppServletContext.println(printStream, "classFinder: " + this.war.getClassFinder());
        WebAppServletContext.println(printStream, "httpServer.isDebugHttp: " + HTTPDebugLogger.isEnabled());
        WebAppServletContext.println(printStream, "caseSensitive: " + !WebAppConfigManager.isCaseInsensitive());
        WebAppServletContext.println(printStream, "servletStubs: " + this.servletStubs);
        WebAppServletContext.println(printStream, "servletMapping: " + this.servletMapping);
        WebAppServletContext.println(printStream, "authRealmName: " + this.configManager.getAuthRealmName());
        WebAppServletContext.println(printStream, "securityManager: " + this.getSecurityManager());
        WebAppServletContext.println(printStream, "webAppSecurity: " + this.getSecurityManager().getWebAppSecurity());
        WebAppServletContext.println(printStream, "exceptionMap: " + this.errorManager.getStatusErrors());
    }

    private static void println(PrintStream printStream, String string) {
        printStream.println(string + "<br>");
    }

    private static final String addUpRequestInfo(HttpServer httpServer, ServletRequestImpl servletRequestImpl, String string) {
        if (httpServer.isProductionModeEnabled()) {
            return string;
        }
        return string + ", request: " + (Object)((Object)servletRequestImpl);
    }

    public static void enableWLDFDyeInjection(Boolean bl) throws Exception {
        if (bl.booleanValue()) {
            Class<?> clazz = Class.forName("weblogic.diagnostics.instrumentation.support.DyeInjectionMonitorSupport");
            Class[] classArray = new Class[]{Object.class};
            wldfDyeInjectionMethod = clazz.getMethod("dyeWebAppRequest", classArray);
        } else {
            wldfDyeInjectionMethod = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSession(HttpSession httpSession) {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = this.pushEnvironment(thread2);
        try {
            httpSession.invalidate();
        }
        finally {
            WebAppServletContext.popEnvironment(thread2, classLoader);
        }
    }

    void removeTransientAttributes(ClassLoader classLoader) {
        this.attributes.removeTransientAttributes(classLoader, this);
    }

    public HttpServletRequest cloneRequest(HttpServletRequest httpServletRequest) {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        return servletRequestImpl == null ? null : servletRequestImpl.copy();
    }

    public JspApplicationContext getJspApplicationContext() {
        return this.jacImpl;
    }

    boolean isJsfApplication() {
        return this.isJsfApplication;
    }

    public EnvironmentBuilder getEnvironmentBuilder() {
        return this.compEnv.getEnvironmentBuilder();
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.servlet.internal.WebAppServletContext");
        _WLDF$INST_FLD_Servlet_Context_Handle_Throwable_Around_High = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_Context_Handle_Throwable_Around_High");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WebAppServletContext.java", (String)"weblogic.servlet.internal.WebAppServletContext", (String)"handleThrowableFromInvocation", (String)"(Ljava/lang/Throwable;Lweblogic/servlet/internal/ServletRequestImpl;Lweblogic/servlet/internal/ServletResponseImpl;)V", (int)2286, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_Context_Handle_Throwable_Around_High"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{null, InstrumentationSupport.createValueHandlingInfo((String)"req", (String)"weblogic.diagnostics.instrumentation.gathering.ServletRequestRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        WIN_32 = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
        NO_VERSION_CHECK = Boolean.getBoolean("weblogic.jspc.skipVersionCheck");
        FSC = File.separatorChar;
        NON_BLOCKING_DISPATCH = new HashMap();
        DIRECT_DISPATCH = new HashMap();
        NON_BLOCKING_DISPATCH.put("wl-dispatch-policy", "weblogic.kernel.Non-Blocking");
        DIRECT_DISPATCH.put("wl-dispatch-policy", "direct");
        DEBUG_URL_RES = DebugLogger.getDebugLogger((String)"DebugURLResolution");
        wldfDyeInjectionMethod = null;
        maxConcurrentRequestsAllowed = -1;
        mergeDescriptors = true;
        doNotSendContinueHeader = false;
        doNotSendContinueHeader = Boolean.getBoolean("doNotSendContinueHeader");
        String string = System.getProperty("weblogic.http.session.maxConcurrentRequest");
        String string2 = System.getProperty("weblogic.http.descriptor.merge");
        try {
            if (string != null) {
                maxConcurrentRequestsAllowed = Integer.parseInt(string);
            }
            if (maxConcurrentRequestsAllowed < 1) {
                maxConcurrentRequestsAllowed = -1;
            }
            if (string2 != null && "false".equalsIgnoreCase(string2)) {
                mergeDescriptors = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServletContextWebAppHelper
    implements WebAppHelper {
        private static final String JSF_CONFIG_FILES = "javax.faces.CONFIG_FILES";
        private List annotatedClasses = null;
        private Set managedBeans = Collections.EMPTY_SET;

        @Override
        public Set getTagListeners(boolean bl) {
            return WebAppServletContext.this.war.getTagClasses(bl, "listener-class");
        }

        @Override
        public Set getTagHandlers(boolean bl) {
            return WebAppServletContext.this.war.getTagClasses(bl, "tag-class");
        }

        @Override
        public Set getManagedBeanClasses() {
            if (this.managedBeans == Collections.EMPTY_SET && WebAppServletContext.this.isJsfApplication()) {
                String string = WebAppServletContext.this.getInitParameter(JSF_CONFIG_FILES);
                this.managedBeans = WebAppServletContext.this.war.getFacesManagedBeans(string, WebAppServletContext.this.rootTempDir);
            }
            return this.managedBeans;
        }

        @Override
        public Set getManagedBeanClasses(Set<String> set) {
            this.managedBeans = this.getManagedBeanClasses();
            if (this.managedBeans == Collections.EMPTY_SET) {
                this.managedBeans = new HashSet();
            }
            this.managedBeans.addAll(set);
            return this.managedBeans;
        }

        @Override
        public List getAnnotatedClasses(WebAnnotationProcessor webAnnotationProcessor) {
            if (this.annotatedClasses == null) {
                this.annotatedClasses = WebAppServletContext.this.war.getAnnotatedClasses(webAnnotationProcessor);
            }
            return this.annotatedClasses;
        }
    }

    private final class ServletInvocationAction
    implements PrivilegedAction {
        private final HttpServletRequest req;
        private final HttpServletResponse rsp;
        private final ServletStubImpl stub;
        static final long serialVersionUID = 6236264500641467779L;
        public static final String _WLDF$INST_VERSION = "9.0.0";
        static /* synthetic */ Class _WLDF$INST_FLD_class;
        public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_Invocation_Around_Low;
        public static final JoinPoint _WLDF$INST_JPFLD_0;

        ServletInvocationAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletStubImpl servletStubImpl) {
            this.req = httpServletRequest;
            this.rsp = httpServletResponse;
            this.stub = servletStubImpl;
        }

        public Object run() {
            return this.wrapRun(this.stub, this.req, this.rsp);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object wrapRun(ServletStubImpl servletStubImpl, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            boolean bl = _WLDF$INST_FLD_Servlet_Invocation_Around_Low.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var12_7 = null;
            if (bl) {
                Object[] objectArray = null;
                if (_WLDF$INST_FLD_Servlet_Invocation_Around_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this, servletStubImpl, httpServletRequest, httpServletResponse};
                }
                DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_Invocation_Around_Low;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            try {
                try {
                    Object object;
                    WebAppServletContext.this.httpServer.getWorkContextManager().initOrRestoreThreadContexts(WebAppServletContext.this, ServletRequestImpl.getOriginalRequest((ServletRequest)this.req));
                    if (wldfDyeInjectionMethod != null) {
                        try {
                            object = new Object[]{this.req};
                            wldfDyeInjectionMethod.invoke(null, (Object[])object);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (WebAppServletContext.this.getFilterManager().hasFilters() || WebAppServletContext.this.eventsManager.hasRequestListeners()) {
                        object = WebAppServletContext.this.getFilterManager().getFilterChain(this.stub, (ServletRequest)this.req, (ServletResponse)this.rsp, WebAppServletContext.this.eventsManager.hasRequestListeners(), 0);
                        if (object == null) {
                            this.stub.execute((ServletRequest)this.req, (ServletResponse)this.rsp);
                        } else {
                            ((FilterChainImpl)object).doFilter((ServletRequest)this.req, (ServletResponse)this.rsp);
                        }
                    } else {
                        this.stub.execute((ServletRequest)this.req, (ServletResponse)this.rsp);
                    }
                }
                catch (UnavailableException unavailableException) {
                    try {
                        if (unavailableException.isPermanent()) {
                            this.rsp.sendError(404);
                        } else {
                            long l = System.currentTimeMillis() + (long)(unavailableException.getUnavailableSeconds() * 1000);
                            this.rsp.addHeader("Retry-After", new Date(l).toString());
                            this.rsp.sendError(503);
                        }
                    }
                    catch (IOException iOException) {
                        Object var10_17 = null;
                        if (!bl) return iOException;
                        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Invocation_Around_Low, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                        return iOException;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_18 = null;
                    if (!bl) return throwable;
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Invocation_Around_Low, diagnosticActionArray, diagnosticActionStateArray);
                    return throwable;
                }
                Object var10_19 = null;
                if (!bl) return null;
            }
            catch (Throwable throwable) {
                Object var10_20 = null;
                if (!bl) throw throwable;
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Invocation_Around_Low, diagnosticActionArray, diagnosticActionStateArray);
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Invocation_Around_Low, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            return null;
        }

        static {
            _WLDF$INST_FLD_class = Class.forName("weblogic.servlet.internal.WebAppServletContext$ServletInvocationAction");
            _WLDF$INST_FLD_Servlet_Invocation_Around_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_Invocation_Around_Low");
            _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WebAppServletContext.java", (String)"weblogic.servlet.internal.WebAppServletContext$ServletInvocationAction", (String)"wrapRun", (String)"(Lweblogic/servlet/internal/ServletStubImpl;Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)Ljava/lang/Object;", (int)3702, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_Invocation_Around_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"stub", (String)"weblogic.diagnostics.instrumentation.gathering.ServletStubImplRenderer", (boolean)false, (boolean)true), InstrumentationSupport.createValueHandlingInfo((String)"req", (String)"weblogic.diagnostics.instrumentation.gathering.ServletRequestRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        }
    }

    private static final class ContextRequestCallback
    implements RequestCallback {
        private final String uri;
        private final WebAppServletContext ctx;

        ContextRequestCallback(WebAppServletContext webAppServletContext, String string) {
            this.ctx = webAppServletContext;
            this.uri = string;
        }

        public final String getIncludeURI() {
            return this.uri;
        }

        public final void reportJSPTranslationFailure(String string, String string2) {
            this.ctx.logError(string);
        }

        public final void reportJSPCompilationFailure(String string, String string2) {
            this.ctx.logError(string);
        }
    }

    private class AsyncInitRequest
    implements Runnable {
        private final List asyncInitServlets;

        AsyncInitRequest(List list) {
            this.asyncInitServlets = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = WebAppServletContext.this.pushEnvironment(thread2);
            try {
                for (AsyncInitServlet asyncInitServlet : this.asyncInitServlets) {
                    try {
                        asyncInitServlet.initDelegate();
                    }
                    catch (ServletException servletException) {
                        if (!WebAppServletContext.this.asyncInitsStillRunning) {
                            WebAppServletContext.popEnvironment(thread2, classLoader);
                            WebAppServletContext.this.asyncInitsStillRunning = false;
                            this.asyncInitServlets.clear();
                            return;
                        }
                        try {
                            HTTPLogger.logAsyncInitFailed((String)asyncInitServlet.getClass().getName(), (Throwable)(servletException.getRootCause() != null ? servletException.getRootCause() : servletException));
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                WebAppServletContext.popEnvironment(thread2, classLoader);
                WebAppServletContext.this.asyncInitsStillRunning = false;
                this.asyncInitServlets.clear();
            }
        }
    }
}

