/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.Collection;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.WebService;
import weblogic.servlet.internal.session.GracefulShutdownHelper;

public class WebAppShutdownService
extends AbstractServerService {
    private static boolean isSuspending;
    private static boolean isSuspended;
    private static boolean ignoreSessions;

    public static void ignoreSessionsDuringShutdown() {
        ignoreSessions = true;
    }

    static boolean isSuspending() {
        return isSuspending;
    }

    static boolean isSuspended() {
        return isSuspended;
    }

    public void start() throws ServiceFailureException {
        isSuspending = false;
        isSuspended = false;
        ignoreSessions = false;
    }

    public void stop() throws ServiceFailureException {
        isSuspending = true;
        if (!ignoreSessions) {
            GracefulShutdownHelper.waitForPendingSessions();
        }
        this.halt();
    }

    public void halt() {
        Collection collection = WebService.getHttpServers();
        for (HttpServer httpServer : collection) {
            httpServer.shutdown();
        }
        isSuspended = true;
    }
}

