/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.List;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebComponentBeanUpdateListener
implements BeanUpdateListener {
    private PersistenceUnitRegistry persistenceUnitRegistry;

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        block5: for (BeanUpdateEvent.PropertyUpdate propertyUpdate : propertyUpdateArray) {
            switch (propertyUpdate.getUpdateType()) {
                case 2: {
                    Object object = propertyUpdate.getAddedObject();
                    if (object instanceof DescriptorBean) {
                        this.handleBeanAdd(propertyUpdate, (DescriptorBean)object);
                        continue block5;
                    }
                    this.handlePropertyAdd(propertyUpdate, descriptorBean);
                    continue block5;
                }
                case 1: {
                    this.handlePropertyChange(propertyUpdate, descriptorBean);
                    continue block5;
                }
                case 3: {
                    Object object = propertyUpdate.getRemovedObject();
                    if (object instanceof DescriptorBean) {
                        this.handleBeanRemove(propertyUpdate);
                        continue block5;
                    }
                    this.handlePropertyRemove(propertyUpdate);
                    continue block5;
                }
            }
        }
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray;
        block3: for (BeanUpdateEvent.PropertyUpdate propertyUpdate : propertyUpdateArray = beanUpdateEvent.getUpdateList()) {
            switch (propertyUpdate.getUpdateType()) {
                case 2: {
                    Object object = propertyUpdate.getAddedObject();
                    if (!(object instanceof DescriptorBean)) continue block3;
                    this.prepareBeanAdd(propertyUpdate, (DescriptorBean)object);
                    continue block3;
                }
            }
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    protected abstract void prepareBeanAdd(BeanUpdateEvent.PropertyUpdate var1, DescriptorBean var2) throws BeanUpdateRejectedException;

    protected void handlePropertyAdd(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) {
        this.handlePropertyChange(propertyUpdate, descriptorBean);
    }

    protected abstract void handlePropertyChange(BeanUpdateEvent.PropertyUpdate var1, DescriptorBean var2);

    protected abstract void handlePropertyRemove(BeanUpdateEvent.PropertyUpdate var1);

    protected abstract void handleBeanAdd(BeanUpdateEvent.PropertyUpdate var1, DescriptorBean var2);

    protected abstract void handleBeanRemove(BeanUpdateEvent.PropertyUpdate var1);

    protected static boolean computeChange(String string, boolean bl, boolean bl2, List<String> list) {
        boolean bl3;
        boolean bl4 = bl3 = bl2 != bl;
        if (bl3) {
            list.add(string);
        }
        return bl3;
    }

    protected static boolean computeChange(String string, int n, int n2, List<String> list) {
        boolean bl;
        boolean bl2 = bl = n2 != n;
        if (bl) {
            list.add(string);
        }
        return bl;
    }

    protected static boolean computeChange(String string, Object object, Object object2, List<String> list) {
        boolean bl;
        boolean bl2 = bl = object2 == null && object != null || object2 != null && !object2.equals(object);
        if (bl) {
            list.add(string);
        }
        return bl;
    }

    protected static String getChangedPropertyNames(List<String> list) {
        if (list == null && list.isEmpty()) {
            return "No change is found.";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(list.get(i));
        }
        return stringBuilder.toString();
    }
}

