/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import com.oracle.pitchfork.interfaces.WebComponentContributorBroker;
import com.oracle.pitchfork.interfaces.inject.ComponentContributor;
import com.oracle.pitchfork.interfaces.inject.DeploymentUnitMetadataI;
import com.oracle.pitchfork.interfaces.inject.EnricherI;
import com.oracle.pitchfork.interfaces.inject.Jsr250MetadataI;
import com.oracle.pitchfork.interfaces.inject.LifecycleEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.j2ee.descriptor.J2eeEnvironmentBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.injection.J2eeComponentContributor;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.management.DeploymentException;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebComponentCreator;
import weblogic.servlet.utils.WarUtils;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebComponentContributor
extends J2eeComponentContributor
implements WebComponentCreator {
    public static final String SPRING_WEB_XML_LOCATION = "/META-INF/spring-web.xml";
    private static final DebugLogger diLogger = DebugLogger.getDebugLogger((String)"DebugWebAppDI");
    private WebAppBean webBean;
    private WebAppServletContext context;
    private boolean useDI = true;
    private ConcurrentHashMap<String, Jsr250MetadataI> diClasses = new ConcurrentHashMap();
    private boolean usesSpringExtensionModel = false;
    private WebComponentContributorBroker webCompContributorBroker;

    public WebComponentContributor(PitchforkContext pitchforkContext) {
        super(pitchforkContext);
        this.webCompContributorBroker = pitchforkContext.getPitchforkUtils().createWebComponentContributorBroker();
    }

    @Override
    public void initialize(WebAppServletContext webAppServletContext) throws DeploymentException {
        this.context = webAppServletContext;
        this.webBean = webAppServletContext.getWebAppModule().getWebAppBean();
        this.useDI = WarUtils.isDIEnabled(this.webBean);
        if (!this.useDI) {
            WebComponentContributor.dbg("Dependency injection is turned OFF for " + webAppServletContext);
            return;
        }
        this.checkDuplicatedCallback(this.webBean.getPostConstructs(), LifecycleEvent.POST_CONSTRUCT);
        this.checkDuplicatedCallback(this.webBean.getPreDestroys(), LifecycleEvent.PRE_DESTROY);
        String string = null;
        if (webAppServletContext.getWebAppModule().getWlWebAppBean() != null && webAppServletContext.getWebAppModule().getWlWebAppBean().getComponentFactoryClassName().length > 0) {
            string = webAppServletContext.getWebAppModule().getWlWebAppBean().getComponentFactoryClassName()[0];
        }
        this.usesSpringExtensionModel = this.pitchforkContext.isSpringComponentFactoryClassName();
        try {
            this.webCompContributorBroker.initialize(this.context.getServletClassLoader(), SPRING_WEB_XML_LOCATION, PitchforkContext.getComponentFactoryClassName(string), this.usesSpringExtensionModel, (ComponentContributor)this);
        }
        catch (Throwable throwable) {
            diLogger.debug("Exception when creating spring bean factory" + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            throw new DeploymentException(throwable);
        }
    }

    @Override
    protected void contribute(Jsr250MetadataI jsr250MetadataI, J2eeEnvironmentBean j2eeEnvironmentBean) {
    }

    public Jsr250MetadataI getMetadata(String string) {
        throw new AssertionError("This method is not supported!");
    }

    static void dbg(String string) {
        if (diLogger.isDebugEnabled()) {
            diLogger.debug(string);
        }
    }

    public void contribute(EnricherI enricherI) {
        String string;
        Debug.assertion((this.context != null ? 1 : 0) != 0, (String)"not initialized");
        if (!this.useDI) {
            return;
        }
        Set set = super.getInjectableTargetClasses((J2eeEnvironmentBean)this.webBean);
        List<String> list = Arrays.asList(enricherI.getRegisteredBeanDefinitionNames());
        for (ServletBean servletBean : this.webBean.getServlets()) {
            string = servletBean.getServletClass();
            if (string == null || !list.contains(string) && !this.containsAssignableClass(set, string)) continue;
            WebComponentContributor.dbg("injecting metadata for Servlet " + string);
            this.contribute(enricherI, string);
        }
        for (ServletBean servletBean : this.webBean.getFilters()) {
            string = servletBean.getFilterClass();
            if (!list.contains(string) && !this.containsAssignableClass(set, string)) continue;
            WebComponentContributor.dbg("injecting metadata for Filter " + string);
            this.contribute(enricherI, string);
        }
        for (ServletBean servletBean : this.webBean.getListeners()) {
            string = servletBean.getListenerClass();
            if (!list.contains(string) && !this.containsAssignableClass(set, string)) continue;
            WebComponentContributor.dbg("injecting metadata for Listener " + string);
            this.contribute(enricherI, string);
        }
        for (Object e : this.context.getHelper().getTagHandlers(false)) {
            String string2 = (String)e;
            if (!list.contains(string2) && !this.containsAssignableClass(set, string2)) continue;
            WebComponentContributor.dbg("injecting metadata for taglib handler " + string2);
            this.contribute(enricherI, string2);
        }
        for (Object e : this.context.getHelper().getTagListeners(false)) {
            String string3 = (String)e;
            if (!list.contains(string3) && !this.containsAssignableClass(set, string3)) continue;
            WebComponentContributor.dbg("injecting metadata for tld listener " + string3);
            this.contribute(enricherI, string3);
        }
        for (Object e : this.context.getHelper().getManagedBeanClasses()) {
            String string4 = (String)e;
            if (!list.contains(string4) && !this.containsAssignableClass(set, string4)) continue;
            WebComponentContributor.dbg("injecting metadata for managed bean" + string4);
            this.contribute(enricherI, string4);
        }
    }

    private boolean containsAssignableClass(Set set, String string) {
        if (set.contains(string)) {
            return true;
        }
        Class<?> clazz = null;
        try {
            clazz = this.context.getServletClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        while (!clazz.equals(Object.class)) {
            if (!set.contains((clazz = clazz.getSuperclass()).getName())) continue;
            return true;
        }
        return false;
    }

    private void contribute(EnricherI enricherI, String string) {
        this.contribute(enricherI, string, string, (J2eeEnvironmentBean)this.webBean);
    }

    public Jsr250MetadataI newJsr250Metadata(String string, Class<?> clazz, DeploymentUnitMetadataI deploymentUnitMetadataI) {
        Debug.assertion((this.context != null ? 1 : 0) != 0, (String)"not initialized");
        Jsr250MetadataI jsr250MetadataI = this.webCompContributorBroker.createJsr250Metadata(deploymentUnitMetadataI, string, clazz);
        this.diClasses.put(string, jsr250MetadataI);
        return jsr250MetadataI;
    }

    private Object getNewInstance(String string, ClassLoader classLoader) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!this.usesSpringExtensionModel || string.startsWith("weblogic")) {
            Class<?> clazz = classLoader.loadClass(string);
            Object obj = clazz.newInstance();
            try {
                this.inject(obj);
                this.notifyPostConstruct(obj);
            }
            catch (Exception exception) {
                return clazz.newInstance();
            }
            return obj;
        }
        if (!this.diClasses.containsKey(string)) {
            Class<?> clazz = classLoader.loadClass(string);
            return clazz.newInstance();
        }
        return this.webCompContributorBroker.getNewInstance(string);
    }

    @Override
    public Servlet createServletInstance(String string) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        Debug.assertion((this.context != null ? 1 : 0) != 0, (String)"not initialized");
        return (Servlet)this.getNewInstance(string, this.context.getServletClassLoader());
    }

    @Override
    public Filter createFilterInstance(String string) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        Debug.assertion((this.context != null ? 1 : 0) != 0, (String)"not initialized");
        return (Filter)this.getNewInstance(string, this.context.getServletClassLoader());
    }

    @Override
    public EventListener createListenerInstance(String string) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        Debug.assertion((this.context != null ? 1 : 0) != 0, (String)"not initialized");
        return (EventListener)this.getNewInstance(string, this.context.getServletClassLoader());
    }

    @Override
    public void inject(Object object) {
        if (!this.useDI) {
            return;
        }
        String string = object.getClass().getName();
        try {
            Jsr250MetadataI jsr250MetadataI = this.diClasses.get(string);
            if (jsr250MetadataI != null) {
                jsr250MetadataI.inject(object);
            }
        }
        catch (RuntimeException runtimeException) {
            this.diClasses.remove(string);
            HTTPLogger.logDependencyInjectionFailed((String)this.context.getLogContext(), (String)string, (Throwable)runtimeException);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Dependency injection failed for class " + string, (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    @Override
    public void notifyPostConstruct(Object object) {
        this.invokeLifecycleMethods(object, LifecycleEvent.POST_CONSTRUCT);
    }

    @Override
    public void notifyPreDestroy(Object object) {
        this.invokeLifecycleMethods(object, LifecycleEvent.PRE_DESTROY);
    }

    private void invokeLifecycleMethods(Object object, LifecycleEvent lifecycleEvent) {
        if (!this.useDI) {
            return;
        }
        Jsr250MetadataI jsr250MetadataI = this.diClasses.get(object.getClass().getName());
        if (jsr250MetadataI != null) {
            jsr250MetadataI.invokeLifecycleMethods(object, lifecycleEvent);
        }
    }

    private void checkDuplicatedCallback(LifecycleCallbackBean[] lifecycleCallbackBeanArray, LifecycleEvent lifecycleEvent) throws DeploymentException {
        if (lifecycleCallbackBeanArray == null || lifecycleCallbackBeanArray.length < 2) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(lifecycleCallbackBeanArray.length);
        for (LifecycleCallbackBean lifecycleCallbackBean : lifecycleCallbackBeanArray) {
            String string = hashMap.put(lifecycleCallbackBean.getLifecycleCallbackClass(), lifecycleCallbackBean.getLifecycleCallbackMethod());
            if (string == null || string.equals(lifecycleCallbackBean.getLifecycleCallbackMethod())) continue;
            throw new DeploymentException("There are multiple lifecycle callbacks declared for event " + lifecycleEvent + " on class: " + lifecycleCallbackBean.getLifecycleCallbackClass());
        }
    }

    @Override
    protected void addLifecycleMethods(Jsr250MetadataI jsr250MetadataI, J2eeEnvironmentBean j2eeEnvironmentBean) {
        int n;
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = this.getComponentCallbackBeans(jsr250MetadataI, j2eeEnvironmentBean.getPostConstructs());
        for (n = lifecycleCallbackBeanArray.length - 1; n > -1; --n) {
            this.addLifecycleMethods(jsr250MetadataI, lifecycleCallbackBeanArray[n], LifecycleEvent.POST_CONSTRUCT);
        }
        lifecycleCallbackBeanArray = this.getComponentCallbackBeans(jsr250MetadataI, j2eeEnvironmentBean.getPreDestroys());
        for (n = 0; n < lifecycleCallbackBeanArray.length; ++n) {
            this.addLifecycleMethods(jsr250MetadataI, lifecycleCallbackBeanArray[n], LifecycleEvent.PRE_DESTROY);
        }
    }

    private LifecycleCallbackBean[] getComponentCallbackBeans(Jsr250MetadataI jsr250MetadataI, LifecycleCallbackBean[] lifecycleCallbackBeanArray) {
        if (lifecycleCallbackBeanArray == null || lifecycleCallbackBeanArray.length == 0) {
            return new LifecycleCallbackBean[0];
        }
        TreeSet<LifecycleCallbackBean> treeSet = this.sortCallbackBeans(jsr250MetadataI, lifecycleCallbackBeanArray);
        treeSet = this.removeOverridenCallbackBeans(treeSet);
        return treeSet.toArray(new LifecycleCallbackBean[treeSet.size()]);
    }

    private TreeSet<LifecycleCallbackBean> sortCallbackBeans(Jsr250MetadataI jsr250MetadataI, LifecycleCallbackBean[] lifecycleCallbackBeanArray) {
        TreeSet<LifecycleCallbackBean> treeSet = new TreeSet<LifecycleCallbackBean>(new Comparator(){

            public int compare(Object object, Object object2) {
                Class clazz;
                LifecycleCallbackBean lifecycleCallbackBean = (LifecycleCallbackBean)object;
                LifecycleCallbackBean lifecycleCallbackBean2 = (LifecycleCallbackBean)object2;
                Class clazz2 = WebComponentContributor.this.loadClass(lifecycleCallbackBean.getLifecycleCallbackClass(), WebComponentContributor.this.classLoader);
                if (!clazz2.isAssignableFrom(clazz = WebComponentContributor.this.loadClass(lifecycleCallbackBean2.getLifecycleCallbackClass(), WebComponentContributor.this.classLoader))) {
                    return -1;
                }
                if (clazz2 != clazz) {
                    return 1;
                }
                return lifecycleCallbackBean.getLifecycleCallbackMethod().equals(lifecycleCallbackBean2.getLifecycleCallbackMethod()) ? 0 : 1;
            }
        });
        Class clazz = this.loadClass(jsr250MetadataI.getComponentName(), this.classLoader);
        for (LifecycleCallbackBean lifecycleCallbackBean : lifecycleCallbackBeanArray) {
            Class clazz2 = this.loadClass(lifecycleCallbackBean.getLifecycleCallbackClass(), this.classLoader);
            if (!clazz2.isAssignableFrom(clazz)) continue;
            treeSet.add(lifecycleCallbackBean);
        }
        return treeSet;
    }

    private TreeSet<LifecycleCallbackBean> removeOverridenCallbackBeans(TreeSet<LifecycleCallbackBean> treeSet) {
        HashSet<String> hashSet = new HashSet<String>(treeSet.size());
        Iterator<LifecycleCallbackBean> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            LifecycleCallbackBean lifecycleCallbackBean = iterator.next();
            String string = lifecycleCallbackBean.getLifecycleCallbackMethod();
            if (!hashSet.contains(string)) {
                hashSet.add(string);
                continue;
            }
            Class clazz = this.loadClass(lifecycleCallbackBean.getLifecycleCallbackClass(), this.classLoader);
            Method method = this.getDeclaredMethod(clazz, string, new Class[0]);
            if (Modifier.isPrivate(method.getModifiers())) continue;
            iterator.remove();
        }
        return treeSet;
    }
}

